/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.dao.SscConsultBaseInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultProgressMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultQuoteInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultQuoteItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultSupplierInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscFileInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscSupplyApplyItemInfoMapper;
import com.tydic.dyc.pro.dmc.po.DycProSscQryConsultUniTaskPageUnAuditListQryPO;
import com.tydic.dyc.pro.dmc.po.DycProSscQryOfferOldPO;
import com.tydic.dyc.pro.dmc.po.DycProSscQrySourcingResultListPageReqPO;
import com.tydic.dyc.pro.dmc.po.SscConsultBaseInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultItemInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultProgressPO;
import com.tydic.dyc.pro.dmc.po.SscConsultQuoteInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultQuoteItemInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultSupplierInfoPO;
import com.tydic.dyc.pro.dmc.po.SscFileInfoPO;
import com.tydic.dyc.pro.dmc.po.SscSupplyApplyItemInfoPO;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultAuditQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultCreateQuoteTurnDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultHandleDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultProgressDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSubmitChosenInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQryConsultAndItemAndSupplierListDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQryConsultAndSupplierListDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQryConsultUniTaskRspDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQryOfferOldDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQrySourcingResultListPageReqDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQrySourcingResultListPageRspDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProSscConsultRepositoryImpl
implements DycProSscConsultRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProSscConsultRepositoryImpl.class);
    @Autowired
    private SscFileInfoMapper sscFileInfoMapper;
    @Autowired
    private SscConsultSupplierInfoMapper sscConsultSupplierInfoMapper;
    @Autowired
    private SscConsultQuoteItemInfoMapper sscConsultQuoteItemInfoMapper;
    @Autowired
    private SscConsultQuoteInfoMapper sscConsultQuoteInfoMapper;
    @Autowired
    private SscConsultItemInfoMapper sscConsultItemInfoMapper;
    @Autowired
    private SscConsultBaseInfoMapper sscConsultBaseInfoMapper;
    @Autowired
    private SscSupplyApplyItemInfoMapper sscSupplyApplyItemInfoMapper;
    @Resource
    private DycProEncodeSerialService encodeSerialService;
    @Resource
    private SscConsultProgressMapper sscConsultProgressMapper;

    @Override
    public RspPage<DycProSscConsultDTO> queryConsultListPageByCondition(DycProSscConsultQryDTO qryDTO) {
        Page result;
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        LambdaQueryWrapperX sscConsultBaseInfoPOLambdaQueryWrapper = new LambdaQueryWrapperX().likeIfPresent(SscConsultBaseInfoPO::getConsultName, qryDTO.getConsultName()).likeIfPresent(SscConsultBaseInfoPO::getConsultNo, qryDTO.getConsultNo()).likeIfPresent(SscConsultBaseInfoPO::getSupplierName, qryDTO.getSupplierName()).likeIfPresent(SscConsultBaseInfoPO::getCreateUserName, qryDTO.getCreateUserName()).likeIfPresent(SscConsultBaseInfoPO::getCreateCompanyName, qryDTO.getCreateCompanyName()).eqIfPresent(SscConsultBaseInfoPO::getConsultStatus, (Object)qryDTO.getConsultStatus()).eqIfPresent(SscConsultBaseInfoPO::getConsultType, (Object)qryDTO.getConsultType()).eqIfPresent(SscConsultBaseInfoPO::getSupplierId, (Object)qryDTO.getSupplierId()).geIfPresent(SscConsultBaseInfoPO::getQuoteEndTime, (Object)qryDTO.getQuoteEndStartTime()).leIfPresent(SscConsultBaseInfoPO::getQuoteEndTime, (Object)qryDTO.getQuoteEndEndTime()).geIfPresent(SscConsultBaseInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeStart()).leIfPresent(SscConsultBaseInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeEnd()).inIfPresent(SscConsultBaseInfoPO::getConsultStatus, qryDTO.getStatusList()).eqIfPresent(SscConsultBaseInfoPO::getDelFlag, (Object)DycProSscConstants.DEL_FLAG.UN_DELETE).eqIfPresent(SscConsultBaseInfoPO::getCreateUserId, (Object)qryDTO.getCreateUserId());
        if (qryDTO.getSortChoose() != null) {
            switch (qryDTO.getSortChoose()) {
                case "CREATE_TIME": {
                    sscConsultBaseInfoPOLambdaQueryWrapper.orderByDesc(SscConsultBaseInfoPO::getCreateTime);
                }
                case "QUOTE_ENT_TIME": {
                    sscConsultBaseInfoPOLambdaQueryWrapper.orderByDesc(SscConsultBaseInfoPO::getQuoteEndTime);
                }
            }
            sscConsultBaseInfoPOLambdaQueryWrapper.orderByDesc(SscConsultBaseInfoPO::getCreateTime);
        }
        if (!CollectionUtils.isEmpty((Collection)(result = (Page)this.sscConsultBaseInfoMapper.selectPage((IPage)page, (Wrapper)sscConsultBaseInfoPOLambdaQueryWrapper)).getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProSscConsultDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public int queryConsultCountByCondition(DycProSscConsultQryDTO qryDTO) {
        LambdaQueryWrapperX sscConsultBaseInfoPOLambdaQueryWrapper = new LambdaQueryWrapperX().likeIfPresent(SscConsultBaseInfoPO::getConsultName, qryDTO.getConsultName()).likeIfPresent(SscConsultBaseInfoPO::getConsultNo, qryDTO.getConsultNo()).likeIfPresent(SscConsultBaseInfoPO::getSupplierName, qryDTO.getSupplierName()).likeIfPresent(SscConsultBaseInfoPO::getCreateUserName, qryDTO.getCreateUserName()).likeIfPresent(SscConsultBaseInfoPO::getCreateCompanyName, qryDTO.getCreateCompanyName()).eqIfPresent(SscConsultBaseInfoPO::getConsultStatus, (Object)qryDTO.getConsultStatus()).eqIfPresent(SscConsultBaseInfoPO::getConsultType, (Object)qryDTO.getConsultType()).eqIfPresent(SscConsultBaseInfoPO::getSupplierId, (Object)qryDTO.getSupplierId()).geIfPresent(SscConsultBaseInfoPO::getQuoteEndTime, (Object)qryDTO.getQuoteEndStartTime()).leIfPresent(SscConsultBaseInfoPO::getQuoteEndTime, (Object)qryDTO.getQuoteEndEndTime()).geIfPresent(SscConsultBaseInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeStart()).leIfPresent(SscConsultBaseInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeEnd()).inIfPresent(SscConsultBaseInfoPO::getConsultStatus, qryDTO.getStatusList()).eqIfPresent(SscConsultBaseInfoPO::getDelFlag, (Object)DycProSscConstants.DEL_FLAG.UN_DELETE).eqIfPresent(SscConsultBaseInfoPO::getCreateUserId, (Object)qryDTO.getCreateUserId());
        return Math.toIntExact(this.sscConsultBaseInfoMapper.selectCount((Wrapper)sscConsultBaseInfoPOLambdaQueryWrapper));
    }

    @Override
    public void updateConsultBaseInfoById(DycProSscConsultDTO consultDTO) {
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)consultDTO), SscConsultBaseInfoPO.class);
        SscConsultBaseInfoPO sscConsultBaseBeforeInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)sscConsultBaseInfoPO.getConsultId());
        this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)sscConsultBaseInfoPO.getConsultId());
        if (DycProSscConstants.ConsultSource.CONSULT_SOURCE_SSC.equals(sscConsultBaseInfoPO.getConsultSource())) {
            List sscConsultItemInfoPOS;
            if (DycProSscConstants.ConsultStatus.QUOTATION_TERMINATED.equals(sscConsultBaseInfoPO.getConsultStatus())) {
                sscConsultItemInfoPOS = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
                sscConsultItemInfoPOS.forEach(item -> this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyItemId, (Object)item.getRelationshipId())).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.INQUIRY_STOP)));
            }
            if (DycProSscConstants.ConsultStatus.COMPLETED.equals(sscConsultBaseInfoPO.getConsultStatus())) {
                sscConsultItemInfoPOS = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
                sscConsultItemInfoPOS.forEach(item -> this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyItemId, (Object)item.getRelationshipId())).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.INQUIRYED)));
            }
        }
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(sscConsultBaseInfoPO.getConsultType()) && DycProSscConstants.ConsultStatus.TO_BE_PUBLISHED.equals(sscConsultBaseInfoPO.getConsultStatus())) {
            sscConsultBaseInfoPO.setConsultStatus(DycProSscConstants.ConsultStatus.NOT_STARTED);
            this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        }
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            SscConsultProgressPO sscConsultProgressPO = new SscConsultProgressPO();
            sscConsultProgressPO.setProgressId(Long.valueOf(Sequence.getInstance().nextId()));
            sscConsultProgressPO.setConsultId(sscConsultBaseInfoPO.getConsultId());
            sscConsultProgressPO.setSupplierId(sscConsultBaseInfoPO.getSupplierId());
            sscConsultProgressPO.setConsultStatus(sscConsultBaseInfoPO.getConsultStatus());
            sscConsultProgressPO.setConsultType(sscConsultBaseInfoPO.getConsultType());
            sscConsultProgressPO.setQuoteEndTime(sscConsultBaseInfoPO.getQuoteEndTime());
            sscConsultProgressPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            sscConsultProgressPO.setCurrentQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            sscConsultProgressPO.setCreateTime(new Date());
            sscConsultProgressPO.setCreateUserId(sscConsultBaseInfoPO.getCreateUserId());
            sscConsultProgressPO.setCreateUserName(sscConsultBaseInfoPO.getCreateUserName());
            sscConsultProgressPO.setCreateOrgId(sscConsultBaseInfoPO.getCreateOrgId());
            sscConsultProgressPO.setCreateOrgName(sscConsultBaseInfoPO.getCreateOrgName());
            sscConsultProgressPO.setCreateOrgPath(sscConsultBaseInfoPO.getCreateOrgPath());
            sscConsultProgressPO.setCreateCompanyId(sscConsultBaseInfoPO.getCreateCompanyId());
            sscConsultProgressPO.setCreateCompanyName(sscConsultBaseInfoPO.getCreateCompanyName());
            int currentQuoteTurn = sscConsultBaseInfoPO.getCurrentQuoteTurn();
            String chineseQuoteTurn = this.numberToChinese(currentQuoteTurn);
            if (!sscConsultBaseBeforeInfoPO.getConsultStatus().equals(sscConsultBaseInfoPO.getConsultStatus())) {
                if (DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION.equals(sscConsultBaseInfoPO.getConsultStatus())) {
                    if (sscConsultBaseInfoPO.getCurrentQuoteTurn() <= 1) {
                        sscConsultProgressPO.setProgressName("\u4f9b\u5e94\u5546\u62a5\u4ef7");
                        sscConsultProgressPO.setRemark("\u4f9b\u5e94\u5546\u63d0\u4ea4\u7b2c\u4e00\u8f6e\u62a5\u4ef7");
                    } else {
                        sscConsultProgressPO.setProgressName("\u4f9b\u5e94\u5546\u62a5\u4ef7");
                        sscConsultProgressPO.setRemark("\u4f9b\u5e94\u5546\u63d0\u4ea4\u7b2c" + chineseQuoteTurn + "\u8f6e\u62a5\u4ef7");
                    }
                } else if (DycProSscConstants.ConsultStatus.QUOTATION_TERMINATED.equals(sscConsultBaseInfoPO.getConsultStatus())) {
                    sscConsultProgressPO.setProgressName("\u7ec8\u6b62\u8bae\u4ef7");
                    sscConsultProgressPO.setRemark("\u91c7\u8d2d\u4fa7\u7ec8\u6b62\u8bae\u4ef7\uff0c\u7ec8\u6b62\u539f\u56e0\uff1a" + sscConsultBaseInfoPO.getStopReason());
                    if (!"2".equals(consultDTO.getStopType())) {
                        sscConsultProgressPO.setRemark("\u4f9b\u5e94\u5546\u62d2\u7edd\u62a5\u4ef7\uff0c\u7ec8\u6b62\u8bae\u4ef7\uff0c\u62d2\u7edd\u539f\u56e0\uff1a" + sscConsultBaseInfoPO.getStopReason());
                    }
                }
            } else if (!sscConsultBaseBeforeInfoPO.getQuoteEndTime().equals(sscConsultBaseInfoPO.getQuoteEndTime())) {
                sscConsultProgressPO.setProgressName("\u53d8\u66f4\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4");
                sscConsultProgressPO.setRemark("\u91c7\u8d2d\u4fa7\u53d8\u66f4\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4");
            }
            this.sscConsultProgressMapper.insert((Object)sscConsultProgressPO);
        }
    }

    @Override
    public void deleteConsultById(DycProSscConsultDTO consultDTO) {
        SscConsultBaseInfoPO sscConsultBaseInfoPO = new SscConsultBaseInfoPO();
        sscConsultBaseInfoPO.setDelFlag(DycProSscConstants.DEL_FLAG.DELETE);
        sscConsultBaseInfoPO.setConsultId(consultDTO.getConsultId());
        this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)consultDTO.getConsultId());
        if (DycProSscConstants.ConsultSource.CONSULT_SOURCE_SSC.equals(sscConsultBaseInfoPO.getConsultSource())) {
            List sscConsultItemInfoPOS = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
            sscConsultItemInfoPOS.forEach(item -> this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyItemId, (Object)item.getRelationshipId())).set(SscSupplyApplyItemInfoPO::getInquiryId, null)).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.UNINQUIRY)));
        }
    }

    @Override
    public void createFile(DycProSscConsultHandleDTO consultHandleDTO) {
        List fileInfoPOS = consultHandleDTO.getFileInfoList().stream().map(fileInfo -> {
            SscFileInfoPO sscFileInfoPO = (SscFileInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)fileInfo), SscFileInfoPO.class);
            sscFileInfoPO.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            sscFileInfoPO.setObjId(consultHandleDTO.getObjId());
            sscFileInfoPO.setObjType(consultHandleDTO.getObjType());
            return sscFileInfoPO;
        }).collect(Collectors.toList());
        this.sscFileInfoMapper.insertBatch(fileInfoPOS);
    }

    @Override
    public void updateFileByObj(DycProSscConsultHandleDTO consultHandleDTO) {
        this.sscFileInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)consultHandleDTO.getObjId())).eq(SscFileInfoPO::getObjType, (Object)consultHandleDTO.getObjType()));
        if (!CollectionUtils.isEmpty(consultHandleDTO.getFileInfoList())) {
            List fileInfoPOS = consultHandleDTO.getFileInfoList().stream().map(fileInfo -> {
                SscFileInfoPO sscFileInfoPO = (SscFileInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)fileInfo), SscFileInfoPO.class);
                sscFileInfoPO.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
                sscFileInfoPO.setObjId(consultHandleDTO.getObjId());
                sscFileInfoPO.setObjType(consultHandleDTO.getObjType());
                return sscFileInfoPO;
            }).collect(Collectors.toList());
            this.sscFileInfoMapper.insertBatch(fileInfoPOS);
        }
    }

    @Override
    public List<DycProSscFileInfoDTO> qryFileByObj(DycProSscFileInfoDTO dycProSscFileInfoDTO) {
        List sscFileInfoPOS = this.sscFileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)dycProSscFileInfoDTO.getObjId())).eq(SscFileInfoPO::getObjType, (Object)dycProSscFileInfoDTO.getObjType()));
        return JSON.parseArray((String)JSON.toJSONString((Object)sscFileInfoPOS), DycProSscFileInfoDTO.class);
    }

    @Override
    public DycProSscConsultDTO addConsultAllInfo(DycProSscConsultDTO consultDTO) {
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)consultDTO), SscConsultBaseInfoPO.class);
        sscConsultBaseInfoPO.setConsultId(Long.valueOf(Sequence.getInstance().nextId()));
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("SSC");
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            encodeSerialReqBO.setEncodeRuleCode("SSC_CONSULT_TYPE_XJ");
        } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            encodeSerialReqBO.setEncodeRuleCode("SSC_CONSULT_TYPE_JJ");
        } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            encodeSerialReqBO.setEncodeRuleCode("SSC_CONSULT_TYPE_YJ");
        } else {
            encodeSerialReqBO.setEncodeRuleCode("SSC_CONSULT_TYPE_XJ");
        }
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        sscConsultBaseInfoPO.setConsultNo((String)encode.getSerialNoList().get(0));
        sscConsultBaseInfoPO.setCreateTime(new Date());
        sscConsultBaseInfoPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        sscConsultBaseInfoPO.setCurrentQuoteTurn(Integer.valueOf(1));
        List sscConsultItemInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getConsultItemInfoList()), SscConsultItemInfoPO.class);
        sscConsultItemInfoPOList.forEach(item -> {
            if (item.getPredictPrice() == null || item.getPredictPurchaseQuantity() == null) {
                // empty if block
            }
            item.setConsultItemId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setConsultId(sscConsultBaseInfoPO.getConsultId());
            if (item.getPredictPrice() != null && item.getPredictPurchaseQuantity() != null) {
                item.setPredictTotalPrice(item.getPredictPrice().multiply(item.getPredictPurchaseQuantity()).setScale(2, RoundingMode.HALF_UP));
            }
            if (DycProSscConstants.ConsultSource.CONSULT_SOURCE_SSC.equals(item.getConsultSource())) {
                this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyItemId, (Object)item.getRelationshipId())).set(SscSupplyApplyItemInfoPO::getInquiryId, (Object)sscConsultBaseInfoPO.getConsultId())).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.INQUIRYING));
            }
        });
        this.sscConsultItemInfoMapper.insertBatch((Collection)sscConsultItemInfoPOList);
        List sscConsultSupplierInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getSupplierInfoList()), SscConsultSupplierInfoPO.class);
        LinkedHashMap uniqueSupplierMap = new LinkedHashMap();
        sscConsultSupplierInfoPOList.forEach(item -> uniqueSupplierMap.put(item.getSupplierId(), item));
        ArrayList uniqueSscConsultSupplierInfoPOList = new ArrayList(uniqueSupplierMap.values());
        uniqueSscConsultSupplierInfoPOList.forEach(item -> {
            item.setInvitedId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setConsultId(sscConsultBaseInfoPO.getConsultId());
            item.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            item.setQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            item.setQuoteCount(Long.valueOf(0L));
        });
        this.sscConsultSupplierInfoMapper.insertBatch(uniqueSscConsultSupplierInfoPOList);
        List sscFileInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getFileInfoList()), SscFileInfoPO.class);
        sscFileInfoPOList.forEach(item -> {
            item.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setObjId(sscConsultBaseInfoPO.getConsultId());
            item.setObjType(DycProSscConstants.SscFileObjType.CONSULT_MAIN);
        });
        this.sscFileInfoMapper.insertBatch((Collection)sscFileInfoPOList);
        sscConsultBaseInfoPO.setConsultStatus(DycProSscConstants.ConsultStatus.DRAFT);
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            sscConsultBaseInfoPO.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTING);
        }
        sscConsultBaseInfoPO.setConsultItemCount(Long.valueOf(sscConsultItemInfoPOList.size()));
        sscConsultBaseInfoPO.setConsultSupplierCount(Integer.valueOf(sscConsultSupplierInfoPOList.size()));
        sscConsultBaseInfoPO.setConsultTotalPrice(sscConsultItemInfoPOList.stream().map(item -> {
            BigDecimal price = item.getPredictTotalPrice();
            return price != null && price.compareTo(BigDecimal.ZERO) >= 0 ? price : BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add));
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType()) && !CollectionUtils.isEmpty(consultDTO.getSupplierInfoList())) {
            sscConsultBaseInfoPO.setSupplierId(consultDTO.getSupplierInfoList().get(0).getSupplierId());
            sscConsultBaseInfoPO.setSupplierName(consultDTO.getSupplierInfoList().get(0).getSupplierName());
        }
        this.sscConsultBaseInfoMapper.insert((Object)sscConsultBaseInfoPO);
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            SscConsultProgressPO sscConsultProgressPO = new SscConsultProgressPO();
            sscConsultProgressPO.setProgressId(Long.valueOf(Sequence.getInstance().nextId()));
            sscConsultProgressPO.setConsultId(sscConsultBaseInfoPO.getConsultId());
            sscConsultProgressPO.setProgressName("\u53d1\u8d77\u8bae\u4ef7");
            sscConsultProgressPO.setSupplierId(sscConsultBaseInfoPO.getSupplierId());
            sscConsultProgressPO.setConsultStatus(sscConsultBaseInfoPO.getConsultStatus());
            sscConsultProgressPO.setRemark("\u91c7\u8d2d\u4fa7\u63d0\u4ea4\u8bae\u4ef7\u7533\u8bf7");
            sscConsultProgressPO.setConsultType(sscConsultBaseInfoPO.getConsultType());
            sscConsultProgressPO.setQuoteEndTime(sscConsultBaseInfoPO.getQuoteEndTime());
            sscConsultProgressPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            sscConsultProgressPO.setCreateTime(new Date());
            sscConsultProgressPO.setCreateUserId(sscConsultBaseInfoPO.getCreateUserId());
            sscConsultProgressPO.setCreateUserName(sscConsultBaseInfoPO.getCreateUserName());
            sscConsultProgressPO.setCreateOrgId(sscConsultBaseInfoPO.getCreateOrgId());
            sscConsultProgressPO.setCreateOrgName(sscConsultBaseInfoPO.getCreateOrgName());
            sscConsultProgressPO.setCreateOrgPath(sscConsultBaseInfoPO.getCreateOrgPath());
            sscConsultProgressPO.setCreateCompanyId(sscConsultBaseInfoPO.getCreateCompanyId());
            sscConsultProgressPO.setCreateCompanyName(sscConsultBaseInfoPO.getCreateCompanyName());
            sscConsultProgressPO.setCurrentQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            this.sscConsultProgressMapper.insert((Object)sscConsultProgressPO);
        }
        consultDTO.setConsultId(sscConsultBaseInfoPO.getConsultId());
        consultDTO.setConsultNo(sscConsultBaseInfoPO.getConsultNo());
        return consultDTO;
    }

    @Override
    public void updateConsultAllInfo(DycProSscConsultDTO consultDTO) {
        if (consultDTO == null || consultDTO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)consultDTO), SscConsultBaseInfoPO.class);
        this.sscConsultItemInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
        List sscConsultItemInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getConsultItemInfoList()), SscConsultItemInfoPO.class);
        sscConsultItemInfoPOList.forEach(item -> {
            item.setConsultItemId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setConsultId(sscConsultBaseInfoPO.getConsultId());
            if (item.getPredictPrice() != null && item.getPredictPurchaseQuantity() != null) {
                item.setPredictTotalPrice(item.getPredictPrice().multiply(item.getPredictPurchaseQuantity()).setScale(2, RoundingMode.HALF_UP));
            }
        });
        this.sscConsultItemInfoMapper.insertBatch((Collection)sscConsultItemInfoPOList);
        this.sscConsultSupplierInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn()));
        List sscConsultSupplierInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getSupplierInfoList()), SscConsultSupplierInfoPO.class);
        LinkedHashMap uniqueSupplierMap = new LinkedHashMap();
        sscConsultSupplierInfoPOList.forEach(item -> uniqueSupplierMap.put(item.getSupplierId(), item));
        ArrayList uniqueSscConsultSupplierInfoPOList = new ArrayList(uniqueSupplierMap.values());
        uniqueSscConsultSupplierInfoPOList.forEach(item -> {
            item.setInvitedId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setConsultId(sscConsultBaseInfoPO.getConsultId());
            item.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            item.setQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            item.setQuoteCount(Long.valueOf(0L));
        });
        this.sscConsultSupplierInfoMapper.insertBatch(uniqueSscConsultSupplierInfoPOList);
        this.sscFileInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscFileInfoPO::getObjType, (Object)DycProSscConstants.SscFileObjType.CONSULT_MAIN));
        List sscFileInfoPOList = JSON.parseArray((String)JSON.toJSONString(consultDTO.getFileInfoList()), SscFileInfoPO.class);
        sscFileInfoPOList.forEach(item -> {
            item.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setObjId(sscConsultBaseInfoPO.getConsultId());
            item.setObjType(DycProSscConstants.SscFileObjType.CONSULT_MAIN);
        });
        this.sscFileInfoMapper.insertBatch((Collection)sscFileInfoPOList);
        sscConsultBaseInfoPO.setConsultItemCount(Long.valueOf(sscConsultItemInfoPOList.size()));
        sscConsultBaseInfoPO.setConsultSupplierCount(Integer.valueOf(sscConsultSupplierInfoPOList.size()));
        sscConsultBaseInfoPO.setConsultTotalPrice(sscConsultItemInfoPOList.stream().map(item -> {
            BigDecimal price = item.getPredictTotalPrice();
            return price != null && price.compareTo(BigDecimal.ZERO) >= 0 ? price : BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add));
        int update = this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        if (update < 1) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u57fa\u672c\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
        consultDTO.setConsultId(sscConsultBaseInfoPO.getConsultId());
        consultDTO.setConsultNo(sscConsultBaseInfoPO.getConsultNo());
    }

    @Override
    public DycProSscConsultDTO createConsult(DycProSscConsultDTO consultDTO) {
        return null;
    }

    @Override
    public DycProSscConsultDTO queryConsultDetailById(DycProSscConsultQryDTO qryDTO) {
        if (qryDTO == null || qryDTO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)qryDTO.getConsultId());
        if (sscConsultBaseInfoPO == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u4e0d\u5b58\u5728\uff1a\u3010" + qryDTO.getConsultId() + "\u3011");
        }
        List sscConsultItemInfoPOS = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
        List sscConsultSupplierInfoPOS = this.sscConsultSupplierInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn()));
        List sscFileInfoPOS = this.sscFileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscFileInfoPO::getObjType, (Object)DycProSscConstants.SscFileObjType.CONSULT_MAIN));
        List sscConsultProgressPOS = this.sscConsultProgressMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultProgressPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).orderByDesc(SscConsultProgressPO::getProgressId));
        DycProSscConsultDTO rspDTO = (DycProSscConsultDTO)JSON.parseObject((String)JSON.toJSONString((Object)sscConsultBaseInfoPO), DycProSscConsultDTO.class);
        if (!CollectionUtils.isEmpty((Collection)sscConsultItemInfoPOS)) {
            rspDTO.setConsultItemInfoList(JSON.parseArray((String)JSON.toJSONString((Object)sscConsultItemInfoPOS), DycProSscConsultItemInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)sscConsultSupplierInfoPOS)) {
            rspDTO.setSupplierInfoList(JSON.parseArray((String)JSON.toJSONString((Object)sscConsultSupplierInfoPOS), DycProSscConsultSupplierInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)sscFileInfoPOS)) {
            rspDTO.setFileInfoList(JSON.parseArray((String)JSON.toJSONString((Object)sscFileInfoPOS), DycProSscFileInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)sscConsultProgressPOS)) {
            rspDTO.setConsultProgressList(JSON.parseArray((String)JSON.toJSONString((Object)sscConsultProgressPOS), DycProSscConsultProgressDTO.class));
        }
        return rspDTO;
    }

    @Override
    public RspPage<DycProSscQryConsultUniTaskRspDTO> queryConsultUniTaskPageList(DycProSscConsultAuditQryDTO qryDTO) {
        DycProSscQryConsultUniTaskPageUnAuditListQryPO qryPO = new DycProSscQryConsultUniTaskPageUnAuditListQryPO();
        BeanUtils.copyProperties((Object)qryDTO, (Object)qryPO);
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        if (qryDTO.getTabId() == 1) {
            page = this.sscConsultBaseInfoMapper.qryConsultUniTaskPageUnAuditList(page, qryPO);
        } else if (qryDTO.getTabId() == 2) {
            page = this.sscConsultBaseInfoMapper.qryConsultUniTaskAuditedPageList(page, qryPO);
        }
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return rspPage;
        }
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProSscQryConsultUniTaskRspDTO.class));
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public List<DycProSscConsultSupplierInfoDTO> queryConsultSupplierList(DycProSscConsultSupplierInfoDTO dycProSscSupplierInfoDTO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX().eqIfPresent(SscConsultSupplierInfoPO::getConsultId, (Object)dycProSscSupplierInfoDTO.getConsultId()).eqIfPresent(SscConsultSupplierInfoPO::getSupplierId, (Object)dycProSscSupplierInfoDTO.getSupplierId()).eqIfPresent(SscConsultSupplierInfoPO::getQuoteTurn, (Object)dycProSscSupplierInfoDTO.getQuoteTurn()).eqIfPresent(SscConsultSupplierInfoPO::getDelFlag, (Object)dycProSscSupplierInfoDTO.getDelFlag());
        List sscConsultSupplierInfoPOS = this.sscConsultSupplierInfoMapper.selectList((Wrapper)queryWrapperX);
        return JSON.parseArray((String)JSON.toJSONString((Object)sscConsultSupplierInfoPOS), DycProSscConsultSupplierInfoDTO.class);
    }

    @Override
    public List<DycProSscConsultProgressDTO> queryConsultProgressList(DycProSscConsultProgressDTO dycProSscConsultProgressDTO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX().eqIfPresent(SscConsultProgressPO::getConsultId, (Object)dycProSscConsultProgressDTO.getConsultId()).eqIfPresent(SscConsultProgressPO::getSupplierId, (Object)dycProSscConsultProgressDTO.getSupplierId()).eqIfPresent(SscConsultProgressPO::getCurrentQuoteTurn, (Object)dycProSscConsultProgressDTO.getCurrentQuoteTurn()).eqIfPresent(SscConsultProgressPO::getDelFlag, (Object)dycProSscConsultProgressDTO.getDelFlag());
        List sscConsultProgressPOS = this.sscConsultProgressMapper.selectList((Wrapper)queryWrapperX);
        return JSON.parseArray((String)JSON.toJSONString((Object)sscConsultProgressPOS), DycProSscConsultProgressDTO.class);
    }

    @Override
    public List<DycProSscConsultQuoteInfoDTO> queryConsultQuoteInfoList(DycProSscConsultQuoteInfoDTO dycProSscConsultQuoteInfoDTO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX().eqIfPresent(SscConsultQuoteInfoPO::getConsultId, (Object)dycProSscConsultQuoteInfoDTO.getConsultId()).eqIfPresent(SscConsultQuoteInfoPO::getSupplierId, (Object)dycProSscConsultQuoteInfoDTO.getSupplierId()).eqIfPresent(SscConsultQuoteInfoPO::getQuoteStatus, (Object)dycProSscConsultQuoteInfoDTO.getQuoteStatus()).eqIfPresent(SscConsultQuoteInfoPO::getQuoteTurn, (Object)dycProSscConsultQuoteInfoDTO.getQuoteTurn()).eqIfPresent(SscConsultQuoteInfoPO::getDelFlag, (Object)dycProSscConsultQuoteInfoDTO.getDelFlag()).orderByDesc(SscConsultQuoteInfoPO::getQuoteTime);
        List sscConsultQuoteInfoPOS = this.sscConsultQuoteInfoMapper.selectList((Wrapper)queryWrapperX);
        return JSON.parseArray((String)JSON.toJSONString((Object)sscConsultQuoteInfoPOS), DycProSscConsultQuoteInfoDTO.class);
    }

    @Override
    public DycProSscConsultDTO queryConsultBaseInfo(DycProSscConsultDTO qryDTO) {
        if (qryDTO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)qryDTO.getConsultId());
        if (sscConsultBaseInfoPO == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u4e0d\u5b58\u5728\uff1a\u3010" + qryDTO.getConsultId() + "\u3011");
        }
        return (DycProSscConsultDTO)JSON.parseObject((String)JSON.toJSONString((Object)sscConsultBaseInfoPO), DycProSscConsultDTO.class);
    }

    @Override
    public List<DycProSscQryConsultAndItemAndSupplierListDTO> qryConsultAndItemAndSupplierList(DycProSscConsultQuoteItemInfoDTO qryDTO) {
        SscConsultQuoteItemInfoPO sscConsultQuoteItemInfoPO = (SscConsultQuoteItemInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscConsultQuoteItemInfoPO.class);
        List sscQryConsultItemAndSupplierListPOList = this.sscConsultQuoteItemInfoMapper.qryConsultAndItemAndSupplierList(sscConsultQuoteItemInfoPO);
        if (null != sscQryConsultItemAndSupplierListPOList && !sscQryConsultItemAndSupplierListPOList.isEmpty()) {
            return JSON.parseArray((String)JSON.toJSONString((Object)sscQryConsultItemAndSupplierListPOList), DycProSscQryConsultAndItemAndSupplierListDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DycProSscQryConsultAndItemAndSupplierListDTO> qryManyConsultAndItemAndSupplierList(DycProSscConsultQuoteItemInfoDTO qryDTO) {
        SscConsultQuoteItemInfoPO sscConsultQuoteItemInfoPO = (SscConsultQuoteItemInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscConsultQuoteItemInfoPO.class);
        List sscQryConsultItemAndSupplierListPOList = this.sscConsultQuoteItemInfoMapper.qryManyConsultAndItemAndSupplierList(sscConsultQuoteItemInfoPO);
        if (null != sscQryConsultItemAndSupplierListPOList && !sscQryConsultItemAndSupplierListPOList.isEmpty()) {
            return JSON.parseArray((String)JSON.toJSONString((Object)sscQryConsultItemAndSupplierListPOList), DycProSscQryConsultAndItemAndSupplierListDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public void createQuoteTurn(DycProSscConsultCreateQuoteTurnDTO createQuoteTurnDTO) {
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)createQuoteTurnDTO.getConsultId());
        if (sscConsultBaseInfoPO == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u4e0d\u5b58\u5728\uff1a\u3010" + createQuoteTurnDTO.getConsultId() + "\u3011");
        }
        if (createQuoteTurnDTO.getQuoteEndTime() == null) {
            throw new ZTBusinessException("\u672c\u8f6e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sscConsultSupplierInfoPOList = JSON.parseArray((String)JSON.toJSONString(createQuoteTurnDTO.getSupplierInfoList()), SscConsultSupplierInfoPO.class);
        List sscConsultSupplierInfoPOS = this.sscConsultSupplierInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn()));
        sscConsultBaseInfoPO.setCurrentQuoteTurn(Integer.valueOf(sscConsultBaseInfoPO.getCurrentQuoteTurn() + 1));
        sscConsultBaseInfoPO.setQuoteEndTime(createQuoteTurnDTO.getQuoteEndTime());
        sscConsultBaseInfoPO.setUpdateTime(new Date());
        sscConsultBaseInfoPO.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTING);
        for (SscConsultSupplierInfoPO sscConsultSupplierInfoPO : sscConsultSupplierInfoPOS) {
            boolean exists = sscConsultSupplierInfoPOList.stream().anyMatch(s -> s.getSupplierId().equals(sscConsultSupplierInfoPO.getSupplierId()));
            sscConsultSupplierInfoPO.setInvitedQuoteTurn(Integer.valueOf(exists ? 1 : 0));
            sscConsultSupplierInfoPO.setInvitedId(Long.valueOf(Sequence.getInstance().nextId()));
            sscConsultSupplierInfoPO.setConsultId(sscConsultBaseInfoPO.getConsultId());
            sscConsultSupplierInfoPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            sscConsultSupplierInfoPO.setQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            sscConsultSupplierInfoPO.setQuoteCount(Long.valueOf(0L));
            sscConsultSupplierInfoPO.setIsChosen(Integer.valueOf(1));
            sscConsultSupplierInfoPO.setQuoteTotalAmount(null);
            sscConsultSupplierInfoPO.setQuoteTime(null);
            sscConsultSupplierInfoPO.setDropFee(null);
            sscConsultSupplierInfoPO.setDiscountRate(null);
        }
        this.sscConsultSupplierInfoMapper.insertBatch((Collection)sscConsultSupplierInfoPOS);
        this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            SscConsultProgressPO sscConsultProgressPO = new SscConsultProgressPO();
            sscConsultProgressPO.setProgressId(Long.valueOf(Sequence.getInstance().nextId()));
            sscConsultProgressPO.setConsultId(sscConsultBaseInfoPO.getConsultId());
            sscConsultProgressPO.setSupplierId(sscConsultBaseInfoPO.getSupplierId());
            sscConsultProgressPO.setConsultStatus(sscConsultBaseInfoPO.getConsultStatus());
            sscConsultProgressPO.setConsultType(sscConsultBaseInfoPO.getConsultType());
            sscConsultProgressPO.setQuoteEndTime(sscConsultBaseInfoPO.getQuoteEndTime());
            sscConsultProgressPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            sscConsultProgressPO.setCreateTime(new Date());
            sscConsultProgressPO.setCreateUserId(sscConsultBaseInfoPO.getCreateUserId());
            sscConsultProgressPO.setCreateUserName(sscConsultBaseInfoPO.getCreateUserName());
            sscConsultProgressPO.setCreateOrgId(sscConsultBaseInfoPO.getCreateOrgId());
            sscConsultProgressPO.setCreateOrgName(sscConsultBaseInfoPO.getCreateOrgName());
            sscConsultProgressPO.setCreateOrgPath(sscConsultBaseInfoPO.getCreateOrgPath());
            sscConsultProgressPO.setCreateCompanyId(sscConsultBaseInfoPO.getCreateCompanyId());
            sscConsultProgressPO.setCreateCompanyName(sscConsultBaseInfoPO.getCreateCompanyName());
            sscConsultProgressPO.setCurrentQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            int currentQuoteTurn = sscConsultBaseInfoPO.getCurrentQuoteTurn();
            String chineseQuoteTurn = this.numberToChinese(currentQuoteTurn);
            sscConsultProgressPO.setProgressName("\u91cd\u65b0\u8bae\u4ef7-\u7b2c" + chineseQuoteTurn + "\u8f6e\u62a5\u4ef7");
            sscConsultProgressPO.setRemark("\u91c7\u8d2d\u4fa7\u63d0\u4ea4\u91cd\u65b0\u8bae\u4ef7\u7533\u8bf7");
            this.sscConsultProgressMapper.insert((Object)sscConsultProgressPO);
        }
    }

    @Override
    public void submitChosenInfo(DycProSscConsultSubmitChosenInfoDTO submitChosenInfoDTO) {
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)submitChosenInfoDTO.getConsultId());
        if (sscConsultBaseInfoPO == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u4e0d\u5b58\u5728\uff1a\u3010" + submitChosenInfoDTO.getConsultId() + "\u3011");
        }
        sscConsultBaseInfoPO.setUpdateTime(new Date());
        sscConsultBaseInfoPO.setChosenType(submitChosenInfoDTO.getChosenType());
        sscConsultBaseInfoPO.setChosenReason(submitChosenInfoDTO.getChosenReason());
        this.sscConsultBaseInfoMapper.updateById((Object)sscConsultBaseInfoPO);
        List sscConsultQuoteItemInfoPOList = JSON.parseArray((String)JSON.toJSONString(submitChosenInfoDTO.getConsultQuoteItemList()), SscConsultQuoteItemInfoPO.class);
        List oldQuoteItemList = this.sscConsultQuoteItemInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultQuoteItemInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn())).eq(SscConsultQuoteItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
        oldQuoteItemList.forEach(item -> {
            item.setIsChosen(Integer.valueOf(1));
            this.sscConsultQuoteItemInfoMapper.updateById(item);
        });
        List sscConsultQuoteInfoPOList = JSON.parseArray((String)JSON.toJSONString(submitChosenInfoDTO.getConsultQuoteInfoList()), SscConsultQuoteInfoPO.class);
        if (!CollectionUtils.isEmpty((Collection)sscConsultQuoteInfoPOList)) {
            List quoteIds = sscConsultQuoteInfoPOList.stream().map(SscConsultQuoteInfoPO::getQuoteId).distinct().collect(Collectors.toList());
            sscConsultQuoteItemInfoPOList = this.sscConsultQuoteItemInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultQuoteItemInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).in(SscConsultQuoteItemInfoPO::getQuoteId, quoteIds));
        }
        sscConsultQuoteItemInfoPOList.forEach(item -> {
            SscConsultQuoteItemInfoPO updateItem = new SscConsultQuoteItemInfoPO();
            updateItem.setQuoteItemId(item.getQuoteItemId());
            updateItem.setIsChosen(Integer.valueOf(0));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.eq(SscConsultQuoteItemInfoPO::getQuoteItemId, (Object)item.getQuoteItemId())).set(SscConsultQuoteItemInfoPO::getIsChosen, (Object)0);
            int rows = this.sscConsultQuoteItemInfoMapper.update((Object)updateItem, (Wrapper)updateWrapper);
        });
        List supplierIds = sscConsultQuoteItemInfoPOList.stream().map(SscConsultQuoteItemInfoPO::getSupplierId).distinct().collect(Collectors.toList());
        List supplierInfoList = this.sscConsultSupplierInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn())).eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId()));
        supplierInfoList.forEach(item -> {
            if (supplierIds.contains(item.getSupplierId())) {
                item.setIsChosen(Integer.valueOf(0));
            } else {
                item.setIsChosen(Integer.valueOf(1));
            }
            this.sscConsultSupplierInfoMapper.updateById(item);
        });
        this.sscFileInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscFileInfoPO::getObjType, (Object)DycProSscConstants.SscFileObjType.CONSULT_CHOSEN));
        List sscFileInfoPOList = JSON.parseArray((String)JSON.toJSONString(submitChosenInfoDTO.getFileInfoList()), SscFileInfoPO.class);
        sscFileInfoPOList.forEach(item -> {
            item.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setObjId(sscConsultBaseInfoPO.getConsultId());
            item.setObjType(DycProSscConstants.SscFileObjType.CONSULT_CHOSEN);
        });
        this.sscFileInfoMapper.insertBatch((Collection)sscFileInfoPOList);
    }

    @Override
    public List<DycProSscConsultDTO> timingUpdateConsultStatus() {
        List sscConsultBaseInfoPOS1;
        Date now = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)now);
        ArrayList<DycProSscConsultDTO> resultList = new ArrayList<DycProSscConsultDTO>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ);
        typeList.add(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ);
        List sscConsultBaseInfoPOS = this.sscConsultBaseInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultBaseInfoPO::getConsultStatus, (Object)DycProSscConstants.ConsultStatus.NOT_STARTED)).eq(SscConsultBaseInfoPO::getDelFlag, (Object)DycProSscConstants.DEL_FLAG.UN_DELETE)).in(SscConsultBaseInfoPO::getConsultType, typeList)).le(SscConsultBaseInfoPO::getQuoteStartTime, (Object)now));
        if (!CollectionUtils.isEmpty((Collection)sscConsultBaseInfoPOS)) {
            sscConsultBaseInfoPOS.forEach(item -> item.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTING));
            this.sscConsultBaseInfoMapper.updateBatchByIds((Collection)sscConsultBaseInfoPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(sscConsultBaseInfoPOS1 = this.sscConsultBaseInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultBaseInfoPO::getConsultStatus, (Object)DycProSscConstants.ConsultStatus.QUOTING)).eq(SscConsultBaseInfoPO::getDelFlag, (Object)DycProSscConstants.DEL_FLAG.UN_DELETE)).in(SscConsultBaseInfoPO::getConsultType, typeList)).le(SscConsultBaseInfoPO::getQuoteEndTime, (Object)now))))) {
            sscConsultBaseInfoPOS1.forEach(item -> {
                if (item.getAutoExtendDuration() != null && item.getAutoExtendBidding() != null && item.getAutoExtendBidding().equals(DycProSscConstants.AutoExtendBidding.YES) && item.getMaxExtendAttempts() != null && item.getAlreadyExtendAttempts() != null && item.getMaxExtendAttempts() > item.getAlreadyExtendAttempts()) {
                    item.getQuoteEndTime().setTime(item.getQuoteEndTime().getTime() + (long)(item.getAutoExtendDuration() * 60 * 1000));
                    item.setAlreadyExtendAttempts(Integer.valueOf(item.getAlreadyExtendAttempts() + 1));
                } else {
                    List supplierInfoList = this.sscConsultSupplierInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)item.getCurrentQuoteTurn())).eq(SscConsultSupplierInfoPO::getConsultId, (Object)item.getConsultId())).gt(SscConsultSupplierInfoPO::getQuoteCount, (Object)0));
                    if (!CollectionUtils.isEmpty((Collection)supplierInfoList)) {
                        item.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTATION_DEADLINE);
                        if (item.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                            item.setConsultStatus(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
                        }
                    } else {
                        item.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTATION_FAIL);
                        if (item.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                            item.setConsultStatus(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
                        }
                        item.setFailReason("\u65e0\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u8be2\u4ef7\u5931\u8d25\uff01");
                        List sscConsultItemInfoPOS = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SscConsultItemInfoPO::getConsultId, (Object)item.getConsultId()));
                        sscConsultItemInfoPOS.forEach(consultItem -> this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyItemId, (Object)consultItem.getRelationshipId())).set(SscSupplyApplyItemInfoPO::getInquiryId, null)).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.INQUIRY_FAIL)));
                    }
                    DycProSscConsultDTO failConsult = new DycProSscConsultDTO();
                    failConsult.setConsultId(item.getConsultId());
                    failConsult.setConsultType(item.getConsultType());
                    resultList.add(failConsult);
                }
            });
            this.sscConsultBaseInfoMapper.updateBatchByIds((Collection)sscConsultBaseInfoPOS1);
        }
        return resultList;
    }

    @Override
    public void updateConsultSupplier(DycProSscConsultSupplierInfoDTO dycProSscSupplierInfoDTO) {
        SscConsultSupplierInfoPO result = (SscConsultSupplierInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProSscSupplierInfoDTO), SscConsultSupplierInfoPO.class);
        this.sscConsultSupplierInfoMapper.updateById((Object)result);
    }

    @Override
    public List<DycProSscQryConsultAndSupplierListDTO> qryConsultAndSupplierList(DycProSscConsultQuoteItemInfoDTO qryDTO) {
        SscConsultQuoteInfoPO sscConsultQuoteInfoPO = (SscConsultQuoteInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscConsultQuoteInfoPO.class);
        List dycProSscQryConsultAndSupplierListPOS = this.sscConsultQuoteInfoMapper.qryConsultAndSupplierList(sscConsultQuoteInfoPO);
        return JSON.parseArray((String)JSON.toJSONString((Object)dycProSscQryConsultAndSupplierListPOS), DycProSscQryConsultAndSupplierListDTO.class);
    }

    @Override
    public RspPage<DycProSscQryConsultAndSupplierListDTO> querySupplierQuoteConsultListPage(DycProSscConsultQuoteItemInfoDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        SscConsultQuoteInfoPO reqPO = (SscConsultQuoteInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscConsultQuoteInfoPO.class);
        Page listPage = this.sscConsultQuoteInfoMapper.querySupplierQuoteConsultListPage(page, reqPO);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)listPage.getRecords())) {
            rspPage.setPageNo(Math.toIntExact(listPage.getCurrent()));
            rspPage.setTotal(Math.toIntExact(listPage.getPages()));
            rspPage.setRecordsTotal(Math.toIntExact(listPage.getTotal()));
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)listPage.getRecords()), DycProSscQryConsultAndSupplierListDTO.class));
        }
        return rspPage;
    }

    @Override
    public DycProSscQryOfferOldDTO qryOfferRank(DycProSscConsultQuoteInfoDTO qryDTO) {
        SscConsultQuoteInfoPO sscConsultQuoteInfoPO = (SscConsultQuoteInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscConsultQuoteInfoPO.class);
        DycProSscQryOfferOldPO result = this.sscConsultQuoteInfoMapper.qryOfferRank(sscConsultQuoteInfoPO);
        return (DycProSscQryOfferOldDTO)JSON.parseObject((String)JSON.toJSONString((Object)result), DycProSscQryOfferOldDTO.class);
    }

    @Override
    public RspPage<DycProSscQrySourcingResultListPageRspDTO> qrySourcingResultListPage(DycProSscQrySourcingResultListPageReqDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        DycProSscQrySourcingResultListPageReqPO reqPO = (DycProSscQrySourcingResultListPageReqPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), DycProSscQrySourcingResultListPageReqPO.class);
        Page listPage = this.sscConsultBaseInfoMapper.qrySourcingResultListPage(page, reqPO);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)listPage.getRecords())) {
            rspPage.setPageNo(Math.toIntExact(listPage.getCurrent()));
            rspPage.setTotal(Math.toIntExact(listPage.getPages()));
            rspPage.setRecordsTotal(Math.toIntExact(listPage.getTotal()));
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)listPage.getRecords()), DycProSscQrySourcingResultListPageRspDTO.class));
        }
        return rspPage;
    }

    private String numberToChinese(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("\u6570\u5b57\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570");
        }
        String[] chineseNumbers = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] units = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341\u4e07", "\u767e\u4e07", "\u5343\u4e07", "\u4ebf"};
        if (number == 0) {
            return chineseNumbers[0];
        }
        StringBuilder result = new StringBuilder();
        int unitIndex = 0;
        while (number > 0) {
            int digit = number % 10;
            if (digit != 0) {
                result.insert(0, units[unitIndex]);
                result.insert(0, chineseNumbers[digit]);
            }
            number /= 10;
            ++unitIndex;
        }
        if (result.toString().startsWith("\u4e00\u5341")) {
            result = new StringBuilder(result.toString().replaceFirst("\u4e00\u5341", "\u5341"));
        }
        if (result.toString().endsWith("\u96f6")) {
            result = new StringBuilder(result.toString().replaceAll("\u96f6+$", ""));
        }
        return result.toString();
    }
}

