/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.dao.SscConsultBaseInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultQuoteInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultQuoteItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscConsultSupplierInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscFileInfoMapper;
import com.tydic.dyc.pro.dmc.po.SscConsultBaseInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultItemInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultQuoteInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultQuoteItemInfoPO;
import com.tydic.dyc.pro.dmc.po.SscConsultSupplierInfoPO;
import com.tydic.dyc.pro.dmc.po.SscFileInfoPO;
import com.tydic.dyc.pro.dmc.po.SscQrySupplierConsultBaseListPageReqPO;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultResponseRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSubmitQuoteInfoDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProSscConsultResponseRepositoryImpl
implements DycProSscConsultResponseRepository {
    @Autowired
    private SscConsultBaseInfoMapper sscConsultBaseInfoMapper;
    @Autowired
    private SscFileInfoMapper sscFileInfoMapper;
    @Autowired
    private SscConsultQuoteInfoMapper sscConsultQuoteInfoMapper;
    @Autowired
    private SscConsultItemInfoMapper sscConsultItemInfoMapper;
    @Autowired
    private SscConsultSupplierInfoMapper sscConsultSupplierInfoMapper;
    @Autowired
    private SscConsultQuoteItemInfoMapper sscConsultQuoteItemInfoMapper;

    @Override
    public RspPage<DycProSscConsultDTO> querySupplierConsultListPage(DycProSscConsultQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        SscQrySupplierConsultBaseListPageReqPO reqPO = (SscQrySupplierConsultBaseListPageReqPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscQrySupplierConsultBaseListPageReqPO.class);
        Page listPage = this.sscConsultBaseInfoMapper.querySupplierConsultListPage(page, reqPO);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)listPage.getRecords())) {
            rspPage.setPageNo(Math.toIntExact(listPage.getCurrent()));
            rspPage.setTotal(Math.toIntExact(listPage.getPages()));
            rspPage.setRecordsTotal(Math.toIntExact(listPage.getTotal()));
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)listPage.getRecords()), DycProSscConsultDTO.class));
        }
        return rspPage;
    }

    @Override
    public void submitConsultQuote(DycProSscConsultSubmitQuoteInfoDTO submitQuoteDTO) {
        SscConsultQuoteInfoPO firstItem;
        SscConsultBaseInfoPO sscConsultBaseInfoPO = (SscConsultBaseInfoPO)this.sscConsultBaseInfoMapper.selectById((Serializable)submitQuoteDTO.getConsultId());
        if (sscConsultBaseInfoPO == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355\u4e0d\u5b58\u5728\uff1a\u3010" + submitQuoteDTO.getConsultId() + "\u3011");
        }
        if (DycProSscConstants.ConsultStatus.QUOTATION_DEADLINE.equals(sscConsultBaseInfoPO.getConsultStatus()) || new Date().after(sscConsultBaseInfoPO.getQuoteEndTime())) {
            throw new ZTBusinessException("\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01");
        }
        SscConsultQuoteInfoPO sscConsultQuoteInfoPO = new SscConsultQuoteInfoPO();
        sscConsultQuoteInfoPO.setQuoteId(Long.valueOf(Sequence.getInstance().nextId()));
        sscConsultQuoteInfoPO.setConsultId(sscConsultBaseInfoPO.getConsultId());
        sscConsultQuoteInfoPO.setQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
        sscConsultQuoteInfoPO.setQuoteTimes(Integer.valueOf(1));
        List sscConsultQuoteInfoPOS = this.sscConsultQuoteInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultQuoteInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscConsultQuoteInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn())).eq(SscConsultQuoteInfoPO::getSupplierId, (Object)submitQuoteDTO.getSupplierId())).orderByDesc(SscConsultQuoteInfoPO::getQuoteTimes)).last("LIMIT 1"));
        if (!CollectionUtils.isEmpty((Collection)sscConsultQuoteInfoPOS)) {
            sscConsultQuoteInfoPO.setQuoteTimes(Integer.valueOf(((SscConsultQuoteInfoPO)sscConsultQuoteInfoPOS.get(0)).getQuoteTimes() + 1));
        }
        if (sscConsultBaseInfoPO.getMaxQuoteAttempts() != null && DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(sscConsultBaseInfoPO.getConsultType()) && sscConsultBaseInfoPO.getMaxQuoteAttempts() < sscConsultQuoteInfoPO.getQuoteTimes()) {
            throw new ZTBusinessException("\u62a5\u4ef7\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u80fd\u62a5\u4ef7");
        }
        if (sscConsultQuoteInfoPOS != null && !sscConsultQuoteInfoPOS.isEmpty() && (firstItem = (SscConsultQuoteInfoPO)sscConsultQuoteInfoPOS.get(0)) != null && DycProSscConstants.QuoteStatus.HAS_QUOTE.equals(firstItem.getQuoteStatus())) {
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(sscConsultBaseInfoPO.getConsultType()) || DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(sscConsultBaseInfoPO.getConsultType())) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546\u5df2\u6709\u62a5\u4ef7\u8bb0\u5f55\uff0c\u8bf7\u5148\u64a4\u56de\u62a5\u4ef7\uff0c\u518d\u62a5\u4ef7");
            }
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(sscConsultBaseInfoPO.getConsultType())) {
                SscConsultQuoteInfoPO updateSscConsultQuoteInfo = new SscConsultQuoteInfoPO();
                updateSscConsultQuoteInfo.setQuoteId(firstItem.getQuoteId());
                updateSscConsultQuoteInfo.setQuoteStatus(DycProSscConstants.QuoteStatus.LOST_QUOTE);
                updateSscConsultQuoteInfo.setCancelQuoteReason("\u63d0\u4ea4\u65b0\u7ade\u4ef7\u62a5\u4ef7\uff0c\u5386\u53f2\u62a5\u4ef7\u81ea\u52a8\u5931\u6548");
                updateSscConsultQuoteInfo.setCancelTime(new Date());
                this.sscConsultQuoteInfoMapper.updateById((Object)updateSscConsultQuoteInfo);
            }
        }
        sscConsultQuoteInfoPO.setSupplierId(submitQuoteDTO.getSupplierId());
        sscConsultQuoteInfoPO.setSupplierName(submitQuoteDTO.getSupplierName());
        List sscConsultQuoteItemInfoPOList = JSON.parseArray((String)JSON.toJSONString(submitQuoteDTO.getConsultQuoteItemList()), SscConsultQuoteItemInfoPO.class);
        List consultItemIds = sscConsultQuoteItemInfoPOList.stream().map(SscConsultQuoteItemInfoPO::getConsultItemId).collect(Collectors.toList());
        List itemInfoList = this.sscConsultItemInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SscConsultItemInfoPO::getConsultItemId, consultItemIds));
        Map itemInfoMap = itemInfoList.stream().collect(Collectors.toMap(SscConsultItemInfoPO::getConsultItemId, Function.identity()));
        BigDecimal[] quoteTotalDropFee = new BigDecimal[]{BigDecimal.ZERO};
        sscConsultQuoteItemInfoPOList.forEach(item -> {
            item.setQuoteItemId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setQuoteId(sscConsultQuoteInfoPO.getQuoteId());
            item.setConsultId(sscConsultBaseInfoPO.getConsultId());
            item.setQuoteTurn(sscConsultBaseInfoPO.getCurrentQuoteTurn());
            item.setSupplierId(submitQuoteDTO.getSupplierId());
            item.setSupplierName(submitQuoteDTO.getSupplierName());
            item.setIsChosen(Integer.valueOf(1));
            item.setQuoteTotalAmount(item.getQuotePrice().multiply(item.getPurchaseQuantity()));
            item.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
            SscConsultItemInfoPO itemInfo = (SscConsultItemInfoPO)itemInfoMap.get(item.getConsultItemId());
            if (itemInfo == null) {
                item.setDropFee(BigDecimal.ZERO);
                item.setDiscountRate(BigDecimal.ZERO);
            } else {
                BigDecimal predictTotalPrice = itemInfo.getPredictTotalPrice();
                BigDecimal quoteTotalAmount = item.getQuoteTotalAmount();
                if (predictTotalPrice == null || predictTotalPrice.compareTo(BigDecimal.ZERO) <= 0) {
                    item.setDropFee(BigDecimal.ZERO);
                    item.setDiscountRate(BigDecimal.ZERO);
                } else {
                    BigDecimal dropFee = predictTotalPrice.subtract(quoteTotalAmount);
                    item.setDropFee(dropFee);
                    quoteTotalDropFee[0] = quoteTotalDropFee[0].add(dropFee);
                    try {
                        BigDecimal discountRate = dropFee.divide(predictTotalPrice, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                        item.setDiscountRate(discountRate);
                    }
                    catch (ArithmeticException e) {
                        item.setDiscountRate(BigDecimal.ZERO);
                    }
                }
            }
        });
        this.sscConsultQuoteItemInfoMapper.insertBatch((Collection)sscConsultQuoteItemInfoPOList);
        sscConsultQuoteInfoPO.setQuoteCount(Long.valueOf(sscConsultQuoteItemInfoPOList.size()));
        sscConsultQuoteInfoPO.setQuoteTotalAmount(sscConsultQuoteItemInfoPOList.stream().map(item -> item.getQuoteTotalAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(sscConsultBaseInfoPO.getConsultType())) {
            List sscConsultQuoteInfoMinPOS = this.sscConsultQuoteInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultQuoteInfoPO::getConsultId, (Object)sscConsultBaseInfoPO.getConsultId())).eq(SscConsultQuoteInfoPO::getQuoteTurn, (Object)sscConsultBaseInfoPO.getCurrentQuoteTurn())).orderByAsc(SscConsultQuoteInfoPO::getQuoteTotalAmount)).last("LIMIT 1"));
            if (!CollectionUtils.isEmpty((Collection)sscConsultQuoteInfoMinPOS) && sscConsultQuoteInfoPO.getQuoteTotalAmount().compareTo(((SscConsultQuoteInfoPO)sscConsultQuoteInfoMinPOS.get(0)).getQuoteTotalAmount()) >= 0) {
                throw new ZTBusinessException("\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e\u5f53\u524d\u6700\u4f4e\u62a5\u4ef7\u91d1\u989d");
            }
            if (sscConsultQuoteInfoPO.getQuoteTotalAmount().compareTo(sscConsultBaseInfoPO.getConsultTotalPrice()) >= 0) {
                throw new ZTBusinessException("\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e\u8d77\u7ade\u4ef7");
            }
        }
        BigDecimal totalDropFee = quoteTotalDropFee[0];
        sscConsultQuoteInfoPO.setDropFee(totalDropFee);
        if (sscConsultBaseInfoPO.getConsultTotalPrice().compareTo(BigDecimal.ZERO) == 0) {
            sscConsultQuoteInfoPO.setDiscountRate(BigDecimal.ZERO);
        } else {
            sscConsultQuoteInfoPO.setDiscountRate(totalDropFee.divide(sscConsultBaseInfoPO.getConsultTotalPrice(), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
        }
        sscConsultQuoteInfoPO.setQuoteStatus(DycProSscConstants.QuoteStatus.HAS_QUOTE);
        sscConsultQuoteInfoPO.setQuoteTime(new Date());
        sscConsultQuoteInfoPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        this.sscConsultQuoteInfoMapper.insert((Object)sscConsultQuoteInfoPO);
        SscConsultSupplierInfoPO updateConsultSupplierPO = new SscConsultSupplierInfoPO();
        updateConsultSupplierPO.setQuoteCount(sscConsultQuoteInfoPO.getQuoteCount());
        updateConsultSupplierPO.setQuoteTotalAmount(sscConsultQuoteInfoPO.getQuoteTotalAmount());
        updateConsultSupplierPO.setQuoteTime(new Date());
        updateConsultSupplierPO.setDropFee(sscConsultQuoteInfoPO.getDropFee());
        updateConsultSupplierPO.setDiscountRate(sscConsultQuoteInfoPO.getDiscountRate());
        int rowsAffected = this.sscConsultSupplierInfoMapper.update((Object)updateConsultSupplierPO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultQuoteInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getSupplierId, (Object)sscConsultQuoteInfoPO.getSupplierId())).eq(SscConsultSupplierInfoPO::getQuoteTurn, (Object)sscConsultQuoteInfoPO.getQuoteTurn()));
        if (rowsAffected != 1) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        List sscFileInfoPOList = JSON.parseArray((String)JSON.toJSONString(submitQuoteDTO.getFileInfoList()), SscFileInfoPO.class);
        sscFileInfoPOList.forEach(item -> {
            item.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setObjId(sscConsultQuoteInfoPO.getQuoteId());
            item.setObjType(DycProSscConstants.SscFileObjType.CONSULT_SUPPLIER_QUOTE);
        });
        this.sscFileInfoMapper.insertBatch((Collection)sscFileInfoPOList);
    }

    @Override
    public void dealRevocationConsultQuote(DycProSscConsultQuoteInfoDTO dycProSscConsultQuoteInfoDTO) {
        SscConsultQuoteInfoPO sscConsultQuoteInfoPO = (SscConsultQuoteInfoPO)this.sscConsultQuoteInfoMapper.selectById((Serializable)dycProSscConsultQuoteInfoDTO.getQuoteId());
        if (null == sscConsultQuoteInfoPO) {
            throw new ZTBusinessException("\u62a5\u4ef7\u4fe1\u606f\u4e3a\u7a7a");
        }
        SscConsultSupplierInfoPO sscConsultSupplierInfoPO = (SscConsultSupplierInfoPO)this.sscConsultSupplierInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultQuoteInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getSupplierId, (Object)sscConsultQuoteInfoPO.getSupplierId()));
        if (null == sscConsultSupplierInfoPO) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (sscConsultQuoteInfoPO.getQuoteCount() > sscConsultSupplierInfoPO.getQuoteCount() || sscConsultQuoteInfoPO.getQuoteTotalAmount().compareTo(sscConsultSupplierInfoPO.getQuoteTotalAmount()) > 0) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u6570\u91cf\u6216\u91d1\u989d\u4e0d\u8db3");
        }
        SscConsultQuoteInfoPO updateSscConsultQuoteInfo = new SscConsultQuoteInfoPO();
        updateSscConsultQuoteInfo.setQuoteId(dycProSscConsultQuoteInfoDTO.getQuoteId());
        updateSscConsultQuoteInfo.setQuoteStatus(DycProSscConstants.QuoteStatus.REVOCATION_QUOTE);
        updateSscConsultQuoteInfo.setCancelQuoteReason(dycProSscConsultQuoteInfoDTO.getCancelQuoteReason());
        updateSscConsultQuoteInfo.setCancelTime(new Date());
        this.sscConsultQuoteInfoMapper.updateById((Object)updateSscConsultQuoteInfo);
        this.sscConsultSupplierInfoMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SscConsultSupplierInfoPO::getConsultId, (Object)sscConsultQuoteInfoPO.getConsultId())).eq(SscConsultSupplierInfoPO::getSupplierId, (Object)sscConsultQuoteInfoPO.getSupplierId())).setSql("QUOTE_COUNT = QUOTE_COUNT - " + sscConsultQuoteInfoPO.getQuoteCount() + " ,QUOTE_TOTAL_AMOUNT = QUOTE_TOTAL_AMOUNT - " + sscConsultQuoteInfoPO.getQuoteTotalAmount()));
    }
}

