/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.impl;

import cn.hutool.core.date.ChineseDate;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.dao.SscWorkDayInfoMapper;
import com.tydic.dyc.pro.dmc.po.SscWorkDayInfoPO;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscWorkDayRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscWorkDayInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscWorkDayQryDTO;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycProSscWorkDayRepositoryImpl
implements DycProSscWorkDayRepository {
    @Autowired
    private SscWorkDayInfoMapper sscWorkDayInfoMapper;

    @Override
    public void initWorkDataInfo(DycProSscWorkDayInfoDTO dycProSscWorkDayInfoDTO) {
        int year = dycProSscWorkDayInfoDTO.getWorkDayYear();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter formatterLunar = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        ArrayList<SscWorkDayInfoPO> sscWorkDayInfoPOList = new ArrayList<SscWorkDayInfoPO>();
        Date now = new Date();
        for (int month = 1; month <= 12; ++month) {
            LocalDate date = LocalDate.of(year, month, 1);
            for (int day = 1; day <= date.getMonth().length(date.isLeapYear()); ++day) {
                LocalDate currentDate = LocalDate.of(year, month, day);
                SscWorkDayInfoPO sscWorkDayInfoPO = new SscWorkDayInfoPO();
                sscWorkDayInfoPO.setWorkDayId(Long.valueOf(Sequence.getInstance().nextId()));
                sscWorkDayInfoPO.setCreateTime(now);
                sscWorkDayInfoPO.setUpdateTime(now);
                sscWorkDayInfoPO.setCreateId(dycProSscWorkDayInfoDTO.getUpdateId());
                sscWorkDayInfoPO.setCreateName(dycProSscWorkDayInfoDTO.getUpdateName());
                sscWorkDayInfoPO.setCreateUsername(dycProSscWorkDayInfoDTO.getUpdateUsername());
                sscWorkDayInfoPO.setUpdateId(dycProSscWorkDayInfoDTO.getUpdateId());
                sscWorkDayInfoPO.setUpdateName(dycProSscWorkDayInfoDTO.getUpdateName());
                sscWorkDayInfoPO.setUpdateUsername(dycProSscWorkDayInfoDTO.getUpdateUsername());
                sscWorkDayInfoPO.setWorkDayDate(Long.valueOf(Long.parseLong(currentDate.format(formatter))));
                sscWorkDayInfoPO.setWorkDayYear(Integer.valueOf(year));
                sscWorkDayInfoPO.setWorkDayMonth(Integer.valueOf(month));
                sscWorkDayInfoPO.setWorkDayDay(Integer.valueOf(day));
                sscWorkDayInfoPO.setWorkDayWeek(Integer.valueOf(currentDate.getDayOfWeek().getValue()));
                sscWorkDayInfoPO.setWorkDayDelFlag(DycProSscConstants.WorkDayIsDel.NOT_DEL);
                sscWorkDayInfoPO.setWorkDayDateType(DycProSscConstants.DateType.NORMAL_DAY);
                sscWorkDayInfoPO.setWorkDayFestType(DycProSscConstants.Festival.NO_FESTIVAL);
                if (currentDate.getDayOfWeek().getValue() == 6 || currentDate.getDayOfWeek().getValue() == 7) {
                    sscWorkDayInfoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_NOT_WORK_DAY);
                } else {
                    sscWorkDayInfoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_WORK_DAY);
                }
                ChineseDate chineseDate = new ChineseDate((Date)DateUtil.parseDate((CharSequence)currentDate.format(formatterLunar)));
                if (chineseDate.getDay() == 1) {
                    sscWorkDayInfoPO.setWorkDayLunar(chineseDate.getChineseMonth());
                } else {
                    sscWorkDayInfoPO.setWorkDayLunar(chineseDate.getChineseDay());
                }
                if (sscWorkDayInfoPO.getWorkDayMonth().equals(1) && sscWorkDayInfoPO.getWorkDayDay().equals(1)) {
                    sscWorkDayInfoPO.setWorkDayFestType(DycProSscConstants.Festival.NEW_YEAR);
                    sscWorkDayInfoPO.setWorkDayDateType(DycProSscConstants.DateType.FESTIVAL);
                    sscWorkDayInfoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_NOT_WORK_DAY);
                }
                sscWorkDayInfoPOList.add(sscWorkDayInfoPO);
            }
        }
        this.sscWorkDayInfoMapper.insertBatch(sscWorkDayInfoPOList);
    }

    @Override
    public void updateWorkDayType(DycProSscWorkDayInfoDTO dycProSscWorkDayInfoDTO) {
        dycProSscWorkDayInfoDTO.setWorkDayDate(null);
        SscWorkDayInfoPO sscWorkDayInfoPO = (SscWorkDayInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProSscWorkDayInfoDTO), SscWorkDayInfoPO.class);
        ArrayList infoPOList = new ArrayList();
        List qryIdPOList = this.sscWorkDayInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().between(null != dycProSscWorkDayInfoDTO.getWorkDayStart() && null != dycProSscWorkDayInfoDTO.getWorkDayEnd(), SscWorkDayInfoPO::getWorkDayDate, (Object)dycProSscWorkDayInfoDTO.getWorkDayStart(), (Object)dycProSscWorkDayInfoDTO.getWorkDayEnd()));
        if (qryIdPOList != null && !qryIdPOList.isEmpty()) {
            qryIdPOList.forEach(datePO -> {
                SscWorkDayInfoPO infoPO = new SscWorkDayInfoPO();
                BeanUtils.copyProperties((Object)sscWorkDayInfoPO, (Object)infoPO);
                if (infoPO.getWorkDayDateType() != DycProSscConstants.DateType.FESTIVAL || datePO != qryIdPOList.get(0)) {
                    infoPO.setWorkDayFestType(DycProSscConstants.Festival.NO_FESTIVAL);
                }
                if (infoPO.getWorkDayDateType() == DycProSscConstants.DateType.ADJUSTMENT) {
                    infoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_WORK_DAY);
                } else if (infoPO.getWorkDayDateType() == DycProSscConstants.DateType.FESTIVAL) {
                    infoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_NOT_WORK_DAY);
                } else if (datePO.getWorkDayWeek() == DycProSscConstants.WorkDayWeek.SATURDAY || datePO.getWorkDayWeek() == DycProSscConstants.WorkDayWeek.SUNDAY) {
                    infoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_NOT_WORK_DAY);
                } else {
                    infoPO.setIsWorkDay(DycProSscConstants.IsWorkDay.IS_WORK_DAY);
                }
                infoPO.setWorkDayId(datePO.getWorkDayId());
                infoPOList.add(infoPO);
            });
            if (!infoPOList.isEmpty()) {
                try {
                    this.sscWorkDayInfoMapper.updateBatchByIds(infoPOList);
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u66f4\u65b0\u5de5\u4f5c\u65e5\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }

    @Override
    public RspPage<DycProSscWorkDayInfoDTO> selectWorkDayInfoConditionPage(DycProSscWorkDayQryDTO qryDTO) {
        RspPage rspPage = new RspPage();
        if (qryDTO.getWorkDayYear() != null) {
            boolean isLeapYear;
            int year = qryDTO.getWorkDayYear();
            boolean bl = isLeapYear = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
            if (isLeapYear) {
                qryDTO.setPageSize(DycProSscConstants.IsLeapYear.LEAP_YEAR);
            } else {
                qryDTO.setPageSize(DycProSscConstants.IsLeapYear.NOT_LEAP_YEAR);
            }
        }
        Page pg = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        if (qryDTO.getOperType() == DycProSscConstants.isOperType.YES) {
            DycProSscWorkDayInfoDTO dto = new DycProSscWorkDayInfoDTO();
            BeanUtils.copyProperties((Object)qryDTO, (Object)dto);
            if (qryDTO.getWorkDayYear() == null) {
                dto.setWorkDayYear(LocalDate.now().getYear());
                qryDTO.setWorkDayYear(LocalDate.now().getYear());
            }
            this.initWorkDataInfo(dto);
        }
        Page sscWorkDayInfoPOPage = (Page)this.sscWorkDayInfoMapper.selectPage((IPage)pg, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != qryDTO.getWorkDayYear(), SscWorkDayInfoPO::getWorkDayYear, (Object)qryDTO.getWorkDayYear())).orderBy(true, "asc".equalsIgnoreCase(qryDTO.getOrderBy()), SscWorkDayInfoPO::getWorkDayDate));
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)sscWorkDayInfoPOPage.getRecords()), DycProSscWorkDayInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public DycProSscWorkDayInfoDTO selectWorkDayInfoByDateAndWorkDay(DycProSscWorkDayQryDTO qryDTO) {
        DycProSscWorkDayInfoDTO dycProSscWorkDayInfoDTO = new DycProSscWorkDayInfoDTO();
        if (qryDTO.getWorkDayNum() == null || qryDTO.getWorkDayNum() <= 0) {
            SscWorkDayInfoPO sscWorkDayInfoPO = (SscWorkDayInfoPO)this.sscWorkDayInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != qryDTO.getWorkDayDate(), SscWorkDayInfoPO::getWorkDayDate, (Object)qryDTO.getWorkDayDate()));
            BeanUtils.copyProperties((Object)sscWorkDayInfoPO, (Object)dycProSscWorkDayInfoDTO);
            return dycProSscWorkDayInfoDTO;
        }
        Page page = new Page((long)qryDTO.getWorkDayNum().intValue(), 1L);
        Page resultPage = (Page)this.sscWorkDayInfoMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().gt(SscWorkDayInfoPO::getWorkDayDate, (Object)qryDTO.getWorkDayDate())).eq(SscWorkDayInfoPO::getIsWorkDay, (Object)DycProSscConstants.IsWorkDay.IS_WORK_DAY)).orderByAsc(SscWorkDayInfoPO::getWorkDayDate));
        if (resultPage.getRecords().isEmpty()) {
            return null;
        }
        SscWorkDayInfoPO targetWorkDay = (SscWorkDayInfoPO)resultPage.getRecords().get(0);
        BeanUtils.copyProperties((Object)targetWorkDay, (Object)dycProSscWorkDayInfoDTO);
        return dycProSscWorkDayInfoDTO;
    }

    @Override
    public RspPage<DycProSscWorkDayInfoDTO> selectWorkDayInfoByYearMonth(DycProSscWorkDayQryDTO qryDTO) {
        RspPage rspPage = new RspPage();
        Page pg = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        Page sscWorkDayInfoPOPage = (Page)this.sscWorkDayInfoMapper.selectPage((IPage)pg, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != qryDTO.getWorkDayDateType(), SscWorkDayInfoPO::getWorkDayDateType, (Object)qryDTO.getWorkDayDateType())).eq(null != qryDTO.getWorkDayFestType(), SscWorkDayInfoPO::getWorkDayFestType, (Object)qryDTO.getWorkDayFestType())).eq(null != qryDTO.getWorkDayYear(), SscWorkDayInfoPO::getWorkDayYear, (Object)qryDTO.getWorkDayYear())).eq(null != qryDTO.getWorkDayMonth(), SscWorkDayInfoPO::getWorkDayMonth, (Object)qryDTO.getWorkDayMonth())).orderBy(true, "asc".equalsIgnoreCase(qryDTO.getOrderBy()), SscWorkDayInfoPO::getWorkDayDate));
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)sscWorkDayInfoPOPage.getRecords()), DycProSscWorkDayInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }
}

