/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderSysnPayStateApiService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSysnPayStateApiReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSysnPayStateApiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderSysnPayStateApiService"})
public class DycProOrderSysnPayStateApiServiceImpl
implements DycProOrderSysnPayStateApiService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @PostMapping(value={"sysnPayState"})
    public DycProOrderSysnPayStateApiRspBO sysnPayState(@RequestBody DycProOrderSysnPayStateApiReqBO reqBO) {
        List saleOrderDtoList;
        this.verifyParam(reqBO);
        DycProOrderSaleOrderDTO saleOrderQryDto = new DycProOrderSaleOrderDTO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSaleOrderIds())) {
            saleOrderQryDto.setSaleOrderIds(reqBO.getSaleOrderIds());
        }
        if (null != reqBO.getFscOrderId()) {
            saleOrderQryDto.setFscOrderId(reqBO.getFscOrderId());
        }
        if (StringUtil.isNotBlank((CharSequence)reqBO.getSaleOrderNoExt())) {
            saleOrderQryDto.setSaleOrderNoExt(reqBO.getSaleOrderNoExt());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderListByCondition(saleOrderQryDto)))) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
        }
        List updateSaleOrderDtoList = saleOrderDtoList.stream().map(item -> {
            DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
            updateSaleOrderDto.setSaleOrderId(item.getSaleOrderId());
            updateSaleOrderDto.setPayState(DycProOrderApiServiceConstant.PayState.PAYED);
            return updateSaleOrderDto;
        }).collect(Collectors.toList());
        this.dycProOrderSaleOrderRepository.updateSaleOrderBatchByIdSameAndSyncNosql(updateSaleOrderDtoList);
        return new DycProOrderSysnPayStateApiRspBO();
    }

    private void verifyParam(DycProOrderSysnPayStateApiReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSaleOrderIds()) && null == reqBO.getFscOrderId() && StringUtil.isBlank((CharSequence)reqBO.getSaleOrderNoExt())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

