/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealAfOrderShopAddressService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderShopAddressReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderShopAddressRspBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealAfOrderShopAddressService"})
public class DycProOrderDealAfOrderShopAddressServiceImpl
implements DycProOrderDealAfOrderShopAddressService {
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    public static final Integer PICKWARE_TYPE = 40;

    @PostMapping(value={"dealAfOrderShopAddress"})
    public DycProOrderDealAfOrderShopAddressRspBO dealAfOrderShopAddress(@RequestBody DycProOrderDealAfOrderShopAddressReqBO reqBo) {
        DycProOrderDealAfOrderShopAddressRspBO rspBo = new DycProOrderDealAfOrderShopAddressRspBO();
        boolean pickwareTypeFlag = this.validataArg(reqBo);
        if (pickwareTypeFlag) {
            return rspBo;
        }
        List<DycProOrderAfOrderDTO> afOrderList = this.getAfOrderList(reqBo);
        if (ObjectUtil.isEmpty(afOrderList)) {
            throw new ZTBusinessException("\u6839\u636e\u670d\u52a1\u5355ID\u67e5\u8be2\u552e\u540e\u5355\u4e3a\u7a7a");
        }
        Date now = new Date();
        DycProOrderOrdLogisticsRelaDTO logisticsRela = this.insertLogisticsRela(reqBo, afOrderList.get(0), now);
        this.updateAfOrderRela(afOrderList.get(0), logisticsRela, now);
        return rspBo;
    }

    private void updateAfOrderRela(DycProOrderAfOrderDTO afOrder, DycProOrderOrdLogisticsRelaDTO logisticsRela, Date now) {
        DycProOrderAfOrderDTO afOrderDo = new DycProOrderAfOrderDTO();
        afOrderDo.setAfOrderId(afOrder.getAfOrderId());
        afOrderDo.setUpdateTime(now);
        this.dycProOrderAfOrderRepository.modifyAfOrderById(afOrderDo);
    }

    private List<DycProOrderAfOrderDTO> getAfOrderList(DycProOrderDealAfOrderShopAddressReqBO reqBo) {
        DycProOrderAfOrderDTO afOrderDto = new DycProOrderAfOrderDTO();
        afOrderDto.setExtAfId(reqBo.getServiceId());
        return this.dycProOrderAfOrderRepository.getAfOrderList(afOrderDto);
    }

    private DycProOrderOrdLogisticsRelaDTO insertLogisticsRela(DycProOrderDealAfOrderShopAddressReqBO reqBo, DycProOrderAfOrderDTO afOrder, Date now) {
        Long contactId = Sequence.getInstance().nextId();
        DycProOrderAfOrderDTO uocAfOrderDo = new DycProOrderAfOrderDTO();
        uocAfOrderDo.setAfOrderId(afOrder.getAfOrderId());
        uocAfOrderDo.setJhContactId(contactId);
        this.dycProOrderAfOrderRepository.modifyAfOrderById(uocAfOrderDo);
        DycProOrderOrdLogisticsRelaDTO logisticsRela = new DycProOrderOrdLogisticsRelaDTO();
        logisticsRela.setContactId(contactId);
        logisticsRela.setOrderId(afOrder.getOrderId());
        logisticsRela.setContactAddress(reqBo.getReturnAdress());
        logisticsRela.setContactName(reqBo.getLinkedMan());
        logisticsRela.setContactMobile(reqBo.getLinkedMobile());
        logisticsRela.setCreateTime(now);
        return this.dycProOrderOrderRepository.createOrderLogisticsRela(logisticsRela);
    }

    private boolean validataArg(DycProOrderDealAfOrderShopAddressReqBO reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getServiceId())) {
            throw new ZTBusinessException("\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u670d\u52a1\u5355\u53f7[serviceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPickwareType())) {
            throw new ZTBusinessException("\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u5bc4\u4ef6\u65b9\u5f0f[pickwareType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.notEqual((Object)reqBo.getPickwareType(), (Object)PICKWARE_TYPE)) {
            return true;
        }
        if (ObjectUtil.equal((Object)reqBo.getPickwareType(), (Object)PICKWARE_TYPE) && ObjectUtil.isEmpty((Object)reqBo.getReturnAdress())) {
            throw new ZTBusinessException("\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u5bc4\u4ef6\u65b9\u5f0f\u4e3a\u5ba2\u6237\u53d1\u8d27\u65f6\u5bc4\u4ef6\u5730\u5740[returnAdress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return false;
    }
}

