/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.approve.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcPurApplyItemStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcPurApplyStatus;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.egc.constant.DycProOrderServiceConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderAgreementDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderConfSupplierDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAgreementDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleAfterTakeTypeDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.service.approve.api.DycProOrderCompleteApproveTaskService;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderCompleteApproveTaskRspBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderPublicTaskInstBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspSaleOrderBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspSaleOrderItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.approve.api.DycProOrderCompleteApproveTaskService"})
public class DycProOrderCompleteApproveTaskServiceImpl
implements DycProOrderCompleteApproveTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCompleteApproveTaskServiceImpl.class);
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Value(value="${isLimitPrice:true}")
    private boolean limitPrice;

    @PostMapping(value={"completeApproveTask"})
    public DycProOrderCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProOrderCompleteApproveTaskReqBO reqBO) {
        DycProOrderCompleteApproveTaskRspBO rspBO = new DycProOrderCompleteApproveTaskRspBO();
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowTaskInstHandleDto);
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        if (reqBO.getIsFinish().booleanValue()) {
            if ("BudgetApprove".equals(reqBO.getBusiType())) {
                log.info("\u5904\u7406\u9884\u7b97\u5ba1\u6279\uff0c\u9884\u7b97ID: {}, \u5ba1\u6279\u7ed3\u679c: {}", (Object)reqBO.getObjId(), (Object)reqBO.getDealResult());
                Integer budgetStatus = "pass".equals(reqBO.getDealResult()) ? DycProOrderApiServiceConstant.BudgetStatus.PENDING_EFFECTIVE : DycProOrderApiServiceConstant.BudgetStatus.REJECTED;
                int updateResult = this.dycProOrderBudgetRepository.updateBudgetStatus(reqBO.getObjId(), budgetStatus);
                if (updateResult <= 0) {
                    throw new ZTBusinessException("\u9884\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u9884\u7b97ID: " + reqBO.getObjId());
                }
                log.info("\u9884\u7b97\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c\u9884\u7b97ID: {}, \u65b0\u72b6\u6001: {}", (Object)reqBO.getObjId(), (Object)budgetStatus);
            } else if ("PurchaseApplyApprove".equals(reqBO.getBusiType())) {
                log.info("\u5904\u7406\u91c7\u8d2d\u7533\u8bf7\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
                DycProOrderApprovalObjDTO approvalObjDTO = new DycProOrderApprovalObjDTO();
                approvalObjDTO.setAuditOrderId(reqBO.getObjId());
                DycProOrderApprovalObjDTO approvalObjDto = this.dycProOrderApproveRepository.queryApprovalObjOneById(approvalObjDTO);
                DycProOrderOrderDTO queryOrderBO = new DycProOrderOrderDTO();
                queryOrderBO.setOrderId(Long.valueOf(approvalObjDto.getObjId()));
                DycProOrderOrderDTO orderMainInfo = this.dycProOrderOrderRepository.queryOrderAllInfo(queryOrderBO);
                DycProOrderSaleOrderItemQryDTO queryOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
                queryOrderItemDto.setOrderId(Long.valueOf(approvalObjDto.getObjId()));
                List orderItemList = this.dycProOrderOrderRepository.qryOrderItemList(queryOrderItemDto);
                if ("pass".equals(reqBO.getDealResult())) {
                    this.updatePurApplyAndItemStatusPass(orderItemList);
                    rspBO.setSaleOrderList(this.splitMainOrder(orderItemList, approvalObjDto, orderMainInfo));
                    rspBO.setOrderId(Long.valueOf(Long.parseLong(approvalObjDto.getObjId())));
                    rspBO.setOrgId(orderMainInfo.getOrgId());
                    rspBO.setOrgName(orderMainInfo.getOrgName());
                    rspBO.setUserId(orderMainInfo.getUserId());
                    rspBO.setUserName(orderMainInfo.getUserName());
                    rspBO.setOrderId(orderMainInfo.getOrderId());
                } else {
                    this.updatePurApplyAndItemStatusReject(orderItemList, orderMainInfo);
                }
            } else {
                DycProOrderApprovalObjDTO approvalObjDTO = new DycProOrderApprovalObjDTO();
                approvalObjDTO.setAuditOrderId(reqBO.getObjId());
                DycProOrderApprovalObjDTO approvalObjDto = this.dycProOrderApproveRepository.queryApprovalObjOneById(approvalObjDTO);
                if (DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER.equals(approvalObjDto.getObjBusiType())) {
                    ArrayList<Object> taskInsts = new ArrayList<Object>();
                    DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
                    saleOrderDTO.setOrderId(Long.valueOf(approvalObjDto.getObjId()));
                    List saleOrderDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderListByCondition(saleOrderDTO);
                    for (DycProOrderSaleOrderDTO saleOrder : saleOrderDTOList) {
                        if ("XS_QX_QX".equals(saleOrder.getSaleOrderState()) || "XS_XD_SB".equals(saleOrder.getSaleOrderState())) continue;
                        DycProPublicTaskInstDTO publicTaskInstDTO = new DycProPublicTaskInstDTO();
                        publicTaskInstDTO.setObjId(saleOrder.getSaleOrderId());
                        publicTaskInstDTO.setObjType("salesOrder");
                        publicTaskInstDTO.setFinishTag(Integer.valueOf(0));
                        List taskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(publicTaskInstDTO);
                        if (CollectionUtils.isEmpty((Collection)taskInstDTOS) || taskInstDTOS.size() != 1) {
                            throw new ZTBusinessException("\u67e5\u8be2\u5f85\u5904\u7406\u4e1a\u52a1\u6d41\u4efb\u52a1\u9519\u8bef\uff01");
                        }
                        DycProPublicTaskInstDTO taskInstDTO = (DycProPublicTaskInstDTO)taskInstDTOS.get(0);
                        taskInsts.add(JSON.parseObject((String)JSON.toJSONString((Object)taskInstDTO), DycProOrderPublicTaskInstBO.class));
                        DycProPublicTaskInstHandleDTO busiTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
                        busiTaskInstHandleDto.setTaskInstId(taskInstDTO.getTaskInstId());
                        this.dycProPublicTaskInstRepository.completeBusiFlowTask(busiTaskInstHandleDto);
                        if (!"reject".equals(reqBO.getDealResult())) continue;
                        DycProOrderSaleOrderDTO updaeSaleOrderDTO = new DycProOrderSaleOrderDTO();
                        updaeSaleOrderDTO.setSaleOrderId(saleOrder.getSaleOrderId());
                        updaeSaleOrderDTO.setSaleOrderState("XS_QX_QX");
                        updaeSaleOrderDTO.setCancelReason(reqBO.getDealRemark());
                        updaeSaleOrderDTO.setCancelOperId(reqBO.getDealUserId().toString());
                        updaeSaleOrderDTO.setCancelOperName(reqBO.getDealUserName());
                        updaeSaleOrderDTO.setCancelTime(new Date());
                        updaeSaleOrderDTO.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.APPROVE_CANCEL);
                        updaeSaleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
                        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updaeSaleOrderDTO, true);
                        if (CollectionUtils.isEmpty((Collection)reqBO.getApprovelOrderFileList())) continue;
                        ArrayList<DycProOrderOrderAccessoryDTO> cancelOrderFileList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                        for (DycProOrderAccessoryApiBO accessoryBO : reqBO.getApprovelOrderFileList()) {
                            DycProOrderOrderAccessoryDTO addAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)addAccessoryDTO);
                            addAccessoryDTO.setObjId(saleOrder.getSaleOrderId());
                            addAccessoryDTO.setOrderId(saleOrder.getOrderId());
                            addAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CANCEL);
                            cancelOrderFileList.add(addAccessoryDTO);
                        }
                        this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(cancelOrderFileList);
                    }
                    rspBO.setTaskInsts(taskInsts);
                }
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updatePurApplyAndItemStatusPass(List<DycProOrderSaleOrderItemDTO> orderItemList) {
        ArrayList<DycProOrderZlPurchaseApplyItemDTO> updatePurchaseApplyItemList = new ArrayList<DycProOrderZlPurchaseApplyItemDTO>();
        if (!CollectionUtils.isEmpty(orderItemList)) {
            for (DycProOrderSaleOrderItemDTO item2 : orderItemList) {
                DycProOrderZlPurchaseApplyItemDTO applyItem = new DycProOrderZlPurchaseApplyItemDTO();
                applyItem.setPurApplyItemId(item2.getPurApplyItemId());
                applyItem.setPurApplyItemStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyItemStatus.EXECUTED.getCode())));
                updatePurchaseApplyItemList.add(applyItem);
            }
        }
        if (!CollectionUtils.isEmpty(updatePurchaseApplyItemList)) {
            this.dycProOrderPurchaseApplyRepository.updateBatchPurchaseApplyItemByIds(updatePurchaseApplyItemList);
            DycProOrderZlPurchaseApplyItemDTO queryApplyItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
            List executedPurApplyIds = updatePurchaseApplyItemList.stream().distinct().map(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(executedPurApplyIds)) {
                queryApplyItemDTO.setPurApplyIds(executedPurApplyIds);
                List dycProOrderZlPurchaseApplyItemDTOS = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryApplyItemDTO);
                Map<Long, List<DycProOrderZlPurchaseApplyItemDTO>> groupedByPurApplyId = dycProOrderZlPurchaseApplyItemDTOS.stream().collect(Collectors.groupingBy(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId));
                for (Long purApplyId : executedPurApplyIds) {
                    List<DycProOrderZlPurchaseApplyItemDTO> items = groupedByPurApplyId.get(purApplyId);
                    boolean allExecuted = items.stream().allMatch(item -> Integer.parseInt(ZLEgcPurApplyItemStatus.EXECUTED.getCode()) == item.getPurApplyItemStatus());
                    if (!allExecuted) continue;
                    DycProOrderZlPurchaseApplyDTO updatePurchaseApplyDTO = new DycProOrderZlPurchaseApplyDTO();
                    updatePurchaseApplyDTO.setPurApplyId(purApplyId);
                    updatePurchaseApplyDTO.setPurApplyStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyStatus.EXECUTED.getCode())));
                    this.dycProOrderPurchaseApplyRepository.updatePurchaseApplyById(updatePurchaseApplyDTO);
                }
            }
        }
    }

    private void updatePurApplyAndItemStatusReject(List<DycProOrderSaleOrderItemDTO> orderItemList, DycProOrderOrderDTO orderMainInfo) {
        List dycProOrderZlPurchaseApplyItemDTOS;
        ArrayList<DycProOrderZlPurchaseApplyItemDTO> updatePurchaseApplyItemList = new ArrayList<DycProOrderZlPurchaseApplyItemDTO>();
        if (!CollectionUtils.isEmpty(orderItemList)) {
            List purApplyItemIds = orderItemList.stream().distinct().map(DycProOrderSaleOrderItemDTO::getPurApplyItemId).collect(Collectors.toList());
            DycProOrderZlPurchaseApplyItemDTO queryApplyItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
            queryApplyItemDTO.setPurApplyItemIds(purApplyItemIds);
            dycProOrderZlPurchaseApplyItemDTOS = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryApplyItemDTO);
            Map purchaseApplyItemMap = dycProOrderZlPurchaseApplyItemDTOS.stream().collect(Collectors.toMap(DycProOrderZlPurchaseApplyItemDTO::getPurApplyItemId, Function.identity()));
            for (DycProOrderSaleOrderItemDTO item2 : orderItemList) {
                DycProOrderZlPurchaseApplyItemDTO purchaseApplyItemDTO = (DycProOrderZlPurchaseApplyItemDTO)purchaseApplyItemMap.get(item2.getPurApplyItemId());
                if (purchaseApplyItemDTO == null) continue;
                DycProOrderZlPurchaseApplyItemDTO applyItem = new DycProOrderZlPurchaseApplyItemDTO();
                applyItem.setPurApplyItemId(item2.getPurApplyItemId());
                if (purchaseApplyItemDTO.getOccupyAmount().compareTo(item2.getPurchaseCount()) == 0) {
                    applyItem.setPurApplyItemStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyItemStatus.PENDING_EXECUTION.getCode())));
                } else {
                    applyItem.setPurApplyItemStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyItemStatus.EXECUTED.getCode())));
                }
                updatePurchaseApplyItemList.add(applyItem);
            }
        }
        if (!CollectionUtils.isEmpty(updatePurchaseApplyItemList)) {
            this.dycProOrderPurchaseApplyRepository.updateBatchPurchaseApplyItemByIds(updatePurchaseApplyItemList);
            List executedPurApplyIds = updatePurchaseApplyItemList.stream().distinct().map(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(executedPurApplyIds)) {
                DycProOrderZlPurchaseApplyItemDTO queryNewItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
                queryNewItemDTO.setPurApplyIds(executedPurApplyIds);
                dycProOrderZlPurchaseApplyItemDTOS = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryNewItemDTO);
                Map<Long, List<DycProOrderZlPurchaseApplyItemDTO>> groupedByPurApplyId = dycProOrderZlPurchaseApplyItemDTOS.stream().collect(Collectors.groupingBy(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId));
                for (Long purApplyId : executedPurApplyIds) {
                    List<DycProOrderZlPurchaseApplyItemDTO> items = groupedByPurApplyId.get(purApplyId);
                    boolean allPendingExecuted = items.stream().allMatch(item -> Integer.parseInt(ZLEgcPurApplyItemStatus.PENDING_EXECUTION.getCode()) == item.getPurApplyItemStatus());
                    if (!allPendingExecuted) continue;
                    DycProOrderZlPurchaseApplyDTO updatePurchaseApplyDTO = new DycProOrderZlPurchaseApplyDTO();
                    updatePurchaseApplyDTO.setPurApplyId(purApplyId);
                    updatePurchaseApplyDTO.setPurApplyStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyStatus.PENDING.getCode())));
                    this.dycProOrderPurchaseApplyRepository.updatePurchaseApplyById(updatePurchaseApplyDTO);
                }
            }
        }
    }

    private List<DycProOrderCreateOrderServiceRspSaleOrderBO> splitMainOrder(List<DycProOrderSaleOrderItemDTO> orderItemList, DycProOrderApprovalObjDTO approvalObjDto, DycProOrderOrderDTO orderMainInfo) {
        ArrayList<DycProOrderCreateOrderServiceRspSaleOrderBO> saleOrderResultList = new ArrayList<DycProOrderCreateOrderServiceRspSaleOrderBO>();
        if (DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.PURCHASE.equals(approvalObjDto.getObjBusiType())) {
            List saleItemList = JSONArray.parseArray((String)JSON.toJSONString(orderItemList)).toJavaList(DycProOrderSaleOrderItemDTO.class);
            List<DycProOrderSaleOrderDTO> createSaleOrderList = this.splitSaleOrderNew(orderMainInfo, saleItemList);
            for (DycProOrderSaleOrderDTO saleOrderDo : createSaleOrderList) {
                if (null != orderMainInfo.getBudgetId()) {
                    this.deductBudget(saleOrderDo);
                }
                DycProOrderSaleOrderDTO saleOrder = this.createSaleOrder(saleOrderDo);
                DycProOrderCreateOrderServiceRspSaleOrderBO orderItemRspData = new DycProOrderCreateOrderServiceRspSaleOrderBO();
                BeanUtils.copyProperties((Object)saleOrder, (Object)orderItemRspData);
                BeanUtils.copyProperties((Object)saleOrder.getSaleStakeholder(), (Object)orderItemRspData);
                orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
                List itemList = JSON.parseArray((String)JSON.toJSONString((Object)saleOrder.getSaleItemList()), DycProOrderCreateOrderServiceRspSaleOrderItemBO.class);
                orderItemRspData.setItemBoList(itemList);
                orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
                orderItemRspData.setOrderSource(saleOrder.getOrderSource());
                orderItemRspData.setAgrId(saleOrder.getAgreementId());
                orderItemRspData.setModelSettle(saleOrder.getModelSettle());
                orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
                saleOrderResultList.add(orderItemRspData);
            }
        }
        return saleOrderResultList;
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(1));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private List<DycProOrderSaleOrderDTO> splitSaleOrderNew(DycProOrderOrderDTO orderInfo, List<DycProOrderSaleOrderItemDTO> saleItemList) {
        ArrayList<DycProOrderSaleOrderDTO> saleOrderList = new ArrayList<DycProOrderSaleOrderDTO>();
        List<DycProOrderSaleOrderDTO> splitSaleOrderResultList = this.splitOrder(saleItemList);
        List agrInfoList = orderInfo.getAgrInfoList();
        Map<Object, Object> agrInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrInfoList)) {
            agrInfoMap = agrInfoList.stream().collect(Collectors.toMap(DycProOrderAgreementDTO::getAgreementId, item -> item));
        }
        Map<String, DycProOrderSaleStakeholderDTO> orderStakeholderMap = orderInfo.getSaleStakeholderInfoList().stream().collect(Collectors.toMap(DycProOrderSaleStakeholderDTO::getSupId, item -> item));
        Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSkuId, o -> o));
        for (DycProOrderSaleOrderDTO saleOrderDo : splitSaleOrderResultList) {
            DycProOrderSaleOrderDTO createSaleOrderDo = (DycProOrderSaleOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)orderInfo), DycProOrderSaleOrderDTO.class);
            createSaleOrderDo.setOrderType(DycProOrderServiceConstant.OrderType.MALL_PUR);
            createSaleOrderDo.setPurchaseApplyId(orderInfo.getPurchaseApplyId());
            saleOrderList.add(createSaleOrderDo);
            List saleOrderItems = saleOrderDo.getSaleItemList();
            for (DycProOrderSaleOrderItemDTO each : saleOrderItems) {
                BeanUtils.copyProperties((Object)saleOrderItemMap.get(each.getSkuId()), (Object)each);
                each.setAgreementName(((DycProOrderAgreementDTO)agrInfoMap.get(each.getAgreementId())).getAgreementName());
                each.setAgreementInfo((DycProOrderOrderAgreementDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrInfoMap.get(each.getAgreementId())), DycProOrderOrderAgreementDTO.class));
                each.setPurApplyItemId(each.getPurApplyItemId());
            }
            createSaleOrderDo.setDeliveryAddress(orderInfo.getReceiverAddress());
            createSaleOrderDo.setSaleItemList(saleOrderItems);
            createSaleOrderDo.setAccessoryList(orderInfo.getAccessoryList());
            createSaleOrderDo.setOrderSource(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSkuSource());
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSupplierId()).getStakeholderId());
            createSaleOrderDo.setSaleStakeholder(orderStakeholderMap.get(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSupplierId()));
            createSaleOrderDo.setTotalSaleFee(this.computeSaleOrderTotalSaleFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setTotalPurchaseFee(this.computeSaleOrderTotalPurchaseFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setCreatedResult(DycProOrderApiServiceConstant.CREATED_RESULT.SUCCESS);
            if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSkuSource())) {
                createSaleOrderDo.setCreatedResult(DycProOrderApiServiceConstant.CREATED_RESULT.PROCESSING);
            }
            createSaleOrderDo.setPurchaseType(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getPurchaseType());
            createSaleOrderDo.setMaterialType(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getMaterialType());
            createSaleOrderDo.setOrderNo(orderInfo.getOrderNo());
            createSaleOrderDo.setPayState(DycProOrderApiServiceConstant.PayState.PAY_FAILED);
            createSaleOrderDo.setModelSettle(DycProOrderApiServiceConstant.ModelSettle.MATCH);
            createSaleOrderDo.setReceiverAddress(orderInfo.getReceiverAddress());
            createSaleOrderDo.setInvoice(orderInfo.getUocOrdInvoice());
        }
        return saleOrderList;
    }

    private List<DycProOrderSaleOrderDTO> splitOrder(List<DycProOrderSaleOrderItemDTO> saleItemList) {
        ArrayList<DycProOrderSaleOrderDTO> saleOrderDoList = new ArrayList<DycProOrderSaleOrderDTO>();
        ArrayList<List<Object>> retList = new ArrayList<List<Object>>();
        Map<String, List<DycProOrderSaleOrderItemDTO>> supMap = saleItemList.stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getSupplierId));
        for (Map.Entry<String, List<DycProOrderSaleOrderItemDTO>> entry : supMap.entrySet()) {
            Map<Integer, List<DycProOrderSaleOrderItemDTO>> agrMap = entry.getValue().stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getMaterialType));
            for (Map.Entry<Integer, List<DycProOrderSaleOrderItemDTO>> agrEntry : agrMap.entrySet()) {
                List planList;
                List noPlanList = agrEntry.getValue().stream().filter(item -> ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(noPlanList)) {
                    retList.add(noPlanList);
                }
                if (!ObjectUtil.isNotEmpty(planList = agrEntry.getValue().stream().filter(item -> !ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.toList()))) continue;
                retList.addAll(planList.stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getPlanId)).values());
            }
        }
        for (List list : retList) {
            DycProOrderSaleOrderDTO createSaleOrderDo = new DycProOrderSaleOrderDTO();
            createSaleOrderDo.setSaleItemList(list);
            saleOrderDoList.add(createSaleOrderDo);
        }
        return saleOrderDoList;
    }

    private BigDecimal computeSaleOrderTotalPurchaseFee(List<DycProOrderSaleOrderItemDTO> saleOrderItems, Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap) {
        BigDecimal saleFee = new BigDecimal(0);
        for (DycProOrderSaleOrderItemDTO uocOrderItem : saleOrderItems) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal computeSaleOrderTotalSaleFee(List<DycProOrderSaleOrderItemDTO> saleOrderItems, Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (DycProOrderSaleOrderItemDTO uocOrderItem : saleOrderItems) {
            totalSaleFee = totalSaleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getSalePrice()));
        }
        return totalSaleFee;
    }

    private DycProOrderSaleOrderDTO createSaleOrder(DycProOrderSaleOrderDTO saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderNo())) {
            DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
            encodeSerialReqBO.setCenterCode("UOC");
            encodeSerialReqBO.setEncodeRuleCode("orderSaleOrderCode");
            encodeSerialReqBO.setNum(Long.valueOf(1L));
            DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
            saleOrderDo.setSaleOrderNo((String)encode.getSerialNoList().get(0));
        }
        saleOrderDo.setContactId(saleOrderDo.getReceiverAddress() != null ? saleOrderDo.getReceiverAddress().getContactId() : null);
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderId())) {
            saleOrderDo.setSaleOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderState())) {
            saleOrderDo.setSaleOrderState(null);
        }
        this.setSaleOrderAccessoryInfo(saleOrderDo);
        this.setSaleItems(saleOrderDo);
        this.setAfterTakeType(saleOrderDo);
        if (this.limitPrice) {
            BigDecimal totalSale = saleOrderDo.getTotalSaleFee();
            totalSale = totalSale.multiply(new BigDecimal(10000));
            String supNo = saleOrderDo.getSaleStakeholder().getSupId();
            String supName = saleOrderDo.getSaleStakeholder().getSupName();
            log.info("\u4f9b\u5e94\u5546 {}\uff0c\u4e0b\u5355\u91d1\u989d\u4e3a {}", (Object)supNo, (Object)totalSale);
            DycProOrderConfSupplierDTO uocConfSupplier = new DycProOrderConfSupplierDTO();
            uocConfSupplier.setSupNo(supNo);
            uocConfSupplier.setLimitStatus(Integer.valueOf(0));
            uocConfSupplier = this.dycProOrderOrderRepository.getConfSupplierModelBy(uocConfSupplier);
            DycProOrderConfSupplierDTO uocConfSupplier1 = new DycProOrderConfSupplierDTO();
            uocConfSupplier1.setSupNo("0");
            uocConfSupplier1.setLimitStatus(Integer.valueOf(0));
            uocConfSupplier1.setBusinessTypeCode(String.valueOf(saleOrderDo.getOrderSource()));
            uocConfSupplier1 = this.dycProOrderOrderRepository.getConfSupplierModelBy(uocConfSupplier1);
            DycProOrderConfSupplierDTO dycProOrderConfSupplierDTO = uocConfSupplier = Objects.nonNull(uocConfSupplier) ? uocConfSupplier : uocConfSupplier1;
            if (ObjectUtil.isNotEmpty((Object)uocConfSupplier)) {
                Long limit = Long.valueOf(uocConfSupplier.getOrderLimit());
                log.info("\u8ba2\u5355\u9650\u989d\uff1a{}", (Object)limit);
                if (limit != null && limit > 0L && limit > totalSale.longValue()) {
                    String money = null;
                    try {
                        money = this.long2BigDecimal(limit).toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw new ZTBusinessException(supName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
                }
            }
        }
        return this.dycProOrderSaleOrderRepository.createSaleOrderAndSyncNoSql(saleOrderDo);
    }

    private void setSaleItems(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleItemList();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItems) {
            List priceComparisonAttachBos;
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderItemId())) {
                saleOrderItem.setSaleOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));
            saleOrderItem.setSaleFee(saleOrderItem.getSalePrice().multiply(saleOrderItem.getPurchaseCount()));
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }
            if (!ObjectUtil.isNotEmpty((Object)(priceComparisonAttachBos = saleOrderItem.getPriceComparisonAttachBos()))) continue;
            for (DycProOrderOrderAccessoryDTO accessory : priceComparisonAttachBos) {
                accessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
                accessory.setObjId(saleOrderItem.getSaleOrderItemId());
                accessory.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.PRICE_COMPARISON);
                accessory.setOrderId(saleOrderDo.getSaleOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
    }

    private void setSaleOrderAccessoryInfo(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderAccessoryList = saleOrderDo.getAccessoryList();
        if (ObjectUtil.isNotEmpty((Object)saleOrderAccessoryList)) {
            for (DycProOrderOrderAccessoryDTO accessory : saleOrderAccessoryList) {
                accessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
    }

    private void setAfterTakeType(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleItemList();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItems) {
            List returnTypeList = saleOrderItem.getServerReturnTypeList();
            ArrayList afterTakeTypeList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)returnTypeList)) {
                returnTypeList.forEach(e -> {
                    DycProOrderSaleAfterTakeTypeDTO afterTakeTypeBo = new DycProOrderSaleAfterTakeTypeDTO();
                    afterTakeTypeBo.setAfterTakeType(e);
                    afterTakeTypeBo.setAfterTakeId(Long.valueOf(Sequence.getInstance().nextId()));
                    afterTakeTypeBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    afterTakeTypeBo.setCommodityId(saleOrderItem.getCommodityId());
                    afterTakeTypeList.add(afterTakeTypeBo);
                });
            }
            saleOrderItem.setAfterTakeTypeList(afterTakeTypeList);
        }
    }

    private Object long2BigDecimal(Long amount) {
        if (amount != null) {
            try {
                BigDecimal bd = new BigDecimal("10000");
                BigDecimal bAmount = new BigDecimal(amount);
                return bAmount.divide(bd, 2, 1);
            }
            catch (Exception var3) {
                throw new ZTBusinessException("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef: " + var3);
            }
        }
        return null;
    }
}

