/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractForTyRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.constant.DycProOrderServiceConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderZlSysnStateTyDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderForTyService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderForTyServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderForTyServiceRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderServiceReqSkuBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderForTyService"})
public class DycProOrderResoveEsPreOrderForTyServiceImpl
implements DycProOrderResoveEsPreOrderForTyService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderResoveEsPreOrderForTyServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Value(value="${call.ty.url.createContractUrlForTy}")
    private String createContractUrlForTy;
    @Value(value="${call.ty.createContractMethodNameForTy}")
    private String createContractMethodNameForTy;

    @PostMapping(value={"dealEsPreOrderForTy"})
    public DycProOrderResoveEsPreOrderForTyServiceRspBO dealEsPreOrderForTy(@RequestBody DycProOrderResoveEsPreOrderForTyServiceReqBO reqBo) {
        DycProOrderResoveEsPreOrderForTyServiceRspBO rspBo = new DycProOrderResoveEsPreOrderForTyServiceRspBO();
        if (DycProOrderServiceConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState("XS_XD_SB");
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            updateExtOrderIdDo.setOrderStage(DycProOrderRepositoryConstant.ORDER_STAPE.TRADE_CLOSE);
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
            DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
            querySaleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
            if (null != saleOrderDTO.getBudgetId()) {
                this.deductBudget(saleOrderDTO);
            }
            if (DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDTO.getOrderType())) {
                this.returnPurApply(saleOrderDTO);
            }
        } else {
            DycProOrderSaleOrderDTO saleOrderDTO = this.assembleUpdateDo(reqBo);
            this.saleOrderRepository.updateSaleItemBatch(saleOrderDTO);
            DycProOrderOrderQueryIndexDTO index = new DycProOrderOrderQueryIndexDTO();
            index.setId(Long.valueOf(Sequence.getInstance().nextId()));
            index.setOrderId(reqBo.getOrderId());
            index.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
            index.setObjId(reqBo.getSaleOrderId());
            index.setOutObjId(reqBo.getOutOrderId());
            this.saleOrderRepository.addOrderQueryIndex(index);
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
            this.pushApprovalOrder(reqBo);
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());
        return rspBo;
    }

    private void pushApprovalOrder(DycProOrderResoveEsPreOrderForTyServiceReqBO reqBO) {
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.saleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        DycProOrderSaleOrderDTO querySaleOrderStakeholderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderStakeholderDTO.setStakeholderId(saleOrderDTO.getStakeholderId());
        DycProOrderSaleStakeholderDTO saleOrderStakeholderDTO = this.saleOrderRepository.querySaleOrderStakeholderByCondition(querySaleOrderStakeholderDTO).getSaleStakeholder();
        DycProOrderOrdLogisticsRelaDTO queryOrdLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
        queryOrdLogisticsRelaDTO.setContactId(saleOrderDTO.getContactId());
        DycProOrderOrdLogisticsRelaDTO ordLogisticsRelaDTO = this.dycProOrderOrderRepository.queryOrderOrdLogisticsRelaOneByCondition(queryOrdLogisticsRelaDTO);
        DycProOrderOrderAccessoryDTO queryOrderCmpAccessoryDTO = new DycProOrderOrderAccessoryDTO();
        queryOrderCmpAccessoryDTO.setObjId(saleOrderDTO.getOrderId());
        queryOrderCmpAccessoryDTO.setObjType(DycProOrderRepositoryConstant.OrderAccessoryObjType.PRICE_COMPARISON);
        List orderCmpAccessoryDTOList = this.dycProOrderOrderRepository.queryKindsAccessoryListByCondition(queryOrderCmpAccessoryDTO);
        DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
        dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProOrderInterLogDTO.setObjId(reqBO.getSaleOrderId());
        dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        dycProOrderInterLogDTO.setOrderId(reqBO.getOrderId());
        dycProOrderInterLogDTO.setInterSn(this.createContractUrlForTy);
        DycProBaseCallEsbUtilCreateContractForTyReqBO dycProBaseCallEsbUtilCreateContractForTyReqBO = new DycProBaseCallEsbUtilCreateContractForTyReqBO();
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setUrl(this.createContractUrlForTy);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setMethodName(this.createContractMethodNameForTy);
        DycProBaseCallEsbUtilCreateContractForTyBO dycProBaseCallEsbUtilCreateContractForTyBO = new DycProBaseCallEsbUtilCreateContractForTyBO();
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderId(saleOrderDTO.getSaleOrderId());
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderCode(saleOrderDTO.getSaleOrderNo());
        dycProBaseCallEsbUtilCreateContractForTyBO.setCreateCompanyID(saleOrderStakeholderDTO.getPurCompanyId());
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderStatus(Integer.valueOf(21));
        dycProBaseCallEsbUtilCreateContractForTyBO.setPayType(String.valueOf(101));
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderAmount(saleOrderDTO.getTotalSaleFee());
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderTaxPrice(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderNakedPrice(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setQiWeiUserId(saleOrderDTO.getOutCreateUserId());
        dycProBaseCallEsbUtilCreateContractForTyBO.setCreateDate(saleOrderDTO.getCreateTime());
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderDesc(saleOrderDTO.getRemark());
        dycProBaseCallEsbUtilCreateContractForTyBO.setUserAddressName(ordLogisticsRelaDTO.getContactName());
        dycProBaseCallEsbUtilCreateContractForTyBO.setUserAddressMail(ordLogisticsRelaDTO.getContactEmail());
        dycProBaseCallEsbUtilCreateContractForTyBO.setUserAddressPhone(ordLogisticsRelaDTO.getContactMobile());
        dycProBaseCallEsbUtilCreateContractForTyBO.setReceiveInfo(ordLogisticsRelaDTO.getContactProvinceName() + ordLogisticsRelaDTO.getContactCityName() + ordLogisticsRelaDTO.getContactCountyName() + ordLogisticsRelaDTO.getContactTown() + ordLogisticsRelaDTO.getContactAddress());
        dycProBaseCallEsbUtilCreateContractForTyBO.setCreateTimeStamp(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setSourceType(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderType(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setContractCode(null);
        dycProBaseCallEsbUtilCreateContractForTyBO.setStoreCode(null);
        ArrayList<DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO> orderDetails = new ArrayList<DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO>(1);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO = new DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO();
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setOrderDetailId(saleOrderItemDTO.getSaleOrderItemId());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionId(Long.valueOf(saleOrderItemDTO.getSkuId()));
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionDesc(null);
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setPrice(saleOrderItemDTO.getSalePrice());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionNum(saleOrderItemDTO.getPurchaseCount());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setTax(null);
            String allOrderCmpAccessoryUrl = CollectionUtils.isEmpty((Collection)orderCmpAccessoryDTOList) ? null : orderCmpAccessoryDTOList.stream().map(DycProOrderOrderAccessoryDTO::getAccessoryUrl).collect(Collectors.joining(","));
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setExtField03(allOrderCmpAccessoryUrl);
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setUnit(saleOrderStakeholderDTO.getPurCompanyId());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setConfigureData(null);
            orderDetails.add(dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO);
        }
        dycProBaseCallEsbUtilCreateContractForTyBO.setOrderDetails(orderDetails);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setJsonStr(JSON.toJSONString((Object)dycProBaseCallEsbUtilCreateContractForTyBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilCreateContractForTyReqBO));
        try {
            DycProBaseCallEsbUtilCreateContractForTyRspBO dycProBaseCallEsbUtilCreateContractForTyRspBO = DycProBaseCallEsbUtil.createContractForTy((DycProBaseCallEsbUtilCreateContractForTyReqBO)dycProBaseCallEsbUtilCreateContractForTyReqBO);
            dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilCreateContractForTyRspBO));
            if (null == dycProBaseCallEsbUtilCreateContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilCreateContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultCode())) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u5f85\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}", (Object)dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
                dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
                throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u5f85\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}" + dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u7cd6\u4e1a\u5f85\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}", (Object)e.getMessage());
            dycProOrderInterLogDTO.setErrDetail(e.getMessage());
        }
        this.saleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        DycProOrderZlSysnStateTyDTO addZlSysnStateTyDTO = new DycProOrderZlSysnStateTyDTO();
        addZlSysnStateTyDTO.setSysnStsteId(Long.valueOf(Sequence.getInstance().nextId()));
        addZlSysnStateTyDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        addZlSysnStateTyDTO.setObjId(saleOrderDTO.getSaleOrderId());
        addZlSysnStateTyDTO.setFinishFlag(Integer.valueOf(0));
        addZlSysnStateTyDTO.setCreateTime(new Date());
        this.saleOrderRepository.addZlSysnStateTy(addZlSysnStateTyDTO);
    }

    private DycProOrderSaleOrderDTO assembleUpdateDo(DycProOrderResoveEsPreOrderForTyServiceReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        saleOrderDTO.setOrderId(reqBo.getOrderId());
        saleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
        List sku = reqBo.getSku();
        ArrayList<DycProOrderSaleOrderItemDTO> saleItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        saleOrderDTO.setSaleItemList(saleItemList);
        for (DycProOrderResoveEsPreOrderServiceReqSkuBO skuBo : sku) {
            if (ObjectUtil.isEmpty((Object)skuBo.getSkuId())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getNakedPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTax())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTaxPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DycProOrderSaleOrderItemDTO item = new DycProOrderSaleOrderItemDTO();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());
            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            saleItemList.add(item);
        }
        return saleOrderDTO;
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrderDTO.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrderDTO.getTotalSaleFee().negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrderDTO.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrderDTO.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(6));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.saleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount().negate());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.saleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }
}

