/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderConfirmOrRefuseSaleOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderConfirmOrRefuseSaleOrderReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderConfirmOrRefuseSaleOrderRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderConfirmOrRefuseSaleOrderService"})
public class DycProOrderConfirmOrRefuseSaleOrderServiceImpl
implements DycProOrderConfirmOrRefuseSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmOrRefuseSaleOrderServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @PostMapping(value={"confirmOrRefuseSaleOrder"})
    public DycProOrderConfirmOrRefuseSaleOrderRspBO confirmOrRefuseSaleOrder(@RequestBody DycProOrderConfirmOrRefuseSaleOrderReqBO reqBO) {
        this.paramVerify(reqBO);
        if (DycProOrderApiServiceConstant.ConfirmResult.REFUSE.equals(reqBO.getConfirmResult())) {
            DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
            updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
            updateSaleOrderDto.setRejectOperId(String.valueOf(reqBO.getUserId()));
            updateSaleOrderDto.setRejectOperName(reqBO.getName());
            updateSaleOrderDto.setRejectTime(new Date());
            updateSaleOrderDto.setRejectReason(reqBO.getRefuseReason());
            updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.VENDOR_CANCEL);
            updateSaleOrderDto.setCancelReason(reqBO.getRefuseReason());
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getConfirmSaleOrderAccessoryList())) {
                ArrayList<DycProOrderOrderAccessoryDTO> saleOrderRefuseFileList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                for (DycProOrderAccessoryApiBO accessoryBO : reqBO.getConfirmSaleOrderAccessoryList()) {
                    DycProOrderOrderAccessoryDTO addAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                    BeanUtils.copyProperties((Object)accessoryBO, (Object)addAccessoryDTO);
                    addAccessoryDTO.setObjId(reqBO.getSaleOrderId());
                    addAccessoryDTO.setOrderId(reqBO.getSaleOrderId());
                    addAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CONFIRM_OR_REFUSE);
                    saleOrderRefuseFileList.add(addAccessoryDTO);
                }
                this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(saleOrderRefuseFileList);
            }
        }
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        flowTaskInstHandleDto.setTaskInstId(reqBO.getTaskId());
        this.dycProPublicTaskInstRepository.completeBusiFlowTask(flowTaskInstHandleDto);
        return new DycProOrderConfirmOrRefuseSaleOrderRspBO();
    }

    private void paramVerify(DycProOrderConfirmOrRefuseSaleOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getConfirmResult()) {
            throw new ZTBusinessException("\u786e\u8ba4\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTaskId()) {
            throw new ZTBusinessException("\u6d41\u7a0b\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

