/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.config.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.config.api.DycProOrderZlConfigRepository;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderCreateZlReceiveFactoryInfoDTO;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderQueryZlReceiveFactoryInfoDTO;
import com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtReceiveFactorySyncService;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtReceiveFactorySyncReqBO;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtReceiveFactorySyncRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtReceiveFactorySyncService"})
public class DycProOrderExtReceiveFactorySyncServiceImpl
implements DycProOrderExtReceiveFactorySyncService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderExtReceiveFactorySyncServiceImpl.class);
    @Autowired
    private DycProOrderZlConfigRepository zlConfigRepository;

    @PostMapping(value={"syncReceiveFactory"})
    public DycProOrderExtReceiveFactorySyncRspBO syncReceiveFactory(@RequestBody DycProOrderExtReceiveFactorySyncReqBO reqBO) {
        log.info("syncReceiveFactory syncType={}, code={}, orgId={}, orgCode={}", new Object[]{reqBO.getSyncType(), reqBO.getFactoryCode(), reqBO.getOrgId(), reqBO.getOrgCode()});
        Integer syncType = reqBO.getSyncType() == null ? 1 : reqBO.getSyncType();
        switch (syncType) {
            case 1: {
                DycProOrderQueryZlReceiveFactoryInfoDTO queryReq = new DycProOrderQueryZlReceiveFactoryInfoDTO();
                queryReq.setFactoryCode(reqBO.getFactoryCode());
                queryReq.setOrgId(reqBO.getOrgId());
                if (this.zlConfigRepository.getReceiveFactoryByCodeAndOrg(queryReq) != null) break;
                DycProOrderCreateZlReceiveFactoryInfoDTO dto = new DycProOrderCreateZlReceiveFactoryInfoDTO();
                BeanUtils.copyProperties((Object)reqBO, (Object)dto);
                this.zlConfigRepository.createZlReceiveFactoryInfo(dto);
                break;
            }
            case 2: {
                DycProOrderQueryZlReceiveFactoryInfoDTO queryReq2 = new DycProOrderQueryZlReceiveFactoryInfoDTO();
                queryReq2.setFactoryCode(reqBO.getFactoryCode());
                queryReq2.setOrgId(reqBO.getOrgId());
                DycProOrderQueryZlReceiveFactoryInfoDTO exist = this.zlConfigRepository.getReceiveFactoryByCodeAndOrg(queryReq2);
                if (exist == null) {
                    DycProOrderCreateZlReceiveFactoryInfoDTO dto = new DycProOrderCreateZlReceiveFactoryInfoDTO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)dto);
                    this.zlConfigRepository.createZlReceiveFactoryInfo(dto);
                    break;
                }
                BeanUtils.copyProperties((Object)reqBO, (Object)exist);
                this.zlConfigRepository.updateReceiveFactory(exist);
                break;
            }
            case 3: {
                DycProOrderQueryZlReceiveFactoryInfoDTO deleteReq = new DycProOrderQueryZlReceiveFactoryInfoDTO();
                deleteReq.setFactoryCode(reqBO.getFactoryCode());
                deleteReq.setOrgId(reqBO.getOrgId());
                this.zlConfigRepository.deleteReceiveFactoryByCodeAndOrg(deleteReq);
                break;
            }
            default: {
                throw new ZTBusinessException("\u975e\u6cd5\u7684syncType: " + syncType);
            }
        }
        return new DycProOrderExtReceiveFactorySyncRspBO();
    }
}

