/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmAfsOrderForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmAfsOrderParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCompleteAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCompleteAfterOrderReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCompleteAfterOrderRspBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderFinishConfirmAfterOrderReturnInfoBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCompleteAfterOrderService"})
public class DycProOrderCompleteAfterOrderServiceImpl
implements DycProOrderCompleteAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCompleteAfterOrderServiceImpl.class);
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private Environment environment;
    @Value(value="${call.esb.url.confirmAfsOrder}")
    private String callEsbConfirmAfsOrderUrl;
    @Value(value="${call.ty.url.deleteContractUrlForTy}")
    private String deleteContractUrlForTy;
    @Value(value="${call.ty.deleteContractMethodNameForTy}")
    private String deleteContractMethodNameForTy;

    @PostMapping(value={"completeAfterOrder"})
    public DycProOrderCompleteAfterOrderRspBO completeAfterOrder(@RequestBody DycProOrderCompleteAfterOrderReqBO reqBo) {
        String hsn;
        this.verifyParam(reqBo);
        if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource()) && ("jd".equals(hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBo.getSupId())) || "jdvop".equals(hsn))) {
            DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO callEsbUtilConfirmAfsOrderForJdReqBO = new DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO();
            callEsbUtilConfirmAfsOrderForJdReqBO.setHsn(hsn);
            callEsbUtilConfirmAfsOrderForJdReqBO.setUrl(this.callEsbConfirmAfsOrderUrl);
            DycProBaseCallEsbUtilConfirmAfsOrderParamForJdBO param = new DycProBaseCallEsbUtilConfirmAfsOrderParamForJdBO();
            param.setOrderId(Long.valueOf(reqBo.getSaleOrderNoExt()));
            param.setThirdApplyIds(Collections.singletonList(reqBo.getExtAfId()));
            callEsbUtilConfirmAfsOrderForJdReqBO.setParam(param);
            DycProBaseCallEsbUtilConfirmAfsOrderForJdRspBO callEsbUtilConfirmAfsOrderForJdRspBO = DycProBaseCallEsbUtil.confirmAfsOrderForJd((DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO)callEsbUtilConfirmAfsOrderForJdReqBO);
            if (!callEsbUtilConfirmAfsOrderForJdRspBO.getSuccess().booleanValue()) {
                throw new ZTBusinessException("\u552e\u540e\u786e\u8ba4\uff08\u4eac\u4e1c\uff09\u54cd\u5e94\u5931\u8d25");
            }
            if (!"0000".equals(callEsbUtilConfirmAfsOrderForJdRspBO.getResultCode())) {
                throw new ZTBusinessException("\u552e\u540e\u786e\u8ba4\uff08\u4eac\u4e1c\uff09\u5931\u8d25: " + callEsbUtilConfirmAfsOrderForJdRspBO.getResultMessage());
            }
        }
        DycProOrderAfOrderDTO updateAfOrderDto = new DycProOrderAfOrderDTO();
        updateAfOrderDto.setAfOrderId(reqBo.getAfOrderId());
        updateAfOrderDto.setOrderId(reqBo.getOrderId());
        updateAfOrderDto.setServState(DycProOrderApiServiceConstant.ServiceState.COMPLATE);
        if (null != reqBo.getFlag() && reqBo.getFlag().equals(DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS)) {
            updateAfOrderDto.setServState(DycProOrderApiServiceConstant.ServiceState.REMARK_COMPLATE);
        }
        updateAfOrderDto.setFinishTime(new Date());
        updateAfOrderDto.setUpdateTime(new Date());
        updateAfOrderDto.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateAfOrderDto.setWaybillFlag(DycProOrderApiServiceConstant.WaybillFlag.CAN_NOT_MAINTAIN);
        this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDto);
        DycProOrderAfOrderDTO afOrderQryDto = new DycProOrderAfOrderDTO();
        afOrderQryDto.setOrderId(reqBo.getOrderId());
        afOrderQryDto.setAfOrderId(reqBo.getAfOrderId());
        DycProOrderAfOrderDTO afOrderDto = this.dycProOrderAfOrderRepository.queryAfOrderOneByCondition(afOrderQryDto);
        DycProOrderAfOrderItemDTO afOrderItemQryDto = new DycProOrderAfOrderItemDTO();
        afOrderItemQryDto.setAfOrderId(reqBo.getAfOrderId());
        afOrderItemQryDto.setOrderId(reqBo.getOrderId());
        List afOrderItemDtoList = this.dycProOrderAfOrderRepository.queryAfOrderItemListByCondition(afOrderItemQryDto);
        if (null != reqBo.getFlag() && reqBo.getFlag().equals(DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS)) {
            this.updateAfteringCount(reqBo, afOrderDto, afOrderItemDtoList);
        }
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderId(afOrderDto.getSaleOrderId());
        DycProOrderSaleOrderDTO resultSaleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderDto.getServType()) && null != resultSaleOrderDTO.getBudgetId() && null != reqBo.getFlag() && reqBo.getFlag().equals(DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS)) {
            this.deductBudget(afOrderDto, afOrderItemDtoList, resultSaleOrderDTO);
        }
        if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderDto.getServType()) && DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS.equals(reqBo.getFlag()) && DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(resultSaleOrderDTO.getOrderType())) {
            this.returnPurApply(resultSaleOrderDTO, afOrderItemDtoList);
        }
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(afOrderDto.getAfOrderId());
        updateAfOrderDTO.setServState(DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS.equals(reqBo.getFlag()) ? DycProOrderApiServiceConstant.ServiceState.REMARK_COMPLATE : DycProOrderApiServiceConstant.ServiceState.COMPLATE);
        afOrderList.add(updateAfOrderDTO);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(afOrderDto.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
        if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderDto.getServType()) && DycProOrderApiServiceConstant.AfOrderConfirmType.SUPPLIERS.equals(reqBo.getFlag()) && "1".equals(resultSaleOrderDTO.getProfessionalCompanyType()) && DycProOrderApiServiceConstant.PurchaseType.MRO_CENTRALIZED_PROCUREMENT.equals(resultSaleOrderDTO.getPurchaseType())) {
            this.pushAfterReturnForTy(afOrderDto, afOrderItemDtoList, resultSaleOrderDTO);
        }
        DycProOrderCompleteAfterOrderRspBO rspBO = new DycProOrderCompleteAfterOrderRspBO();
        rspBO.setServType(afOrderDto.getServType());
        List returnInfoBOS = JSON.parseArray((String)JSON.toJSONString((Object)afOrderItemDtoList), DycProOrderFinishConfirmAfterOrderReturnInfoBO.class);
        rspBO.setReturnInfoList(returnInfoBOS);
        return rspBO;
    }

    private void deductBudget(DycProOrderAfOrderDTO afOrderDto, List<DycProOrderAfOrderItemDTO> afOrderItemDtoList, DycProOrderSaleOrderDTO resultSaleOrderDTO) {
        BigDecimal afTotalSaleFee = afOrderItemDtoList.stream().map(DycProOrderAfOrderItemDTO::getRetSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(resultSaleOrderDTO.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(afTotalSaleFee.negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(afOrderDto.getAfOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(afOrderDto.getAfServCode());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(4));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private void updateAfteringCount(DycProOrderCompleteAfterOrderReqBO reqBo, DycProOrderAfOrderDTO afOrder, List<DycProOrderAfOrderItemDTO> afOrderItemList) {
        DycProOrderAfOrderObjDTO afOrderObjQryDto = new DycProOrderAfOrderObjDTO();
        afOrderObjQryDto.setAfOrderId(reqBo.getAfOrderId());
        DycProOrderAfOrderObjDTO afOrderObjDto = this.dycProOrderAfOrderRepository.queryAfOrderObjOneByCondition(afOrderObjQryDto);
        DycProOrderShipOrderItemQryDTO shipOrderItemQryDto = new DycProOrderShipOrderItemQryDTO();
        shipOrderItemQryDto.setShipOrderId(afOrderObjDto.getShipOrderId());
        List shipOrderItemDtoList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(shipOrderItemQryDto);
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setSaleOrderId(afOrderObjDto.getSaleOrderId());
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemDtoList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, item -> item, (k1, k2) -> k1));
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemDtoList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDTOList = new ArrayList<DycProOrderShipOrderItemDTO>(1);
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        for (DycProOrderAfOrderItemDTO afOrderItem : afOrderItemList) {
            DycProOrderShipOrderItemDTO thisShipOrderItem = shipOrderItemMap.get(afOrderItem.getShipItemId());
            DycProOrderSaleOrderItemDTO thisSaleOrderItem = saleOrderItemMap.get(afOrderItem.getSaleOrderItemId());
            BigDecimal returnCount = afOrderItem.getReturnCount();
            DycProOrderShipOrderItemDTO shipOrderItemDto = new DycProOrderShipOrderItemDTO();
            shipOrderItemDto.setOrderId(afOrderItem.getOrderId());
            shipOrderItemDto.setShipOrderItemId(afOrderItem.getShipItemId());
            shipOrderItemDto.setAfterServingCount(thisShipOrderItem.getAfterServingCount().subtract(returnCount));
            if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrder.getServType())) {
                shipOrderItemDto.setReturnCount(thisShipOrderItem.getReturnCount().add(returnCount));
                shipOrderItemDto.setArriveCount(thisShipOrderItem.getArriveCount().subtract(returnCount));
            }
            shipOrderItemDto.setUpdateTime(new Date());
            shipOrderItemDto.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            updateShipOrderItemDTOList.add(shipOrderItemDto);
            DycProOrderSaleOrderItemDTO saleOrderItemDto = new DycProOrderSaleOrderItemDTO();
            saleOrderItemDto.setOrderId(afOrderItem.getOrderId());
            saleOrderItemDto.setSaleOrderItemId(afOrderItem.getSaleOrderItemId());
            saleOrderItemDto.setAfterServingCount(thisSaleOrderItem.getAfterServingCount().subtract(returnCount));
            if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrder.getServType())) {
                saleOrderItemDto.setReturnCount(thisSaleOrderItem.getReturnCount().add(returnCount));
                saleOrderItemDto.setArriveCount(thisSaleOrderItem.getArriveCount().subtract(returnCount));
            }
            saleOrderItemDto.setUpdateTime(new Date());
            saleOrderItemDto.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            updateSaleOrderItemDTOList.add(saleOrderItemDto);
        }
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipItemList(updateShipOrderItemDTOList);
        updateShipOrderDTO.setShipOrderId(afOrderObjDto.getShipOrderId());
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderDTO);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDTOList);
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO, List<DycProOrderAfOrderItemDTO> afOrderItemDTOList) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> idVsSaleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderAfOrderItemDTO afOrderItemDTO : afOrderItemDTOList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = idVsSaleOrderItemMap.get(afOrderItemDTO.getSaleOrderItemId());
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(afOrderItemDTO.getReturnCount());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }

    private void pushAfterReturnForTy(DycProOrderAfOrderDTO afOrderDTO, List<DycProOrderAfOrderItemDTO> afOrderItemDTOList, DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> idVsSaleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        DycProOrderSaleOrderDTO querySaleOrderStakeholderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderStakeholderDTO.setStakeholderId(saleOrderDTO.getStakeholderId());
        DycProOrderSaleStakeholderDTO saleOrderStakeholderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(querySaleOrderStakeholderDTO).getSaleStakeholder();
        for (DycProOrderAfOrderItemDTO afOrderItemDTO : afOrderItemDTOList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = idVsSaleOrderItemMap.get(afOrderItemDTO.getSaleOrderItemId());
            DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
            dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            dycProOrderInterLogDTO.setObjId(afOrderDTO.getAfOrderId());
            dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.AFTER);
            dycProOrderInterLogDTO.setOrderId(afOrderDTO.getOrderId());
            dycProOrderInterLogDTO.setInterSn(this.deleteContractUrlForTy);
            DycProBaseCallEsbUtilDeleteContractForTyReqBO dycProBaseCallEsbUtilDeleteContractForTyReqBO = new DycProBaseCallEsbUtilDeleteContractForTyReqBO();
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setUrl(this.deleteContractUrlForTy);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMethodName(this.deleteContractMethodNameForTy);
            DycProBaseCallEsbUtilDeleteContractForTyBO dycProBaseCallEsbUtilDeleteContractForTyBO = new DycProBaseCallEsbUtilDeleteContractForTyBO();
            dycProBaseCallEsbUtilDeleteContractForTyBO.setId(afOrderDTO.getAfOrderId());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsNum(afOrderItemDTO.getReturnCount());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSourceType(Integer.valueOf(saleOrderStakeholderDTO.getSupId()));
            dycProBaseCallEsbUtilDeleteContractForTyBO.setYctOrderCode(saleOrderDTO.getSaleOrderNo());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setServiceCode(afOrderDTO.getAfServCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setCreateDate(afOrderDTO.getCreateTime());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setTimeStamp(Long.valueOf(new Date().getTime()));
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setOrderDetailId(saleOrderItemDTO.getSaleOrderItemId());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setOrganizationId(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setCustomerId(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSendEpsFail(Integer.valueOf(0));
            ArrayList<DycProBaseCallEsbUtilDeleteContractForTyBO> dycProBaseCallEsbUtilDeleteContractForTyBOList = new ArrayList<DycProBaseCallEsbUtilDeleteContractForTyBO>(1);
            dycProBaseCallEsbUtilDeleteContractForTyBOList.add(dycProBaseCallEsbUtilDeleteContractForTyBO);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setJsonStr(JSON.toJSONString(dycProBaseCallEsbUtilDeleteContractForTyBOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyReqBO));
            try {
                DycProBaseCallEsbUtilDeleteContractForTyRspBO dycProBaseCallEsbUtilDeleteContractForTyRspBO = DycProBaseCallEsbUtil.deleteContractForTy((DycProBaseCallEsbUtilDeleteContractForTyReqBO)dycProBaseCallEsbUtilDeleteContractForTyReqBO);
                dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyRspBO));
                if (null == dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultCode())) {
                    log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                }
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5f02\u5e38: {}", (Object)e.getMessage());
                dycProOrderInterLogDTO.setErrDetail(e.getMessage());
            }
            this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        }
    }

    private void verifyParam(DycProOrderCompleteAfterOrderReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new ZTBusinessException("\u552e\u540e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            if (StringUtils.isBlank((String)reqBo.getExtAfId())) {
                throw new ZTBusinessException("\u5916\u90e8\u552e\u540e\u670d\u52a1\u5355\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)reqBo.getSaleOrderNoExt())) {
                throw new ZTBusinessException("\u5916\u90e8\u9500\u552e\u5355\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)reqBo.getSupId())) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
            }
        }
        if (null == reqBo.getFlag()) {
            throw new ZTBusinessException("\u786e\u8ba4\u6807\u8bc6\u4e3a\u7a7a");
        }
    }
}

