/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.config.impl;

import cn.hutool.core.util.IdUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.egc.repository.config.api.DycProOrderZlConfigRepository;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderExtConfigLogsDTO;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderExtConfigTempDTO;
import com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtConfigTempService;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtConfigMigrateReqBO;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtConfigTempReqBO;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtConfigTempRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtConfigTempService"})
public class DycProOrderExtConfigTempServiceImpl
implements DycProOrderExtConfigTempService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderExtConfigTempServiceImpl.class);
    @Autowired
    private DycProOrderZlConfigRepository dycProOrderZlConfigRepository;

    @PostMapping(value={"insertExtConfigTemp"})
    public DycProOrderExtConfigTempRspBO insertExtConfigTemp(@RequestBody DycProOrderExtConfigTempReqBO reqBO) {
        DycProOrderExtConfigTempDTO dto = new DycProOrderExtConfigTempDTO();
        Long tempId = Sequence.getInstance().nextId();
        dto.setId(tempId);
        dto.setBatchId(IdUtil.objectId());
        dto.setExtObjId(reqBO.getExtObjId());
        dto.setExtOriginalData(reqBO.getExtOriginalData());
        dto.setReceiveTime(new Date());
        dto.setDealResult(Integer.valueOf(2));
        dto.setCurrentDealCount(Integer.valueOf(0));
        dto.setConfigType(reqBO.getConfigType());
        this.dycProOrderZlConfigRepository.insertTemp(dto);
        DycProOrderExtConfigTempRspBO rspBO = new DycProOrderExtConfigTempRspBO();
        rspBO.setTempId(tempId);
        return rspBO;
    }

    @PostMapping(value={"migrateTempToLogsAndDelete"})
    public void migrateTempToLogsAndDelete(@RequestBody DycProOrderExtConfigMigrateReqBO reqBO) {
        DycProOrderExtConfigTempDTO tempDTO = this.dycProOrderZlConfigRepository.getConfigTempById(reqBO.getTempId());
        if (tempDTO == null) {
            log.warn("\u4e34\u65f6\u8868\u6570\u636e\u4e0d\u5b58\u5728\uff0ctempId={}", (Object)reqBO.getTempId());
            return;
        }
        DycProOrderExtConfigLogsDTO logDTO = new DycProOrderExtConfigLogsDTO();
        logDTO.setLogId(Long.valueOf(Sequence.getInstance().nextId()));
        logDTO.setId(tempDTO.getId());
        logDTO.setBatchId(tempDTO.getBatchId());
        logDTO.setExtObjId(tempDTO.getExtObjId());
        logDTO.setExtOriginalData(tempDTO.getExtOriginalData());
        logDTO.setReceiveTime(tempDTO.getReceiveTime());
        logDTO.setDealTime(new Date());
        logDTO.setDealResult(reqBO.getDealResult());
        logDTO.setCurrentDealCount(Integer.valueOf(tempDTO.getCurrentDealCount() + 1));
        logDTO.setDealResultDesc(reqBO.getDealResultDesc());
        logDTO.setConfigType(tempDTO.getConfigType());
        this.dycProOrderZlConfigRepository.insertLog(logDTO);
        this.dycProOrderZlConfigRepository.deleteTempById(reqBO.getTempId());
    }
}

