/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.report.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.service.report.api.DycProOrderReportService;
import com.tydic.dyc.pro.egc.service.report.bo.DycProOrderGenerateReportReqBO;
import com.tydic.dyc.pro.egc.service.report.bo.DycProOrderGenerateReportRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.report.api.DycProOrderReportService"})
public class DycProOrderReportServiceImpl
implements DycProOrderReportService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderReportServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private FileClient fileClient;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;

    @PostMapping(value={"generateSaleOrderExcelReport"})
    public DycProOrderGenerateReportRspBO generateSaleOrderExcelReport(@RequestBody DycProOrderGenerateReportReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleOrderId()) && StringUtils.isBlank((CharSequence)reqBO.getSaleOrderNo())) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u548c\u9500\u552e\u5355\u7f16\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        try {
            DycProOrderSaleOrderDTO saleOrder = new DycProOrderSaleOrderDTO();
            saleOrder.setSaleOrderNo(reqBO.getSaleOrderNo());
            saleOrder.setSaleOrderId(reqBO.getSaleOrderId());
            List<DycProOrderSaleOrderItemDTO> saleOrderItems = this.querySaleOrderItems(reqBO.getSaleOrderId(), reqBO.getAgreementId());
            byte[] excelBytes = this.generateExcelFile(saleOrder, saleOrderItems);
            String fileName = this.generateFileName(saleOrder);
            String filePath = this.uploadToOSS(excelBytes, fileName);
            DycProOrderGenerateReportRspBO rspBO = new DycProOrderGenerateReportRspBO();
            rspBO.setFileName(fileName);
            rspBO.setFilePath(filePath);
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9500\u552e\u5355Excel\u62a5\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u751f\u6210\u9500\u552e\u5355Excel\u62a5\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private DycProOrderSaleOrderDTO querySaleOrderInfo(DycProOrderGenerateReportReqBO reqBO) {
        DycProOrderSaleOrderQryDTO qryDTO = new DycProOrderSaleOrderQryDTO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSaleOrderId())) {
            qryDTO.setSaleOrderId(reqBO.getSaleOrderId());
        } else {
            qryDTO.setSaleOrderNo(reqBO.getSaleOrderNo());
        }
        return this.dycProOrderSaleOrderRepository.qrySaleOrder(qryDTO);
    }

    private List<DycProOrderSaleOrderItemDTO> querySaleOrderItems(Long saleOrderId, String agreementId) {
        DycProOrderSaleOrderItemQryDTO qryDTO = new DycProOrderSaleOrderItemQryDTO();
        qryDTO.setSaleOrderId(saleOrderId);
        qryDTO.setAgreementId(agreementId);
        return this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(qryDTO);
    }

    /*
     * Exception decompiling
     */
    private byte[] generateExcelFile(DycProOrderSaleOrderDTO saleOrder, List<DycProOrderSaleOrderItemDTO> saleOrderItems) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateFileName(DycProOrderSaleOrderDTO saleOrder) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        return String.format("\u9500\u552e\u5355\u62a5\u8868_%s_%s.xlsx", saleOrder.getSaleOrderNo() != null ? saleOrder.getSaleOrderNo() : saleOrder.getSaleOrderId(), timestamp);
    }

    private String uploadToOSS(byte[] fileBytes, String fileName) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
            String filePath = this.instDataPath + "/" + UUID.randomUUID().toString().replace("-", "");
            String fileUrl = this.fileClient.uploadFileByInputStream(filePath, fileName, (InputStream)inputStream);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u540d\uff1a{}\uff0c\u8def\u5f84\uff1a{}", (Object)fileName, (Object)fileUrl);
            return fileUrl;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

