/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.budget.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcBudgetStatus;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetQryDTO;
import com.tydic.dyc.pro.egc.service.budget.api.DycProOrderQueryBudgetListPageService;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderBudgetInfoBO;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderQueryBudgetListPageReqBO;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderQueryBudgetListPageRspBO;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.budget.api.DycProOrderQueryBudgetListPageService"})
public class DycProOrderQueryBudgetListPageServiceImpl
implements DycProOrderQueryBudgetListPageService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQueryBudgetListPageServiceImpl.class);
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @Override
    @PostMapping(value={"queryBudgetListPage"})
    public DycProOrderQueryBudgetListPageRspBO queryBudgetListPage(@RequestBody DycProOrderQueryBudgetListPageReqBO reqBO) {
        RspPage dycProOrderBudgetInfoDTORspPage;
        DycProOrderQueryBudgetListPageRspBO dycProOrderQueryBudgetListPageRspBO;
        this.paramVerify(reqBO);
        DycProOrderBudgetQryDTO qryDTO = new DycProOrderBudgetQryDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)qryDTO);
        qryDTO.setCreateCompanyId(reqBO.getCompanyId());
        if (qryDTO.getBudgetStatus() == null && (qryDTO.getBudgetStatusList() == null || qryDTO.getBudgetStatusList().isEmpty())) {
            qryDTO.setBudgetStatusList(Arrays.asList(DycProOrderManageServiceConstant.BudgetStatus.APPROVING, DycProOrderManageServiceConstant.BudgetStatus.PENDING_EFFECTIVE, DycProOrderManageServiceConstant.BudgetStatus.EFFECTIVE, DycProOrderManageServiceConstant.BudgetStatus.REJECTED, DycProOrderManageServiceConstant.BudgetStatus.EXPIRED));
        }
        if (!CollectionUtils.isEmpty((Collection)(dycProOrderQueryBudgetListPageRspBO = (DycProOrderQueryBudgetListPageRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)(dycProOrderBudgetInfoDTORspPage = this.dycProOrderBudgetRepository.queryBudgetListPageByCondition(qryDTO))), DycProOrderQueryBudgetListPageRspBO.class))).getRows())) {
            for (DycProOrderBudgetInfoBO row : dycProOrderQueryBudgetListPageRspBO.getRows()) {
                if (null == row.getBudgetStatus()) continue;
                row.setBudgetStatusStr(this.getBudgetStatusStr(row.getBudgetStatus()));
            }
        }
        return dycProOrderQueryBudgetListPageRspBO;
    }

    @Override
    @PostMapping(value={"queryBudgetListPageForOperator"})
    public DycProOrderQueryBudgetListPageRspBO queryBudgetListPageForOperator(@RequestBody DycProOrderQueryBudgetListPageReqBO reqBO) {
        RspPage page;
        DycProOrderQueryBudgetListPageRspBO rsp;
        this.paramVerify(reqBO);
        DycProOrderBudgetQryDTO qryDTO = new DycProOrderBudgetQryDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)qryDTO);
        if (qryDTO.getBudgetStatus() == null && (qryDTO.getBudgetStatusList() == null || qryDTO.getBudgetStatusList().isEmpty())) {
            qryDTO.setBudgetStatusList(Arrays.asList(DycProOrderManageServiceConstant.BudgetStatus.APPROVING, DycProOrderManageServiceConstant.BudgetStatus.PENDING_EFFECTIVE, DycProOrderManageServiceConstant.BudgetStatus.EFFECTIVE, DycProOrderManageServiceConstant.BudgetStatus.REJECTED, DycProOrderManageServiceConstant.BudgetStatus.EXPIRED));
        }
        if (!CollectionUtils.isEmpty((Collection)(rsp = (DycProOrderQueryBudgetListPageRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)(page = this.dycProOrderBudgetRepository.queryBudgetListPageByCondition(qryDTO))), DycProOrderQueryBudgetListPageRspBO.class))).getRows())) {
            for (DycProOrderBudgetInfoBO row : rsp.getRows()) {
                if (null == row.getBudgetStatus()) continue;
                row.setBudgetStatusStr(this.getBudgetStatusStr(row.getBudgetStatus()));
            }
        }
        return rsp;
    }

    private void paramVerify(DycProOrderQueryBudgetListPageReqBO reqBO) {
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
    }

    private String getBudgetStatusStr(Integer status) {
        if (status == null) {
            return "";
        }
        String value = DictionaryFrameworkUtils.getDicDataByCode((String)ZLEgcBudgetStatus.class.getSimpleName(), (String)String.valueOf(status));
        return value == null ? "\u672a\u77e5\u72b6\u6001" : value;
    }
}

