/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderReturnPurchaseApplyItemService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderReturnPurchaseApplyItemReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderReturnPurchaseApplyItemRspBO;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderReturnPurchaseApplyItemService"})
public class DycProOrderReturnPurchaseApplyItemServiceImpl
implements DycProOrderReturnPurchaseApplyItemService {
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;

    @Override
    @PostMapping(value={"returnPurchaseApplyItem"})
    public DycProOrderReturnPurchaseApplyItemRspBO returnPurchaseApplyItem(@RequestBody DycProOrderReturnPurchaseApplyItemReqBO reqBO) {
        if (reqBO == null || reqBO.getPurApplyItemId() == null || reqBO.getPurApplyId() == null) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u660e\u7ec6ID\u4e0e\u91c7\u8d2d\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderZlPurchaseApplyItemDTO updateItem = new DycProOrderZlPurchaseApplyItemDTO();
        updateItem.setPurApplyItemId(reqBO.getPurApplyItemId());
        updateItem.setPurApplyId(reqBO.getPurApplyId());
        updateItem.setPurApplyItemStatus(DycProOrderManageServiceConstant.PurApplyItemStatus.TERMINATED);
        this.dycProOrderPurchaseApplyRepository.updatePurchaseApplyItemById(updateItem);
        DycProOrderZlPurchaseApplyItemDTO queryItems = new DycProOrderZlPurchaseApplyItemDTO();
        queryItems.setPurApplyId(reqBO.getPurApplyId());
        List allItems = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryItems);
        DycProOrderReturnPurchaseApplyItemRspBO rsp = new DycProOrderReturnPurchaseApplyItemRspBO();
        if (allItems != null && !allItems.isEmpty()) {
            boolean allTerminated = allItems.stream().filter(Objects::nonNull).allMatch(i -> DycProOrderManageServiceConstant.PurApplyItemStatus.TERMINATED.equals(i.getPurApplyItemStatus()));
            boolean allExecutedOrTerminated = allItems.stream().filter(Objects::nonNull).allMatch(i -> DycProOrderManageServiceConstant.PurApplyItemStatus.TERMINATED.equals(i.getPurApplyItemStatus()) || DycProOrderManageServiceConstant.PurApplyItemStatus.EXECUTED.equals(i.getPurApplyItemStatus()));
            DycProOrderZlPurchaseApplyDTO updateMain = new DycProOrderZlPurchaseApplyDTO();
            updateMain.setPurApplyId(reqBO.getPurApplyId());
            if (allTerminated) {
                updateMain.setPurApplyStatus(DycProOrderManageServiceConstant.PurApplyStatus.TERMINATED);
                rsp.setMainApplyTerminated(Boolean.TRUE);
            } else if (allExecutedOrTerminated) {
                updateMain.setPurApplyStatus(DycProOrderManageServiceConstant.PurApplyStatus.EXECUTED);
                rsp.setMainApplyTerminated(Boolean.TRUE);
            } else {
                rsp.setMainApplyTerminated(Boolean.FALSE);
                return rsp;
            }
            this.dycProOrderPurchaseApplyRepository.updatePurchaseApplyById(updateMain);
        } else {
            rsp.setMainApplyTerminated(Boolean.FALSE);
        }
        return rsp;
    }
}

