/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProShipOrderExportService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderFileBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProShipOrderExportReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProShipOrderExportRspBO;
import com.tydic.dyc.pro.egc.util.PDFTemplateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProShipOrderExportService"})
public class DycProShipOrderExportServiceImpl
implements DycProShipOrderExportService {
    private static final Logger log = LoggerFactory.getLogger(DycProShipOrderExportServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Value(value="${dyc.file.inst.data.path}")
    private String instDataPath;
    @Value(value="${plugin.file.type}")
    private String fileType;

    @Override
    @PostMapping(value={"exportShipOrder"})
    public DycProShipOrderExportRspBO exportShipOrder(@RequestBody DycProShipOrderExportReqBO reqBO) {
        DycProShipOrderExportRspBO rspBO = new DycProShipOrderExportRspBO();
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList files = new ArrayList();
        DycProOrderShipOrderQryDTO shipOrderQryDto = new DycProOrderShipOrderQryDTO();
        shipOrderQryDto.setShipOrderId(reqBO.getShipOrderId());
        shipOrderQryDto.setOrderId(reqBO.getOrderId());
        DycProOrderShipOrderDTO shipOrderDto = this.dycProOrderShipOrderRepository.queryShipOrderAllInfoById(shipOrderQryDto);
        if (null == shipOrderDto) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u5931\u8d25");
        }
        DycProOrderSaleOrderDTO saleOrderQryDto = new DycProOrderSaleOrderDTO();
        saleOrderQryDto.setSaleOrderId(shipOrderDto.getSaleOrderId());
        saleOrderQryDto.setOrderId(reqBO.getOrderId());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderQryDto);
        if (null == saleOrderDto) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u5931\u8d25");
        }
        List saleOrderItemIdList = shipOrderDto.getShipItemList().stream().map(DycProOrderShipOrderItemDTO::getSaleOrderItemId).collect(Collectors.toList());
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setSaleOrderItemIdList(saleOrderItemIdList);
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        log.info("\u53c2\u6570\u6821\u9a8cmcode" + JSON.toJSONString((Object)saleOrderItemDtoList));
        if (CollectionUtils.isEmpty((Collection)saleOrderItemDtoList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5931\u8d25");
        }
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemDTOMap = shipOrderDto.getShipItemList().stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDtoList) {
            saleOrderItemDTO.setSkuMaterialCode(saleOrderItemDTO.getMCode());
            saleOrderItemDTO.setSendCount(shipOrderItemDTOMap.get(saleOrderItemDTO.getSaleOrderItemId()).getSendCount());
        }
        data.put("saleOrder", saleOrderDto);
        data.put("saleOrderItemList", saleOrderItemDtoList);
        data.put("shipOrder", shipOrderDto);
        log.info("\u53c2\u6570\u6821\u9a8cdata" + JSON.toJSONString(data));
        String filePath = this.doTest(data);
        for (File file : files) {
            file.delete();
        }
        rspBO.setFilePath(filePath);
        return rspBO;
    }

    private String doTest(Map<String, Object> data) {
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            String path;
            String fileName = URLEncoder.encode("shiporderinfo.pdf", "UTF-8");
            String filetemplateName = "shipOrderInfo.ftl";
            baos = PDFTemplateUtil.createPDF(data, filetemplateName);
            byte[] pdfBytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            DycProOrderFileBO dycUocFileBO = new DycProOrderFileBO();
            dycUocFileBO.setPath(this.instDataPath);
            dycUocFileBO.setInputStream(inputStream);
            dycUocFileBO.setFilename(fileName);
            dycUocFileBO.setFileType(this.fileType);
            String fileUrl = path = this.uploadFile(dycUocFileBO);
            System.out.println("fileUrl:" + fileUrl);
            baos.close();
            String string = fileUrl;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("8888,\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String uploadFile(DycProOrderFileBO dycUocFileBO) {
        String path = this.fileClient.uploadFileByInputStream(dycUocFileBO.getPath() + "/" + UUID.randomUUID().toString().replace("-", "") + "/", dycUocFileBO.getFilename(), dycUocFileBO.getInputStream());
        return path;
    }
}

