/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.insporder.api.DycProOrderInspOrderRepository;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderRelDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderCreateNumChngOrderService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderCreateNumChngOrderInspBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderCreateNumChngOrderInspItemBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderCreateNumChngOrderReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderCreateNumChngOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderCreateNumChngOrderService"})
public class DycProOrderCreateNumChngOrderServiceImpl
implements DycProOrderCreateNumChngOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateNumChngOrderServiceImpl.class);
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;
    @Autowired
    private DycProOrderInspOrderRepository dycProOrderInspOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Value(value="${uoc.inspect.allowSupportMoreChng}")
    private boolean allowSupportMoreChng;
    private static final Integer CHNG_TYPE_ADD = 1;
    private static final Integer CHNG_TYPE_SUBTRACT = 2;

    @Override
    @PostMapping(value={"createNumChngOrder"})
    public DycProOrderCreateNumChngOrderRspBO createNumChngOrder(@RequestBody DycProOrderCreateNumChngOrderReqBO reqBo) {
        this.verifyParam(reqBo);
        DycProOrderSaleOrderDTO saleOrderQryDto = new DycProOrderSaleOrderDTO();
        saleOrderQryDto.setSaleOrderId(reqBo.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderQryDto);
        if (!"XS_YS_YS".equals(saleOrderDto.getSaleOrderState()) && !"XS_YS_BFYS".equals(saleOrderDto.getSaleOrderState())) {
            throw new ZTBusinessException("\u8be5\u8ba2\u5355\u8fd8\u672a\u5b8c\u5168\u9a8c\u6536,\u6682\u4e0d\u80fd\u64cd\u4f5c\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4");
        }
        List<DycProOrderInspOrderItemDTO> inspOrderItemDtoList = this.getInspOrderItemList(reqBo);
        this.checkChngingCount(reqBo, inspOrderItemDtoList);
        List<DycProOrderSaleOrderItemDTO> saleOrderItems = this.getImplOrderItemList(inspOrderItemDtoList);
        DycProOrderChngOrderDTO chngOrderDto = this.convertChngOrderDto(reqBo, inspOrderItemDtoList, saleOrderItems);
        DycProOrderChngOrderDTO resultChngOrderDto = this.dycProOrderChngOrderRepository.createChngOrderAllInfoAndSyncNosql(chngOrderDto);
        for (DycProOrderCreateNumChngOrderInspBO createNumChngOrderInspBo : reqBo.getChngOrderList()) {
            DycProOrderInspOrderDTO updateInspOrderDTO = new DycProOrderInspOrderDTO();
            updateInspOrderDTO.setInspOrderId(createNumChngOrderInspBo.getInspOrderId());
            updateInspOrderDTO.setInspItemList(this.convertInspOrderDto(reqBo, createNumChngOrderInspBo, inspOrderItemDtoList));
            this.dycProOrderInspOrderRepository.updateOnlyInspOrderItemBatchByIdsAndSyncNosql(updateInspOrderDTO);
            this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(this.convertSaleOrderDto(reqBo, createNumChngOrderInspBo, inspOrderItemDtoList));
            ArrayList<DycProOrderChngOrderDTO> chngOrderList = new ArrayList<DycProOrderChngOrderDTO>(1);
            chngOrderList.add(resultChngOrderDto);
            DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
            updateSaleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
            updateSaleOrderDTO.setChngOrderList(chngOrderList);
            this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
        }
        List<Long> inspOrderIdList = reqBo.getChngOrderList().stream().map(DycProOrderCreateNumChngOrderInspBO::getInspOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(inspOrderIdList)) {
            this.updateRelState(inspOrderIdList, reqBo.getOrderId(), reqBo.getSaleOrderId());
        }
        DycProOrderCreateNumChngOrderRspBO rspBo = new DycProOrderCreateNumChngOrderRspBO();
        rspBo.setChngOrderId(resultChngOrderDto.getChngOrderId());
        rspBo.setChngOrderNo(resultChngOrderDto.getChngOrderNo());
        return rspBo;
    }

    private List<DycProOrderInspOrderItemDTO> convertInspOrderDto(DycProOrderCreateNumChngOrderReqBO reqBo, DycProOrderCreateNumChngOrderInspBO createNumChngOrderInspBo, List<DycProOrderInspOrderItemDTO> inspOrderItemList) {
        Map<Long, DycProOrderInspOrderItemDTO> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, item -> item, (existing, replacement) -> existing));
        ArrayList<DycProOrderInspOrderItemDTO> inspOrderItemDtoList = new ArrayList<DycProOrderInspOrderItemDTO>();
        createNumChngOrderInspBo.getInspOrderItemList().forEach(item -> {
            DycProOrderInspOrderItemDTO inspOrderItemDto = new DycProOrderInspOrderItemDTO();
            inspOrderItemDto.setInspOrderItemId(item.getInspOrderItemId());
            if (null != ((DycProOrderInspOrderItemDTO)inspOrderItemMap.get(item.getInspOrderItemId())).getChngingCount()) {
                inspOrderItemDto.setChngingCount(item.getChngCount().add(((DycProOrderInspOrderItemDTO)inspOrderItemMap.get(item.getInspOrderItemId())).getChngingCount()));
            } else {
                inspOrderItemDto.setChngingCount(item.getChngCount());
            }
            inspOrderItemDto.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            inspOrderItemDto.setUpdateTime(new Date());
            inspOrderItemDtoList.add(inspOrderItemDto);
        });
        return inspOrderItemDtoList;
    }

    private List<DycProOrderSaleOrderItemDTO> convertSaleOrderDto(DycProOrderCreateNumChngOrderReqBO reqBo, DycProOrderCreateNumChngOrderInspBO createNumChngOrderInspBo, List<DycProOrderInspOrderItemDTO> inspOrderItemList) {
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setSaleOrderId(reqBo.getSaleOrderId());
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        Map<Long, DycProOrderInspOrderItemDTO> inspItemMap = inspOrderItemList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderCreateNumChngOrderInspItemBO inspItemBO : createNumChngOrderInspBo.getInspOrderItemList()) {
            DycProOrderSaleOrderItemDTO saleOrderItemDto = new DycProOrderSaleOrderItemDTO();
            saleOrderItemDto.setSaleOrderItemId(inspItemMap.get(inspItemBO.getInspOrderItemId()).getSaleOrderItemId());
            if (null != saleOrderItemMap.get(inspItemMap.get(inspItemBO.getInspOrderItemId()).getSaleOrderItemId()).getChngingCount()) {
                saleOrderItemDto.setChngingCount(saleOrderItemMap.get(inspItemMap.get(inspItemBO.getInspOrderItemId()).getSaleOrderItemId()).getChngingCount().add(inspItemBO.getChngCount()));
            } else {
                saleOrderItemDto.setChngingCount(inspItemBO.getChngCount());
            }
            saleOrderItemDto.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            saleOrderItemDto.setUpdateTime(new Date());
            updateSaleOrderItemDTOList.add(saleOrderItemDto);
        }
        return updateSaleOrderItemDTOList;
    }

    private List<DycProOrderInspOrderItemDTO> getInspOrderItemList(DycProOrderCreateNumChngOrderReqBO reqBo) {
        ArrayList<DycProOrderInspOrderItemDTO> inspOrderItems = new ArrayList<DycProOrderInspOrderItemDTO>();
        for (DycProOrderCreateNumChngOrderInspBO createNumChngOrderInspBo : reqBo.getChngOrderList()) {
            DycProOrderInspOrderItemDTO inspOrderItemQryDto = new DycProOrderInspOrderItemDTO();
            inspOrderItemQryDto.setInspOrderId(createNumChngOrderInspBo.getInspOrderId());
            List inspOrderDto = this.dycProOrderInspOrderRepository.queryInspOrderItemList(inspOrderItemQryDto);
            if (CollectionUtils.isEmpty((Collection)inspOrderDto)) {
                throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
            }
            inspOrderItems.addAll(inspOrderDto);
        }
        return inspOrderItems;
    }

    private DycProOrderChngOrderDTO convertChngOrderDto(DycProOrderCreateNumChngOrderReqBO reqBo, List<DycProOrderInspOrderItemDTO> inspOrderItemDtoList, List<DycProOrderSaleOrderItemDTO> saleOrderItems) {
        Map<Long, DycProOrderInspOrderItemDTO> inspOrderItemMap = inspOrderItemDtoList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, o -> o));
        Map<Long, DycProOrderSaleOrderItemDTO> implOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
        DycProOrderChngOrderDTO chngOrderDto = new DycProOrderChngOrderDTO();
        chngOrderDto.setChngOrderState("CHNG_CHNG_QRZ");
        chngOrderDto.setCreateOperId(String.valueOf(reqBo.getUserId()));
        chngOrderDto.setCreateOperName(reqBo.getName());
        chngOrderDto.setCreateOperMobile(reqBo.getRegMobile());
        chngOrderDto.setSaleOrderId(reqBo.getSaleOrderId());
        chngOrderDto.setOrderId(reqBo.getOrderId());
        chngOrderDto.setBusiType(DycProOrderManageServiceConstant.BUSI_TYPE.NUM);
        chngOrderDto.setRemark(reqBo.getRemark());
        ArrayList<DycProOrderChngOrderObjDTO> chngOrderObjList = new ArrayList<DycProOrderChngOrderObjDTO>();
        for (DycProOrderCreateNumChngOrderInspBO createNumChngOrderInspBo : reqBo.getChngOrderList()) {
            DycProOrderChngOrderObjDTO chngOrderObj = new DycProOrderChngOrderObjDTO();
            chngOrderObj.setOrderId(reqBo.getOrderId());
            chngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            chngOrderObj.setInspOrderId(createNumChngOrderInspBo.getInspOrderId());
            chngOrderObj.setChngType(DycProOrderManageServiceConstant.BUSI_TYPE.NUM);
            chngOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
            ArrayList chngOrderItemObjList = new ArrayList();
            chngOrderObj.setChngNum(BigDecimal.ZERO);
            chngOrderObj.setChngFee(BigDecimal.ZERO);
            createNumChngOrderInspBo.getInspOrderItemList().forEach(item -> {
                DycProOrderInspOrderItemDTO inspOrderItem = (DycProOrderInspOrderItemDTO)inspOrderItemMap.get(item.getInspOrderItemId());
                DycProOrderSaleOrderItemDTO saleOrderItem = (DycProOrderSaleOrderItemDTO)implOrderItemMap.get(inspOrderItem.getSaleOrderItemId());
                DycProOrderChngOrderItemObjDTO chngOrderItemObj = new DycProOrderChngOrderItemObjDTO();
                chngOrderItemObj.setChngNumPre(item.getRemainInspNum());
                chngOrderItemObj.setChngNum(item.getChngCount());
                chngOrderItemObj.setChngFee(item.getChngCount().multiply(saleOrderItem.getSalePrice()));
                chngOrderItemObj.setChngPurchaseFee(item.getChngCount().multiply(saleOrderItem.getPurchasePrice()));
                chngOrderItemObj.setInspOrderItemId(item.getInspOrderItemId());
                chngOrderItemObj.setSaleOrderItemId(inspOrderItem.getSaleOrderItemId());
                chngOrderItemObj.setChngType(DycProOrderManageServiceConstant.BUSI_TYPE.NUM);
                chngOrderItemObj.setOrderId(reqBo.getOrderId());
                chngOrderItemObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
                chngOrderItemObj.setAddOrSubtractType(item.getAddOrDelType());
                chngOrderItemObj.setRemainInspCount(item.getRemainInspNum());
                chngOrderItemObjList.add(chngOrderItemObj);
                chngOrderObj.setChngNum(chngOrderObj.getChngNum().add(item.getChngCount()));
                if (item.getAddOrDelType().equals(CHNG_TYPE_ADD)) {
                    chngOrderObj.setChngFee(chngOrderObj.getChngFee().subtract(chngOrderItemObj.getChngFee()));
                } else if (item.getAddOrDelType().equals(CHNG_TYPE_SUBTRACT)) {
                    chngOrderObj.setChngFee(chngOrderObj.getChngFee().add(chngOrderItemObj.getChngFee()));
                }
            });
            chngOrderObj.setUocChngOrderItemObjList(chngOrderItemObjList);
            chngOrderObjList.add(chngOrderObj);
        }
        chngOrderDto.setUocChngOrderObjList(chngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List orderAccessoryList = JSON.parseArray((String)JSON.toJSONString(reqBo.getOrderAccessoryBoList()), DycProOrderOrderAccessoryDTO.class);
            orderAccessoryList.forEach(orderAccessory -> {
                orderAccessory.setCreateOperId(reqBo.getUserId().toString());
                orderAccessory.setObjType(DycProOrderManageServiceConstant.OBJ_TYPE.CHNG);
            });
            chngOrderDto.setChngOrderAccessoryList(orderAccessoryList);
        }
        return chngOrderDto;
    }

    private List<DycProOrderSaleOrderItemDTO> getImplOrderItemList(List<DycProOrderInspOrderItemDTO> inspOrderItemList) {
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setOrderId(inspOrderItemList.get(0).getOrderId());
        saleOrderItemQryDto.setSaleOrderItemIdList(inspOrderItemList.stream().map(DycProOrderInspOrderItemDTO::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        if (CollectionUtils.isEmpty((Collection)saleOrderItemDtoList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return saleOrderItemDtoList;
    }

    private void checkChngingCount(DycProOrderCreateNumChngOrderReqBO reqBo, List<DycProOrderInspOrderItemDTO> inspOrderItemList) {
        Map<Long, DycProOrderInspOrderItemDTO> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, o -> o));
        reqBo.getChngOrderList().forEach(x -> x.getInspOrderItemList().forEach(y -> {
            DycProOrderInspOrderItemDTO inspOrderItem = (DycProOrderInspOrderItemDTO)inspOrderItemMap.get(y.getInspOrderItemId());
            if (null != inspOrderItem.getChngingCount() && inspOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new ZTBusinessException("\u5b58\u5728\u5f02\u5e38\u53d8\u66f4\u5728\u9014\u6570\u91cf\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u7ed3\u540e\u518d\u53d1\u8d77");
            }
            Integer addOrDelType = y.getAddOrDelType();
            if (addOrDelType == 1) {
                if (!(this.allowSupportMoreChng || y.getChngCount().compareTo(BigDecimal.ZERO) >= 0 && y.getChngCount().compareTo(inspOrderItem.getInitInspCount().subtract(inspOrderItem.getRemainInspCount())) <= 0)) {
                    throw new ZTBusinessException("\u53d8\u66f4\u6570\u91cf\u8d85\u8fc7(\u521d\u59cb\u9a8c\u6536\u6570\u91cf-\u5269\u4f59\u9a8c\u6536\u91cf)\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else if (addOrDelType == 2 && (y.getChngCount().compareTo(BigDecimal.ZERO) < 0 || y.getChngCount().compareTo(inspOrderItem.getRemainInspCount()) > 0)) {
                throw new ZTBusinessException("\u53d8\u66f4\u6570\u91cf\u8d85\u8fc7\u5269\u4f59\u9a8c\u6536\u91cf\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }));
    }

    private void updateRelState(List<Long> inspOrderIdList, Long orderId, Long saleOrderId) {
        for (Long inspOrderId : inspOrderIdList) {
            List<Object> updateRelList;
            DycProOrderOrderRelDTO orderOrderRelQryDto = new DycProOrderOrderRelDTO();
            orderOrderRelQryDto.setObjId(inspOrderId);
            orderOrderRelQryDto.setOrderId(orderId);
            orderOrderRelQryDto.setObjType(DycProOrderManageServiceConstant.OBJ_TYPE.INSPECTION);
            List qryRelResultDtoList = this.dycProOrderOrderRepository.qryListRelInfo(orderOrderRelQryDto);
            if (CollectionUtils.isEmpty((Collection)qryRelResultDtoList)) continue;
            DycProOrderSaleOrderDTO saleOrderDto = new DycProOrderSaleOrderDTO();
            saleOrderDto.setOrderId(orderId);
            saleOrderDto.setSaleOrderId(saleOrderId);
            DycProOrderSaleOrderDTO qrySaleResult = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderDto);
            if (null == qrySaleResult) {
                throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a\uff01");
            }
            if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(qrySaleResult.getOrderSource())) {
                if (DycProOrderManageServiceConstant.ModelSettle.TRADE.equals(qrySaleResult.getModelSettle())) {
                    updateRelList = qryRelResultDtoList.stream().filter(bo -> DycProOrderManageServiceConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || DycProOrderManageServiceConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(updateRelList)) continue;
                    this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.REL_STATUS.HANG);
                    continue;
                }
                updateRelList = qryRelResultDtoList.stream().filter(bo -> DycProOrderManageServiceConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelList)) continue;
                this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.REL_STATUS.HANG);
                continue;
            }
            if (DycProOrderManageServiceConstant.ModelSettle.TRADE.equals(qrySaleResult.getModelSettle())) {
                updateRelList = qryRelResultDtoList.stream().filter(bo -> (DycProOrderManageServiceConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || DycProOrderManageServiceConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())) && !DycProOrderManageServiceConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelList)) continue;
                this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.REL_STATUS.HANG);
                continue;
            }
            updateRelList = qryRelResultDtoList.stream().filter(bo -> DycProOrderManageServiceConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType()) && !DycProOrderManageServiceConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateRelList)) continue;
            this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.REL_STATUS.HANG);
        }
    }

    private void updateRelStateData(List<DycProOrderOrderRelDTO> updateRelDtoList, Integer relStatus) {
        updateRelDtoList.stream().filter(Objects::nonNull).forEach(updateRelDto -> updateRelDto.setRelStatus(relStatus));
        this.dycProOrderOrderRepository.updateOrderRelBatchById(updateRelDtoList);
    }

    private void verifyParam(DycProOrderCreateNumChngOrderReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        reqBo.getChngOrderList().forEach(uocNumChngOrderCreateReqInspBo -> {
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderId()) {
                throw new ZTBusinessException("\u5165\u53c2\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderItemList()) {
                throw new ZTBusinessException("\u5165\u53c2\u9a8c\u6536\u5bf9\u8c61\u4e3a\u7a7a");
            }
            uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
                if (null == x.getInspOrderItemId()) {
                    throw new ZTBusinessException("\u5165\u53c2\u9a8c\u6536\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
                }
                if (null == x.getChngCount()) {
                    throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4\u6570\u91cf\u4e3a\u7a7a");
                }
                if (null == x.getAddOrDelType()) {
                    throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (null == x.getRemainInspNum()) {
                    throw new ZTBusinessException("\u5165\u53c2\u5269\u4f59\u9a8c\u6536\u6570\u91cf\u4e3a\u7a7a");
                }
                if (1 != x.getAddOrDelType() && 2 != x.getAddOrDelType()) {
                    throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u9519\u8bef");
                }
            });
        });
    }
}

