/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.insporder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderUploadInspOrderPicService;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderUploadInspOrderPicReqBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderUploadInspOrderPicRspBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderOrderAccessoryBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderUploadInspOrderPicService"})
public class DycProOrderUploadInspOrderPicServiceImpl
implements DycProOrderUploadInspOrderPicService {
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @Override
    @PostMapping(value={"uploadInspOrderPic"})
    public DycProOrderUploadInspOrderPicRspBO uploadInspOrderPic(@RequestBody DycProOrderUploadInspOrderPicReqBO reqBO) {
        DycProOrderOrderAccessoryDTO accessoryPicDto;
        this.verifyParam(reqBO);
        ArrayList<DycProOrderOrderAccessoryDTO> inspOrderPicList = new ArrayList<DycProOrderOrderAccessoryDTO>();
        if (!CollectionUtils.isEmpty(reqBO.getInspOrderPicList())) {
            for (DycProOrderOrderAccessoryBO accessoryBo : reqBO.getInspOrderPicList()) {
                accessoryPicDto = new DycProOrderOrderAccessoryDTO();
                BeanUtils.copyProperties((Object)accessoryBo, (Object)accessoryPicDto);
                accessoryPicDto.setObjId(reqBO.getInspOrderId());
                accessoryPicDto.setOrderId(reqBO.getSaleOrderId());
                accessoryPicDto.setObjType(DycProOrderManageServiceConstant.OrderAccessoryObjType.INSP_ORDER_PIC);
                inspOrderPicList.add(accessoryPicDto);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getInspOrderAccessoryList())) {
            for (DycProOrderOrderAccessoryBO accessoryBo : reqBO.getInspOrderAccessoryList()) {
                accessoryPicDto = new DycProOrderOrderAccessoryDTO();
                BeanUtils.copyProperties((Object)accessoryBo, (Object)accessoryPicDto);
                accessoryPicDto.setObjId(reqBO.getInspOrderId());
                accessoryPicDto.setOrderId(reqBO.getSaleOrderId());
                accessoryPicDto.setObjType(DycProOrderManageServiceConstant.OrderAccessoryObjType.INSP_ORDER_FILE);
                inspOrderPicList.add(accessoryPicDto);
            }
        }
        if (!CollectionUtils.isEmpty(inspOrderPicList)) {
            this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(inspOrderPicList);
        }
        return new DycProOrderUploadInspOrderPicRspBO();
    }

    private void verifyParam(DycProOrderUploadInspOrderPicReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInspOrderId()) {
            throw new ZTBusinessException("\u9a8c\u6536\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getInspOrderPicList()) && (CollectionUtils.isEmpty(reqBO.getInspOrderAccessoryList()) || CollectionUtils.isEmpty(this.getInspOrderPicList(reqBO)))) {
            throw new ZTBusinessException("\u9a8c\u6536\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<DycProOrderOrderAccessoryDTO> getInspOrderPicList(DycProOrderUploadInspOrderPicReqBO reqBO) {
        DycProOrderOrderAccessoryDTO queryInspOrderPicListDTO = new DycProOrderOrderAccessoryDTO();
        queryInspOrderPicListDTO.setObjId(reqBO.getInspOrderId());
        queryInspOrderPicListDTO.setOrderId(reqBO.getSaleOrderId());
        queryInspOrderPicListDTO.setObjType(DycProOrderManageServiceConstant.OrderAccessoryObjType.INSP_ORDER_PIC);
        return this.dycProOrderOrderRepository.queryKindsAccessoryListByCondition(queryInspOrderPicListDTO);
    }
}

