/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSaleInspOrderBO;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderConfEffectiveDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderConfEvaluateDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageForPurchaseService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageForPurchaseReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageForPurchaseRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderEsBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderTabCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageForPurchaseService"})
public class DycProOrderQrySaleOrderListPageForPurchaseServiceImpl
implements DycProOrderQrySaleOrderListPageForPurchaseService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQrySaleOrderListPageForPurchaseServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    private static final Integer ALLOW_EVA = 1;
    private static final Integer NOT_ALLOW_EVA = 0;
    private static final Integer SYSTEM_AUTOMATIC_PRAISE = 1;

    @Override
    @PostMapping(value={"qrySaleOrderListPageForPurchase"})
    public DycProOrderQrySaleOrderListPageForPurchaseRspBO qrySaleOrderListPageForPurchase(@RequestBody DycProOrderQrySaleOrderListPageForPurchaseReqBO reqBO) {
        this.paramVerify(reqBO);
        if ("myOrderList".equals(reqBO.getMenuCode())) {
            reqBO.setCreateOperId(reqBO.getUserId().toString());
        }
        if ("arrivalAcceptanceList".equals(reqBO.getMenuCode())) {
            reqBO.setPurCompanyId(reqBO.getCompanyId());
        }
        DycProOrderSaleOrderQryDTO qryDTO = (DycProOrderSaleOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderSaleOrderQryDTO.class);
        qryDTO.setSaleOrderStateList(this.getTabQueryParam(reqBO.getTabId(), reqBO.getMenuCode()));
        RspPage rspPage = this.dycProOrderSaleOrderRepository.querySaleOrderEsPageListByCondition(qryDTO);
        DycProOrderQrySaleOrderListPageForPurchaseRspBO rspBO = new DycProOrderQrySaleOrderListPageForPurchaseRspBO();
        if (!CollectionUtils.isEmpty((Collection)rspPage.getRows())) {
            rspBO = (DycProOrderQrySaleOrderListPageForPurchaseRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQrySaleOrderListPageForPurchaseRspBO.class));
            for (DycProOrderSaleOrderEsBO saleOrder : rspBO.getRows()) {
                saleOrder.setSaleOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderSaleOrderState", (String)saleOrder.getSaleOrderState()));
                if (null != saleOrder.getOrderStage()) {
                    saleOrder.setOrderStageStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderOrderStage", (String)saleOrder.getOrderStage().toString()));
                }
                if (null != saleOrder.getPurchaseType()) {
                    saleOrder.setPurchaseTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoPurchaseType", (String)saleOrder.getPurchaseType().toString()));
                }
                if (null != saleOrder.getMaterialType()) {
                    saleOrder.setMaterialTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoMaterialType", (String)saleOrder.getMaterialType().toString()));
                }
                if (null == saleOrder.getPayState()) continue;
                saleOrder.setPayStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderPayState", (String)saleOrder.getPayState().toString()));
            }
        }
        this.buildTabCount(rspBO, reqBO);
        this.setAging(rspBO);
        this.setIsAllowEva(rspBO, reqBO);
        return rspBO;
    }

    private void setIsAllowEva(DycProOrderQrySaleOrderListPageForPurchaseRspBO rspBO, DycProOrderQrySaleOrderListPageForPurchaseReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            Long evaluationDeadline;
            log.info("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u8bc4\u4ef7\u6309\u94ae\u63a7\u5236\uff1a\u6839\u636e\u8bc4\u4ef7\u914d\u7f6e\u60c5\u51b5\uff0c\u63a7\u5236\u8bc4\u4ef7\u6309\u94ae\u5c55\u793a");
            DycProOrderConfEvaluateDTO evaConf = this.getEvaConf(reqBO.getOrgId().toString());
            log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)evaConf));
            if (null != evaConf && null != (evaluationDeadline = evaConf.getEvaluationDeadline())) {
                for (DycProOrderSaleOrderEsBO saleOrder : rspBO.getRows()) {
                    saleOrder.setAddEvaFlag(evaConf.getWhetherReview());
                    saleOrder.setAddEvaTime(evaConf.getReviewDeadline());
                    if (!CollectionUtils.isEmpty(saleOrder.getInspOrderList())) {
                        Date lastInspTime = saleOrder.getInspOrderList().stream().map(DycProEsIndexMappingSaleInspOrderBO::getCreateTime).max(Date::compareTo).get();
                        log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff1a\u6700\u665a\u9a8c\u6536\u65f6\u95f4{}", (Object)JSON.toJSONString((Object)lastInspTime));
                        log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u6700\u665a\u9a8c\u6536\u65f6\u95f4\uff1a{}\uff0c\u8bc4\u4ef7\u622a\u81f3\u65f6\u957f\u6beb\u79d2\u6570\uff1a{}\uff0c\u662f\u5426\u5141\u8bb8\u81ea\u52a8\u597d\u8bc4\uff1a{}", new Object[]{System.currentTimeMillis(), lastInspTime.getTime(), evaluationDeadline, evaConf.getSystemAutomaticPraise()});
                        if (System.currentTimeMillis() > lastInspTime.getTime() + evaluationDeadline && !SYSTEM_AUTOMATIC_PRAISE.equals(evaConf.getSystemAutomaticPraise())) {
                            log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff1a\u5f53\u524d\u65f6\u95f4 > \u6700\u665a\u9a8c\u6536\u65f6\u95f4 + \u8bc4\u4ef7\u622a\u81f3\u65f6\u957f\u6beb\u79d2\u6570 \u5e76\u4e14 \u8d85\u8fc7\u65f6\u95f4\u540e\u4e0d\u5141\u8bb8\u8bc4\u4ef7");
                            saleOrder.setIsAllowEva(NOT_ALLOW_EVA);
                            continue;
                        }
                        log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff1a\u672a\u8d85\u65f6");
                        saleOrder.setIsAllowEva(ALLOW_EVA);
                        continue;
                    }
                    log.debug("\u8bc4\u4ef7\u914d\u7f6e\uff1a\u9a8c\u6536\u5355\u5217\u8868\u4e3a\u7a7a");
                    saleOrder.setIsAllowEva(NOT_ALLOW_EVA);
                }
            }
        }
    }

    private DycProOrderConfEvaluateDTO getEvaConf(String orgId) {
        List evaConfList = this.dycProOrderOrderRepository.queryConfEvaluateListByCondition(new DycProOrderConfEvaluateDTO());
        if (CollectionUtils.isEmpty((Collection)evaConfList)) {
            return null;
        }
        Map<String, DycProOrderConfEvaluateDTO> evaConf = evaConfList.stream().collect(Collectors.toMap(DycProOrderConfEvaluateDTO::getApplicationUnitNo, o -> o));
        DycProOrderConfEvaluateDTO evaluateDTO = evaConf.get(orgId);
        if (null != evaluateDTO) {
            return evaluateDTO;
        }
        return evaConf.get("0");
    }

    private void setAging(DycProOrderQrySaleOrderListPageForPurchaseRspBO rspBO) {
        Map<String, Map<String, Long>> effConfMap;
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows()) && null != (effConfMap = this.getEffConf()) && !effConfMap.isEmpty()) {
            for (DycProOrderSaleOrderEsBO saleOrder : rspBO.getRows()) {
                Map<String, Long> inspEffMap;
                Map<String, Long> stockEffMap = effConfMap.get("1" + saleOrder.getOrderSource());
                if (null != stockEffMap) {
                    Long time = stockEffMap.get(saleOrder.getSaleStakeholder().getSupId());
                    if (null == time) {
                        time = stockEffMap.get("0");
                    }
                    saleOrder.setStockAging(time);
                }
                if (null == (inspEffMap = effConfMap.get("4" + saleOrder.getOrderSource()))) continue;
                Long time = inspEffMap.get(saleOrder.getSaleStakeholder().getSupId());
                if (null == time) {
                    time = inspEffMap.get("0");
                }
                saleOrder.setInspAging(time);
            }
        }
    }

    private Map<String, Map<String, Long>> getEffConf() {
        List dycProOrderConfEffectiveDTOS = this.dycProOrderOrderRepository.queryConfEffectiveListByCondition(new DycProOrderConfEffectiveDTO());
        if (!CollectionUtils.isEmpty((Collection)dycProOrderConfEffectiveDTOS)) {
            Map<String, List<DycProOrderConfEffectiveDTO>> effListMap = dycProOrderConfEffectiveDTOS.stream().collect(Collectors.groupingBy(e -> e.getEffectiveCode() + e.getBusinessTypeCode()));
            HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
            effListMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(DycProOrderConfEffectiveDTO::getSupplierNo, DycProOrderConfEffectiveDTO::getAging))));
            return map;
        }
        return null;
    }

    private void paramVerify(DycProOrderQrySaleOrderListPageForPurchaseReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (null == reqBO.getTabId()) {
            throw new ZTBusinessException("\u9875\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getMenuCode())) {
            throw new ZTBusinessException("menuCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<String> getTabQueryParam(String tabId, String menuCode) {
        ArrayList<String> saleOrderStateList = new ArrayList<String>(1);
        if ("myOrderList".equals(menuCode)) {
            if ("1001".equals(tabId)) {
                saleOrderStateList.add("XS_QR_DQR");
                saleOrderStateList.add("XS_QR_JDDCL");
                saleOrderStateList.add("XS_SP_SPZ");
                saleOrderStateList.add("XS_QX_QXSQ");
                saleOrderStateList.add("XS_FH_DFH");
                saleOrderStateList.add("XS_FH_FHZ");
                saleOrderStateList.add("XS_FH_FHWC");
                saleOrderStateList.add("XS_DH_DH");
                saleOrderStateList.add("XS_DH_BFDH");
                saleOrderStateList.add("XS_YS_YS");
                saleOrderStateList.add("XS_YS_BFYS");
                saleOrderStateList.add("XS_DH_JS");
                saleOrderStateList.add("XS_QX_QX");
                saleOrderStateList.add("XS_XD_SB");
            } else if ("1002".equals(tabId)) {
                saleOrderStateList.add("XS_QR_DQR");
                saleOrderStateList.add("XS_QR_JDDCL");
                saleOrderStateList.add("XS_SP_SPZ");
                saleOrderStateList.add("XS_QX_QXSQ");
                saleOrderStateList.add("XS_FH_DFH");
                saleOrderStateList.add("XS_FH_FHZ");
                saleOrderStateList.add("XS_FH_FHWC");
            } else if ("1003".equals(tabId)) {
                saleOrderStateList.add("XS_DH_DH");
                saleOrderStateList.add("XS_DH_BFDH");
                saleOrderStateList.add("XS_YS_YS");
                saleOrderStateList.add("XS_YS_BFYS");
                saleOrderStateList.add("XS_DH_JS");
            } else if ("1004".equals(tabId)) {
                saleOrderStateList.add("XS_QX_QX");
                saleOrderStateList.add("XS_XD_SB");
            } else {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
            }
        }
        if ("arrivalAcceptanceList".equals(menuCode)) {
            if ("1002".equals(tabId)) {
                saleOrderStateList.add("XS_FH_FHZ");
                saleOrderStateList.add("XS_FH_FHWC");
            } else if ("1003".equals(tabId)) {
                saleOrderStateList.add("XS_DH_BFDH");
                saleOrderStateList.add("XS_DH_DH");
            } else if ("1004".equals(tabId)) {
                saleOrderStateList.add("XS_YS_BFYS");
            } else if ("1005".equals(tabId)) {
                saleOrderStateList.add("XS_YS_YS");
            } else if ("1001".equals(tabId)) {
                saleOrderStateList.add("XS_FH_FHZ");
                saleOrderStateList.add("XS_FH_FHWC");
                saleOrderStateList.add("XS_DH_BFDH");
                saleOrderStateList.add("XS_DH_DH");
                saleOrderStateList.add("XS_YS_BFYS");
                saleOrderStateList.add("XS_YS_YS");
            } else {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
            }
        }
        if ("myToDoOrderList".equals(menuCode)) {
            if ("1001".equals(tabId)) {
                saleOrderStateList.add("XS_QR_DQR");
                saleOrderStateList.add("XS_QR_JDDCL");
                saleOrderStateList.add("XS_FH_DFH");
            } else if ("1002".equals(tabId)) {
                saleOrderStateList.add("XS_QR_DQR");
            } else if ("1003".equals(tabId)) {
                saleOrderStateList.add("XS_QR_JDDCL");
            } else if ("1004".equals(tabId)) {
                saleOrderStateList.add("XS_FH_DFH");
            } else {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
            }
        }
        return saleOrderStateList;
    }

    private void buildTabCount(DycProOrderQrySaleOrderListPageForPurchaseRspBO rspBO, DycProOrderQrySaleOrderListPageForPurchaseReqBO reqBO) {
        DycProOrderTabCountBO invalidOrderTabCountBO;
        DycProOrderTabCountBO inShipOrderTabCountBO;
        DycProOrderTabCountBO inDoOrderTabCountBO;
        DycProOrderSaleOrderQryDTO qryTabCountDTO = (DycProOrderSaleOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderSaleOrderQryDTO.class);
        ArrayList<DycProOrderTabCountBO> tabCountList = new ArrayList<DycProOrderTabCountBO>(1);
        if ("myOrderList".equals(reqBO.getMenuCode())) {
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1002", reqBO.getMenuCode()));
            inDoOrderTabCountBO = new DycProOrderTabCountBO();
            inDoOrderTabCountBO.setTabId("1002");
            inDoOrderTabCountBO.setTabName("\u5904\u7406\u4e2d\u8ba2\u5355");
            inDoOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inDoOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1003", reqBO.getMenuCode()));
            inShipOrderTabCountBO = new DycProOrderTabCountBO();
            inShipOrderTabCountBO.setTabId("1003");
            inShipOrderTabCountBO.setTabName("\u6536\u8d27\u4e2d\u8ba2\u5355");
            inShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inShipOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1004", reqBO.getMenuCode()));
            invalidOrderTabCountBO = new DycProOrderTabCountBO();
            invalidOrderTabCountBO.setTabId("1004");
            invalidOrderTabCountBO.setTabName("\u65e0\u6548\u8ba2\u5355");
            invalidOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(invalidOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1001", reqBO.getMenuCode()));
            DycProOrderTabCountBO allOrderTabCountBO = new DycProOrderTabCountBO();
            allOrderTabCountBO.setTabId("1001");
            allOrderTabCountBO.setTabName("\u5168\u90e8\u8ba2\u5355");
            allOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(allOrderTabCountBO);
        }
        if ("arrivalAcceptanceList".equals(reqBO.getMenuCode())) {
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1002", reqBO.getMenuCode()));
            inDoOrderTabCountBO = new DycProOrderTabCountBO();
            inDoOrderTabCountBO.setTabId("1002");
            inDoOrderTabCountBO.setTabName("\u5230\u8d27\u786e\u8ba4");
            inDoOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inDoOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1003", reqBO.getMenuCode()));
            inShipOrderTabCountBO = new DycProOrderTabCountBO();
            inShipOrderTabCountBO.setTabId("1003");
            inShipOrderTabCountBO.setTabName("\u5f85\u9a8c\u6536");
            inShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inShipOrderTabCountBO);
        }
        if ("myToDoOrderList".equals(reqBO.getMenuCode())) {
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1002", reqBO.getMenuCode()));
            inDoOrderTabCountBO = new DycProOrderTabCountBO();
            inDoOrderTabCountBO.setTabId("1002");
            inDoOrderTabCountBO.setTabName("\u5f85\u786e\u8ba4");
            inDoOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inDoOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1003", reqBO.getMenuCode()));
            inShipOrderTabCountBO = new DycProOrderTabCountBO();
            inShipOrderTabCountBO.setTabId("1003");
            inShipOrderTabCountBO.setTabName("\u62d2\u5355\u5f85\u5904\u7406");
            inShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inShipOrderTabCountBO);
            qryTabCountDTO.setSaleOrderStateList(this.getTabQueryParam("1004", reqBO.getMenuCode()));
            invalidOrderTabCountBO = new DycProOrderTabCountBO();
            invalidOrderTabCountBO.setTabId("1004");
            invalidOrderTabCountBO.setTabName("\u50ac\u4ea4");
            invalidOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(invalidOrderTabCountBO);
        }
        rspBO.setTabCountList(tabCountList);
    }

    private Integer getTabCount(DycProOrderSaleOrderQryDTO qryDTO) {
        qryDTO.setPageSize(0);
        RspPage baseManagePageRspBO = this.dycProOrderSaleOrderRepository.querySaleOrderEsPageListByCondition(qryDTO);
        return baseManagePageRspBO.getRecordsTotal();
    }
}

