/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.repository.chngorder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.ohaotian.plugin.nosql.impl.NosqlCreateBuilder;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingChngOrderBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingChngOrderObjBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSaleOrderItemBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSaleStakeholderBO;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.dao.UocChngOrderItemObjMapper;
import com.tydic.dyc.pro.egc.dao.UocChngOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocChngOrderObjMapper;
import com.tydic.dyc.pro.egc.dao.UocInspOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocInspOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.pro.egc.dao.UocOrderAgreementMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleStakeholderMapper;
import com.tydic.dyc.pro.egc.dao.UocShipOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocShipOrderMapper;
import com.tydic.dyc.pro.egc.po.UocChngOrderItemObjPO;
import com.tydic.dyc.pro.egc.po.UocChngOrderObjPO;
import com.tydic.dyc.pro.egc.po.UocChngOrderPO;
import com.tydic.dyc.pro.egc.po.UocInspOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocInspOrderPO;
import com.tydic.dyc.pro.egc.po.UocOrderAccessoryPO;
import com.tydic.dyc.pro.egc.po.UocSaleOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocSaleOrderPO;
import com.tydic.dyc.pro.egc.po.UocSaleStakeholderPO;
import com.tydic.dyc.pro.egc.po.UocShipOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocShipOrderPO;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemMapDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemObjQryDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjQryDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProOrderChngOrderRepositoryImpl
implements DycProOrderChngOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderChngOrderRepositoryImpl.class);
    @Value(value="${egc.es.chngOrder.index}")
    private String egcEsChngOrderIndex;
    @Autowired
    private NosqlClient nosqlClient;
    @Autowired
    private UocChngOrderMapper uocChngOrderMapper;
    @Autowired
    private UocChngOrderObjMapper uocChngOrderObjMapper;
    @Autowired
    private UocChngOrderItemObjMapper uocChngOrderItemObjMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocSaleStakeholderMapper uptSaleStakeholderMapper;
    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    @Override
    public void updateChngOrderAndSyncNosql(DycProOrderChngOrderDTO uocChngOrderDto) {
        UocChngOrderPO uocChngOrderPo = new UocChngOrderPO();
        BeanUtils.copyProperties((Object)uocChngOrderDto, (Object)uocChngOrderPo);
        this.uocChngOrderMapper.updateById((Object)uocChngOrderPo);
        DycProEsIndexMappingChngOrderBO updateChngOrderEsBO = new DycProEsIndexMappingChngOrderBO();
        BeanUtils.copyProperties((Object)uocChngOrderDto, (Object)updateChngOrderEsBO);
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.egcEsChngOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(uocChngOrderDto.getChngOrderId()));
        nosqlBO.setObject((Object)updateChngOrderEsBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u66f4\u65b0\u53d8\u66f4\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public DycProOrderChngOrderDTO createChngOrderAllInfoAndSyncNosql(DycProOrderChngOrderDTO uocChngOrderDto) {
        List uocSaleOrderItemPOList;
        Long chngOrderId = Sequence.getInstance().nextId();
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        if (uocChngOrderDto.getBusiType().equals(DycProOrderRepositoryConstant.BUSI_TYPE.NUM)) {
            encodeSerialReqBO.setEncodeRuleCode("ChngOrderCode");
        } else if (uocChngOrderDto.getBusiType().equals(DycProOrderRepositoryConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
            encodeSerialReqBO.setEncodeRuleCode("ApplyCancelSaleOrderCode");
        } else {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7c7b\u578b");
        }
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        String chngOrderNo = (String)encode.getSerialNoList().get(0);
        UocChngOrderPO addChngOrderPo = new UocChngOrderPO();
        BeanUtils.copyProperties((Object)uocChngOrderDto, (Object)addChngOrderPo);
        addChngOrderPo.setChngOrderId(chngOrderId);
        addChngOrderPo.setChngOrderNo(chngOrderNo);
        addChngOrderPo.setCreateTime(new Date());
        addChngOrderPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
        this.uocChngOrderMapper.insert((Object)addChngOrderPo);
        ArrayList<UocChngOrderObjPO> addChngOrderObjList = null;
        ArrayList<UocChngOrderItemObjPO> addChngOrderItemObjList = null;
        if (!CollectionUtils.isEmpty(uocChngOrderDto.getUocChngOrderObjList())) {
            addChngOrderObjList = new ArrayList<UocChngOrderObjPO>();
            addChngOrderItemObjList = new ArrayList<UocChngOrderItemObjPO>(1);
            for (DycProOrderChngOrderObjDTO dycProOrderChngOrderObjDTO : uocChngOrderDto.getUocChngOrderObjList()) {
                UocChngOrderObjPO addChngOrderObjPo = new UocChngOrderObjPO();
                BeanUtils.copyProperties((Object)dycProOrderChngOrderObjDTO, (Object)addChngOrderObjPo);
                addChngOrderObjPo.setChngOrderObjId(Long.valueOf(Sequence.getInstance().nextId()));
                addChngOrderObjPo.setChngOrderId(chngOrderId);
                addChngOrderObjPo.setCreateTime(new Date());
                addChngOrderObjList.add(addChngOrderObjPo);
                if (CollectionUtils.isEmpty(dycProOrderChngOrderObjDTO.getUocChngOrderItemObjList())) continue;
                for (DycProOrderChngOrderItemObjDTO chngOrderItemObjDTO : dycProOrderChngOrderObjDTO.getUocChngOrderItemObjList()) {
                    UocChngOrderItemObjPO addChngOrderItemObjPo = new UocChngOrderItemObjPO();
                    BeanUtils.copyProperties((Object)chngOrderItemObjDTO, (Object)addChngOrderItemObjPo);
                    addChngOrderItemObjPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    addChngOrderItemObjPo.setChngOrderId(chngOrderId);
                    addChngOrderItemObjPo.setChngOrderObjId(addChngOrderObjPo.getChngOrderObjId());
                    addChngOrderItemObjPo.setCreateTime(new Date());
                    addChngOrderItemObjList.add(addChngOrderItemObjPo);
                }
            }
            this.uocChngOrderObjMapper.insertBatch(addChngOrderObjList);
            if (!CollectionUtils.isEmpty(addChngOrderItemObjList)) {
                this.uocChngOrderItemObjMapper.insertBatch(addChngOrderItemObjList);
            }
        }
        if (!CollectionUtils.isEmpty(uocChngOrderDto.getChngOrderAccessoryList())) {
            ArrayList<UocOrderAccessoryPO> addChngOrderAccessoryList = new ArrayList<UocOrderAccessoryPO>();
            for (DycProOrderOrderAccessoryDTO chngOrderAccessoryDto : uocChngOrderDto.getChngOrderAccessoryList()) {
                UocOrderAccessoryPO addChngOrderAccessoryPo = new UocOrderAccessoryPO();
                BeanUtils.copyProperties((Object)chngOrderAccessoryDto, (Object)addChngOrderAccessoryPo);
                addChngOrderAccessoryPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                addChngOrderAccessoryPo.setObjId(chngOrderId);
                addChngOrderAccessoryPo.setOrderId(uocChngOrderDto.getSaleOrderId());
                addChngOrderAccessoryPo.setCreateTime(new Date());
                addChngOrderAccessoryPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addChngOrderAccessoryList.add(addChngOrderAccessoryPo);
            }
            this.uocOrderAccessoryMapper.insertBatch(addChngOrderAccessoryList);
        }
        NosqlAddSingleReqBO addNosqlReqBo = new NosqlAddSingleReqBO();
        DycProEsIndexMappingChngOrderBO dycProEsIndexMappingChngOrderBO = new DycProEsIndexMappingChngOrderBO();
        BeanUtils.copyProperties((Object)addChngOrderPo, (Object)dycProEsIndexMappingChngOrderBO);
        if (!CollectionUtils.isEmpty(addChngOrderObjList)) {
            List chngOrderObjEsList = JSONArray.parseArray((String)JSON.toJSONString(addChngOrderObjList)).toJavaList(DycProEsIndexMappingChngOrderObjBO.class);
            dycProEsIndexMappingChngOrderBO.setChngOrderObjList(chngOrderObjEsList);
        }
        if (DycProOrderRepositoryConstant.ChngOrderBusiType.APPLY_CANCEL.equals(addChngOrderPo.getBusiType()) && !CollectionUtils.isEmpty((Collection)(uocSaleOrderItemPOList = this.uocSaleOrderItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != uocChngOrderDto.getUocChngOrderObjList().get(0).getSaleOrderId(), UocSaleOrderItemPO::getSaleOrderId, (Object)uocChngOrderDto.getUocChngOrderObjList().get(0).getSaleOrderId()))))) {
            List saleOrderItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)uocSaleOrderItemPOList)).toJavaList(DycProEsIndexMappingSaleOrderItemBO.class);
            dycProEsIndexMappingChngOrderBO.setSaleOrderItemList(saleOrderItemList);
        }
        UocSaleOrderPO uocSaleOrderPO = (UocSaleOrderPO)this.uocSaleOrderMapper.selectById((Serializable)uocChngOrderDto.getSaleOrderId());
        dycProEsIndexMappingChngOrderBO.setOrderSource(uocSaleOrderPO.getOrderSource());
        dycProEsIndexMappingChngOrderBO.setSaleOrderNo(uocSaleOrderPO.getSaleOrderNo());
        dycProEsIndexMappingChngOrderBO.setTotalSaleFee(uocSaleOrderPO.getTotalSaleFee());
        dycProEsIndexMappingChngOrderBO.setTotalPurchaseFee(uocSaleOrderPO.getTotalPurchaseFee());
        dycProEsIndexMappingChngOrderBO.setOrderCreateTime(uocSaleOrderPO.getCreateTime());
        dycProEsIndexMappingChngOrderBO.setOrderCreateOperName(uocSaleOrderPO.getCreateOperName());
        dycProEsIndexMappingChngOrderBO.setModelSettle(uocSaleOrderPO.getModelSettle());
        if (DycProOrderRepositoryConstant.OrderSource.E_ORDER.equals(uocSaleOrderPO.getOrderSource())) {
            dycProEsIndexMappingChngOrderBO.setSaleOrderNoExt(uocSaleOrderPO.getSaleOrderNoExt());
        }
        dycProEsIndexMappingChngOrderBO.setPurchaseType(uocSaleOrderPO.getPurchaseType());
        dycProEsIndexMappingChngOrderBO.setPurchaseApplyNo(uocSaleOrderPO.getPurchaseApplyNo());
        dycProEsIndexMappingChngOrderBO.setBudgetId(uocSaleOrderPO.getBudgetId());
        dycProEsIndexMappingChngOrderBO.setMaterialType(uocSaleOrderPO.getMaterialType());
        dycProEsIndexMappingChngOrderBO.setProfessionalCompanyType(uocSaleOrderPO.getProfessionalCompanyType());
        dycProEsIndexMappingChngOrderBO.setProfessionalCompanyNo(uocSaleOrderPO.getProfessionalCompanyNo());
        dycProEsIndexMappingChngOrderBO.setOrderNo(uocSaleOrderPO.getOrderNo());
        dycProEsIndexMappingChngOrderBO.setNeedOrgId(uocSaleOrderPO.getNeedOrgId());
        dycProEsIndexMappingChngOrderBO.setNeedOrgName(uocSaleOrderPO.getNeedOrgName());
        UocSaleStakeholderPO uocSaleStakeholderPO = (UocSaleStakeholderPO)this.uptSaleStakeholderMapper.selectById((Serializable)uocSaleOrderPO.getStakeholderId());
        DycProEsIndexMappingSaleStakeholderBO saleStakeholderBO = (DycProEsIndexMappingSaleStakeholderBO)JSON.parseObject((String)JSON.toJSONString((Object)uocSaleStakeholderPO), DycProEsIndexMappingSaleStakeholderBO.class);
        dycProEsIndexMappingChngOrderBO.setSaleStakeholder(saleStakeholderBO);
        if (uocChngOrderDto.getBusiType().equals(DycProOrderRepositoryConstant.BUSI_TYPE.NUM)) {
            Long inspOrderId = uocChngOrderDto.getUocChngOrderObjList().get(0).getInspOrderId();
            UocInspOrderPO uocInspOrderPO = (UocInspOrderPO)this.uocInspOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != inspOrderId, UocInspOrderPO::getInspOrderId, (Object)inspOrderId));
            if (null != uocInspOrderPO) {
                dycProEsIndexMappingChngOrderBO.setInspOrderNo(uocInspOrderPO.getInspOrderNo());
                dycProEsIndexMappingChngOrderBO.setInspCreateTime(uocInspOrderPO.getCreateTime());
                dycProEsIndexMappingChngOrderBO.setInspCreateOperName(uocInspOrderPO.getInspOper());
            }
            List uocInspOrderItemPOList = this.uocInspOrderItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UocInspOrderItemPO::getInspOrderId, (Object)inspOrderId));
            List shipOrderItemIdList = uocInspOrderItemPOList.stream().map(UocInspOrderItemPO::getShipOrderItemId).collect(Collectors.toList());
            List uocShipOrderItemPOList = this.uocShipOrderItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(UocShipOrderItemPO::getShipOrderItemId, shipOrderItemIdList));
            List shipOrderIdList = uocShipOrderItemPOList.stream().map(UocShipOrderItemPO::getShipOrderId).collect(Collectors.toList());
            List uocShipOrderPOList = this.uocShipOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(UocShipOrderPO::getShipOrderId, shipOrderIdList));
            List shipOrderNoList = uocShipOrderPOList.stream().map(UocShipOrderPO::getShipOrderNo).collect(Collectors.toList());
            dycProEsIndexMappingChngOrderBO.setShipOrderNoList(shipOrderNoList);
            if (!CollectionUtils.isEmpty(addChngOrderItemObjList)) {
                BigDecimal chngFee = BigDecimal.ZERO;
                for (UocChngOrderItemObjPO uocChngOrderItemObj : addChngOrderItemObjList) {
                    if (null != uocChngOrderItemObj.getAddOrSubtractType() && uocChngOrderItemObj.getAddOrSubtractType() == 1) {
                        chngFee = chngFee.subtract(uocChngOrderItemObj.getChngFee());
                        continue;
                    }
                    if (uocChngOrderItemObj.getAddOrSubtractType() == null || uocChngOrderItemObj.getAddOrSubtractType() != 2) continue;
                    chngFee = chngFee.add(uocChngOrderItemObj.getChngFee());
                }
                Integer addOrSubtractType = chngFee.compareTo(BigDecimal.ZERO) >= 0 ? 2 : 1;
                dycProEsIndexMappingChngOrderBO.setAddOrSubtractType(addOrSubtractType);
                BigDecimal totalChngPurchaseFee = BigDecimal.ZERO;
                for (UocChngOrderItemObjPO chngOrderItemObjPO : addChngOrderItemObjList) {
                    if (chngOrderItemObjPO.getAddOrSubtractType() == 1) {
                        totalChngPurchaseFee = totalChngPurchaseFee.subtract(chngOrderItemObjPO.getChngPurchaseFee());
                    }
                    if (chngOrderItemObjPO.getAddOrSubtractType() != 2) continue;
                    totalChngPurchaseFee = totalChngPurchaseFee.add(chngOrderItemObjPO.getChngPurchaseFee());
                }
                ((DycProEsIndexMappingChngOrderObjBO)dycProEsIndexMappingChngOrderBO.getChngOrderObjList().get(0)).setChngPurchaseFee(totalChngPurchaseFee);
            }
        }
        addNosqlReqBo.setIndex(this.egcEsChngOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(chngOrderId));
        nosqlBO.setObject((Object)dycProEsIndexMappingChngOrderBO);
        log.info("\u65b0\u589e\u53d8\u66f4\u5355\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dycProEsIndexMappingChngOrderBO));
        addNosqlReqBo.setNosqlBO(nosqlBO);
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(addNosqlReqBo);
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u53d8\u66f4\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
        DycProOrderChngOrderDTO resultChngOrderDto = new DycProOrderChngOrderDTO();
        BeanUtils.copyProperties((Object)addChngOrderPo, (Object)resultChngOrderDto);
        return resultChngOrderDto;
    }

    @Override
    public RspPage<DycProEsIndexMappingChngOrderBO> queryChngOrderEsPageListByCondition(DycProOrderChngOrderQryDTO qryDTO) {
        NosqlQueryByBuilderReqBO nosqlQueryByBuilderReqBO = new NosqlQueryByBuilderReqBO();
        nosqlQueryByBuilderReqBO.setIndex(this.egcEsChngOrderIndex);
        nosqlQueryByBuilderReqBO.setNosqlBuilder(this.getChngOrderNosqlBuilder(qryDTO));
        NosqlQueryByBuilderRsqBO nosqlQueryByBuilderRsqBO = this.nosqlClient.queryByBuilder(nosqlQueryByBuilderReqBO);
        if (!"0000".equals(nosqlQueryByBuilderRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u5206\u9875\u67e5\u8be2\u53d8\u66f4\u5355es\u6570\u636e\u5f02\u5e38: " + nosqlQueryByBuilderRsqBO.getRespDesc());
        }
        RspPage rspBO = new RspPage();
        rspBO.setPageNo(nosqlQueryByBuilderRsqBO.getPageNo().intValue());
        rspBO.setTotal(nosqlQueryByBuilderRsqBO.getTotal().intValue());
        rspBO.setRecordsTotal(nosqlQueryByBuilderRsqBO.getRecordsTotal().intValue());
        rspBO.setRows(JSON.parseArray((String)nosqlQueryByBuilderRsqBO.getDocumentStr(), DycProEsIndexMappingChngOrderBO.class));
        this.buildChngOrderEsPageListRspNumValue((RspPage<DycProEsIndexMappingChngOrderBO>)rspBO);
        return rspBO;
    }

    private void buildChngOrderEsPageListRspNumValue(RspPage<DycProEsIndexMappingChngOrderBO> rspBO) {
        for (DycProEsIndexMappingChngOrderBO chngOrderEsBO : rspBO.getRows()) {
            if (CollectionUtils.isEmpty((Collection)chngOrderEsBO.getChngOrderObjList())) continue;
            for (DycProEsIndexMappingChngOrderObjBO chngOrderObjEsBO : chngOrderEsBO.getChngOrderObjList()) {
                if (null != chngOrderObjEsBO.getChngFee()) {
                    chngOrderObjEsBO.setChngFee(chngOrderObjEsBO.getChngFee().setScale(2, RoundingMode.HALF_UP));
                }
                if (null == chngOrderObjEsBO.getChngPurchaseFee()) continue;
                chngOrderObjEsBO.setChngPurchaseFee(chngOrderObjEsBO.getChngPurchaseFee().setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private NosqlBuilder getChngOrderNosqlBuilder(DycProOrderChngOrderQryDTO qryDTO) {
        NosqlQueryBO shipOrderNo;
        NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
        nosqlCreateBuilder.pageNo(Integer.valueOf(qryDTO.getPageNo()));
        nosqlCreateBuilder.pageSize(Integer.valueOf(qryDTO.getPageSize()));
        nosqlCreateBuilder.orderBy("createTime", NosqlSortOrder.DESC);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>(1);
        ArrayList<NosqlQueryBO> nosqlQueryBOList = new ArrayList<NosqlQueryBO>(1);
        NosqlQueryGroupBO queryGroupBO = new NosqlQueryGroupBO();
        queryGroupBO.setNosqlQueryList(nosqlQueryBOList);
        queryGroupBO.setConnetType(NosqlConnetType.AND);
        ArrayList<NosqlQueryGroupBO> queryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        queryGroupBOList.add(queryGroupBO);
        NosqlQueryGroupBO nosqlQueryGroupBO = new NosqlQueryGroupBO(queryGroupBOList, NosqlConnetType.AND);
        nosqlQueryGroupBOList.add(nosqlQueryGroupBO);
        if (null != qryDTO.getOrderSource()) {
            NosqlQueryBO orderSource = new NosqlQueryBO("orderSource", String.valueOf(qryDTO.getOrderSource()), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(orderSource);
        }
        if (null != qryDTO.getChngOrderNo()) {
            shipOrderNo = new NosqlQueryBO("chngOrderNo", qryDTO.getChngOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(shipOrderNo);
        }
        if (null != qryDTO.getChngOrderState()) {
            NosqlQueryBO chngOrderState = new NosqlQueryBO("chngOrderState", qryDTO.getChngOrderState(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(chngOrderState);
        }
        if (null != qryDTO.getChngOrderStateList()) {
            NosqlQueryBO saleOrderState = new NosqlQueryBO("chngOrderState", qryDTO.getChngOrderStateList(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(saleOrderState);
        }
        if (null != qryDTO.getCreateOperName()) {
            NosqlQueryBO createOperName = new NosqlQueryBO("createOperName", qryDTO.getCreateOperName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(createOperName);
        }
        if (null != qryDTO.getInspOrderNo()) {
            NosqlQueryBO inspOrderNo = new NosqlQueryBO("inspOrderNo", qryDTO.getInspOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(inspOrderNo);
        }
        if (null != qryDTO.getShipOrderNo()) {
            shipOrderNo = new NosqlQueryBO("shipOrderNoList", qryDTO.getShipOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(shipOrderNo);
        }
        if (null != qryDTO.getSaleOrderNo()) {
            NosqlQueryBO saleOrderNo = new NosqlQueryBO("saleOrderNo", qryDTO.getSaleOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNo);
        }
        if (null != qryDTO.getSaleOrderNoExt()) {
            NosqlQueryBO saleOrderNoExt = new NosqlQueryBO("saleOrderNoExt", qryDTO.getSaleOrderNoExt(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNoExt);
        }
        NosqlQueryBO createTime = new NosqlQueryBO("createTime", qryDTO.getCreateTimeStart(), qryDTO.getCreateTimeEnd());
        nosqlQueryBOList.add(createTime);
        NosqlQueryBO inspCreateTime = new NosqlQueryBO("inspCreateTime", qryDTO.getInspCreateTimeStart(), qryDTO.getInspCreateTimeEnd());
        nosqlQueryBOList.add(inspCreateTime);
        NosqlQueryBO saleOrderCreateTime = new NosqlQueryBO("orderCreateTime", qryDTO.getOrderCreateTimeStart(), qryDTO.getOrderCreateTimeEnd());
        nosqlQueryBOList.add(saleOrderCreateTime);
        if (!StringUtils.isBlank((CharSequence)qryDTO.getOrderCreateOperName())) {
            NosqlQueryBO saleOrderCreateOperName = new NosqlQueryBO("orderCreateOperName", qryDTO.getOrderCreateOperName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderCreateOperName);
        }
        if (!StringUtils.isBlank((CharSequence)qryDTO.getInspCreateOperName())) {
            NosqlQueryBO inspCreateOperName = new NosqlQueryBO("inspCreateOperName", qryDTO.getInspCreateOperName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(inspCreateOperName);
        }
        if (null != qryDTO.getInspOrderState()) {
            NosqlQueryBO inspOrderState = new NosqlQueryBO("inspOrderState", qryDTO.getInspOrderState(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(inspOrderState);
        }
        if (null != qryDTO.getChngType()) {
            NosqlQueryBO chngType = new NosqlQueryBO("chngOrderObjList.chngType", String.valueOf(qryDTO.getChngType()), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(chngType);
        }
        if (null != qryDTO.getSupId()) {
            NosqlQueryBO supId = new NosqlQueryBO("saleStakeholder.supId", qryDTO.getSupId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(supId);
        }
        if (null != qryDTO.getPurCompanyId()) {
            NosqlQueryBO purCompanyId = new NosqlQueryBO("saleStakeholder.purCompanyId", qryDTO.getPurCompanyId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purCompanyId);
        }
        if (null != qryDTO.getPurOrgId()) {
            NosqlQueryBO purOrgId = new NosqlQueryBO("saleStakeholder.purOrgId", qryDTO.getPurOrgId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purOrgId);
        }
        if (null != qryDTO.getPurUserId()) {
            NosqlQueryBO purUserId = new NosqlQueryBO("saleStakeholder.purUserId", qryDTO.getPurUserId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purUserId);
        }
        if (null != qryDTO.getModelSettle()) {
            NosqlQueryBO modelSettle = new NosqlQueryBO("modelSettle", String.valueOf(qryDTO.getModelSettle()), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(modelSettle);
        }
        nosqlCreateBuilder.queryGroupList(nosqlQueryGroupBOList);
        return nosqlCreateBuilder.build();
    }

    @Override
    public List<DycProOrderChngOrderObjDTO> getListChngOrderObjWithOutItem(DycProOrderChngOrderObjQryDTO dycProOrderChngOrderObjQryDTO) {
        UocChngOrderObjPO uocChngOrderObjPO = (UocChngOrderObjPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderObjQryDTO), UocChngOrderObjPO.class);
        List uocChngOrderObjPOList = this.uocChngOrderObjMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != uocChngOrderObjPO.getOrderId(), UocChngOrderObjPO::getOrderId, (Object)uocChngOrderObjPO.getOrderId())).eq(null != uocChngOrderObjPO.getSaleOrderId(), UocChngOrderObjPO::getSaleOrderId, (Object)uocChngOrderObjPO.getSaleOrderId())).eq(null != uocChngOrderObjPO.getChngType(), UocChngOrderObjPO::getChngType, (Object)uocChngOrderObjPO.getChngType())).in(!CollectionUtils.isEmpty(dycProOrderChngOrderObjQryDTO.getChngOrderIdList()), UocChngOrderObjPO::getChngOrderId, dycProOrderChngOrderObjQryDTO.getChngOrderIdList()));
        return JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderObjPOList), DycProOrderChngOrderObjDTO.class);
    }

    @Override
    public DycProOrderChngOrderDTO getChngOrder(DycProOrderChngOrderQryDTO dycProOrderChngOrderQryDTO) {
        UocChngOrderPO uocChngOrderPO = (UocChngOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderQryDTO), UocChngOrderPO.class);
        uocChngOrderPO = (UocChngOrderPO)this.uocChngOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocChngOrderPO.getChngOrderId() != null, UocChngOrderPO::getChngOrderId, (Object)uocChngOrderPO.getChngOrderId())).eq(uocChngOrderPO.getOrderId() != null, UocChngOrderPO::getOrderId, (Object)uocChngOrderPO.getOrderId())).in(!CollectionUtils.isEmpty(dycProOrderChngOrderQryDTO.getChngOrderIdList()), UocChngOrderPO::getChngOrderId, dycProOrderChngOrderQryDTO.getChngOrderIdList())).eq(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dycProOrderChngOrderQryDTO.getChngOrderState()}), UocChngOrderPO::getChngOrderState, (Object)dycProOrderChngOrderQryDTO.getChngOrderState())).eq(null != dycProOrderChngOrderQryDTO.getBusiType(), UocChngOrderPO::getBusiType, (Object)dycProOrderChngOrderQryDTO.getBusiType()));
        DycProOrderChngOrderDTO dycProOrderChngOrderDTO = (DycProOrderChngOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)uocChngOrderPO), DycProOrderChngOrderDTO.class);
        return dycProOrderChngOrderDTO;
    }

    @Override
    public List<DycProOrderChngOrderObjDTO> getListChngOrderObj(DycProOrderChngOrderObjQryDTO dycProOrderChngOrderObjQryDTO) {
        List<DycProOrderChngOrderObjDTO> dycProOrderChngOrderObjDTOList = new ArrayList<DycProOrderChngOrderObjDTO>();
        UocChngOrderObjPO uocChngOrderObjPO = (UocChngOrderObjPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderObjQryDTO), UocChngOrderObjPO.class);
        List uocChngOrderObjPoList = this.uocChngOrderObjMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocChngOrderObjPO.getChngOrderId() != null, UocChngOrderObjPO::getChngOrderId, (Object)uocChngOrderObjPO.getChngOrderId())).eq(uocChngOrderObjPO.getOrderId() != null, UocChngOrderObjPO::getOrderId, (Object)uocChngOrderObjPO.getOrderId()));
        if (!CollectionUtils.isEmpty((Collection)uocChngOrderObjPoList)) {
            dycProOrderChngOrderObjDTOList = JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderObjPoList), DycProOrderChngOrderObjDTO.class);
            UocChngOrderItemObjPO uocChngOrderItemObjPO = (UocChngOrderItemObjPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderObjQryDTO), UocChngOrderItemObjPO.class);
            List uocChngOrderItemObjPoList = this.uocChngOrderItemObjMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocChngOrderItemObjPO.getChngOrderId() != null, UocChngOrderItemObjPO::getChngOrderId, (Object)uocChngOrderItemObjPO.getChngOrderId())).eq(uocChngOrderItemObjPO.getOrderId() != null, UocChngOrderItemObjPO::getOrderId, (Object)uocChngOrderItemObjPO.getOrderId()));
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderItemObjPoList)) {
                ConcurrentMap<Long, List<UocChngOrderItemObjPO>> chngOrderItemObjMap = uocChngOrderItemObjPoList.stream().collect(Collectors.groupingByConcurrent(UocChngOrderItemObjPO::getChngOrderObjId));
                dycProOrderChngOrderObjDTOList.forEach(dycProOrderChngOrderObjDTO -> {
                    List uocChngOrderItemObjPos = (List)chngOrderItemObjMap.get(dycProOrderChngOrderObjDTO.getChngOrderObjId());
                    if (!CollectionUtils.isEmpty((Collection)uocChngOrderItemObjPos)) {
                        dycProOrderChngOrderObjDTO.setUocChngOrderItemObjList(JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderItemObjPos), DycProOrderChngOrderItemObjDTO.class));
                    }
                });
            }
        }
        return dycProOrderChngOrderObjDTOList;
    }

    @Override
    public List<DycProOrderChngOrderItemObjDTO> getListChngOrderItemObj(DycProOrderChngOrderItemObjQryDTO dycProOrderChngOrderItemObjQryDTO) {
        UocChngOrderItemObjPO uocChngOrderItemObjPO = (UocChngOrderItemObjPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderItemObjQryDTO), UocChngOrderItemObjPO.class);
        List uocChngOrderItemObjPoList = this.uocChngOrderItemObjMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != uocChngOrderItemObjPO.getChngOrderId(), UocChngOrderItemObjPO::getChngOrderId, (Object)uocChngOrderItemObjPO.getChngOrderId())).eq(null != uocChngOrderItemObjPO.getOrderId(), UocChngOrderItemObjPO::getOrderId, (Object)uocChngOrderItemObjPO.getOrderId())).eq(null != uocChngOrderItemObjPO.getId(), UocChngOrderItemObjPO::getId, (Object)uocChngOrderItemObjPO.getId())).eq(null != uocChngOrderItemObjPO.getSaleOrderItemId(), UocChngOrderItemObjPO::getSaleOrderItemId, (Object)uocChngOrderItemObjPO.getSaleOrderItemId())).eq(null != uocChngOrderItemObjPO.getChngType(), UocChngOrderItemObjPO::getChngType, (Object)uocChngOrderItemObjPO.getChngType())).in(!CollectionUtils.isEmpty(dycProOrderChngOrderItemObjQryDTO.getChngOrderIdList()), UocChngOrderItemObjPO::getChngOrderId, dycProOrderChngOrderItemObjQryDTO.getChngOrderIdList())).in(!CollectionUtils.isEmpty(dycProOrderChngOrderItemObjQryDTO.getOrderIdList()), UocChngOrderItemObjPO::getOrderId, dycProOrderChngOrderItemObjQryDTO.getOrderIdList())).in(!CollectionUtils.isEmpty(dycProOrderChngOrderItemObjQryDTO.getIds()), UocChngOrderItemObjPO::getId, dycProOrderChngOrderItemObjQryDTO.getIds()));
        return JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderItemObjPoList), DycProOrderChngOrderItemObjDTO.class);
    }

    @Override
    public List<DycProOrderChngOrderItemMapDTO> getChngItemMapItem(DycProOrderChngOrderItemMapDTO dycProOrderChngOrderItemMapDTO) {
        UocChngOrderItemObjPO uocChngOrderItemMapPo = (UocChngOrderItemObjPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderChngOrderItemMapDTO), UocChngOrderItemObjPO.class);
        List uocChngOrderItemObjMapPoList = this.uocChngOrderItemObjMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocChngOrderItemMapPo.getChngOrderId() != null, UocChngOrderItemObjPO::getChngOrderId, (Object)uocChngOrderItemMapPo.getChngOrderId())).eq(uocChngOrderItemMapPo.getOrderId() != null, UocChngOrderItemObjPO::getOrderId, (Object)uocChngOrderItemMapPo.getOrderId())).eq(uocChngOrderItemMapPo.getChngOrderObjId() != null, UocChngOrderItemObjPO::getChngOrderObjId, (Object)uocChngOrderItemMapPo.getChngOrderObjId()));
        return JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderItemObjMapPoList), DycProOrderChngOrderItemMapDTO.class);
    }

    @Override
    public void updateBatchChngOrderObjItemById(List<DycProOrderChngOrderItemObjDTO> dycProOrderChngOrderItemObjDTO) {
        List uocChngOrderItemObjPOList = JSON.parseArray((String)JSON.toJSONString(dycProOrderChngOrderItemObjDTO), UocChngOrderItemObjPO.class);
        this.uocChngOrderItemObjMapper.updateBatchByIds((Collection)uocChngOrderItemObjPOList);
    }

    @Override
    public List<DycProOrderChngOrderObjDTO> queryChngOrderObjListByCondition(DycProOrderChngOrderQryDTO qryDTO) {
        List uocChngOrderObjPOList = this.uocChngOrderObjMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(!CollectionUtils.isEmpty(qryDTO.getChngOrderIdList()), UocChngOrderObjPO::getChngOrderId, qryDTO.getChngOrderIdList()));
        if (!CollectionUtils.isEmpty((Collection)uocChngOrderObjPOList)) {
            return JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderObjPOList), DycProOrderChngOrderObjDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public DycProOrderChngOrderDTO queryChngOrderOneByCondition(DycProOrderChngOrderDTO qryDto) {
        UocChngOrderPO uocChngOrderPO = (UocChngOrderPO)this.uocChngOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != qryDto.getChngOrderId(), UocChngOrderPO::getChngOrderId, (Object)qryDto.getChngOrderId()));
        if (null != uocChngOrderPO) {
            DycProOrderChngOrderDTO chngOrderDTO = new DycProOrderChngOrderDTO();
            BeanUtils.copyProperties((Object)uocChngOrderPO, (Object)chngOrderDTO);
            return chngOrderDTO;
        }
        return null;
    }
}

