/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.repository.insporder.impl;

import com.alibaba.fastjson.JSONArray;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.ohaotian.plugin.nosql.impl.NosqlCreateBuilder;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingInspOrderBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingInspOrderItemBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSaleStakeholderBO;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.dao.UocInspOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocInspOrderMapMapper;
import com.tydic.dyc.pro.egc.dao.UocInspOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocShipInspRelMapper;
import com.tydic.dyc.pro.egc.po.UocInspOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocInspOrderMapPO;
import com.tydic.dyc.pro.egc.po.UocInspOrderPO;
import com.tydic.dyc.pro.egc.po.UocOrderAccessoryPO;
import com.tydic.dyc.pro.egc.po.UocSaleOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocShipInspRelPO;
import com.tydic.dyc.pro.egc.repository.insporder.api.DycProOrderInspOrderRepository;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderHandleDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderShipInspRelDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProSaleOrderInspRepositoryImpl
implements DycProOrderInspOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProSaleOrderInspRepositoryImpl.class);
    @Value(value="${egc.es.inspOrder.index}")
    private String inspOrderIndex;
    @Autowired
    private NosqlClient nosqlClient;
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocInspOrderMapMapper uocInspOrderMapMapper;
    @Autowired
    private UocShipInspRelMapper uocShipInspRelMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;

    @Override
    public DycProOrderInspOrderDTO createInspOrderAllInfoAndSyncNosql(DycProOrderInspOrderHandleDTO inspOrderDto, DycProOrderSaleOrderDTO salOrderDetail) {
        Long inspOrderId = Sequence.getInstance().nextId();
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        encodeSerialReqBO.setEncodeRuleCode("InspOrderCode");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        String inspOrderNo = (String)encode.getSerialNoList().get(0);
        UocInspOrderPO addInspOrderPo = new UocInspOrderPO();
        BeanUtils.copyProperties((Object)inspOrderDto, (Object)addInspOrderPo);
        addInspOrderPo.setInspOrderId(inspOrderId);
        addInspOrderPo.setInspOrderNo(inspOrderNo);
        addInspOrderPo.setCreateTime(new Date());
        addInspOrderPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
        addInspOrderPo.setInvoiceTag(DycProOrderRepositoryConstant.InvoiceTag.NOT_INVOICED);
        addInspOrderPo.setInspOrderState("YS_YS_YS");
        this.uocInspOrderMapper.insert((Object)addInspOrderPo);
        if (!CollectionUtils.isEmpty(inspOrderDto.getInspItemList())) {
            ArrayList<UocInspOrderItemPO> addInspOrderItemList = new ArrayList<UocInspOrderItemPO>();
            for (DycProOrderInspOrderItemDTO inspOrderItemDto : inspOrderDto.getInspItemList()) {
                UocInspOrderItemPO addInspOrderItemPo = new UocInspOrderItemPO();
                BeanUtils.copyProperties((Object)inspOrderItemDto, (Object)addInspOrderItemPo);
                addInspOrderItemPo.setInspOrderId(inspOrderId);
                addInspOrderItemPo.setInspOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
                addInspOrderItemPo.setCreateTime(new Date());
                addInspOrderItemPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addInspOrderItemList.add(addInspOrderItemPo);
                inspOrderItemDto.setInspOrderItemId(addInspOrderItemPo.getInspOrderItemId());
            }
            this.uocInspOrderItemMapper.insertBatch(addInspOrderItemList);
        }
        if (!CollectionUtils.isEmpty(inspOrderDto.getInspOrderAccessoryList())) {
            ArrayList<UocOrderAccessoryPO> addInspAccessoryList = new ArrayList<UocOrderAccessoryPO>();
            for (DycProOrderOrderAccessoryDTO orderAccessoryDto : inspOrderDto.getInspOrderAccessoryList()) {
                UocOrderAccessoryPO addInspOrderAccessPo = new UocOrderAccessoryPO();
                BeanUtils.copyProperties((Object)orderAccessoryDto, (Object)addInspOrderAccessPo);
                addInspOrderAccessPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                addInspOrderAccessPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addInspOrderAccessPo.setObjId(inspOrderId);
                addInspOrderAccessPo.setOrderId(inspOrderDto.getSaleOrderId());
                addInspAccessoryList.add(addInspOrderAccessPo);
            }
            this.uocOrderAccessoryMapper.insertBatch(addInspAccessoryList);
        }
        if (!CollectionUtils.isEmpty(inspOrderDto.getInspOrderPicList())) {
            ArrayList<UocOrderAccessoryPO> addInspPicList = new ArrayList<UocOrderAccessoryPO>();
            for (DycProOrderOrderAccessoryDTO orderAccessoryDto : inspOrderDto.getInspOrderPicList()) {
                UocOrderAccessoryPO addInspOrderPicPo = new UocOrderAccessoryPO();
                BeanUtils.copyProperties((Object)orderAccessoryDto, (Object)addInspOrderPicPo);
                addInspOrderPicPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                addInspOrderPicPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addInspOrderPicPo.setObjId(inspOrderId);
                addInspOrderPicPo.setOrderId(inspOrderDto.getSaleOrderId());
                addInspPicList.add(addInspOrderPicPo);
            }
            this.uocOrderAccessoryMapper.insertBatch(addInspPicList);
        }
        if (!CollectionUtils.isEmpty(inspOrderDto.getShipOrderInspRelList())) {
            ArrayList<UocShipInspRelPO> addShipInspRelList = new ArrayList<UocShipInspRelPO>();
            for (DycProOrderShipInspRelDTO shipInspRelDto : inspOrderDto.getShipOrderInspRelList()) {
                UocShipInspRelPO addShipInspRelPo = new UocShipInspRelPO();
                BeanUtils.copyProperties((Object)shipInspRelDto, (Object)addShipInspRelPo);
                addShipInspRelPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                addShipInspRelPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addShipInspRelPo.setInspOrderId(inspOrderId);
                addShipInspRelList.add(addShipInspRelPo);
            }
            this.uocShipInspRelMapper.insertBatch(addShipInspRelList);
        }
        DycProEsIndexMappingInspOrderBO addEsIndexMappingInspOrderBo = new DycProEsIndexMappingInspOrderBO();
        BeanUtils.copyProperties((Object)addInspOrderPo, (Object)addEsIndexMappingInspOrderBo);
        addEsIndexMappingInspOrderBo.setModelSettle(salOrderDetail.getModelSettle());
        addEsIndexMappingInspOrderBo.setSaleOrderNo(salOrderDetail.getSaleOrderNo());
        addEsIndexMappingInspOrderBo.setOrderSource(salOrderDetail.getOrderSource());
        addEsIndexMappingInspOrderBo.setSaleOrderNoExt(salOrderDetail.getSaleOrderNoExt());
        addEsIndexMappingInspOrderBo.setOrderCreateTime(salOrderDetail.getCreateTime());
        addEsIndexMappingInspOrderBo.setOrderCreateOperName(salOrderDetail.getCreateOperName());
        addEsIndexMappingInspOrderBo.setSaleStakeholder((DycProEsIndexMappingSaleStakeholderBO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)salOrderDetail.getSaleStakeholder()), DycProEsIndexMappingSaleStakeholderBO.class));
        if (!CollectionUtils.isEmpty(inspOrderDto.getInspItemList())) {
            BigDecimal allInspTotalSaleFee = BigDecimal.ZERO;
            BigDecimal allInspTotalPurchaseFee = BigDecimal.ZERO;
            List inspItemList = JSONArray.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(inspOrderDto.getInspItemList())).toJavaList(DycProEsIndexMappingInspOrderItemBO.class);
            Map saleOrderItemDTOMap = salOrderDetail.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
            for (DycProEsIndexMappingInspOrderItemBO inspItem : inspItemList) {
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(inspItem.getSaleOrderItemId());
                BeanUtils.copyProperties((Object)saleOrderItemDTO, (Object)inspItem);
                inspItem.setTotalSaleFee(saleOrderItemDTO.getSaleFee());
                inspItem.setTotalPurchaseFee(saleOrderItemDTO.getPurchaseFee());
                BigDecimal inspTotalSaleFee = saleOrderItemDTO.getSalePrice().multiply(inspItem.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal inspTotalPurchaseFee = saleOrderItemDTO.getPurchasePrice().multiply(inspItem.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                inspItem.setInspTotalSaleFee(inspTotalSaleFee);
                inspItem.setInspTotalPurchaseFee(inspTotalPurchaseFee);
                allInspTotalSaleFee = allInspTotalSaleFee.add(inspTotalSaleFee);
                allInspTotalPurchaseFee = allInspTotalPurchaseFee.add(inspTotalPurchaseFee);
            }
            addEsIndexMappingInspOrderBo.setInspItemList(inspItemList);
            addEsIndexMappingInspOrderBo.setInspTotalSaleFee(allInspTotalSaleFee);
            addEsIndexMappingInspOrderBo.setInspTotalPurchaseFee(allInspTotalPurchaseFee);
        }
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.inspOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(inspOrderId));
        nosqlBO.setObject((Object)addEsIndexMappingInspOrderBo);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u9a8c\u6536\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
        DycProOrderInspOrderDTO resultInspOrderDTO = new DycProOrderInspOrderDTO();
        resultInspOrderDTO.setInspOrderNo(inspOrderNo);
        resultInspOrderDTO.setInspOrderId(inspOrderId);
        resultInspOrderDTO.setInspOrderState(addInspOrderPo.getInspOrderState());
        resultInspOrderDTO.setCreateTime(addInspOrderPo.getCreateTime());
        resultInspOrderDTO.setInspOper(addInspOrderPo.getInspOper());
        return resultInspOrderDTO;
    }

    @Override
    public DycProOrderInspOrderDTO queryInspOrderById(DycProOrderInspOrderQryDTO uocInspOrderQryBo) {
        UocInspOrderPO uocInspOrderPO = (UocInspOrderPO)this.uocInspOrderMapper.selectById((Serializable)uocInspOrderQryBo.getInspOrderId());
        return (DycProOrderInspOrderDTO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderPO), DycProOrderInspOrderDTO.class);
    }

    @Override
    public List<DycProOrderInspOrderItemDTO> getListInspOrderItem(DycProOrderInspOrderItemDTO dycProOrderInspOrderItemDTO) {
        UocInspOrderItemPO uocInspOrderItemPO = (UocInspOrderItemPO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)dycProOrderInspOrderItemDTO), UocInspOrderItemPO.class);
        List uocInspOrderItemPoList = this.uocInspOrderItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != uocInspOrderItemPO.getInspOrderId(), UocInspOrderItemPO::getInspOrderId, (Object)uocInspOrderItemPO.getInspOrderId())).eq(null != uocInspOrderItemPO.getOrderId(), UocInspOrderItemPO::getOrderId, (Object)uocInspOrderItemPO.getOrderId())).eq(null != uocInspOrderItemPO.getInspOrderItemId(), UocInspOrderItemPO::getInspOrderItemId, (Object)uocInspOrderItemPO.getInspOrderItemId())).in(!CollectionUtils.isEmpty(dycProOrderInspOrderItemDTO.getInspOrderItemsIdList()), UocInspOrderItemPO::getInspOrderItemId, dycProOrderInspOrderItemDTO.getInspOrderItemsIdList()));
        return com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderItemPoList), DycProOrderInspOrderItemDTO.class);
    }

    @Override
    public RspPage<DycProEsIndexMappingInspOrderBO> queryInspOrderEsPageListByCondition(DycProOrderInspOrderQryDTO qryDTO) {
        NosqlQueryByBuilderReqBO nosqlQueryByBuilderReqBO = new NosqlQueryByBuilderReqBO();
        nosqlQueryByBuilderReqBO.setIndex(this.inspOrderIndex);
        nosqlQueryByBuilderReqBO.setNosqlBuilder(this.getInspOrderNosqlBuilder(qryDTO));
        log.debug("\u9a8c\u6536\u5355es\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)nosqlQueryByBuilderReqBO));
        NosqlQueryByBuilderRsqBO nosqlQueryByBuilderRsqBO = this.nosqlClient.queryByBuilder(nosqlQueryByBuilderReqBO);
        log.debug("\u9a8c\u6536\u5355es\u67e5\u8be2\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)nosqlQueryByBuilderRsqBO));
        if (!"0000".equals(nosqlQueryByBuilderRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u5206\u9875\u67e5\u8be2\u9a8c\u6536\u5355es\u6570\u636e\u5f02\u5e38: " + nosqlQueryByBuilderRsqBO.getRespDesc());
        }
        RspPage rspBO = new RspPage();
        rspBO.setPageNo(nosqlQueryByBuilderRsqBO.getPageNo().intValue());
        rspBO.setTotal(nosqlQueryByBuilderRsqBO.getTotal().intValue());
        rspBO.setRecordsTotal(nosqlQueryByBuilderRsqBO.getRecordsTotal().intValue());
        rspBO.setRows(com.alibaba.fastjson.JSON.parseArray((String)nosqlQueryByBuilderRsqBO.getDocumentStr(), DycProEsIndexMappingInspOrderBO.class));
        for (DycProEsIndexMappingInspOrderBO inspOrder : rspBO.getRows()) {
            if (CollectionUtils.isEmpty((Collection)inspOrder.getInspItemList())) continue;
            for (DycProEsIndexMappingInspOrderItemBO inspItem : inspOrder.getInspItemList()) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inspItem.getUnitDigit())) continue;
                if (null != inspItem.getPurchaseCount()) {
                    inspItem.setPurchaseCount(inspItem.getPurchaseCount().setScale(Integer.parseInt(inspItem.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != inspItem.getInspCount()) {
                    inspItem.setInspCount(inspItem.getInspCount().setScale(Integer.parseInt(inspItem.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != inspItem.getSalePrice()) {
                    inspItem.setSalePrice(inspItem.getSalePrice().setScale(2, RoundingMode.HALF_UP));
                }
                if (null == inspItem.getPurchasePrice()) continue;
                inspItem.setPurchasePrice(inspItem.getPurchasePrice().setScale(2, RoundingMode.HALF_UP));
            }
        }
        return rspBO;
    }

    @Override
    public DycProOrderInspOrderDTO getInspOrderMain(DycProOrderInspOrderQryDTO uocInspOrderQryBo) {
        UocInspOrderPO uocInspOrderPo = new UocInspOrderPO();
        uocInspOrderPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
        uocInspOrderPo = (UocInspOrderPO)this.uocInspOrderMapper.selectById((Serializable)uocInspOrderPo.getInspOrderId());
        DycProOrderInspOrderDTO uocInspOrderDo = (DycProOrderInspOrderDTO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderPo), DycProOrderInspOrderDTO.class);
        if (null != uocInspOrderPo) {
            UocInspOrderMapPO uocInspOrderMapPo = new UocInspOrderMapPO();
            uocInspOrderMapPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List uocInspOrderMapPoList = this.uocInspOrderMapMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UocInspOrderMapPO::getInspOrderId, (Object)uocInspOrderQryBo.getInspOrderId()));
            UocShipInspRelPO uocShipInspRelPo = new UocShipInspRelPO();
            uocShipInspRelPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List uocShipInspRelPoList = this.uocShipInspRelMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UocShipInspRelPO::getInspOrderId, (Object)uocInspOrderQryBo.getInspOrderId()));
            UocOrderAccessoryPO uocOrderAccessoryPo = new UocOrderAccessoryPO();
            uocOrderAccessoryPo.setOrderId(uocInspOrderQryBo.getOrderId());
            uocOrderAccessoryPo.setObjId(uocInspOrderQryBo.getInspOrderId());
            List list = this.uocOrderAccessoryMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UocOrderAccessoryPO::getObjId, (Object)uocInspOrderQryBo.getInspOrderId())).eq(UocOrderAccessoryPO::getOrderId, (Object)uocInspOrderQryBo.getOrderId()));
        }
        return uocInspOrderDo;
    }

    @Override
    public void updateInspOrderById(DycProOrderInspOrderDTO dycProOrderInspOrderDTO) {
        UocInspOrderPO uocInspOrderPO = (UocInspOrderPO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)dycProOrderInspOrderDTO), UocInspOrderPO.class);
        this.uocInspOrderMapper.updateById((Object)uocInspOrderPO);
        DycProEsIndexMappingInspOrderBO indexMappingInspOrderBO = new DycProEsIndexMappingInspOrderBO();
        BeanUtils.copyProperties((Object)uocInspOrderPO, (Object)indexMappingInspOrderBO);
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.inspOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(dycProOrderInspOrderDTO.getInspOrderId()));
        nosqlBO.setObject((Object)indexMappingInspOrderBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u66f4\u65b0\u552e\u540e\u5355\u540c\u6b65nosql\u5f02\u5e38: " + nosqlUpdateSingleRsqBO.getRespCode());
        }
    }

    @Override
    public List<DycProOrderInspOrderItemDTO> queryInspOrderItemList(DycProOrderInspOrderItemDTO inspOrderItemDTO) {
        List uocInspOrderItemPOList = this.uocInspOrderItemMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(inspOrderItemDTO.getInspOrderId() != null, UocInspOrderItemPO::getInspOrderId, (Object)inspOrderItemDTO.getInspOrderId()));
        if (CollectionUtils.isEmpty((Collection)uocInspOrderItemPOList)) {
            return Collections.emptyList();
        }
        List inspOrderItemDtoList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderItemPOList), DycProOrderInspOrderItemDTO.class);
        return inspOrderItemDtoList;
    }

    private NosqlBuilder getInspOrderNosqlBuilder(DycProOrderInspOrderQryDTO qryDTO) {
        NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
        nosqlCreateBuilder.pageNo(Integer.valueOf(qryDTO.getPageNo()));
        nosqlCreateBuilder.pageSize(Integer.valueOf(qryDTO.getPageSize()));
        nosqlCreateBuilder.orderBy("createTime", NosqlSortOrder.DESC);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>(1);
        ArrayList<NosqlQueryBO> nosqlQueryBOList = new ArrayList<NosqlQueryBO>(1);
        NosqlQueryGroupBO queryGroupBO = new NosqlQueryGroupBO();
        queryGroupBO.setNosqlQueryList(nosqlQueryBOList);
        queryGroupBO.setConnetType(NosqlConnetType.AND);
        ArrayList<NosqlQueryGroupBO> queryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        queryGroupBOList.add(queryGroupBO);
        NosqlQueryGroupBO nosqlQueryGroupBO = new NosqlQueryGroupBO(queryGroupBOList, NosqlConnetType.AND);
        nosqlQueryGroupBOList.add(nosqlQueryGroupBO);
        if (null != qryDTO.getInspOrderNo()) {
            NosqlQueryBO inspOrderNo = new NosqlQueryBO("inspOrderNo", qryDTO.getInspOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(inspOrderNo);
        }
        if (StringUtils.hasText((String)qryDTO.getShipOrderNo())) {
            NosqlQueryBO shipOrderNo = new NosqlQueryBO("inspItemList.shipOrderNo", qryDTO.getShipOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(shipOrderNo);
        }
        if (null != qryDTO.getSaleOrderNo()) {
            NosqlQueryBO saleOrderNo = new NosqlQueryBO("saleOrderNo", qryDTO.getSaleOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNo);
        }
        if (null != qryDTO.getSaleOrderNoExt()) {
            NosqlQueryBO saleOrderNoExt = new NosqlQueryBO("saleOrderNoExt", qryDTO.getSaleOrderNoExt(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNoExt);
        }
        NosqlQueryBO saleOrderCreateTime = new NosqlQueryBO("orderCreateTime", qryDTO.getOrderCreateTimeStart(), qryDTO.getOrderCreateTimeEnd());
        nosqlQueryBOList.add(saleOrderCreateTime);
        NosqlQueryBO createTime = new NosqlQueryBO("createTime", qryDTO.getCreateTimeStart(), qryDTO.getCreateTimeEnd());
        nosqlQueryBOList.add(createTime);
        if (StringUtils.hasText((String)qryDTO.getOrderCreateOperName())) {
            NosqlQueryBO saleOrderCreateOperName = new NosqlQueryBO("orderCreateOperName", qryDTO.getOrderCreateOperName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderCreateOperName);
        }
        if (StringUtils.hasText((String)qryDTO.getInspOper())) {
            NosqlQueryBO inspOper = new NosqlQueryBO("inspOper", qryDTO.getInspOper(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(inspOper);
        }
        if (null != qryDTO.getSupId()) {
            NosqlQueryBO supId = new NosqlQueryBO("saleStakeholder.supId", qryDTO.getSupId().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(supId);
        }
        if (null != qryDTO.getPurOrgId()) {
            NosqlQueryBO purOrgId = new NosqlQueryBO("saleStakeholder.purOrgId", qryDTO.getPurOrgId().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purOrgId);
        }
        if (null != qryDTO.getPurCompanyId()) {
            NosqlQueryBO purCompanyId = new NosqlQueryBO("saleStakeholder.purCompanyId", qryDTO.getPurCompanyId().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purCompanyId);
        }
        if (null != qryDTO.getPurUserId()) {
            NosqlQueryBO purUserId = new NosqlQueryBO("saleStakeholder.purUserId", qryDTO.getPurUserId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purUserId);
        }
        if (null != qryDTO.getModelSettle()) {
            NosqlQueryBO modelSettle = new NosqlQueryBO("modelSettle", qryDTO.getModelSettle().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(modelSettle);
        }
        nosqlCreateBuilder.queryGroupList(nosqlQueryGroupBOList);
        return nosqlCreateBuilder.build();
    }

    @Override
    public void updateInspOrderItemBatchById(List<DycProOrderInspOrderItemDTO> inspOrderItemDtoList) {
        List uocInspOrderItemPOList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(inspOrderItemDtoList), UocInspOrderItemPO.class);
        this.uocInspOrderItemMapper.updateBatchByIds((Collection)uocInspOrderItemPOList);
    }

    @Override
    public void updateInspOrderItemBatchByIdsAndSyncNosql(DycProOrderInspOrderDTO reqDTO, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        List uocInspOrderItemPOList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(reqDTO.getInspItemList()), UocInspOrderItemPO.class);
        this.uocInspOrderItemMapper.updateBatchByIds((Collection)uocInspOrderItemPOList);
        if (!CollectionUtils.isEmpty(reqDTO.getInspItemList())) {
            List saleOrderIdList = saleOrderItemList.stream().map(DycProOrderSaleOrderItemDTO::getSaleOrderId).distinct().collect(Collectors.toList());
            List uocSaleOrderItemPOS = this.uocSaleOrderItemMapper.selectList((Wrapper)new LambdaQueryWrapper().in(!CollectionUtils.isEmpty(saleOrderIdList), UocSaleOrderItemPO::getSaleOrderId, saleOrderIdList));
            List saleOrderItemDTOS = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocSaleOrderItemPOS), DycProOrderSaleOrderItemDTO.class);
            Map saleOrderItemDTOMap = saleOrderItemDTOS.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
            for (DycProOrderInspOrderItemDTO inspOrderItemDTO : reqDTO.getInspItemList()) {
                DycProEsIndexMappingInspOrderItemBO inspItem = (DycProEsIndexMappingInspOrderItemBO)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)inspOrderItemDTO), DycProEsIndexMappingInspOrderItemBO.class);
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(inspItem.getSaleOrderItemId());
                inspItem.setTotalSaleFee(saleOrderItemDTO.getSaleFee());
                inspItem.setTotalPurchaseFee(saleOrderItemDTO.getPurchaseFee());
                BigDecimal inspTotalSaleFee = saleOrderItemDTO.getSalePrice().multiply(inspItem.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal inspTotalPurchaseFee = saleOrderItemDTO.getPurchasePrice().multiply(inspItem.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                inspItem.setInspTotalSaleFee(inspTotalSaleFee);
                inspItem.setInspTotalPurchaseFee(inspTotalPurchaseFee);
                NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
                nosqlUpdateArrayFieldReqBO.setIndex(this.inspOrderIndex);
                NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
                ArrayList<NosqlQueryBO> nosqlQueryList = new ArrayList<NosqlQueryBO>();
                NosqlQueryBO nosqlQueryBO = new NosqlQueryBO("inspOrderId", String.valueOf(inspOrderItemDTO.getInspOrderId()), NosqlQueryValueType.ACCURATE);
                nosqlQueryList.add(nosqlQueryBO);
                nosqlCreateBuilder.queryGroup(nosqlQueryList);
                nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
                String arrayFieldName = "inspItemList";
                String idFieldName = "inspOrderItemId";
                String idValue = String.valueOf(inspItem.getInspOrderItemId());
                HashMap<String, BigDecimal> maps = new HashMap<String, BigDecimal>();
                if (null != inspItem.getChngingCount()) {
                    maps.put("chngingCount", inspItem.getChngingCount());
                }
                if (null != inspItem.getInspCount()) {
                    maps.put("inspCount", inspItem.getInspCount());
                }
                if (null != inspItem.getInspTotalPurchaseFee()) {
                    maps.put("inspTotalPurchaseFee", inspItem.getInspTotalPurchaseFee());
                }
                if (null != inspItem.getInspTotalSaleFee()) {
                    maps.put("inspTotalSaleFee", inspItem.getInspTotalSaleFee());
                }
                if (null != inspItem.getTotalSaleFee()) {
                    maps.put("totalSaleFee", inspItem.getTotalSaleFee());
                }
                if (null != inspItem.getTotalPurchaseFee()) {
                    maps.put("totalPurchaseFee", inspItem.getTotalPurchaseFee());
                }
                nosqlUpdateArrayFieldReqBO.setMaps(maps);
                nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
                nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
                nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
                log.debug("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + com.alibaba.fastjson.JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
                NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
                log.debug("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + com.alibaba.fastjson.JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
                if ("0000".equals(nosqlUpdateArrayFieldRsqBO.getRespCode())) continue;
                throw new ZTBusinessException("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO.getRespDesc());
            }
            Map<Long, List<DycProOrderInspOrderItemDTO>> inspMap = reqDTO.getInspItemList().stream().collect(Collectors.groupingBy(DycProOrderInspOrderItemDTO::getInspOrderId));
            for (Long inspOrderId : inspMap.keySet()) {
                UocInspOrderItemPO uocInspOrderItemPO = new UocInspOrderItemPO();
                uocInspOrderItemPO.setInspOrderId(inspOrderId);
                List uocInspOrderItemPOS = this.uocInspOrderItemMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(null != uocInspOrderItemPO.getInspOrderId(), UocInspOrderItemPO::getInspOrderId, (Object)uocInspOrderItemPO.getInspOrderId()));
                List inspOrderItemDTOList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderItemPOS), DycProOrderInspOrderItemDTO.class);
                DycProEsIndexMappingInspOrderBO addEsIndexMappingInspOrderBo = new DycProEsIndexMappingInspOrderBO();
                BigDecimal allInspTotalSaleFee = BigDecimal.ZERO;
                BigDecimal allInspTotalPurchaseFee = BigDecimal.ZERO;
                for (DycProOrderInspOrderItemDTO inspOrderItemDTO : inspOrderItemDTOList) {
                    DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(inspOrderItemDTO.getSaleOrderItemId());
                    BigDecimal inspTotalSaleFee = saleOrderItemDTO.getSalePrice().multiply(inspOrderItemDTO.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal inspTotalPurchaseFee = saleOrderItemDTO.getPurchasePrice().multiply(inspOrderItemDTO.getInspCount()).setScale(2, RoundingMode.HALF_UP);
                    allInspTotalSaleFee = allInspTotalSaleFee.add(inspTotalSaleFee);
                    allInspTotalPurchaseFee = allInspTotalPurchaseFee.add(inspTotalPurchaseFee);
                }
                addEsIndexMappingInspOrderBo.setInspTotalSaleFee(allInspTotalSaleFee);
                addEsIndexMappingInspOrderBo.setInspTotalPurchaseFee(allInspTotalPurchaseFee);
                NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
                nosqlUpdateSingleReqBO.setIndex(this.inspOrderIndex);
                NosqlBO nosqlBO = new NosqlBO();
                nosqlBO.setId(String.valueOf(inspOrderId));
                nosqlBO.setObject((Object)addEsIndexMappingInspOrderBo);
                nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
                NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
                if ("0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) continue;
                throw new ZTBusinessException("\u66f4\u65b0\u9a8c\u6536\u5355\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
            }
        }
    }

    @Override
    public void updateOnlyInspOrderItemBatchByIdsAndSyncNosql(DycProOrderInspOrderDTO reqDTO) {
        List uocInspOrderItemPOList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(reqDTO.getInspItemList()), UocInspOrderItemPO.class);
        this.uocInspOrderItemMapper.updateBatchByIds((Collection)uocInspOrderItemPOList);
        for (DycProOrderInspOrderItemDTO inspOrderItemDTO : reqDTO.getInspItemList()) {
            NosqlQueryBO nosqlQueryBO;
            NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.inspOrderIndex);
            NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
            ArrayList<NosqlQueryBO> nosqlQueryList = new ArrayList<NosqlQueryBO>();
            if (null != reqDTO.getInspOrderId()) {
                nosqlQueryBO = new NosqlQueryBO("inspOrderId", String.valueOf(reqDTO.getInspOrderId()), NosqlQueryValueType.ACCURATE);
                nosqlQueryList.add(nosqlQueryBO);
            } else {
                nosqlQueryBO = new NosqlQueryBO("inspOrderId", String.valueOf(inspOrderItemDTO.getInspOrderId()), NosqlQueryValueType.ACCURATE);
                nosqlQueryList.add(nosqlQueryBO);
            }
            nosqlCreateBuilder.queryGroup(nosqlQueryList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
            String arrayFieldName = "inspItemList";
            String idFieldName = "inspOrderItemId";
            String idValue = String.valueOf(inspOrderItemDTO.getInspOrderItemId());
            HashMap<String, BigDecimal> maps = new HashMap<String, BigDecimal>();
            if (null != inspOrderItemDTO.getChngingCount()) {
                maps.put("chngingCount", inspOrderItemDTO.getChngingCount());
            }
            nosqlUpdateArrayFieldReqBO.setMaps(maps);
            nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
            nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
            nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
            log.debug("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + com.alibaba.fastjson.JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            log.debug("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + com.alibaba.fastjson.JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            if ("0000".equals(nosqlUpdateArrayFieldRsqBO.getRespCode())) continue;
            throw new ZTBusinessException("\u66f4\u65b0\u9a8c\u6536\u5355\u9a8c\u6536\u660e\u7ec6\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO.getRespDesc());
        }
    }

    @Override
    public DycProOrderInspOrderDTO queryInspOrderAllInfoById(DycProOrderInspOrderDTO reqInspOrderDTO) {
        UocInspOrderPO uocInspOrderPO = (UocInspOrderPO)this.uocInspOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != reqInspOrderDTO.getInspOrderId(), UocInspOrderPO::getInspOrderId, (Object)reqInspOrderDTO.getInspOrderId()));
        if (null != uocInspOrderPO) {
            DycProOrderInspOrderDTO inspOrderDTO = new DycProOrderInspOrderDTO();
            BeanUtils.copyProperties((Object)uocInspOrderPO, (Object)inspOrderDTO);
            List uocInspOrderItemPOList = this.uocInspOrderItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != reqInspOrderDTO.getInspOrderId(), UocInspOrderItemPO::getInspOrderId, (Object)reqInspOrderDTO.getInspOrderId()));
            if (!CollectionUtils.isEmpty((Collection)uocInspOrderItemPOList)) {
                List inspOrderItemDTOList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)uocInspOrderItemPOList)).toJavaList(DycProOrderInspOrderItemDTO.class);
                inspOrderDTO.setInspItemList(inspOrderItemDTOList);
            }
            return inspOrderDTO;
        }
        return null;
    }

    @Override
    public DycProOrderInspOrderDTO queryInspOrderOneByCondition(DycProOrderInspOrderDTO reqDto) {
        UocInspOrderPO uocInspOrderPO = (UocInspOrderPO)this.uocInspOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getInspOrderId(), UocInspOrderPO::getInspOrderId, (Object)reqDto.getInspOrderId()));
        if (null != uocInspOrderPO) {
            DycProOrderInspOrderDTO inspOrderDTO = new DycProOrderInspOrderDTO();
            BeanUtils.copyProperties((Object)uocInspOrderPO, (Object)inspOrderDTO);
            return inspOrderDTO;
        }
        return null;
    }
}

