/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.repository.shiporder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.ohaotian.plugin.nosql.impl.NosqlCreateBuilder;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSaleStakeholderBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingShipOrderBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingShipOrderItemBO;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.dao.UocOrdLogisticsRelaMapper;
import com.tydic.dyc.pro.egc.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.pro.egc.dao.UocOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleStakeholderMapper;
import com.tydic.dyc.pro.egc.dao.UocShipItemMapMapper;
import com.tydic.dyc.pro.egc.dao.UocShipOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocShipOrderMapMapper;
import com.tydic.dyc.pro.egc.dao.UocShipOrderMapper;
import com.tydic.dyc.pro.egc.po.UocOrdLogisticsRelaPO;
import com.tydic.dyc.pro.egc.po.UocOrderAccessoryPO;
import com.tydic.dyc.pro.egc.po.UocSaleOrderPO;
import com.tydic.dyc.pro.egc.po.UocSaleStakeholderPO;
import com.tydic.dyc.pro.egc.po.UocShipOrderItemPO;
import com.tydic.dyc.pro.egc.po.UocShipOrderMapPO;
import com.tydic.dyc.pro.egc.po.UocShipOrderPO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProOrderShipOrderRepositoryImpl
implements DycProOrderShipOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderShipOrderRepositoryImpl.class);
    @Value(value="${egc.es.shipOrder.index}")
    private String shipOrderIndex;
    @Autowired
    private NosqlClient nosqlClient;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private UocShipOrderMapMapper uocShipOrderMapMapper;
    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocShipItemMapMapper uocShipItemMapMapper;
    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;
    @Autowired
    private UocOrderMapper uocOrderMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;

    @Override
    public DycProOrderShipOrderDTO getShipOrderById(DycProOrderShipOrderQryDTO uocShipOrderQryDTO) {
        DycProOrderShipOrderDTO DycProOrderShipOrderDTO2 = new DycProOrderShipOrderDTO();
        UocShipOrderPO uocShipOrderPo = (UocShipOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderQryDTO), UocShipOrderPO.class);
        if (null == (uocShipOrderPo = (UocShipOrderPO)this.uocShipOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(null != uocShipOrderPo.getShipOrderId(), UocShipOrderPO::getShipOrderId, (Object)uocShipOrderPo.getShipOrderId())).eq(null != uocShipOrderPo.getOrderId(), UocShipOrderPO::getOrderId, (Object)uocShipOrderPo.getShipOrderId())))) {
            return null;
        }
        DycProOrderShipOrderDTO2 = (DycProOrderShipOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderPo), DycProOrderShipOrderDTO.class);
        UocShipOrderMapPO uocShipOrderMapPo = new UocShipOrderMapPO();
        uocShipOrderMapPo.setShipOrderId(uocShipOrderQryDTO.getShipOrderId());
        List list = this.uocShipOrderMapMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(uocShipOrderMapPo.getShipOrderId() != null, UocShipOrderMapPO::getShipOrderId, (Object)uocShipOrderMapPo.getShipOrderId()));
        return DycProOrderShipOrderDTO2;
    }

    @Override
    public DycProOrderShipOrderDTO queryShipOrderOneByCondition(DycProOrderShipOrderDTO shipOrderDto) {
        UocShipOrderPO uocShipOrderPO = (UocShipOrderPO)this.uocShipOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != shipOrderDto.getShipOrderId(), UocShipOrderPO::getShipOrderId, (Object)shipOrderDto.getShipOrderId())).eq(null != shipOrderDto.getOrderId(), UocShipOrderPO::getOrderId, (Object)shipOrderDto.getOrderId()));
        if (null != uocShipOrderPO) {
            DycProOrderShipOrderQryDTO dycProOrderShipOrderDTO = new DycProOrderShipOrderQryDTO();
            BeanUtils.copyProperties((Object)uocShipOrderPO, (Object)dycProOrderShipOrderDTO);
            return dycProOrderShipOrderDTO;
        }
        return null;
    }

    @Override
    public RspPage<DycProEsIndexMappingShipOrderBO> queryShipOrderEsPageListByCondition(DycProOrderShipOrderQryDTO qryDTO) {
        NosqlQueryByBuilderReqBO nosqlQueryByBuilderReqBO = new NosqlQueryByBuilderReqBO();
        nosqlQueryByBuilderReqBO.setIndex(this.shipOrderIndex);
        nosqlQueryByBuilderReqBO.setNosqlBuilder(this.getShipOrderNosqlBuilder(qryDTO));
        NosqlQueryByBuilderRsqBO nosqlQueryByBuilderRsqBO = this.nosqlClient.queryByBuilder(nosqlQueryByBuilderReqBO);
        if (!"0000".equals(nosqlQueryByBuilderRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u5206\u9875\u67e5\u8be2\u53d1\u8d27\u5355es\u6570\u636e\u5f02\u5e38: " + nosqlQueryByBuilderRsqBO.getRespDesc());
        }
        RspPage rspBO = new RspPage();
        rspBO.setPageNo(nosqlQueryByBuilderRsqBO.getPageNo().intValue());
        rspBO.setTotal(nosqlQueryByBuilderRsqBO.getTotal().intValue());
        rspBO.setRecordsTotal(nosqlQueryByBuilderRsqBO.getRecordsTotal().intValue());
        rspBO.setRows(JSON.parseArray((String)nosqlQueryByBuilderRsqBO.getDocumentStr(), DycProEsIndexMappingShipOrderBO.class));
        for (DycProEsIndexMappingShipOrderBO shipOrder : rspBO.getRows()) {
            if (CollectionUtils.isEmpty((Collection)shipOrder.getShipItemList())) continue;
            for (DycProEsIndexMappingShipOrderItemBO shipItem : shipOrder.getShipItemList()) {
                if (!StringUtils.isNotBlank((CharSequence)shipItem.getUnitDigit())) continue;
                if (null != shipItem.getPurchaseCount()) {
                    shipItem.setPurchaseCount(shipItem.getPurchaseCount().setScale(Integer.parseInt(shipItem.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipItem.getAfterServingCount()) {
                    shipItem.setAfterServingCount(shipItem.getAfterServingCount().setScale(Integer.parseInt(shipItem.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipItem.getSendCount()) {
                    shipItem.setSendCount(shipItem.getSendCount().setScale(Integer.parseInt(shipItem.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipItem.getSalePrice()) {
                    shipItem.setSalePrice(shipItem.getSalePrice().setScale(2, RoundingMode.HALF_UP));
                }
                if (null == shipItem.getPurchasePrice()) continue;
                shipItem.setPurchasePrice(shipItem.getPurchasePrice().setScale(2, RoundingMode.HALF_UP));
            }
        }
        return rspBO;
    }

    @Override
    public DycProOrderShipOrderDTO queryListShipOrder(DycProOrderShipOrderItemQryDTO dycProOrderShipOrderItemQryDTO) {
        DycProOrderShipOrderDTO dycProOrderShipOrderDTO = new DycProOrderShipOrderDTO();
        UocShipOrderPO uocShipOrderPo = (UocShipOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderShipOrderItemQryDTO), UocShipOrderPO.class);
        List uocShipOrderPOList = this.uocShipOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocShipOrderPo.getShipOrderId() != null, UocShipOrderPO::getShipOrderId, (Object)uocShipOrderPo.getShipOrderId())).eq(uocShipOrderPo.getOrderId() != null, UocShipOrderPO::getOrderId, (Object)uocShipOrderPo.getOrderId()));
        if (ObjectUtil.isNotEmpty((Object)uocShipOrderPOList)) {
            dycProOrderShipOrderDTO = (DycProOrderShipOrderDTO)JSON.parseObject((String)JSON.toJSONString(uocShipOrderPOList.get(0)), DycProOrderShipOrderDTO.class);
        }
        return dycProOrderShipOrderDTO;
    }

    @Override
    public List<DycProOrderShipOrderItemDTO> queryShipOrderItemByCondition(DycProOrderShipOrderItemQryDTO reqDto) {
        List uocShipOrderItemPOList = this.uocShipOrderItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != reqDto.getShipOrderId(), UocShipOrderItemPO::getShipOrderId, (Object)reqDto.getShipOrderId())).eq(null != reqDto.getOrderId(), UocShipOrderItemPO::getOrderId, (Object)reqDto.getOrderId())).in(!CollectionUtils.isEmpty(reqDto.getShipOrderIdList()), UocShipOrderItemPO::getShipOrderId, reqDto.getShipOrderIdList()));
        if (CollectionUtils.isEmpty((Collection)uocShipOrderItemPOList)) {
            return Collections.emptyList();
        }
        List shipOrderItemDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)uocShipOrderItemPOList)).toJavaList(DycProOrderShipOrderItemDTO.class);
        return shipOrderItemDTOList;
    }

    @Override
    public void modifyShipOrderItemReturningCount(DycProOrderShipOrderItemDTO uocShipOrderItem) {
        UocShipOrderItemPO uocShipOrderItemPO = (UocShipOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderItem), UocShipOrderItemPO.class);
        this.uocShipOrderItemMapper.update((Object)uocShipOrderItemPO, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UocShipOrderItemPO::getShipOrderItemId, (Object)uocShipOrderItemPO.getShipOrderItemId())).eq(UocShipOrderItemPO::getOrderId, (Object)uocShipOrderItemPO.getOrderId()));
    }

    @Override
    public void modifyShipOrderItemAfterServingCount(DycProOrderShipOrderItemDTO uocShipOrderItem) {
        UocShipOrderItemPO uocShipOrderItemPO = (UocShipOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderItem), UocShipOrderItemPO.class);
        this.uocShipOrderItemMapper.update((Object)uocShipOrderItemPO, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(null != uocShipOrderItemPO.getShipOrderItemId(), UocShipOrderItemPO::getShipOrderItemId, (Object)uocShipOrderItemPO.getShipOrderItemId())).eq(null != uocShipOrderItemPO.getOrderId(), UocShipOrderItemPO::getOrderId, (Object)uocShipOrderItemPO.getOrderId()));
    }

    @Override
    public void updateShipOrderItemBatchByIdsAndSyncNosql(DycProOrderShipOrderDTO reqDto) {
        List updateShipOrderItemPoList = JSONArray.parseArray((String)JSON.toJSONString(reqDto.getShipItemList())).toJavaList(UocShipOrderItemPO.class);
        this.uocShipOrderItemMapper.updateBatchByIds((Collection)updateShipOrderItemPoList);
        for (DycProOrderShipOrderItemDTO uocShipOrderItemDTO : reqDto.getShipItemList()) {
            if (null == uocShipOrderItemDTO.getAfterServingCount() && null == uocShipOrderItemDTO.getReturnCount()) continue;
            NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.shipOrderIndex);
            NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
            ArrayList<NosqlQueryBO> nosqlQueryList = new ArrayList<NosqlQueryBO>();
            NosqlQueryBO nosqlQueryBO = new NosqlQueryBO("shipOrderId", String.valueOf(reqDto.getShipOrderId()), NosqlQueryValueType.ACCURATE);
            nosqlQueryList.add(nosqlQueryBO);
            nosqlCreateBuilder.queryGroup(nosqlQueryList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
            String arrayFieldName = "shipItemList";
            String idFieldName = "shipOrderItemId";
            String idValue = String.valueOf(uocShipOrderItemDTO.getShipOrderItemId());
            HashMap<String, BigDecimal> maps = new HashMap<String, BigDecimal>();
            if (null != uocShipOrderItemDTO.getAfterServingCount()) {
                maps.put("afterServingCount", uocShipOrderItemDTO.getAfterServingCount());
            }
            if (null != uocShipOrderItemDTO.getReturnCount()) {
                maps.put("returnCount", uocShipOrderItemDTO.getReturnCount());
            }
            nosqlUpdateArrayFieldReqBO.setMaps(maps);
            nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
            nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
            nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
            log.debug("\u66f4\u65b0\u53d1\u8d27\u5355\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            log.debug("\u66f4\u65b0\u53d1\u8d27\u5355\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            if ("0000".equals(nosqlUpdateArrayFieldRsqBO.getRespCode())) continue;
            throw new ZTBusinessException("\u66f4\u65b0\u53d1\u8d27\u5355\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO.getRespDesc());
        }
    }

    @Override
    public List<DycProOrderShipOrderDTO> getListShipOrder(DycProOrderShipOrderQryDTO qryDTO) {
        UocShipOrderPO uocShipOrderPO = (UocShipOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), UocShipOrderPO.class);
        List uocShipOrderPOS = this.uocShipOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery((Object)uocShipOrderPO));
        if (!CollectionUtils.isEmpty((Collection)uocShipOrderPOS)) {
            return JSON.parseArray((String)JSON.toJSONString((Object)uocShipOrderPOS), DycProOrderShipOrderDTO.class);
        }
        return new ArrayList<DycProOrderShipOrderDTO>();
    }

    @Override
    public List<DycProOrderShipOrderDTO> queryShipOrderByCondition(DycProOrderShipOrderQryDTO qryDTO) {
        List uocShipOrderPoList = this.uocShipOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != qryDTO.getSaleOrderId(), UocShipOrderPO::getSaleOrderId, (Object)qryDTO.getSaleOrderId()));
        if (CollectionUtils.isEmpty((Collection)uocShipOrderPoList)) {
            return Collections.emptyList();
        }
        List shipOrderDtoList = JSONArray.parseArray((String)JSON.toJSONString((Object)uocShipOrderPoList)).toJavaList(DycProOrderShipOrderDTO.class);
        return shipOrderDtoList;
    }

    @Override
    public void updateShipOrderItem(List<DycProOrderShipOrderItemDTO> dycProOrderShipOrderItemDTOList) {
        for (DycProOrderShipOrderItemDTO shipOrderItemDTO : dycProOrderShipOrderItemDTOList) {
            this.uocShipOrderItemMapper.updateById(JSON.parseObject((String)JSON.toJSONString((Object)shipOrderItemDTO), UocShipOrderItemPO.class));
        }
    }

    @Override
    public void updateShipOrderAndSysnNoSql(DycProOrderShipOrderDTO uocShipOrderDTO, Boolean syncNosql) {
        this.uocShipOrderMapper.updateById(JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderDTO), UocShipOrderPO.class));
        if (syncNosql.booleanValue()) {
            DycProEsIndexMappingShipOrderBO updateDycProEsIndexMappingShipOrderBO = new DycProEsIndexMappingShipOrderBO();
            updateDycProEsIndexMappingShipOrderBO.setShipOrderState(uocShipOrderDTO.getShipOrderState());
            updateDycProEsIndexMappingShipOrderBO.setArriveTime(uocShipOrderDTO.getArriveTime());
            NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
            nosqlUpdateSingleReqBO.setIndex(this.shipOrderIndex);
            NosqlBO nosqlBO = new NosqlBO();
            nosqlBO.setId(String.valueOf(uocShipOrderDTO.getShipOrderId()));
            nosqlBO.setObject((Object)updateDycProEsIndexMappingShipOrderBO);
            nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
            NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
            if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
                throw new ZTBusinessException("\u66f4\u65b0\u53d1\u8d27\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
            }
        }
    }

    @Override
    public void updateShipOrderItemBatchByIds(List<DycProOrderShipOrderItemDTO> shipOrderItemDtoList) {
        List updateShipOrderItemList = JSONArray.parseArray((String)JSON.toJSONString(shipOrderItemDtoList)).toJavaList(UocShipOrderItemPO.class);
        this.uocShipOrderItemMapper.updateBatchByIds((Collection)updateShipOrderItemList);
    }

    @Override
    public void updateShipOrderBatchByIdsAndSyncNosql(List<DycProOrderShipOrderDTO> shipOrderDtoList) {
        List updateShipOrderList = JSONArray.parseArray((String)JSON.toJSONString(shipOrderDtoList)).toJavaList(UocShipOrderPO.class);
        this.uocShipOrderMapper.updateBatchByIds((Collection)updateShipOrderList);
        for (DycProOrderShipOrderDTO shipOrderDto : shipOrderDtoList) {
            NosqlUpdateSingleReqBO updateNosqlReqBo = new NosqlUpdateSingleReqBO();
            updateNosqlReqBo.setIndex(this.shipOrderIndex);
            NosqlBO nosqlBO = new NosqlBO();
            DycProEsIndexMappingShipOrderBO updateShipOrderEsBo = new DycProEsIndexMappingShipOrderBO();
            BeanUtils.copyProperties((Object)shipOrderDto, (Object)updateShipOrderEsBo);
            nosqlBO.setId(String.valueOf(shipOrderDto.getShipOrderId()));
            nosqlBO.setObject((Object)updateShipOrderEsBo);
            updateNosqlReqBo.setNosqlBO(nosqlBO);
            NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(updateNosqlReqBo);
            if ("0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) continue;
            throw new ZTBusinessException("\u66f4\u65b0\u53d1\u8d27\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public DycProOrderShipOrderDTO queryShipOrderAllInfoById(DycProOrderShipOrderQryDTO reqDTO) {
        UocShipOrderPO uocShipOrderPO = (UocShipOrderPO)this.uocShipOrderMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(null != reqDTO.getShipOrderId(), UocShipOrderPO::getShipOrderId, (Object)reqDTO.getShipOrderId()));
        if (null != uocShipOrderPO) {
            UocSaleOrderPO uocSaleOrderPO;
            DycProOrderShipOrderDTO shipOrderDTO = new DycProOrderShipOrderDTO();
            BeanUtils.copyProperties((Object)uocShipOrderPO, (Object)shipOrderDTO);
            List uocShipOrderItemPOList = this.uocShipOrderItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(null != uocShipOrderPO.getShipOrderId(), UocShipOrderItemPO::getShipOrderId, (Object)uocShipOrderPO.getShipOrderId())).eq(null != uocShipOrderPO.getOrderId(), UocShipOrderItemPO::getOrderId, (Object)uocShipOrderPO.getOrderId())).in(!CollectionUtils.isEmpty(reqDTO.getShipOrderItemIdList()), UocShipOrderItemPO::getShipOrderItemId, reqDTO.getShipOrderItemIdList()));
            if (!CollectionUtils.isEmpty((Collection)uocShipOrderItemPOList)) {
                List shipOrderItemDtoList = JSONArray.parseArray((String)JSON.toJSONString((Object)uocShipOrderItemPOList), DycProOrderShipOrderItemDTO.class);
                shipOrderDTO.setShipItemList(shipOrderItemDtoList);
            }
            if (null != (uocSaleOrderPO = (UocSaleOrderPO)this.uocSaleOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != uocShipOrderPO.getSaleOrderId(), UocSaleOrderPO::getSaleOrderId, (Object)uocShipOrderPO.getSaleOrderId())))) {
                UocOrdLogisticsRelaPO uocOrdLogisticsRelaPO;
                UocSaleStakeholderPO uocSaleStakeholderPO = (UocSaleStakeholderPO)this.uocSaleStakeholderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != uocSaleOrderPO.getStakeholderId(), UocSaleStakeholderPO::getStakeholderId, (Object)uocSaleOrderPO.getStakeholderId()));
                if (null != uocSaleStakeholderPO) {
                    DycProOrderSaleStakeholderDTO saleStakeholder = new DycProOrderSaleStakeholderDTO();
                    BeanUtils.copyProperties((Object)uocSaleStakeholderPO, (Object)saleStakeholder);
                    shipOrderDTO.setSaleStakeholder(saleStakeholder);
                }
                if (null != (uocOrdLogisticsRelaPO = (UocOrdLogisticsRelaPO)this.uocOrdLogisticsRelaMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(uocSaleOrderPO.getContactId() != null, UocOrdLogisticsRelaPO::getContactId, (Object)uocSaleOrderPO.getContactId())).eq(uocSaleOrderPO.getOrderId() != null, UocOrdLogisticsRelaPO::getOrderId, (Object)uocSaleOrderPO.getOrderId())))) {
                    DycProOrderOrdLogisticsRelaDTO ordLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
                    BeanUtils.copyProperties((Object)uocOrdLogisticsRelaPO, (Object)ordLogisticsRelaDTO);
                    shipOrderDTO.setDeliveryAddress(ordLogisticsRelaDTO);
                }
            }
            return shipOrderDTO;
        }
        return null;
    }

    @Override
    public void modifyItemRefuseCountConfirm(DycProOrderShipOrderItemDTO dycProOrderShipOrderItemDTO) {
        UocShipOrderItemPO uocShipOrderItemPO = (UocShipOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderShipOrderItemDTO), UocShipOrderItemPO.class);
        this.uocShipOrderItemMapper.update((Object)uocShipOrderItemPO, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(!CollectionUtils.isEmpty(dycProOrderShipOrderItemDTO.getShipOrderItemIdList()), UocShipOrderItemPO::getShipOrderItemId, dycProOrderShipOrderItemDTO.getShipOrderItemIdList())).in(!CollectionUtils.isEmpty(dycProOrderShipOrderItemDTO.getOrderIdList()), UocShipOrderItemPO::getOrderId, dycProOrderShipOrderItemDTO.getOrderIdList()));
    }

    @Override
    public List<DycProOrderShipOrderItemDTO> getShipOrderItem(DycProOrderShipOrderItemQryDTO dycProOrderShipOrderItemQryDTO) {
        List uocShipOrderItemPOList = this.uocShipOrderItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != dycProOrderShipOrderItemQryDTO.getShipOrderId(), UocShipOrderItemPO::getShipOrderId, (Object)dycProOrderShipOrderItemQryDTO.getShipOrderId())).eq(null != dycProOrderShipOrderItemQryDTO.getOrderId(), UocShipOrderItemPO::getOrderId, (Object)dycProOrderShipOrderItemQryDTO.getOrderId())).in(!CollectionUtils.isEmpty(dycProOrderShipOrderItemQryDTO.getShipOrderItemIdList()), UocShipOrderItemPO::getShipOrderItemId, dycProOrderShipOrderItemQryDTO.getShipOrderItemIdList()));
        if (CollectionUtils.isEmpty((Collection)uocShipOrderItemPOList)) {
            return Collections.emptyList();
        }
        return JSONArray.parseArray((String)JSON.toJSONString((Object)uocShipOrderItemPOList), DycProOrderShipOrderItemDTO.class);
    }

    @Override
    public void modifyStatChngShipStatus(DycProOrderShipOrderDTO dycProOrderShipOrderDTO) {
        UocShipOrderPO uocShipOrderPO = (UocShipOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderShipOrderDTO), UocShipOrderPO.class);
        this.uocShipOrderMapper.update((Object)uocShipOrderPO, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(null != uocShipOrderPO.getShipOrderId(), UocShipOrderPO::getShipOrderId, (Object)uocShipOrderPO.getShipOrderId())).eq(null != uocShipOrderPO.getOrderId(), UocShipOrderPO::getOrderId, (Object)uocShipOrderPO.getOrderId()));
    }

    @Override
    public DycProOrderShipOrderDTO addShipOrderAllInfoAndSyncNosql(DycProOrderShipOrderDTO shipOrderDTO, DycProOrderSaleOrderDTO saleOrderDTO) {
        Long shipOrderId = Sequence.getInstance().nextId();
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        encodeSerialReqBO.setEncodeRuleCode("ShipOrderCode");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        String shipOrderNo = (String)encode.getSerialNoList().get(0);
        UocShipOrderPO addShipOrderPO = (UocShipOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)shipOrderDTO), UocShipOrderPO.class);
        addShipOrderPO.setShipOrderId(shipOrderId);
        addShipOrderPO.setShipOrderNo(shipOrderNo);
        addShipOrderPO.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
        addShipOrderPO.setCreateTime(new Date());
        addShipOrderPO.setShipOrderState("FH_FH_FH");
        this.uocShipOrderMapper.insert((Object)addShipOrderPO);
        ArrayList<UocShipOrderItemPO> addShipOrderItemPoList = null;
        if (!CollectionUtils.isEmpty(shipOrderDTO.getShipItemList())) {
            addShipOrderItemPoList = new ArrayList<UocShipOrderItemPO>();
            for (DycProOrderShipOrderItemDTO dycProOrderShipOrderItemDTO : shipOrderDTO.getShipItemList()) {
                UocShipOrderItemPO addShipOrderItemPo = new UocShipOrderItemPO();
                BeanUtils.copyProperties((Object)dycProOrderShipOrderItemDTO, (Object)addShipOrderItemPo);
                addShipOrderItemPo.setShipOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
                addShipOrderItemPo.setShipOrderId(shipOrderId);
                addShipOrderItemPo.setDelTag(DycProOrderRepositoryConstant.DelTag.NOT_DEL);
                addShipOrderItemPo.setCreateTime(new Date());
                addShipOrderItemPoList.add(addShipOrderItemPo);
            }
            this.uocShipOrderItemMapper.insertBatch(addShipOrderItemPoList);
        }
        if (!CollectionUtils.isEmpty(shipOrderDTO.getShipOrderAccessoryList())) {
            ArrayList<UocOrderAccessoryPO> addShipOrderAccessoryPoList = new ArrayList<UocOrderAccessoryPO>();
            for (DycProOrderOrderAccessoryDTO accessoryDto : shipOrderDTO.getShipOrderAccessoryList()) {
                UocOrderAccessoryPO addShipOrderAccessoryPo = new UocOrderAccessoryPO();
                BeanUtils.copyProperties((Object)accessoryDto, (Object)addShipOrderAccessoryPo);
                addShipOrderAccessoryPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                addShipOrderAccessoryPo.setObjId(shipOrderId);
                addShipOrderAccessoryPo.setOrderId(saleOrderDTO.getSaleOrderId());
                addShipOrderAccessoryPoList.add(addShipOrderAccessoryPo);
            }
            this.uocOrderAccessoryMapper.insertBatch(addShipOrderAccessoryPoList);
        }
        DycProEsIndexMappingShipOrderBO dycProEsIndexMappingShipOrderBO = new DycProEsIndexMappingShipOrderBO();
        BeanUtils.copyProperties((Object)addShipOrderPO, (Object)dycProEsIndexMappingShipOrderBO);
        dycProEsIndexMappingShipOrderBO.setSaleOrderNo(saleOrderDTO.getSaleOrderNo());
        dycProEsIndexMappingShipOrderBO.setSaleOrderNoExt(saleOrderDTO.getSaleOrderNoExt());
        dycProEsIndexMappingShipOrderBO.setOrderCreateTime(saleOrderDTO.getCreateTime());
        dycProEsIndexMappingShipOrderBO.setOrderCreateOperName(saleOrderDTO.getCreateOperName());
        dycProEsIndexMappingShipOrderBO.setOrderSource(saleOrderDTO.getOrderSource());
        dycProEsIndexMappingShipOrderBO.setSaleStakeholder((DycProEsIndexMappingSaleStakeholderBO)JSON.parseObject((String)JSON.toJSONString((Object)saleOrderDTO.getSaleStakeholder()), DycProEsIndexMappingSaleStakeholderBO.class));
        if (!CollectionUtils.isEmpty(addShipOrderItemPoList)) {
            List list = JSONArray.parseArray((String)JSON.toJSONString(addShipOrderItemPoList)).toJavaList(DycProEsIndexMappingShipOrderItemBO.class);
            Map saleOrderItemDTOMap = saleOrderDTO.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
            for (DycProEsIndexMappingShipOrderItemBO shipOrderItemBO : list) {
                BigDecimal sendCount = shipOrderItemBO.getSendCount();
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(shipOrderItemBO.getSaleOrderItemId());
                BeanUtils.copyProperties((Object)saleOrderItemDTO, (Object)shipOrderItemBO);
                shipOrderItemBO.setSendCount(sendCount);
                shipOrderItemBO.setReturnCount(BigDecimal.ZERO);
                shipOrderItemBO.setAfterServingCount(BigDecimal.ZERO);
            }
            dycProEsIndexMappingShipOrderBO.setShipItemList(list);
        }
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.shipOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(shipOrderId));
        nosqlBO.setObject((Object)dycProEsIndexMappingShipOrderBO);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        log.debug("\u53d1\u8d27\u5355\u4fe1\u606f\u65b0\u589ees\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleReqBO));
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        log.debug("\u53d1\u8d27\u5355\u4fe1\u606f\u65b0\u589ees\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleRsqBO));
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u53d1\u8d27\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
        DycProOrderShipOrderQryDTO resultShipOrderDto = new DycProOrderShipOrderQryDTO();
        resultShipOrderDto.setShipOrderId(shipOrderId);
        resultShipOrderDto.setShipOrderNo(shipOrderNo);
        resultShipOrderDto.setOrderId(addShipOrderPO.getOrderId());
        ((DycProOrderShipOrderDTO)resultShipOrderDto).setShipOrderNoExt(addShipOrderPO.getShipOrderNoExt());
        resultShipOrderDto.setShipOrderState(addShipOrderPO.getShipOrderState());
        resultShipOrderDto.setCreateTime(addShipOrderPO.getCreateTime());
        return resultShipOrderDto;
    }

    private void syncShipOrderNosql(DycProOrderShipOrderDTO reqDto) {
        DycProEsIndexMappingShipOrderBO dycProEsIndexMappingShipOrderBO = (DycProEsIndexMappingShipOrderBO)JSON.parseObject((String)JSON.toJSONString((Object)reqDto), DycProEsIndexMappingShipOrderBO.class);
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.shipOrderIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(reqDto.getShipOrderId()));
        nosqlBO.setObject((Object)dycProEsIndexMappingShipOrderBO);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        log.debug("\u65b0\u589e\u53d1\u8d27\u5355\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlAddSingleReqBO));
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u53d1\u8d27\u5355\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
    }

    private NosqlBuilder getShipOrderNosqlBuilder(DycProOrderShipOrderQryDTO qryDTO) {
        NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
        nosqlCreateBuilder.pageNo(Integer.valueOf(qryDTO.getPageNo()));
        nosqlCreateBuilder.pageSize(Integer.valueOf(qryDTO.getPageSize()));
        nosqlCreateBuilder.orderBy("createTime", NosqlSortOrder.DESC);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>(1);
        ArrayList<NosqlQueryBO> nosqlQueryBOList = new ArrayList<NosqlQueryBO>(1);
        NosqlQueryGroupBO queryGroupBO = new NosqlQueryGroupBO();
        queryGroupBO.setNosqlQueryList(nosqlQueryBOList);
        queryGroupBO.setConnetType(NosqlConnetType.AND);
        ArrayList<NosqlQueryGroupBO> queryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        queryGroupBOList.add(queryGroupBO);
        NosqlQueryGroupBO nosqlQueryGroupBO = new NosqlQueryGroupBO(queryGroupBOList, NosqlConnetType.AND);
        nosqlQueryGroupBOList.add(nosqlQueryGroupBO);
        if (null != qryDTO.getShipOrderNo()) {
            NosqlQueryBO shipOrderNo = new NosqlQueryBO("shipOrderNo", qryDTO.getShipOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(shipOrderNo);
        }
        if (null != qryDTO.getShipOrderNoExt()) {
            NosqlQueryBO shipOrderNoExt = new NosqlQueryBO("shipOrderNoExt", qryDTO.getShipOrderNoExt(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(shipOrderNoExt);
        }
        if (!CollectionUtils.isEmpty(qryDTO.getShipOrderStateList())) {
            NosqlQueryBO shipOrderState = new NosqlQueryBO("shipOrderState", qryDTO.getShipOrderStateList(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(shipOrderState);
        }
        if (null != qryDTO.getSaleOrderNo()) {
            NosqlQueryBO saleOrderNo = new NosqlQueryBO("saleOrderNo", qryDTO.getSaleOrderNo(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)qryDTO.getSaleOrderNoExt())) {
            NosqlQueryBO saleOrderNoExt = new NosqlQueryBO("saleOrderNoExt", qryDTO.getSaleOrderNoExt(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderNoExt);
        }
        NosqlQueryBO saleOrderCreateTime = new NosqlQueryBO("orderCreateTime", qryDTO.getOrderCreateTimeStart(), qryDTO.getOrderCreateTimeEnd());
        nosqlQueryBOList.add(saleOrderCreateTime);
        if (null != qryDTO.getOrderCreateOperName()) {
            NosqlQueryBO saleOrderCreateOperName = new NosqlQueryBO("orderCreateOperName", qryDTO.getOrderCreateOperName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(saleOrderCreateOperName);
        }
        if (null != qryDTO.getSaleOrderState()) {
            NosqlQueryBO saleOrderState = new NosqlQueryBO("saleOrderState", qryDTO.getSaleOrderState(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(saleOrderState);
        }
        if (null != qryDTO.getSkuCode()) {
            NosqlQueryBO skuCode = new NosqlQueryBO("shipItemList.skuCode", qryDTO.getSkuCode(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(skuCode);
        }
        if (null != qryDTO.getSkuName()) {
            NosqlQueryBO skuName = new NosqlQueryBO("shipItemList.skuName", qryDTO.getSkuName(), NosqlQueryValueType.WILD_CARD);
            nosqlQueryBOList.add(skuName);
        }
        if (null != qryDTO.getSupId()) {
            NosqlQueryBO supId = new NosqlQueryBO("saleStakeholder.supId", qryDTO.getSupId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(supId);
        }
        if (null != qryDTO.getPurUserId()) {
            NosqlQueryBO purUserId = new NosqlQueryBO("saleStakeholder.purUserId", qryDTO.getPurUserId(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(purUserId);
        }
        nosqlCreateBuilder.queryGroupList(nosqlQueryGroupBOList);
        return nosqlCreateBuilder.build();
    }
}

