/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.repository.budget.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderStateConstants;
import com.tydic.dyc.pro.egc.dao.ZlBudgetFileInfoMapper;
import com.tydic.dyc.pro.egc.dao.ZlBudgetInfoMapper;
import com.tydic.dyc.pro.egc.dao.ZlBudgetUsedRecordMapper;
import com.tydic.dyc.pro.egc.po.DycProOrderBudgetAuditReqPO;
import com.tydic.dyc.pro.egc.po.ZlBudgetFileInfoPO;
import com.tydic.dyc.pro.egc.po.ZlBudgetInfoPO;
import com.tydic.dyc.pro.egc.po.ZlBudgetUsedRecordPO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetAuditListDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetAuditQryDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetFileInfoDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetInfoDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetQryDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DycProOrderBudgetRepositoryImpl
implements DycProOrderBudgetRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderBudgetRepositoryImpl.class);
    @Autowired
    private ZlBudgetInfoMapper zlBudgetInfoMapper;
    @Autowired
    private ZlBudgetFileInfoMapper zlBudgetFileInfoMapper;
    @Autowired
    private ZlBudgetUsedRecordMapper zlBudgetUsedRecordMapper;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    @Override
    public RspPage<DycProOrderBudgetInfoDTO> queryBudgetListPageByCondition(DycProOrderBudgetQryDTO qryDTO) {
        LambdaQueryWrapperX zlBudgetInfoPOLambdaQueryWrapper;
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        Page result = (Page)this.zlBudgetInfoMapper.selectPage((IPage)page, (Wrapper)(zlBudgetInfoPOLambdaQueryWrapper = new LambdaQueryWrapperX().likeIfPresent(ZlBudgetInfoPO::getBudgetName, qryDTO.getBudgetName()).likeIfPresent(ZlBudgetInfoPO::getBudgetCode, qryDTO.getBudgetCode()).likeIfPresent(ZlBudgetInfoPO::getCreateCompanyName, qryDTO.getCreateCompanyName()).eqIfPresent(ZlBudgetInfoPO::getBudgetStatus, (Object)qryDTO.getBudgetStatus()).inIfPresent(ZlBudgetInfoPO::getBudgetStatus, qryDTO.getBudgetStatusList()).eqIfPresent(ZlBudgetInfoPO::getCreateCompanyId, (Object)qryDTO.getCreateCompanyId()).eqIfPresent(ZlBudgetInfoPO::getCreateOrgId, (Object)qryDTO.getCreateOrgId()).orderByDesc(ZlBudgetInfoPO::getCreateTime)));
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProOrderBudgetInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBudgetAllInfo(DycProOrderBudgetInfoDTO budgetInfoDTO) {
        Long budgetId = Sequence.getInstance().nextId();
        budgetInfoDTO.setBudgetId(budgetId);
        String budgetCode = this.generateBudgetCode();
        budgetInfoDTO.setBudgetCode(budgetCode);
        ZlBudgetInfoPO po = new ZlBudgetInfoPO();
        BeanUtils.copyProperties((Object)budgetInfoDTO, (Object)po);
        this.zlBudgetInfoMapper.insert((Object)po);
        List<DycProOrderBudgetFileInfoDTO> fileInfoList = budgetInfoDTO.getBudgetFileInfoList();
        if (!CollectionUtils.isEmpty(fileInfoList)) {
            fileInfoList.forEach(item -> item.setBudgetId(budgetId));
            ArrayList<ZlBudgetFileInfoPO> poList = new ArrayList<ZlBudgetFileInfoPO>();
            for (DycProOrderBudgetFileInfoDTO fileInfo : fileInfoList) {
                ZlBudgetFileInfoPO filePo = new ZlBudgetFileInfoPO();
                BeanUtils.copyProperties((Object)fileInfo, (Object)filePo);
                poList.add(filePo);
            }
            this.zlBudgetFileInfoMapper.insertBatch(poList);
        }
        return budgetId;
    }

    @Override
    public boolean existsByBudgetNameAndCompanyId(String budgetName, Long companyId) {
        Long count = this.zlBudgetInfoMapper.selectCount((Wrapper)new LambdaQueryWrapperX().eq(ZlBudgetInfoPO::getBudgetName, (Object)budgetName).eq(ZlBudgetInfoPO::getCreateCompanyId, (Object)companyId));
        return count != null && count > 0L;
    }

    @Override
    public void deductBudget(DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO) {
        ZlBudgetInfoPO budgetInfo = (ZlBudgetInfoPO)this.zlBudgetInfoMapper.selectById((Serializable)dycProOrderBudgetUsedRecordDTO.getBudgetId());
        if (null == budgetInfo) {
            throw new ZTBusinessException("\u67e5\u8be2\u9884\u7b97\u4fe1\u606f\u672a\u7a7a\uff01");
        }
        BigDecimal dealBudgetSurplusAmount = budgetInfo.getBudgetSurplusAmount().subtract(dycProOrderBudgetUsedRecordDTO.getOccupyAmount());
        if (dealBudgetSurplusAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new ZTBusinessException("\u9884\u7b97\u91d1\u989d\u4e0d\u8db3\uff01");
        }
        BigDecimal dealBudgetUsedAmount = budgetInfo.getBudgetUsedAmount().add(dycProOrderBudgetUsedRecordDTO.getOccupyAmount());
        ZlBudgetInfoPO updateBudgetInfo = new ZlBudgetInfoPO();
        updateBudgetInfo.setBudgetId(dycProOrderBudgetUsedRecordDTO.getBudgetId());
        updateBudgetInfo.setBudgetSurplusAmount(dealBudgetSurplusAmount);
        updateBudgetInfo.setBudgetUsedAmount(dealBudgetUsedAmount);
        this.zlBudgetInfoMapper.updateById((Object)updateBudgetInfo);
        ZlBudgetUsedRecordPO zlBudgetUsedRecordPO = new ZlBudgetUsedRecordPO();
        BeanUtils.copyProperties((Object)dycProOrderBudgetUsedRecordDTO, (Object)zlBudgetUsedRecordPO);
        zlBudgetUsedRecordPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        zlBudgetUsedRecordPO.setOccupyTime(new Date());
        this.zlBudgetUsedRecordMapper.insert((Object)zlBudgetUsedRecordPO);
    }

    @Override
    public int updateBudgetStatus(Long budgetId, Integer budgetStatus) {
        ZlBudgetInfoPO updatePo = new ZlBudgetInfoPO();
        updatePo.setBudgetId(budgetId);
        updatePo.setBudgetStatus(budgetStatus);
        updatePo.setUpdateTime(new Date());
        return this.zlBudgetInfoMapper.updateById((Object)updatePo);
    }

    @Override
    public DycProOrderBudgetInfoDTO queryBudgetDetailById(DycProOrderBudgetInfoDTO budgetInfoDto) {
        ZlBudgetInfoPO zlBudgetInfoPO = (ZlBudgetInfoPO)this.zlBudgetInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != budgetInfoDto.getBudgetId(), ZlBudgetInfoPO::getBudgetId, (Object)budgetInfoDto.getBudgetId()));
        if (null == zlBudgetInfoPO) {
            return null;
        }
        DycProOrderBudgetInfoDTO dto = new DycProOrderBudgetInfoDTO();
        BeanUtils.copyProperties((Object)zlBudgetInfoPO, (Object)dto);
        return dto;
    }

    @Override
    public List<DycProOrderBudgetFileInfoDTO> queryBudgetFileListByBudgetId(Long budgetId) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX().eq(ZlBudgetFileInfoPO::getBudgetId, (Object)budgetId);
        List poList = this.zlBudgetFileInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return null;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)poList), DycProOrderBudgetFileInfoDTO.class);
    }

    @Override
    public void timingUpdateBudgetStatus() {
        List effectiveList;
        Date now = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)now);
        List pendingEffectiveList = this.zlBudgetInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(ZlBudgetInfoPO::getBudgetStatus, (Object)DycProOrderStateConstants.BUDGET_STATUS.PENDING_EFFECTIVE).le(ZlBudgetInfoPO::getEffectiveTime, (Object)now));
        if (!CollectionUtils.isEmpty((Collection)pendingEffectiveList)) {
            pendingEffectiveList.forEach(item -> item.setBudgetStatus(DycProOrderStateConstants.BUDGET_STATUS.EFFECTIVE));
            this.zlBudgetInfoMapper.updateBatchByIds((Collection)pendingEffectiveList);
        }
        if (!CollectionUtils.isEmpty((Collection)(effectiveList = this.zlBudgetInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(ZlBudgetInfoPO::getBudgetStatus, (Object)DycProOrderStateConstants.BUDGET_STATUS.EFFECTIVE).le(ZlBudgetInfoPO::getInvalidTime, (Object)now))))) {
            effectiveList.forEach(item -> item.setBudgetStatus(DycProOrderStateConstants.BUDGET_STATUS.EXPIRED));
            this.zlBudgetInfoMapper.updateBatchByIds((Collection)effectiveList);
        }
    }

    @Override
    public RspPage<DycProOrderBudgetAuditListDTO> queryBudgetAuditListPage(DycProOrderBudgetAuditQryDTO qryDTO) {
        RspPage rsp = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        DycProOrderBudgetAuditReqPO record = new DycProOrderBudgetAuditReqPO();
        BeanUtils.copyProperties((Object)qryDTO, (Object)record);
        Page result = qryDTO.getTabId() != null && qryDTO.getTabId() == 1 ? this.zlBudgetInfoMapper.qryBudgetUnAuditedList(page, record) : this.zlBudgetInfoMapper.qryBudgetAuditedList(page, record);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rsp.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProOrderBudgetAuditListDTO.class));
        }
        rsp.setPageNo((int)result.getCurrent());
        rsp.setTotal((int)result.getPages());
        rsp.setRecordsTotal((int)result.getTotal());
        return rsp;
    }

    private String generateBudgetCode() {
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        encodeSerialReqBO.setEncodeRuleCode("EGC_BUDGET_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        if (encode == null || encode.getSerialNoList() == null || encode.getSerialNoList().isEmpty()) {
            throw new ZTBusinessException("\u9884\u7b97\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return (String)encode.getSerialNoList().get(0);
    }
}

