/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.constants.DycProCommonFlowConstant;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderPublicProcInstDTO;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderPublicProcTaskInstDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.api.DycProOrderOsworkflowService;
import com.tydic.dyc.pro.egc.service.api.DycProOrderTodoNoticeCommonService;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderOsworkflowMsgProcessInfoBO;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderOsworkflowMsgTaskInfoBO;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderTodoNoticeCommonReqBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DycProOrderOsworkflowServiceImpl
implements DycProOrderOsworkflowService {
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderTodoNoticeCommonService dycProOrderTodoNoticeCommonService;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Value(value="${uoc.init.initState:}")
    private String initState;

    @Override
    public void addFlowTasks(DycProOrderOsworkflowMsgProcessInfoBO msgProcessInfoBO) {
        DycProPublicProcInstDTO flowProcInstDto = new DycProPublicProcInstDTO();
        flowProcInstDto.setBusiType(msgProcessInfoBO.getBusiType());
        flowProcInstDto.setProcInstId(msgProcessInfoBO.getProcInstId());
        flowProcInstDto.setCenterCode("UOC");
        flowProcInstDto.setProcName(msgProcessInfoBO.getProcDefName());
        flowProcInstDto.setObjId(Long.valueOf(msgProcessInfoBO.getBusinessObjId()));
        flowProcInstDto.setObjType(msgProcessInfoBO.getBusinessObjCode());
        flowProcInstDto.setProcDefKey(msgProcessInfoBO.getProcDefKey());
        flowProcInstDto.setProcType(msgProcessInfoBO.getProcessType());
        if (!ObjectUtils.isEmpty((Object)msgProcessInfoBO.getApproveUserId())) {
            flowProcInstDto.setCreateUserId(Long.valueOf(msgProcessInfoBO.getApproveUserId()));
        }
        flowProcInstDto.setCreateUserName(msgProcessInfoBO.getApproveUserName());
        if (!ObjectUtils.isEmpty((Object)msgProcessInfoBO.getApproveUserOrgId())) {
            flowProcInstDto.setCreateUserOrgId(Long.valueOf(msgProcessInfoBO.getApproveUserOrgId()));
        }
        flowProcInstDto.setCreateUserOrgName(msgProcessInfoBO.getApproveUserOrgName());
        flowProcInstDto.setCreateUserOrgPath(msgProcessInfoBO.getApproveUserOrgPath());
        if (!ObjectUtils.isEmpty((Object)msgProcessInfoBO.getApproveUserCompanyId())) {
            flowProcInstDto.setCreateUserCompanyId(Long.valueOf(msgProcessInfoBO.getApproveUserCompanyId()));
        }
        flowProcInstDto.setCreateUserCompanyName(msgProcessInfoBO.getApproveUserCompanyName());
        flowProcInstDto.setDataRemark(msgProcessInfoBO.getApproveUserRemark());
        ArrayList<DycProPublicTaskInstDTO> procTaskList = new ArrayList<DycProPublicTaskInstDTO>();
        for (DycProOrderOsworkflowMsgTaskInfoBO msgTaskInfoBO : msgProcessInfoBO.getTaskList()) {
            DycProPublicTaskInstDTO dycProPublicTaskInstDTO = new DycProPublicTaskInstDTO();
            if ("BUSINESS".equals(flowProcInstDto.getProcType())) {
                dycProPublicTaskInstDTO.setTaskInstId(msgTaskInfoBO.getTaskId());
            } else {
                dycProPublicTaskInstDTO.setTaskInstId(String.valueOf(msgTaskInfoBO.getApproveTaskId()));
            }
            dycProPublicTaskInstDTO.setProcInstId(msgProcessInfoBO.getProcInstId());
            dycProPublicTaskInstDTO.setProcDefKey(msgProcessInfoBO.getProcDefKey());
            dycProPublicTaskInstDTO.setProcName(msgProcessInfoBO.getProcDefName());
            dycProPublicTaskInstDTO.setProcType(msgProcessInfoBO.getProcessType());
            dycProPublicTaskInstDTO.setStepCode(msgTaskInfoBO.getStepId());
            dycProPublicTaskInstDTO.setStepName(msgTaskInfoBO.getStepName());
            dycProPublicTaskInstDTO.setObjId(Long.valueOf(msgProcessInfoBO.getBusinessObjId()));
            dycProPublicTaskInstDTO.setObjType(msgProcessInfoBO.getBusinessObjCode());
            dycProPublicTaskInstDTO.setBusiType(msgProcessInfoBO.getBusiType());
            dycProPublicTaskInstDTO.setCenterCode("UOC");
            if ("afterJoin".equals(msgTaskInfoBO.getJoinSignType())) {
                dycProPublicTaskInstDTO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.AFTER_JOIN);
            } else {
                dycProPublicTaskInstDTO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.NORMAL);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgTaskInfoBO.getUserId()})) {
                dycProPublicTaskInstDTO.setTaskUserId(Long.valueOf(msgTaskInfoBO.getUserId()));
            }
            dycProPublicTaskInstDTO.setTaskUserName(msgTaskInfoBO.getUserName());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgTaskInfoBO.getOrgId()})) {
                dycProPublicTaskInstDTO.setTaskUserOrgId(Long.valueOf(msgTaskInfoBO.getOrgId()));
            }
            dycProPublicTaskInstDTO.setTaskUserOrgName(msgTaskInfoBO.getOrgName());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgTaskInfoBO.getCompanyId()})) {
                dycProPublicTaskInstDTO.setTaskUserCompanyId(Long.valueOf(msgTaskInfoBO.getCompanyId()));
            }
            dycProPublicTaskInstDTO.setTaskUserCompanyName(msgTaskInfoBO.getCompanyName());
            procTaskList.add(dycProPublicTaskInstDTO);
        }
        flowProcInstDto.setTaskList(procTaskList);
        this.dycProPublicTaskInstRepository.addFlowTasks(flowProcInstDto);
        if ("BUSINESS".equals(flowProcInstDto.getProcType())) {
            for (DycProPublicTaskInstDTO dycProPublicTaskInstDTO : procTaskList) {
                String state = this.getState(dycProPublicTaskInstDTO);
                this.updateState(state, dycProPublicTaskInstDTO);
            }
        }
        for (DycProOrderOsworkflowMsgTaskInfoBO msgTaskInfoBO : msgProcessInfoBO.getTaskList()) {
            DycProOrderTodoNoticeCommonReqBO dycTodoNoticeCommonReqBO = new DycProOrderTodoNoticeCommonReqBO();
            dycTodoNoticeCommonReqBO.setCenter("UOC");
            dycTodoNoticeCommonReqBO.setShareId(Long.parseLong(msgProcessInfoBO.getBusinessObjId()));
            dycTodoNoticeCommonReqBO.setObjId(Long.parseLong(msgProcessInfoBO.getBusinessObjId()));
            dycTodoNoticeCommonReqBO.setBusiType(msgProcessInfoBO.getBusiType());
            dycTodoNoticeCommonReqBO.setStepId(msgTaskInfoBO.getStepId());
            ArrayList<Long> auditUserIds = new ArrayList<Long>();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgTaskInfoBO.getUserId()})) {
                auditUserIds.add(Long.valueOf(msgTaskInfoBO.getUserId()));
            }
            dycTodoNoticeCommonReqBO.setAuditUserIds(auditUserIds);
            dycTodoNoticeCommonReqBO.setBatchNo(msgTaskInfoBO.getStepId());
            if ("BUSINESS".equals(flowProcInstDto.getProcType())) {
                dycTodoNoticeCommonReqBO.setTaskId(msgTaskInfoBO.getTaskId());
                dycTodoNoticeCommonReqBO.setObjType("2");
            } else {
                dycTodoNoticeCommonReqBO.setTaskId(msgTaskInfoBO.getApproveTaskId().toString());
                dycTodoNoticeCommonReqBO.setObjType("9");
                DycProOrderPublicProcTaskInstDTO queryPublicProcTaskInstDTO = new DycProOrderPublicProcTaskInstDTO();
                queryPublicProcTaskInstDTO.setObjId(dycTodoNoticeCommonReqBO.getObjId());
                List publicProcTaskInstDTOList = this.dycProOrderApproveRepository.queryPublicProcTaskInstListByCondition(queryPublicProcTaskInstDTO);
                DycProOrderPublicProcInstDTO queryPublicProcInstDTO = new DycProOrderPublicProcInstDTO();
                queryPublicProcInstDTO.setProcInstId(((DycProOrderPublicProcTaskInstDTO)publicProcTaskInstDTOList.get(0)).getProcInstId());
                DycProOrderPublicProcInstDTO publicProcInstDTO = this.dycProOrderApproveRepository.queryPublicProcInstOneByCondition(queryPublicProcInstDTO);
                dycTodoNoticeCommonReqBO.setProcDataId(publicProcInstDTO.getDataId());
            }
            this.dycProOrderTodoNoticeCommonService.dealTodoNotice(dycTodoNoticeCommonReqBO);
        }
    }

    private void updateState(String state, DycProPublicTaskInstDTO dycProPublicTaskInstDTO) {
        if (ObjectUtil.isNotEmpty((Object)state) && "salesOrder".equals(dycProPublicTaskInstDTO.getObjType())) {
            DycProOrderSaleOrderDTO updateSaleDo = new DycProOrderSaleOrderDTO();
            updateSaleDo.setSaleOrderId(dycProPublicTaskInstDTO.getObjId());
            updateSaleDo.setSaleOrderState(state);
            updateSaleDo.setBusiTaskInstId(dycProPublicTaskInstDTO.getTaskInstId());
            updateSaleDo.setBusiProcInstId(dycProPublicTaskInstDTO.getProcInstId());
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleDo, true);
        }
    }

    private String getState(DycProPublicTaskInstDTO dycProPublicTaskInstDTO) {
        String objType = dycProPublicTaskInstDTO.getObjType();
        String tacheCode = dycProPublicTaskInstDTO.getStepCode();
        String[] rules = this.initState.split(",");
        HashMap<String, String> stateMap = new HashMap<String, String>();
        for (String ru : rules) {
            String[] rus = ru.split(":");
            stateMap.put(rus[0], rus[1]);
        }
        String key = objType + "-" + tacheCode;
        System.out.println("key" + key);
        return (String)stateMap.get(key);
    }
}

