/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.cfc.ability.bo.CfcSupplierTemplateBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.api.CfcQrySupplierTemplateListBusiService;
import com.tydic.cfc.busi.bo.CfcQrySupplierTemplateListBusiReqBO;
import com.tydic.cfc.busi.bo.CfcQrySupplierTemplateListBusiRspBO;
import com.tydic.cfc.dao.CfcSupplierTemplateMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CfcQrySupplierTemplateListBusiServiceImpl
implements CfcQrySupplierTemplateListBusiService {
    @Autowired
    private CfcSupplierTemplateMapper cfcSupplierTemplateMapper;
    @Autowired
    private CfcDictionaryBusiService dictionaryAbilityService;

    @Override
    public CfcQrySupplierTemplateListBusiRspBO qrySupplierTemplateList(CfcQrySupplierTemplateListBusiReqBO busiReqBO) {
        CfcQrySupplierTemplateListBusiRspBO rsp = new CfcQrySupplierTemplateListBusiRspBO();
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        List<CfcSupplierTemplateBO> rows = this.cfcSupplierTemplateMapper.getList(busiReqBO, (Page<CfcSupplierTemplateBO>)page);
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        Map<String, String> supplierTemplateTypeStrMap = this.dictionaryAbilityService.queryBypCodeBackMap("CFC_SUPPLIER_TEMPLATE_TYPE");
        Map<String, String> statusStrMap = this.dictionaryAbilityService.queryBypCodeBackMap("CFC_STATUS");
        for (CfcSupplierTemplateBO bo : rows) {
            if (StringUtils.isNotBlank((CharSequence)bo.getSupplierTemplateType())) {
                bo.setSupplierTemplateTypeStr(supplierTemplateTypeStrMap.get(bo.getSupplierTemplateType()));
            }
            if (!StringUtils.isNotBlank((CharSequence)bo.getStatus())) continue;
            bo.setStatusStr(statusStrMap.get(bo.getStatus()));
        }
        rsp.setPageNo(page.getPageNo());
        rsp.setRows(rows);
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setTotal(page.getTotalPages());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f9b\u5e94\u5546\u6a21\u7248\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rsp;
    }
}

