/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.api.CfcEncodedSerialSyncBusiService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.cfc.ability.bo.CfcEncodedSerialSyncBO;
import com.tydic.cfc.ability.bo.CfcEncodedSerialSyncBusiReqBO;
import com.tydic.cfc.ability.bo.CfcEncodedSerialSyncBusiRspBO;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CfcEncodedSerialSyncBusiServiceImpl
implements CfcEncodedSerialSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedSerialSyncBusiServiceImpl.class);
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedSerialMapper encodedSerialMapper;
    @Autowired
    private CfcEncodedSerialGenerateMapper encodedSerialGenerateMapper;

    public CfcEncodedSerialSyncBusiRspBO syncEncodedSerial(CfcEncodedSerialSyncBusiReqBO busiReqBO) {
        CfcEncodedSerialSyncBusiRspBO rspBO = new CfcEncodedSerialSyncBusiRspBO();
        this.syncMethod(busiReqBO);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void syncMethod(CfcEncodedSerialSyncBusiReqBO reqBO) {
        HashMap<String, List> map = new HashMap<String, List>();
        if (reqBO.getSyncBOLIst() != null && reqBO.getSyncBOLIst().size() > 0) {
            for (CfcEncodedSerialSyncBO itemBO : reqBO.getSyncBOLIst()) {
                CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
                cfcEncodedRuleQryDetailAbilityReqBO.setId(itemBO.getId());
                CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
                if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
                    throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) continue;
                CfcEncodedRuleBO cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
                List encodedSerialPOS = (List)map.get(cfcEncodedRuleBO.getEncodedRuleCode());
                if (CollectionUtils.isEmpty((Collection)encodedSerialPOS)) {
                    CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
                    esParam.setCenter(cfcEncodedRuleBO.getCenter());
                    esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
                    esParam.setEffFlag("1");
                    encodedSerialPOS = this.encodedSerialMapper.getList(esParam);
                }
                if (CollectionUtils.isEmpty((Collection)encodedSerialPOS)) continue;
                CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
                BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
                insertPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
                insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
                insertPO.setEffFlag("1");
                insertPO.setEffType(cfcEncodedRuleBO.getEffType());
                insertPO.setEffDate(this.composeEffDate(insertPO));
                insertPO.setRelType(cfcEncodedRuleBO.getRelType());
                insertPO.setRelId(cfcEncodedRuleBO.getRelId());
                int currentValidNum = 0;
                if (!CollectionUtils.isEmpty((Collection)encodedSerialPOS)) {
                    for (CfcEncodedSerialPO itemPO : encodedSerialPOS) {
                        String effDate;
                        int operateFlag = 0;
                        if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                            operateFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                            operateFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if ((effDate = this.composeEffDate(itemPO)) == null || !"".equals(effDate) && !effDate.equals(itemPO.getEffDate())) continue;
                        if ("1".equals(itemBO.getRestartFlag()) && operateFlag > 0) {
                            CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
                            esgParam.setSerialId(itemPO.getId());
                            List esgList = this.encodedSerialGenerateMapper.getList(esgParam);
                            if (!CollectionUtils.isEmpty((Collection)esgList) && esgList.size() == 1) {
                                CfcEncodedSerialGeneratePO encodedSerialGeneratePO = (CfcEncodedSerialGeneratePO)esgList.get(0);
                                encodedSerialGeneratePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                                encodedSerialGeneratePO.setSerialId(insertPO.getId());
                                this.encodedSerialGenerateMapper.insert(encodedSerialGeneratePO);
                            }
                        }
                        ++currentValidNum;
                    }
                }
                if (currentValidNum <= 0) continue;
                int operateFlag = this.encodedSerialMapper.insert(insertPO);
                encodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), encodedSerialPOS);
            }
        }
    }

    private String composeEffDate(CfcEncodedSerialPO encodedSerialPO) {
        if ("none".equals(encodedSerialPO.getEffType())) {
            return "";
        }
        if ("date".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("month".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }
}

