/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.utils.StandardCharsets;
import com.google.common.base.Charsets;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.Connection;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;
import com.vesoft.nebula.graph.VerifyClientVersionReq;
import com.vesoft.nebula.graph.VerifyClientVersionResp;
import com.vesoft.nebula.util.SslUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncConnection
extends Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConnection.class);
    protected TTransport transport = null;
    protected TProtocol protocol = null;
    private GraphService.Client client = null;
    private int timeout = 0;
    private SSLParam sslParam = null;
    private boolean enabledSsl = false;
    private SSLSocketFactory sslSocketFactory = null;

    @Override
    public void open(HostAddress address, int timeout, SSLParam sslParam) throws IOErrorException, ClientServerIncompatibleException {
        try {
            this.serverAddr = address;
            this.timeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
            this.enabledSsl = true;
            this.sslParam = sslParam;
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = sslParam.getSignMode() == SSLParam.SignMode.CA_SIGNED ? SslUtil.getSSLSocketFactoryWithCA((CASignedSSLParam)sslParam) : SslUtil.getSSLSocketFactoryWithoutCA((SelfSignedSSLParam)sslParam);
            }
            this.transport = new TSocket(this.sslSocketFactory.createSocket(address.getHost(), address.getPort()), this.timeout, this.timeout);
            this.protocol = new TCompactProtocol(this.transport);
            this.client = new GraphService.Client(this.protocol);
            VerifyClientVersionResp resp = this.client.verifyClientVersion(new VerifyClientVersionReq());
            if (resp.error_code != ErrorCode.SUCCEEDED) {
                this.client.getInputProtocol().getTransport().close();
                throw new ClientServerIncompatibleException(new String(resp.getError_msg(), Charsets.UTF_8));
            }
        }
        catch (TException | IOException e) {
            this.close();
            throw new IOErrorException(0, e.getMessage());
        }
    }

    @Override
    public void open(HostAddress address, int timeout) throws IOErrorException, ClientServerIncompatibleException {
        try {
            this.serverAddr = address;
            this.timeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
            this.transport = new TSocket(address.getHost(), address.getPort(), this.timeout, this.timeout);
            this.transport.open();
            this.protocol = new TCompactProtocol(this.transport);
            this.client = new GraphService.Client(this.protocol);
            VerifyClientVersionResp resp = this.client.verifyClientVersion(new VerifyClientVersionReq());
            if (resp.error_code != ErrorCode.SUCCEEDED) {
                this.client.getInputProtocol().getTransport().close();
                throw new ClientServerIncompatibleException(new String(resp.getError_msg(), Charsets.UTF_8));
            }
        }
        catch (TException e) {
            throw new IOErrorException(0, e.getMessage());
        }
    }

    @Override
    public void reopen() throws IOErrorException, ClientServerIncompatibleException {
        this.close();
        if (this.enabledSsl) {
            this.open(this.serverAddr, this.timeout, this.sslParam);
        } else {
            this.open(this.serverAddr, this.timeout);
        }
    }

    public AuthResult authenticate(String user, String password) throws AuthFailedException, IOErrorException, ClientServerIncompatibleException {
        try {
            AuthResponse resp = this.client.authenticate(user.getBytes(), password.getBytes());
            if (resp.error_code != ErrorCode.SUCCEEDED) {
                if (resp.error_msg != null) {
                    throw new AuthFailedException(new String(resp.error_msg));
                }
                throw new AuthFailedException("The error_msg is null, maybe the service not set or the response is disorder.");
            }
            return new AuthResult(resp.getSession_id(), resp.getTime_zone_offset_seconds());
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                if (te.getType() == 4) {
                    throw new IOErrorException(2, te.getMessage());
                }
                if (te.getType() == 3 || te.getMessage().contains("Read timed out")) {
                    this.reopen();
                    throw new IOErrorException(4, te.getMessage());
                }
                if (te.getType() == 1) {
                    throw new IOErrorException(5, te.getMessage());
                }
            }
            throw new AuthFailedException(String.format("Authenticate failed: %s", e.getMessage()));
        }
    }

    public ExecutionResponse execute(long sessionID, String stmt) throws IOErrorException {
        return this.executeWithParameter(sessionID, stmt, Collections.EMPTY_MAP);
    }

    public ExecutionResponse executeWithParameter(long sessionID, String stmt, Map<byte[], Value> parameterMap) throws IOErrorException {
        try {
            return this.client.executeWithParameter(sessionID, stmt.getBytes(), parameterMap);
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                if (te.getType() == 4) {
                    throw new IOErrorException(2, te.getMessage());
                }
                if (te.getType() == 1) {
                    throw new IOErrorException(5, te.getMessage());
                }
                if (te.getType() == 3 || te.getMessage().contains("Read timed out")) {
                    try {
                        this.reopen();
                    }
                    catch (ClientServerIncompatibleException ex) {
                        LOGGER.error(ex.getMessage());
                    }
                    throw new IOErrorException(4, te.getMessage());
                }
            }
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public String executeJson(long sessionID, String stmt) throws IOErrorException {
        return this.executeJsonWithParameter(sessionID, stmt, Collections.EMPTY_MAP);
    }

    public String executeJsonWithParameter(long sessionID, String stmt, Map<byte[], Value> parameterMap) throws IOErrorException {
        try {
            byte[] result = this.client.executeJsonWithParameter(sessionID, stmt.getBytes(), parameterMap);
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                if (te.getType() == 4) {
                    throw new IOErrorException(2, te.getMessage());
                }
                if (te.getType() == 1) {
                    throw new IOErrorException(5, te.getMessage());
                }
                if (te.getType() == 3 || te.getMessage().contains("Read timed out")) {
                    try {
                        this.reopen();
                    }
                    catch (ClientServerIncompatibleException ex) {
                        LOGGER.error(ex.getMessage());
                    }
                    throw new IOErrorException(4, te.getMessage());
                }
            }
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public void signout(long sessionId) {
        this.client.signout(sessionId);
    }

    @Override
    public boolean ping() {
        try {
            this.execute(0L, "YIELD 1;");
            return true;
        }
        catch (IOErrorException e) {
            return false;
        }
    }

    @Override
    public boolean ping(long sessionID) {
        try {
            this.execute(sessionID, "YIELD 1;");
            return true;
        }
        catch (IOErrorException e) {
            return false;
        }
    }

    @Override
    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }
}

