/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.DirInfo;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import com.vesoft.nebula.meta.LeaderInfo;
import com.vesoft.nebula.meta.PartitionList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HBReq
implements TBase,
Serializable,
Cloneable,
Comparable<HBReq> {
    private static final TStruct STRUCT_DESC = new TStruct("HBReq");
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 1);
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 2);
    private static final TField CLUSTER_ID_FIELD_DESC = new TField("cluster_id", 10, 3);
    private static final TField LEADER_PART_IDS_FIELD_DESC = new TField("leader_partIds", 13, 4);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 5);
    private static final TField DISK_PARTS_FIELD_DESC = new TField("disk_parts", 13, 6);
    private static final TField DIR_FIELD_DESC = new TField("dir", 12, 7);
    private static final TField VERSION_FIELD_DESC = new TField("version", 11, 8);
    public HostRole role;
    public HostAddr host;
    public long cluster_id;
    public Map<Integer, List<LeaderInfo>> leader_partIds;
    public byte[] git_info_sha;
    public Map<Integer, Map<byte[], PartitionList>> disk_parts;
    public DirInfo dir;
    public byte[] version;
    public static final int ROLE = 1;
    public static final int HOST = 2;
    public static final int CLUSTER_ID = 3;
    public static final int LEADER_PARTIDS = 4;
    public static final int GIT_INFO_SHA = 5;
    public static final int DISK_PARTS = 6;
    public static final int DIR = 7;
    public static final int VERSION = 8;
    private static final int __CLUSTER_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public HBReq() {
    }

    public HBReq(HostRole role, HostAddr host, long cluster_id, byte[] git_info_sha) {
        this();
        this.role = role;
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.git_info_sha = git_info_sha;
    }

    public HBReq(HostRole role, HostAddr host, long cluster_id, Map<Integer, List<LeaderInfo>> leader_partIds, byte[] git_info_sha, Map<Integer, Map<byte[], PartitionList>> disk_parts, DirInfo dir, byte[] version) {
        this();
        this.role = role;
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.leader_partIds = leader_partIds;
        this.git_info_sha = git_info_sha;
        this.disk_parts = disk_parts;
        this.dir = dir;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HBReq(HBReq other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetRole()) {
            this.role = TBaseHelper.deepCopy(other.role);
        }
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        this.cluster_id = TBaseHelper.deepCopy(other.cluster_id);
        if (other.isSetLeader_partIds()) {
            this.leader_partIds = TBaseHelper.deepCopy(other.leader_partIds);
        }
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
        if (other.isSetDisk_parts()) {
            this.disk_parts = TBaseHelper.deepCopy(other.disk_parts);
        }
        if (other.isSetDir()) {
            this.dir = TBaseHelper.deepCopy(other.dir);
        }
        if (other.isSetVersion()) {
            this.version = TBaseHelper.deepCopy(other.version);
        }
    }

    @Override
    public HBReq deepCopy() {
        return new HBReq(this);
    }

    public HostRole getRole() {
        return this.role;
    }

    public HBReq setRole(HostRole role) {
        this.role = role;
        return this;
    }

    public void unsetRole() {
        this.role = null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public void setRoleIsSet(boolean __value) {
        if (!__value) {
            this.role = null;
        }
    }

    public HostAddr getHost() {
        return this.host;
    }

    public HBReq setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public long getCluster_id() {
        return this.cluster_id;
    }

    public HBReq setCluster_id(long cluster_id) {
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        return this;
    }

    public void unsetCluster_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetCluster_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setCluster_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public Map<Integer, List<LeaderInfo>> getLeader_partIds() {
        return this.leader_partIds;
    }

    public HBReq setLeader_partIds(Map<Integer, List<LeaderInfo>> leader_partIds) {
        this.leader_partIds = leader_partIds;
        return this;
    }

    public void unsetLeader_partIds() {
        this.leader_partIds = null;
    }

    public boolean isSetLeader_partIds() {
        return this.leader_partIds != null;
    }

    public void setLeader_partIdsIsSet(boolean __value) {
        if (!__value) {
            this.leader_partIds = null;
        }
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public HBReq setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean __value) {
        if (!__value) {
            this.git_info_sha = null;
        }
    }

    public Map<Integer, Map<byte[], PartitionList>> getDisk_parts() {
        return this.disk_parts;
    }

    public HBReq setDisk_parts(Map<Integer, Map<byte[], PartitionList>> disk_parts) {
        this.disk_parts = disk_parts;
        return this;
    }

    public void unsetDisk_parts() {
        this.disk_parts = null;
    }

    public boolean isSetDisk_parts() {
        return this.disk_parts != null;
    }

    public void setDisk_partsIsSet(boolean __value) {
        if (!__value) {
            this.disk_parts = null;
        }
    }

    public DirInfo getDir() {
        return this.dir;
    }

    public HBReq setDir(DirInfo dir) {
        this.dir = dir;
        return this;
    }

    public void unsetDir() {
        this.dir = null;
    }

    public boolean isSetDir() {
        return this.dir != null;
    }

    public void setDirIsSet(boolean __value) {
        if (!__value) {
            this.dir = null;
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public HBReq setVersion(byte[] version) {
        this.version = version;
        return this;
    }

    public void unsetVersion() {
        this.version = null;
    }

    public boolean isSetVersion() {
        return this.version != null;
    }

    public void setVersionIsSet(boolean __value) {
        if (!__value) {
            this.version = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((HostRole)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetCluster_id();
                    break;
                }
                this.setCluster_id((Long)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetLeader_partIds();
                    break;
                }
                this.setLeader_partIds((Map)__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])__value);
                break;
            }
            case 6: {
                if (__value == null) {
                    this.unsetDisk_parts();
                    break;
                }
                this.setDisk_parts((Map)__value);
                break;
            }
            case 7: {
                if (__value == null) {
                    this.unsetDir();
                    break;
                }
                this.setDir((DirInfo)__value);
                break;
            }
            case 8: {
                if (__value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getRole();
            }
            case 2: {
                return this.getHost();
            }
            case 3: {
                return new Long(this.getCluster_id());
            }
            case 4: {
                return this.getLeader_partIds();
            }
            case 5: {
                return this.getGit_info_sha();
            }
            case 6: {
                return this.getDisk_parts();
            }
            case 7: {
                return this.getDir();
            }
            case 8: {
                return this.getVersion();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof HBReq)) {
            return false;
        }
        HBReq that = (HBReq)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetRole(), that.isSetRole(), this.role, that.role)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.cluster_id, that.cluster_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader_partIds(), that.isSetLeader_partIds(), this.leader_partIds, that.leader_partIds)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetGit_info_sha(), that.isSetGit_info_sha(), this.git_info_sha, that.git_info_sha)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetDisk_parts(), that.isSetDisk_parts(), this.disk_parts, that.disk_parts)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetDir(), that.isSetDir(), this.dir, that.dir)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetVersion(), that.isSetVersion(), this.version, that.version);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.role, this.host, this.cluster_id, this.leader_partIds, this.git_info_sha, this.disk_parts, this.dir, this.version});
    }

    @Override
    public int compareTo(HBReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCluster_id()).compareTo(other.isSetCluster_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.cluster_id, other.cluster_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader_partIds()).compareTo(other.isSetLeader_partIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader_partIds, other.leader_partIds);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDisk_parts()).compareTo(other.isSetDisk_parts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.disk_parts, other.disk_parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDir()).compareTo(other.isSetDir());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.dir, other.dir);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.version, other.version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.role = HostRole.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 10) {
                        this.cluster_id = iprot.readI64();
                        this.setCluster_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 13) {
                        TMap _map160 = iprot.readMapBegin();
                        this.leader_partIds = new HashMap<Integer, List<LeaderInfo>>(Math.max(0, 2 * _map160.size));
                        int _i161 = 0;
                        while (_map160.size < 0 ? iprot.peekMap() : _i161 < _map160.size) {
                            int _key162 = iprot.readI32();
                            TList _list164 = iprot.readListBegin();
                            ArrayList<LeaderInfo> _val163 = new ArrayList<LeaderInfo>(Math.max(0, _list164.size));
                            int _i165 = 0;
                            while (_list164.size < 0 ? iprot.peekList() : _i165 < _list164.size) {
                                LeaderInfo _elem166 = new LeaderInfo();
                                _elem166.read(iprot);
                                _val163.add(_elem166);
                                ++_i165;
                            }
                            iprot.readListEnd();
                            this.leader_partIds.put(_key162, _val163);
                            ++_i161;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 6: {
                    if (__field.type == 13) {
                        TMap _map167 = iprot.readMapBegin();
                        this.disk_parts = new HashMap<Integer, Map<byte[], PartitionList>>(Math.max(0, 2 * _map167.size));
                        int _i168 = 0;
                        while (_map167.size < 0 ? iprot.peekMap() : _i168 < _map167.size) {
                            int _key169 = iprot.readI32();
                            TMap _map171 = iprot.readMapBegin();
                            HashMap<byte[], PartitionList> _val170 = new HashMap<byte[], PartitionList>(Math.max(0, 2 * _map171.size));
                            int _i172 = 0;
                            while (_map171.size < 0 ? iprot.peekMap() : _i172 < _map171.size) {
                                byte[] _key173 = iprot.readBinary();
                                PartitionList _val174 = new PartitionList();
                                _val174.read(iprot);
                                _val170.put(_key173, _val174);
                                ++_i172;
                            }
                            iprot.readMapEnd();
                            this.disk_parts.put(_key169, _val170);
                            ++_i168;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 7: {
                    if (__field.type == 12) {
                        this.dir = new DirInfo();
                        this.dir.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 8: {
                    if (__field.type == 11) {
                        this.version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.role != null) {
            oprot.writeFieldBegin(ROLE_FIELD_DESC);
            oprot.writeI32(this.role == null ? 0 : this.role.getValue());
            oprot.writeFieldEnd();
        }
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CLUSTER_ID_FIELD_DESC);
        oprot.writeI64(this.cluster_id);
        oprot.writeFieldEnd();
        if (this.leader_partIds != null && this.isSetLeader_partIds()) {
            oprot.writeFieldBegin(LEADER_PART_IDS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.leader_partIds.size()));
            for (Map.Entry<Integer, List<LeaderInfo>> entry : this.leader_partIds.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeListBegin(new TList(12, entry.getValue().size()));
                for (LeaderInfo leaderInfo : entry.getValue()) {
                    leaderInfo.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        if (this.disk_parts != null && this.isSetDisk_parts()) {
            oprot.writeFieldBegin(DISK_PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 13, this.disk_parts.size()));
            for (Map.Entry<Integer, Object> entry : this.disk_parts.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeMapBegin(new TMap(11, 12, ((Map)entry.getValue()).size()));
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    oprot.writeBinary((byte[])entry2.getKey());
                    ((PartitionList)entry2.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.dir != null && this.isSetDir()) {
            oprot.writeFieldBegin(DIR_FIELD_DESC);
            this.dir.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.version != null && this.isSetVersion()) {
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeBinary(this.version);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("HBReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRole() == null) {
            sb.append("null");
        } else {
            String role_name;
            String string = role_name = this.getRole() == null ? "null" : this.getRole().name();
            if (role_name != null) {
                sb.append(role_name);
                sb.append(" (");
            }
            sb.append(this.getRole());
            if (role_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("cluster_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getCluster_id(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetLeader_partIds()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("leader_partIds");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getLeader_partIds() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getLeader_partIds(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (this.isSetDisk_parts()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("disk_parts");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getDisk_parts() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getDisk_parts(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetDir()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("dir");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getDir() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getDir(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetVersion()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("version");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVersion() == null) {
                sb.append("null");
            } else {
                int __version_size = Math.min(this.getVersion().length, 128);
                for (i = 0; i < __version_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getVersion()[i]).length() > 1 ? Integer.toHexString(this.getVersion()[i]).substring(Integer.toHexString(this.getVersion()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getVersion()[i]).toUpperCase());
                }
                if (this.getVersion().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("cluster_id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("leader_partIds", 2, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, LeaderInfo.class)))));
        tmpMetaDataMap.put(5, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(6, new FieldMetaData("disk_parts", 2, new MapMetaData(13, new FieldValueMetaData(8), new MapMetaData(13, new FieldValueMetaData(11), new StructMetaData(12, PartitionList.class)))));
        tmpMetaDataMap.put(7, new FieldMetaData("dir", 2, new StructMetaData(12, DirInfo.class)));
        tmpMetaDataMap.put(8, new FieldMetaData("version", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(HBReq.class, metaDataMap);
    }

    public static class Builder {
        private HostRole role;
        private HostAddr host;
        private long cluster_id;
        private Map<Integer, List<LeaderInfo>> leader_partIds;
        private byte[] git_info_sha;
        private Map<Integer, Map<byte[], PartitionList>> disk_parts;
        private DirInfo dir;
        private byte[] version;
        BitSet __optional_isset = new BitSet(1);

        public Builder setRole(HostRole role) {
            this.role = role;
            return this;
        }

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setCluster_id(long cluster_id) {
            this.cluster_id = cluster_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setLeader_partIds(Map<Integer, List<LeaderInfo>> leader_partIds) {
            this.leader_partIds = leader_partIds;
            return this;
        }

        public Builder setGit_info_sha(byte[] git_info_sha) {
            this.git_info_sha = git_info_sha;
            return this;
        }

        public Builder setDisk_parts(Map<Integer, Map<byte[], PartitionList>> disk_parts) {
            this.disk_parts = disk_parts;
            return this;
        }

        public Builder setDir(DirInfo dir) {
            this.dir = dir;
            return this;
        }

        public Builder setVersion(byte[] version) {
            this.version = version;
            return this;
        }

        public HBReq build() {
            HBReq result = new HBReq();
            result.setRole(this.role);
            result.setHost(this.host);
            if (this.__optional_isset.get(0)) {
                result.setCluster_id(this.cluster_id);
            }
            result.setLeader_partIds(this.leader_partIds);
            result.setGit_info_sha(this.git_info_sha);
            result.setDisk_parts(this.disk_parts);
            result.setDir(this.dir);
            result.setVersion(this.version);
            return result;
        }
    }
}

