/*
 * Decompiled with CFR 0.152.
 */
package com.sinovatech.unicom.util.sign;

import com.unicompay.sign.Base64Util;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class CertificateUtil {
    public static boolean verifySig(String signSource, PublicKey key, String sign) throws Exception {
        byte[] sig = Base64Util.decode(sign);
        byte[] data = signSource.getBytes();
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initVerify(key);
        signer.update(data);
        return signer.verify(sig);
    }

    public static PublicKey getPublicKey(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        PublicKey key = certificate.getPublicKey();
        return key;
    }

    public static void main(String[] args) throws Exception {
        String certificatePath = "D:/cert.cer";
        String signSource = "mp=2|orderid=13678961804454591393|paybalance=150|payfloodid=20130703020200045631|payresult=1|resptime=20130507112729|retype=2|userId=100000000000833";
        String sign = "tGpGRWn/Y214FSUQkvyFxZY3zhr6VctfJkds8ncoLtppt2KHryqFJ0XMEeXYjVkqkSAHDTfxXIFzY0om8d7XFpVFhRFvPwKwbGMxuBTfW/dj0eQQVMV8rDR8g2a7X0M0ittshgWgITK4RFu6HHKBz1mzIIF/N+w5AxL58uBferc=";
        PublicKey pKey = CertificateUtil.getPublicKey(certificatePath);
        try {
            boolean status = CertificateUtil.verifySig(signSource, pKey, sign);
            System.out.println(status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

