/*
 * Decompiled with CFR 0.152.
 */
package com.sinovatech.unicom.util.sign;

import com.sinovatech.unicom.util.sign.Convertor;
import com.sinovatech.unicom.util.sign.exception.CryptException;
import com.sun.crypto.provider.SunJCE;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptUtil {
    private static final String desAlgorithm = "DESede/CBC/PKCS5Padding";
    private static final String desKeyAlgorithm = "DESede";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] defaultIV = new byte[8];
    public static final Convertor DEFAULTCONVERTOR = new Convertor(){

        public String convert(String name) {
            char[] chars = name.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (Character.isUpperCase(chars[i])) {
                    Character c = Character.valueOf(chars[i]);
                    return this.convert(name.replaceFirst(c.toString(), "" + Character.toLowerCase(c.charValue())));
                }
                ++i;
            }
            return name;
        }
    };
    private static SimpleDateFormat recordsnSdf;

    static {
        try {
            Security.addProvider(new SunJCE());
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u8f7dSunJCE\u51fa\u9519");
        }
        recordsnSdf = new SimpleDateFormat("yyMMddHHmmssSSS");
    }

    public static <T> T decryptBeanNoKey(String encryptContent, Class<T> clazz) {
        return CryptUtil.decryptBeanNoKey(encryptContent, "$", "UTF-8", DEFAULTCONVERTOR, clazz);
    }

    public static <T> T decryptBeanNoKey(String encryptContent, String separator, String encoding, Convertor convertor, Class<T> clazz) {
        return CryptUtil.parse(encryptContent, separator, convertor, clazz);
    }

    private static Key KeyGenerator(String KeyStr) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] input = null;
        try {
            input = CryptUtil.md5Hex(KeyStr).substring(0, 24).getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("\u65e0\u6548\u7684\u5b57\u7b26\u96c6GBK", e);
        }
        DESedeKeySpec KeySpec2 = new DESedeKeySpec(input);
        SecretKeyFactory KeyFactory = SecretKeyFactory.getInstance(desKeyAlgorithm);
        return KeyFactory.generateSecret(KeySpec2);
    }

    public static byte[] cryptBy3Des(byte[] input, String key, int cryptModel, byte[] iv) {
        try {
            Key k = CryptUtil.KeyGenerator(key);
            IvParameterSpec IVSpec = iv != null ? CryptUtil.IvGenerator(iv) : CryptUtil.IvGenerator(defaultIV);
            Cipher c = Cipher.getInstance(desAlgorithm);
            c.init(cryptModel, k, IVSpec);
            return c.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw new CryptException("\u65e0\u6548\u7684key:" + key + ",\u9519\u8bef\u7684\u7f16\u7801\u6216\u8005\u957f\u5ea6", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptException("\u65e0\u6548\u7684\u7b97\u6cd5:DESede/CBC/PKCS5Padding", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptException("\u65e0\u6548\u7684\u586b\u5145\u673a\u5236", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptException("\u65e0\u6548\u7684\u7b97\u6cd5:DESede/CBC/PKCS5Padding", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptException("\u65e0\u6cd5\u89e3\u5bc6", e);
        }
        catch (BadPaddingException e) {
            throw new CryptException("\u65e0\u6cd5\u89e3\u5bc6", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptException("\u65e0\u6548\u7684key:" + key + ",\u9519\u8bef\u7684\u7f16\u7801\u6216\u8005\u957f\u5ea6", e);
        }
    }

    public static byte[] encryptBy3Des(byte[] input, String key) {
        return CryptUtil.cryptBy3Des(input, key, 1, null);
    }

    public static String encryptBy3DesAndBase64(String content, String key, String encoding) {
        try {
            byte[] input = content.getBytes(encoding);
            byte[] output = CryptUtil.encryptBy3Des(input, key);
            return new BASE64Encoder().encode(output).replaceAll("[\\n\\r]", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("\u65e0\u6548\u7684\u7f16\u7801:" + encoding, e);
        }
    }

    public static String encryptBy3DesAndBase64(String content, String key) {
        return CryptUtil.encryptBy3DesAndBase64(content, key, "UTF-8");
    }

    public static String decryptBy3DesAndBase64(String encryptContent, String key, String encoding) {
        try {
            byte[] input = new BASE64Decoder().decodeBuffer(encryptContent);
            byte[] output = CryptUtil.decryptBy3Des(input, key);
            return new String(output, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("\u65e0\u6548\u7684\u7f16\u7801:" + encoding, e);
        }
        catch (IOException e1) {
            throw new CryptException("Base64\u89e3\u7801\u5931\u8d25:,e1");
        }
    }

    public static String decryptBy3DesAndBase64(String encryptContent, String key) {
        return CryptUtil.decryptBy3DesAndBase64(encryptContent, key, "UTF-8");
    }

    public static byte[] decryptBy3Des(byte[] input, String key) {
        return CryptUtil.cryptBy3Des(input, key, 2, null);
    }

    private static IvParameterSpec IvGenerator(byte[] b) {
        IvParameterSpec IV = new IvParameterSpec(b);
        return IV;
    }

    public static void parse(String content, String separator, Object javaBean, Convertor convertor) {
        Map<String, String> map = CryptUtil.parseContent(content, separator);
        if (map.isEmpty()) {
            return;
        }
        CryptUtil.parse(map, javaBean, convertor);
    }

    public static void parse(Map<String, String> map, Object javaBean) {
        CryptUtil.parse(map, javaBean, DEFAULTCONVERTOR);
    }

    public static void parse(Map<String, String> map, Object javaBean, Convertor convertor) {
        BeanInfo bi;
        if (convertor == null) {
            convertor = new Convertor(){

                public String convert(String name) {
                    return name;
                }
            };
        }
        Class<?> clazz = javaBean.getClass();
        try {
            bi = Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new CryptException("\u5f97\u5230Class:" + clazz.getName() + "\u7684bean\u4fe1\u606f\u51fa\u9519", e);
        }
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        if (pds != null) {
            PropertyDescriptor[] propertyDescriptorArray = pds;
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                Method setter;
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String value = map.get(convertor.convert(pd.getName()));
                if (value != null && (setter = pd.getWriteMethod()) != null) {
                    try {
                        setter.invoke(javaBean, value);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public static void parse(String content, String separator, Object o) {
        CryptUtil.parse(content, separator, o, DEFAULTCONVERTOR);
    }

    public static <T> T parse(String content, String separator, Convertor convert, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            CryptUtil.parse(content, separator, t, convert);
            return t;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.valueOf(clazz.getName()) + "\u5b9e\u4f8b\u5316\u51fa\u9519", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.valueOf(clazz.getName()) + "\u5b9e\u4f8b\u5316\u51fa\u9519", e);
        }
    }

    public static <T> T parse(String content, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            CryptUtil.parse(content, "$", t, DEFAULTCONVERTOR);
            return t;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.valueOf(clazz.getName()) + "\u5b9e\u4f8b\u5316\u51fa\u9519", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.valueOf(clazz.getName()) + "\u5b9e\u4f8b\u5316\u51fa\u9519", e);
        }
    }

    public static String format(Object o, String separator, Convertor convertor) {
        BeanInfo bi;
        if (convertor == null) {
            convertor = new Convertor(){

                public String convert(String name) {
                    return name;
                }
            };
        }
        Class<?> clazz = o.getClass();
        try {
            bi = Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new CryptException("\u5f97\u5230Class:" + clazz.getName() + "\u7684bean\u4fe1\u606f\u51fa\u9519", e);
        }
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        StringBuffer sb = new StringBuffer();
        if (pds != null) {
            int i = 0;
            while (i < pds.length) {
                sb.append(convertor.convert(pds[i].getName())).append("=");
                String temp = null;
                try {
                    temp = (String)pds[i].getReadMethod().invoke(o, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (temp == null) {
                    temp = "";
                }
                sb.append(temp);
                if (i != pds.length - 1) {
                    sb.append(separator);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String formatNoSign(Object o, String separator, Convertor convertor) {
        BeanInfo bi;
        if (convertor == null) {
            convertor = new Convertor(){

                public String convert(String name) {
                    return name;
                }
            };
        }
        Class<?> clazz = o.getClass();
        try {
            bi = Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new CryptException("\u5f97\u5230Class:" + clazz.getName() + "\u7684bean\u4fe1\u606f\u51fa\u9519", e);
        }
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        StringBuffer sb = new StringBuffer();
        if (pds != null) {
            int i = 0;
            while (i < pds.length) {
                if (!convertor.convert(pds[i].getName()).equalsIgnoreCase("signmsg")) {
                    sb.append(convertor.convert(pds[i].getName())).append("=");
                    String temp = null;
                    try {
                        temp = (String)pds[i].getReadMethod().invoke(o, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (temp == null) {
                        temp = "";
                    }
                    sb.append(temp);
                    if (i != pds.length - 1) {
                        sb.append(separator);
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String format(Object o, String separator) {
        return CryptUtil.format(o, separator, DEFAULTCONVERTOR);
    }

    public static Map<String, String> parseContent(String content, String separator) {
        if ("$".equals(separator)) {
            separator = "\\" + separator;
        }
        String[] params = content.split(separator);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] temps = param.split("=", 2);
            if (temps.length > 1) {
                map.put(temps[0], temps[1]);
            }
            ++n2;
        }
        return map;
    }

    public static String encryptBean(Object bean, String key, String separator, String encoding, Convertor convertor) {
        String content = CryptUtil.formatNoSign(bean, separator, convertor);
        return CryptUtil.encryptBy3DesAndBase64(content, key, encoding);
    }

    public static String encryptBean(Object bean, String key) {
        return CryptUtil.encryptBean(bean, key, "$", "UTF-8", DEFAULTCONVERTOR);
    }

    public static String encryptBean(Object bean, String key, String encoding) {
        return CryptUtil.encryptBean(bean, key, "$", encoding, DEFAULTCONVERTOR);
    }

    public static <T> T decryptBean(String encryptContent, String key, Class<T> clazz) {
        return CryptUtil.decryptBean(encryptContent, key, "$", "UTF-8", DEFAULTCONVERTOR, clazz);
    }

    public static <T> T decryptBean(String encryptContent, String key, String separator, String encoding, Convertor convertor, Class<T> clazz) {
        String content = CryptUtil.decryptBy3DesAndBase64(encryptContent, key, encoding);
        return CryptUtil.parse(content, separator, convertor, clazz);
    }

    public static String md5Hex(String content) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        try {
            md5.update(content.getBytes("GBK"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("\u65e0\u6548\u7684\u5b57\u7b26\u96c6GBK", e);
        }
        return new String(CryptUtil.encodeHex(md5.digest()));
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public static String generateRecordsn(String spId) {
        StringBuilder sb = new StringBuilder();
        sb.append("EPAY").append(recordsnSdf.format(new Date())).append(CryptUtil.randomCode(5)).append(spId);
        return sb.toString();
    }

    private static String randomCode(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append(random.nextInt(10));
            ++i;
        }
        return sb.toString();
    }

    public static String encryptBeanNokey(Object bean, String key, String separator, String encoding, Convertor convertor) {
        String content = CryptUtil.format(bean, separator, convertor);
        return content;
    }

    public static String encryptBeanNokey(Object bean, String separator, String encoding, Convertor convertor) {
        String content = CryptUtil.format(bean, separator, convertor);
        return content;
    }

    public static String encryptBeanNokey(Object bean) {
        return CryptUtil.encryptBeanNokey(bean, "$", "UTF-8", DEFAULTCONVERTOR);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(CryptUtil.encryptBy3DesAndBase64("sp_id=308300200000663$sp_sett_id=000$service_code=MAP03001$user_id=bluesansan@126.com$passport=bluesansan@126.com$order_id=432$account_type=01,02,03$payment_balance=200$payment_type=01$payment_desc=\u5f69\u7968\u8d2d\u4e70$req_time=2012-05-25 15:30:02$need_response=1$page_redirect_url=http://wozhongla.com/unionWap.do?op=union_charge_back$serv_to_serv_url=http://wozhongla.com/unionWap.do?op=union_charge_back$mp=mp$extend=extend$hmac=12ccf25c40c046dfca8add1091f453e5", "24e7252b-62d6-454d-b48e-438f5b11ce450427c786-828"));
        System.out.println(CryptUtil.decryptBy3DesAndBase64("h11VQLuFvMFimMvidnJaI6fo5+W/5v7jA3YVy/2ELNjVLWHOiZNk66R851/ALyZFg0GaWZPP64MfUGUJJlVKnO+fLCQUPr4sZ99z4kRzZSCUBILH08WUK+GwSNKf1/rB2oU66beozzupMpmYvWFiX/O+lrokJygVCl27FztI6CBToPtSTxSO4MWixMm1EUcbPltmgW286rpOwyKcvBPtzwXHcoGKXHvadq4BdDA1OoWlLd9JqxgTMSl+iitWWJt3YCjcYe2kwrPxD+g0rIU7E0DaF3uJYgISzkVUGIUUdhDYD8TePQd6+b1CnT+4uYmUKMOZb0t5I9MUEjDMfuERq+25zooSBQaAwjs7orTnbe12skIRfUJJzKoiLgBPlueDZJuxgUQsOBCAEWzyjxfryaphpZEPs7O8Q3o4xL3jmKQeONTeZqZSQ3mUo6b1Xlb60oS+IqmNKsUReUmabjKpjiSRxOdv9kj1IgSy8ZI3Lq5WoeotwTOmw/V77I1xi5J3CUeBkUlBvuUEwoVPOU+JYutGHmSsrp5nXhLFv5EjBG3genz6GCvRp0H1aF0w6h9ULIWnjP+u51qn03HAsH+7GFZB4GLn2X54fnPCWJVglwU=", "24e7252b-62d6-454d-b48e-438f5b11ce450427c786-828"));
    }
}

