/*
 * Decompiled with CFR 0.152.
 */
package com.unicompayment.mer.access.util;

import ccit.security.bssp.base.SignBase;
import ccit.security.bssp.ex.CrypException;
import ccit.security.bssp.sm2.Cryption;
import ccit.security.bssp.sm2.Randoms;
import ccit.security.bssp.sm2.SM2PrivateKeyDer;
import ccit.security.bssp.sm2.SM2PublicKeyDer;
import ccit.security.bssp.util.Constants;
import ccit.security.bssp.util.MiscTools;
import ccit.security.bssp.util.Resource;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Base64;

public class CAUtilityUtil {
    public static CAUtilityUtil getInstance() {
        return new CAUtilityUtil();
    }

    public static byte[] RsaSign(int type, byte[] privateKey, byte[] indata) throws CrypException {
        if (privateKey == null) {
            throw new CrypException(-2147450878, "Sign failed! Key cann't be null!");
        }
        if (indata == null) {
            throw new CrypException(-2147450878, "Sign failed! The data to be signed cann't be null!");
        }
        byte[] signaturepem = MiscTools.checkPEM((byte[])privateKey);
        if (signaturepem != null) {
            privateKey = Base64.decode((byte[])signaturepem);
        }
        String Algorithms = "";
        if (type == 257) {
            Algorithms = "MD2WITHRSA";
        } else if (type == 258) {
            Algorithms = "MD5WITHRSA";
        } else if (type == 259) {
            Algorithms = "SHA1WITHRSA";
        } else if (type == 261) {
            Algorithms = "SHA256WITHRSA";
        } else {
            throw new CrypException(-2147483643, "Algorithm unsupported!");
        }
        byte[] signdata = SignBase.sign((String)Algorithms, (byte[])privateKey, (byte[])indata);
        return signdata;
    }

    public static byte[] RsaSignByP12(int type, byte[] indata) throws CryptoException {
        return CAUtilityUtil.RsaSignByP12(type, indata, null);
    }

    public static byte[] RsaSignByP12(int type, byte[] indata, String merNo) throws CryptoException {
        byte[] signtedate = null;
        try {
            if (indata == null) {
                throw new CryptoException("indata is null");
            }
            String prikey = " ";
            String filepath = Resource.getValue((String)(merNo != null ? String.valueOf(merNo) + "_" + Constants.P12_CERT : Constants.P12_CERT));
            String p12pincode = Resource.getValue((String)(merNo != null ? String.valueOf(merNo) + "_" + Constants.P12_PINCODE : Constants.P12_PINCODE));
            KeyStore ks = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(filepath);
            char[] nPassword = null;
            nPassword = p12pincode == null || p12pincode.trim().equals("") ? (char[])null : p12pincode.toCharArray();
            ks.load(fis, nPassword);
            fis.close();
            Enumeration<String> enum1 = ks.aliases();
            String keyAlias = null;
            if (enum1.hasMoreElements()) {
                keyAlias = enum1.nextElement();
            }
            PrivateKey privatekey = (PrivateKey)ks.getKey(keyAlias, nPassword);
            prikey = new String(Base64.encode((byte[])privatekey.getEncoded()));
            String Algorithms = "";
            if (type == 257) {
                Algorithms = "MD2WITHRSA";
            } else if (type == 258) {
                Algorithms = "MD5WITHRSA";
            } else if (type == 259) {
                Algorithms = "SHA1WITHRSA";
            } else if (type == 261) {
                Algorithms = "SHA256WITHRSA";
            } else {
                throw new CrypException(-2147483643, "Algorithm unsupported!");
            }
            signtedate = CAUtilityUtil.RsaSign(type, CAUtilityUtil.removePrikeyHead(prikey).getBytes(), indata);
            if (signtedate == null) {
                throw new CryptoException("signtedate is null");
            }
        }
        catch (CrypException e) {
            e.printStackTrace();
            throw new CryptoException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException(e.getMessage());
        }
        return signtedate;
    }

    private static String removePrikeyHead(String prikey) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode((String)prikey));
            ASN1InputStream ais1 = new ASN1InputStream((InputStream)bIn);
            DERObject dobj1 = ais1.readObject();
            DERSequence ass1 = (DERSequence)dobj1;
            bIn.close();
            bIn = null;
            ASN1OctetString priOct = DEROctetString.getInstance((Object)ass1.getObjectAt(2));
            prikey = new String(Base64.encode((byte[])priOct.getOctets()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return prikey;
    }

    public static String SM2EncOrDec(boolean type, String keyData, String indata) throws Exception {
        if (CAUtilityUtil.isEmpty(keyData)) {
            throw new Exception("keyData is null");
        }
        if (CAUtilityUtil.isEmpty(indata)) {
            throw new Exception("indata is null");
        }
        byte[] encdate = null;
        if (type) {
            byte[] bytCryptRand = Randoms.getRandom();
            encdate = Cryption.SM2Encrypt((byte[])indata.getBytes(), (byte[])SM2PublicKeyDer.sm2PubkeyDerDecode((byte[])Base64.decode((String)keyData)), (byte[])bytCryptRand);
            return new String(Base64.encode((byte[])encdate));
        }
        encdate = Cryption.SM2Decrypt((byte[])Base64.decode((byte[])indata.getBytes()), (byte[])SM2PrivateKeyDer.sm2PrivateKeyDerDecode((byte[])Base64.decode((String)keyData)));
        return new String(encdate);
    }

    public static boolean isCert(String cert) {
        boolean flag = false;
        try {
            if (CAUtilityUtil.isEmpty(cert)) {
                throw new Exception("cert is null");
            }
            ByteArrayInputStream bIn1 = new ByteArrayInputStream(Base64.decode((String)cert));
            ASN1InputStream ais1 = new ASN1InputStream((InputStream)bIn1);
            DERObject dobj1 = ais1.readObject();
            ASN1Sequence ass1 = (ASN1Sequence)dobj1;
            ais1.close();
            bIn1.close();
            bIn1 = null;
            X509CertificateStructure x509cert1 = new X509CertificateStructure(ass1);
            if (x509cert1 != null) {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private static boolean isEmpty(String data) {
        return data == null || "".equals(data.trim());
    }
}

