/*
 * Decompiled with CFR 0.152.
 */
package com.unicompayment.mer.access.util;

import ccit.security.bssp.CAUtility;
import com.unicompayment.mer.access.util.CAUtilityUtil;
import com.unicompayment.mer.access.util.Constants;
import com.unicompayment.mer.access.util.HashEncrypt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniPaySignUtils {
    private static Logger logger = LoggerFactory.getLogger(UniPaySignUtils.class);

    public static String getMd5SignMsg(Map<String, String> params, String key, String inputCharset) {
        String signSource = UniPaySignUtils.getSignSourMsg(params, key);
        String signMsg = HashEncrypt.doEncrypt(signSource, "MD5", inputCharset);
        logger.info("\u7b7e\u540d\uff1a" + signMsg);
        return signMsg;
    }

    public static String getSignMsg(Map<String, String> params, String key, String inputCharset) {
        String signCode = params.get("signType");
        if (signCode == null || "".equals(signCode)) {
            signCode = params.get("signtype");
        }
        return HashEncrypt.doEncrypt(UniPaySignUtils.getSignSourMsg(params, key), signCode, inputCharset);
    }

    public static String getSignSourMsg(Map<String, String> params, String key) {
        params = UniPaySignUtils.filterNoParams(params);
        String signSource = UniPaySignUtils.createLinkString(params);
        logger.info("\u4e0d\u5305\u62ecKey\u4ee5\u5916\u7684\u5f85\u7b7e\u540d\u53c2\u6570\u4e32\uff1a" + signSource);
        if (key != null && key.length() > 0) {
            signSource = String.valueOf(signSource) + "|key=" + key;
        }
        logger.info("\u4e0d\u5305\u62ecKey\u4ee5\u5916\u7684\u5f85\u7b7e\u540d\u53c2\u6570\u4e32\uff1a" + signSource);
        return signSource;
    }

    private static Map<String, String> filterNoParams(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        HashMap<String, String> newParam = new HashMap<String, String>();
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (!("hmac".equalsIgnoreCase(key) || "signMsg".equalsIgnoreCase(key) || "signmsg".equalsIgnoreCase(key) || "cert".equalsIgnoreCase(key) || value == null || value.length() == 0)) {
                newParam.put(key, value);
            }
            ++i;
        }
        return newParam;
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                prestr.append(key).append("=").append(value);
            } else {
                prestr.append(key).append("=").append(value).append("|");
            }
            ++i;
        }
        return prestr.toString();
    }

    public static String merSign(Map<String, String> reqMap, String signType, String inputCharset, String key) {
        logger.info("------------------\u6a21\u62df\u5546\u6237\u7b7e\u540d\u5f00\u59cb----------------------------");
        String signResult = null;
        String merNo = null;
        if (!Constants.SIGN_TYPE_DICT.contains(signType)) {
            logger.info("\u4e0d\u652f\u6301\u6b64\u7b7e\u540d\u7c7b\u578b:" + signType);
        } else if ("RSA_SHA256".equals(signType) || "SM2_SM3".equals(signType)) {
            try {
                if (reqMap.get("merno") != null && reqMap.get("merno") != "") {
                    merNo = reqMap.get("merno");
                }
                signResult = UniPaySignUtils.rsaOrSm2Sign(UniPaySignUtils.getSignSourMsg(reqMap), signType, merNo);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5546\u6237\u7528\u975e\u5bf9\u79f0\u52a0\u5bc6\u65b9\u5f0f\u7b7e\u540d-\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            }
        } else {
            if (!Constants.CHARSET_DICT.contains(inputCharset.toUpperCase())) {
                logger.info("\u4e0d\u652f\u6301\u6b64\u5b57\u7b26\u96c6:" + inputCharset + ",\u9ed8\u8ba4\u6a21\u62df\u4ee5UTF-8\u65b9\u5f0f\u7f16\u7801");
                inputCharset = "UTF-8";
            }
            signResult = UniPaySignUtils.getSignMsg(reqMap, key, inputCharset);
        }
        logger.info("\u7b7e\u540d\u65b9\u5f0f(" + signType + "),\u5546\u6237\u751f\u6210\u7684\u7b7e\u540d\u503c[" + signResult + "],\u7b7e\u540d\u539f\u6587\u5b57\u7b26\u96c6" + inputCharset);
        logger.info("------------------\u6a21\u62df\u5546\u6237\u7b7e\u540d\u7ed3\u675f----------------------------");
        return signResult;
    }

    private static String merSignWithRsaOrSm2(String originalData, String signType, String prvKey) {
        String signMsg = "this_is_the_error_sign_message";
        try {
            signMsg = UniPaySignUtils.simulateMerSign(originalData, signType, prvKey);
        }
        catch (Exception e) {
            logger.error("\u6a21\u62df\u5546\u6237\u7528\u975e\u5bf9\u79f0\u52a0\u5bc6\u65b9\u5f0f\u7b7e\u540d-\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
        return signMsg;
    }

    public static String simulateMerSign(String originalData, String algorithm, String prvKey) throws Exception {
        logger.info("\u6a21\u62df\u5546\u6237\u7b7e\u540d-\u7b7e\u540d\u7b97\u6cd5\u4e3a[" + algorithm + "]prvKey\u4e3a\uff1a" + prvKey);
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] privateKey = prvKey.getBytes("UTF-8");
        byte[] signBytes = null;
        if ("RSA_SHA1".equalsIgnoreCase(algorithm)) {
            signBytes = CAUtility.RsaSign((int)259, (byte[])privateKey, (byte[])indata);
        } else if ("RSA_SHA256".equalsIgnoreCase(algorithm)) {
            signBytes = CAUtility.RsaSign((int)261, (byte[])privateKey, (byte[])indata);
        } else if ("SM2_SM3".equalsIgnoreCase(algorithm)) {
            signBytes = CAUtility.EccSign((int)260, (byte[])privateKey, (byte[])indata);
        }
        return new String(CAUtility.base64Encode((byte[])signBytes));
    }

    public static boolean merVerify(Map<String, String> reqMap, String signType, String signMsg, String cert) {
        if (!Constants.SIGN_TYPE_DICT.contains(signType)) {
            logger.info("\u4e0d\u652f\u6301\u6b64\u7b7e\u540d\u7c7b\u578b:" + signType);
            return false;
        }
        try {
            return UniPaySignUtils.rsaOrSm2Verify(UniPaySignUtils.getSignSourMsg(reqMap), signMsg, signType, cert);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String getSignSourMsg(Map<String, String> params) {
        params = UniPaySignUtils.filterNoParams(params);
        String signSource = UniPaySignUtils.createLinkString(params);
        logger.info("\u5f85\u7b7e\u540d\u53c2\u6570\u4e32\uff1a" + signSource);
        return signSource;
    }

    private static boolean rsaOrSm2Verify(String originalData, String signMsg, String algorithm, String cert) throws Exception {
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] certbytes = cert.getBytes("UTF-8");
        byte[] signMsgbytes = signMsg.getBytes("UTF-8");
        int verifyWithCert = 1;
        if ("RSA_SHA256".equalsIgnoreCase(algorithm)) {
            verifyWithCert = CAUtility.verifyWithCert((int)261, (byte[])certbytes, (byte[])indata, (byte[])signMsgbytes);
        } else if ("SM2_SM3".equalsIgnoreCase(algorithm)) {
            verifyWithCert = CAUtility.EccVerifySignByCert((int)260, (byte[])certbytes, (byte[])indata, (byte[])signMsgbytes);
        }
        return verifyWithCert == 0;
    }

    private static String rsaOrSm2Sign(String originalData, String algorithm, String merNo) throws Exception {
        byte[] indata = originalData.getBytes("UTF-8");
        byte[] signBytes = null;
        signBytes = CAUtilityUtil.RsaSignByP12(261, indata, merNo);
        return new String(CAUtility.base64Encode((byte[])signBytes));
    }
}

