/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.auth.interceptor;

import com.xxl.sso.core.annotation.XxlSso;
import com.xxl.sso.core.exception.XxlSsoException;
import com.xxl.sso.core.helper.XxlSsoHelper;
import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.path.impl.AntPathMatcher;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.response.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class XxlSsoWebInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(XxlSsoWebInterceptor.class);
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String excludedPaths;
    private String loginPath;

    public XxlSsoWebInterceptor(String excludedPaths, String loginPath) {
        this.excludedPaths = excludedPaths;
        this.loginPath = loginPath;
        if (StringTool.isBlank((String)loginPath)) {
            this.loginPath = "/login";
        }
        logger.info("XxlSsoWebInterceptor init.");
    }

    public XxlSsoWebInterceptor(String loginPath) {
        this(null, loginPath);
    }

    public boolean isMatchExcludedPaths(HttpServletRequest request) {
        if (StringTool.isBlank((String)this.excludedPaths)) {
            return false;
        }
        String servletPath = request.getServletPath();
        for (String excludedPath : this.excludedPaths.split(",")) {
            String uriPattern = excludedPath.trim();
            if (StringTool.isBlank((String)uriPattern) || !this.antPathMatcher.match(uriPattern, servletPath)) continue;
            return true;
        }
        return false;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String role;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        XxlSso xxlSso = (XxlSso)method.getMethodAnnotation(XxlSso.class);
        boolean needLogin = xxlSso != null ? xxlSso.login() : true;
        String permission = xxlSso != null ? xxlSso.permission() : null;
        String string = role = xxlSso != null ? xxlSso.role() : null;
        if (this.isMatchExcludedPaths(request)) {
            return true;
        }
        if (!needLogin) {
            return true;
        }
        Response<LoginInfo> loginCheckResult = XxlSsoHelper.loginCheckWithCookie(request, response);
        LoginInfo loginInfo = null;
        if (loginCheckResult != null && loginCheckResult.isSuccess()) {
            loginInfo = (LoginInfo)loginCheckResult.getData();
        }
        if (loginInfo == null) {
            boolean isJson;
            boolean bl = isJson = method.getMethodAnnotation(ResponseBody.class) != null;
            if (isJson) {
                throw new XxlSsoException(501, "not login for path:" + request.getServletPath());
            }
            String finalLoginPath = request.getContextPath().concat(this.loginPath);
            response.sendRedirect(finalLoginPath);
            return false;
        }
        request.setAttribute("xxl_sso_user", loginInfo);
        if (!XxlSsoHelper.hasPermission(loginInfo, permission).isSuccess()) {
            throw new XxlSsoException("permission limit, current login-user does not have permission:" + permission);
        }
        if (!XxlSsoHelper.hasRole(loginInfo, role).isSuccess()) {
            throw new XxlSsoException("permission limit, current login-user does not have role:" + role);
        }
        return true;
    }
}

