/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.token;

import com.xxl.sso.core.model.LoginInfo;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.encrypt.Base64Tool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.response.Response;

public class TokenHelper {
    public static Response<String> generateToken(LoginInfo loginInfo) {
        if (loginInfo == null || StringTool.isBlank((String)loginInfo.getUserId()) || StringTool.isBlank((String)loginInfo.getSignature())) {
            return Response.ofFail((String)"generateToken fail, invalid loginInfo.");
        }
        LoginInfo loginInfoForToken = new LoginInfo(loginInfo.getUserId(), loginInfo.getSignature());
        String json = GsonTool.toJson((Object)loginInfoForToken);
        String token = Base64Tool.encodeUrlSafe((String)json);
        return Response.ofSuccess((Object)token);
    }

    public static LoginInfo parseToken(String token) {
        try {
            if (StringTool.isBlank((String)token)) {
                return null;
            }
            String json = Base64Tool.decodeUrlSafe((String)token);
            return (LoginInfo)GsonTool.fromJson((String)json, LoginInfo.class);
        }
        catch (Exception e) {
            return null;
        }
    }
}

