/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.solon.integration;

import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.solon.NodeBreakComponentOfMethod;
import com.yomahub.liteflow.solon.NodeComponentOfMethod;
import com.yomahub.liteflow.solon.NodeForComponentOfMethod;
import com.yomahub.liteflow.solon.NodeIfComponentOfMethod;
import com.yomahub.liteflow.solon.NodeSwitchComponentOfMethod;
import com.yomahub.liteflow.solon.NodeWhileComponentOfMethod;
import com.yomahub.liteflow.solon.config.LiteflowAutoConfiguration;
import com.yomahub.liteflow.solon.config.LiteflowMainAutoConfiguration;
import com.yomahub.liteflow.solon.config.LiteflowMonitorProperty;
import com.yomahub.liteflow.solon.config.LiteflowProperty;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;

public class XPluginImpl
implements Plugin {
    public void start(AopContext context) {
        boolean enable;
        Properties defProps = Utils.loadProperties((String)"META-INF/liteflow-default.properties");
        if (defProps != null && defProps.size() > 0) {
            defProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> context.cfg().putIfAbsent(k, v)));
        }
        if (!(enable = context.cfg().getBool("liteflow.enable", false))) {
            return;
        }
        context.beanMake(LiteflowProperty.class);
        context.beanMake(LiteflowMonitorProperty.class);
        context.beanMake(LiteflowAutoConfiguration.class);
        context.beanMake(LiteflowMainAutoConfiguration.class);
        context.subWrapsOfType(NodeComponent.class, bw -> {
            NodeComponent node1 = (NodeComponent)bw.raw();
            node1.setNodeId(bw.name());
            FlowBus.addSpringScanNode((String)bw.name(), (NodeComponent)((NodeComponent)bw.raw()));
        });
        context.beanExtractorAdd(LiteflowMethod.class, (bw, method, anno) -> {
            Object node1 = null;
            switch (anno.value()) {
                case PROCESS_SWITCH: {
                    node1 = new NodeSwitchComponentOfMethod(bw, method, anno.value());
                    break;
                }
                case PROCESS_IF: {
                    node1 = new NodeIfComponentOfMethod(bw, method, anno.value());
                    break;
                }
                case PROCESS_FOR: {
                    node1 = new NodeForComponentOfMethod(bw, method, anno.value());
                    break;
                }
                case PROCESS_WHILE: {
                    node1 = new NodeWhileComponentOfMethod(bw, method, anno.value());
                    break;
                }
                case PROCESS_BREAK: {
                    node1 = new NodeBreakComponentOfMethod(bw, method, anno.value());
                    break;
                }
                default: {
                    node1 = new NodeComponentOfMethod(bw, method, anno.value());
                }
            }
            String nodeId = Utils.annoAlias((String)anno.nodeId(), (String)bw.name());
            node1.setNodeId(nodeId);
            node1.setType(anno.nodeType());
            FlowBus.addSpringScanNode((String)nodeId, (NodeComponent)node1);
        });
        context.beanBuilderAdd(LiteflowComponent.class, (clz, bw, anno) -> {
            if (NodeComponent.class.isAssignableFrom(clz)) {
                NodeComponent node1 = (NodeComponent)bw.raw();
                String nodeId = Utils.annoAlias((String)anno.id(), (String)anno.value());
                node1.setNodeId(nodeId);
                node1.setName(anno.name());
                FlowBus.addSpringScanNode((String)nodeId, (NodeComponent)node1);
            } else {
                context.beanExtract(bw);
            }
        });
    }
}

