/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.task.spring;

import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.core.rpc.TLogRPCHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SpringScheduledTaskAop {
    private static final Logger log = LoggerFactory.getLogger(SpringScheduledTaskAop.class);
    private final TLogRPCHandler tLogRPCHandler = new TLogRPCHandler();

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        try {
            this.tLogRPCHandler.processProviderSide(new TLogLabelBean());
            Object object = jp.proceed();
            return object;
        }
        finally {
            this.tLogRPCHandler.cleanThreadLocal();
        }
    }
}

