/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.qianfan.QianFanChatOptions;
import org.springframework.ai.qianfan.api.QianFanApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class QianFanChatModel
implements ChatModel,
StreamingChatModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanChatModel.class);
    private final QianFanChatOptions defaultOptions;
    public final RetryTemplate retryTemplate;
    private final QianFanApi qianFanApi;

    public QianFanChatModel(QianFanApi qianFanApi) {
        this(qianFanApi, QianFanChatOptions.builder().withModel(QianFanApi.DEFAULT_CHAT_MODEL).withTemperature(Float.valueOf(0.7f)).build());
    }

    public QianFanChatModel(QianFanApi qianFanApi, QianFanChatOptions options) {
        this(qianFanApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanChatModel(QianFanApi qianFanApi, QianFanChatOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)qianFanApi, (String)"QianFanApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.qianFanApi = qianFanApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public ChatResponse call(Prompt prompt) {
        QianFanApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        return (ChatResponse)this.retryTemplate.execute(ctx -> {
            ResponseEntity<QianFanApi.ChatCompletion> completionEntity = this.doChatCompletion(request);
            QianFanApi.ChatCompletion chatCompletion = (QianFanApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            Generation generation = new Generation(chatCompletion.result(), Map.of("id", chatCompletion.id(), "role", QianFanApi.ChatCompletionMessage.Role.ASSISTANT));
            return new ChatResponse(Collections.singletonList(generation));
        });
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        QianFanApi.ChatCompletionRequest request = this.createRequest(prompt, true);
        return (Flux)this.retryTemplate.execute(ctx -> {
            Flux<QianFanApi.ChatCompletionChunk> completionChunks = this.qianFanApi.chatCompletionStream(request);
            return completionChunks.map(this::toChatCompletion).map(chatCompletion -> {
                String id = chatCompletion.id();
                Generation generation = new Generation(chatCompletion.result(), Map.of("id", id, "role", QianFanApi.ChatCompletionMessage.Role.ASSISTANT));
                return new ChatResponse(Collections.singletonList(generation));
            });
        });
    }

    private QianFanApi.ChatCompletion toChatCompletion(QianFanApi.ChatCompletionChunk chunk) {
        return new QianFanApi.ChatCompletion(chunk.id(), chunk.object(), chunk.created(), chunk.result(), chunk.usage());
    }

    public QianFanApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<QianFanApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(m -> new QianFanApi.ChatCompletionMessage(m.getContent(), QianFanApi.ChatCompletionMessage.Role.valueOf(m.getMessageType().name()))).toList();
        List<QianFanApi.ChatCompletionMessage> systemMessageList = chatCompletionMessages.stream().filter(msg -> msg.role() == QianFanApi.ChatCompletionMessage.Role.SYSTEM).toList();
        if (systemMessageList.size() > 1) {
            throw new IllegalArgumentException("Only one system message is allowed in the prompt");
        }
        String systemMessage = systemMessageList.isEmpty() ? null : systemMessageList.get(0).content();
        QianFanApi.ChatCompletionRequest request = new QianFanApi.ChatCompletionRequest(chatCompletionMessages, systemMessage, stream);
        if (this.defaultOptions != null) {
            request = (QianFanApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)request, QianFanApi.ChatCompletionRequest.class);
        }
        if (prompt.getOptions() != null) {
            ModelOptions modelOptions = prompt.getOptions();
            if (modelOptions instanceof ChatOptions) {
                ChatOptions runtimeOptions = (ChatOptions)modelOptions;
                QianFanChatOptions updatedRuntimeOptions = (QianFanChatOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, ChatOptions.class, QianFanChatOptions.class);
                request = (QianFanApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, QianFanApi.ChatCompletionRequest.class);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type ChatOptions: " + prompt.getOptions().getClass().getSimpleName());
            }
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return QianFanChatOptions.fromOptions(this.defaultOptions);
    }

    private ResponseEntity<QianFanApi.ChatCompletion> doChatCompletion(QianFanApi.ChatCompletionRequest request) {
        return this.qianFanApi.chatCompletionEntity(request);
    }
}

