/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.qianfan.QianFanEmbeddingOptions;
import org.springframework.ai.qianfan.api.QianFanApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class QianFanEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanEmbeddingModel.class);
    private final QianFanEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final QianFanApi qianFanApi;
    private final MetadataMode metadataMode;

    public QianFanEmbeddingModel(QianFanApi qianFanApi) {
        this(qianFanApi, MetadataMode.EMBED);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode) {
        this(qianFanApi, metadataMode, QianFanEmbeddingOptions.builder().withModel(QianFanApi.DEFAULT_EMBEDDING_MODEL).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode, QianFanEmbeddingOptions qianFanEmbeddingOptions) {
        this(qianFanApi, metadataMode, qianFanEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode, QianFanEmbeddingOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)qianFanApi, (String)"QianFanApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.qianFanApi = qianFanApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public List<Double> embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        return (EmbeddingResponse)this.retryTemplate.execute(ctx -> {
            QianFanApi.EmbeddingList apiEmbeddingResponse;
            QianFanApi.EmbeddingRequest apiRequest;
            QianFanApi.EmbeddingRequest embeddingRequest = apiRequest = this.defaultOptions != null ? new QianFanApi.EmbeddingRequest(request.getInstructions(), this.defaultOptions.getModel(), this.defaultOptions.getUser()) : new QianFanApi.EmbeddingRequest(request.getInstructions());
            if (request.getOptions() != null && !EmbeddingOptions.EMPTY.equals((Object)request.getOptions())) {
                apiRequest = (QianFanApi.EmbeddingRequest)ModelOptionsUtils.merge((Object)request.getOptions(), (Object)apiRequest, QianFanApi.EmbeddingRequest.class);
            }
            if ((apiEmbeddingResponse = (QianFanApi.EmbeddingList)this.qianFanApi.embeddings(apiRequest).getBody()) == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            if (apiEmbeddingResponse.errorNsg() != null) {
                logger.error("Error message returned for request: {}", (Object)apiEmbeddingResponse.errorNsg());
                throw new RuntimeException("Embedding failed: error code:" + apiEmbeddingResponse.errorCode() + ", message:" + apiEmbeddingResponse.errorNsg());
            }
            EmbeddingResponseMetadata metadata = this.generateResponseMetadata(apiEmbeddingResponse.model(), apiEmbeddingResponse.usage());
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            return new EmbeddingResponse(embeddings, metadata);
        });
    }

    private EmbeddingResponseMetadata generateResponseMetadata(String model, QianFanApi.Usage usage) {
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.put((Object)"model", (Object)model);
        metadata.put((Object)"prompt-tokens", (Object)usage.promptTokens());
        metadata.put((Object)"total-tokens", (Object)usage.totalTokens());
        return metadata;
    }
}

