/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.qianfan.QianFanImageOptions;
import org.springframework.ai.qianfan.api.QianFanImageApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class QianFanImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanImageModel.class);
    private final QianFanImageOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final QianFanImageApi qianFanImageApi;

    public QianFanImageModel(QianFanImageApi qianFanImageApi) {
        this(qianFanImageApi, QianFanImageOptions.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanImageModel(QianFanImageApi qianFanImageApi, QianFanImageOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)qianFanImageApi, (String)"QianFanImageApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.qianFanImageApi = qianFanImageApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        return (ImageResponse)this.retryTemplate.execute(ctx -> {
            String instructions = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
            QianFanImageApi.QianFanImageRequest imageRequest = new QianFanImageApi.QianFanImageRequest(instructions, QianFanImageApi.DEFAULT_IMAGE_MODEL);
            if (this.defaultOptions != null) {
                imageRequest = (QianFanImageApi.QianFanImageRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)imageRequest, QianFanImageApi.QianFanImageRequest.class);
            }
            if (imagePrompt.getOptions() != null) {
                imageRequest = (QianFanImageApi.QianFanImageRequest)ModelOptionsUtils.merge((Object)this.toQianFanImageOptions(imagePrompt.getOptions()), (Object)imageRequest, QianFanImageApi.QianFanImageRequest.class);
            }
            ResponseEntity<QianFanImageApi.QianFanImageResponse> imageResponseEntity = this.qianFanImageApi.createImage(imageRequest);
            return this.convertResponse(imageResponseEntity, imageRequest);
        });
    }

    private ImageResponse convertResponse(ResponseEntity<QianFanImageApi.QianFanImageResponse> imageResponseEntity, QianFanImageApi.QianFanImageRequest qianFanImageRequest) {
        QianFanImageApi.QianFanImageResponse imageApiResponse = (QianFanImageApi.QianFanImageResponse)imageResponseEntity.getBody();
        if (imageApiResponse == null) {
            logger.warn("No image response returned for request: {}", (Object)qianFanImageRequest);
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = imageApiResponse.data().stream().map(entry -> new ImageGeneration(new Image(null, entry.b64Image()))).toList();
        return new ImageResponse(imageGenerationList);
    }

    private QianFanImageOptions toQianFanImageOptions(ImageOptions runtimeImageOptions) {
        QianFanImageOptions.Builder qianFanImageOptionsBuilder = QianFanImageOptions.builder();
        if (runtimeImageOptions != null) {
            if (runtimeImageOptions.getN() != null) {
                qianFanImageOptionsBuilder.withN(runtimeImageOptions.getN());
            }
            if (runtimeImageOptions.getModel() != null) {
                qianFanImageOptionsBuilder.withModel(runtimeImageOptions.getModel());
            }
            if (runtimeImageOptions.getWidth() != null) {
                qianFanImageOptionsBuilder.withWidth(runtimeImageOptions.getWidth());
            }
            if (runtimeImageOptions.getHeight() != null) {
                qianFanImageOptionsBuilder.withHeight(runtimeImageOptions.getHeight());
            }
            if (runtimeImageOptions instanceof QianFanImageOptions) {
                QianFanImageOptions runtimeQianFanImageOptions = (QianFanImageOptions)runtimeImageOptions;
                if (runtimeQianFanImageOptions.getStyle() != null) {
                    qianFanImageOptionsBuilder.withStyle(runtimeQianFanImageOptions.getStyle());
                }
                if (runtimeQianFanImageOptions.getUser() != null) {
                    qianFanImageOptionsBuilder.withUser(runtimeQianFanImageOptions.getUser());
                }
            }
        }
        return qianFanImageOptionsBuilder.build();
    }
}

