/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.springframework.ai.image.ImageOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QianFanImageOptions
implements ImageOptions {
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="size_width")
    private Integer width;
    @JsonProperty(value="size_height")
    private Integer height;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="style")
    private String style;
    @JsonProperty(value="user_id")
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
        this.size = this.width + "x" + this.height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getResponseFormat() {
        return null;
    }

    public void setHeight(Integer height) {
        this.height = height;
        this.size = this.width + "x" + this.height;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        return this.width != null && this.height != null ? this.width + "x" + this.height : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QianFanImageOptions)) {
            return false;
        }
        QianFanImageOptions that = (QianFanImageOptions)o;
        return Objects.equals(this.n, that.n) && Objects.equals(this.model, that.model) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.size, that.size) && Objects.equals(this.style, that.style) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.n, this.model, this.width, this.height, this.size, this.style, this.user);
    }

    public String toString() {
        return "QianFanImageOptions{n=" + this.n + ", model='" + this.model + "', width=" + this.width + ", height=" + this.height + ", size='" + this.size + "', style='" + this.style + "', user='" + this.user + "'}";
    }

    public static class Builder {
        private final QianFanImageOptions options = new QianFanImageOptions();

        private Builder() {
        }

        public Builder withN(Integer n) {
            this.options.setN(n);
            return this;
        }

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withWidth(Integer width) {
            this.options.setWidth(width);
            return this;
        }

        public Builder withHeight(Integer height) {
            this.options.setHeight(height);
            return this;
        }

        public Builder withStyle(String style) {
            this.options.setStyle(style);
            return this;
        }

        public Builder withUser(String user) {
            this.options.setUser(user);
            return this;
        }

        public QianFanImageOptions build() {
            return this.options;
        }
    }
}

