/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.qianfan.api.ApiUtils;
import org.springframework.ai.qianfan.api.auth.AuthApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QianFanApi
extends AuthApi {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.ERNIE_Speed_8K.getValue();
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.BGE_LARGE_ZH.getValue();
    private static final Predicate<ChatCompletionChunk> SSE_DONE_PREDICATE = ChatCompletionChunk::end;
    private final RestClient restClient;
    private final WebClient webClient;

    public QianFanApi(String apiKey, String secretKey) {
        this("https://aip.baidubce.com/rpc/2.0/ai_custom", apiKey, secretKey);
    }

    public QianFanApi(String baseUrl, String apiKey, String secretKey) {
        this(baseUrl, apiKey, secretKey, RestClient.builder());
    }

    public QianFanApi(String baseUrl, String apiKey, String secretKey, RestClient.Builder restClientBuilder) {
        this(baseUrl, apiKey, secretKey, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public QianFanApi(String baseUrl, String apiKey, String secretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this(baseUrl, apiKey, secretKey, restClientBuilder, WebClient.builder(), responseErrorHandler);
    }

    public QianFanApi(String baseUrl, String apiKey, String secretKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        super(apiKey, secretKey);
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders()).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders()).build();
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the steam property to false.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/wenxinworkshop/chat/{model}?access_token={token}", new Object[]{chatRequest.model, this.getAccessToken()})).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the steam property to true.");
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/wenxinworkshop/chat/{model}?access_token={token}", new Object[]{chatRequest.model, this.getAccessToken()})).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(ChatCompletionChunk.class).takeUntil(SSE_DONE_PREDICATE);
    }

    public ResponseEntity<EmbeddingList> embeddings(EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull(embeddingRequest.texts(), (String)"The input can not be null.");
        Assert.isTrue((!CollectionUtils.isEmpty(embeddingRequest.texts()) ? 1 : 0) != 0, (String)"The input list can not be empty.");
        Assert.isTrue((embeddingRequest.texts().size() <= 16 ? 1 : 0) != 0, (String)"The list must be 16 dimensions or less");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/wenxinworkshop/embeddings/{model}?access_token={token}", new Object[]{embeddingRequest.model, this.getAccessToken()})).body((Object)embeddingRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<EmbeddingList>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="system") String system, @JsonProperty(value="model") String model, @JsonProperty(value="frequency_penalty") Float frequencyPenalty, @JsonProperty(value="max_output_tokens") Integer maxTokens, @JsonProperty(value="presence_penalty") Float presencePenalty, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="top_p") Float topP) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String system, String model, Float temperature) {
            this(messages, system, model, null, null, null, null, null, false, temperature, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String system, String model, Float temperature, boolean stream) {
            this(messages, system, model, null, null, null, null, null, stream, temperature, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String system, Boolean stream) {
            this(messages, system, DEFAULT_CHAT_MODEL, null, null, null, null, null, stream, Float.valueOf(0.8f), null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ResponseFormat(@JsonProperty(value="type") String type) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="created") Long created, @JsonProperty(value="result") String result, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="created") Long created, @JsonProperty(value="result") String result, @JsonProperty(value="is_end") Boolean end, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest(@JsonProperty(value="input") List<String> texts, @JsonProperty(value="model") String model, @JsonProperty(value="user_id") String user) {
        public EmbeddingRequest(String text) {
            this(List.of(text), DEFAULT_EMBEDDING_MODEL, null);
        }

        public EmbeddingRequest(String text, String model, String userId) {
            this(List.of(text), model, userId);
        }

        public EmbeddingRequest(List<String> texts) {
            this(texts, DEFAULT_EMBEDDING_MODEL, null);
        }

        public EmbeddingRequest(List<String> texts, String model) {
            this(texts, model, null);
        }
    }

    public static enum ChatModel {
        ERNIE_4_0_8K("completions_pro"),
        ERNIE_4_0_8K_Preview("ernie-4.0-8k-preview"),
        ERNIE_4_0_8K_Preview_0518("completions_adv_pro"),
        ERNIE_4_0_8K_0329("ernie-4.0-8k-0329"),
        ERNIE_4_0_8K_0104("ernie-4.0-8k-0104"),
        ERNIE_3_5_8K("completions"),
        ERNIE_3_5_128K("ernie-3.5-128k"),
        ERNIE_3_5_8K_Preview("ernie-3.5-8k-preview"),
        ERNIE_3_5_8K_0205("ernie-3.5-8k-0205"),
        ERNIE_3_5_8K_0329("ernie-3.5-8k-0329"),
        ERNIE_3_5_8K_1222("ernie-3.5-8k-1222"),
        ERNIE_3_5_4K_0205("ernie-3.5-4k-0205"),
        ERNIE_Lite_8K_0922("eb-instant"),
        ERNIE_Lite_8K_0308("ernie-lite-8k"),
        ERNIE_Speed_8K("ernie_speed"),
        ERNIE_Speed_128K("ernie-speed-128k"),
        ERNIE_Tiny_8K("ernie-tiny-8k"),
        ERNIE_FUNC_8K("ernie-func-8k");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum EmbeddingModel {
        EMBEDDING_V1("embedding-v1"),
        BGE_LARGE_ZH("bge_large_zh"),
        BGE_LARGE_EN("bge_large_en"),
        TAO_8K("tao_8k");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingList(@JsonProperty(value="object") String object, @JsonProperty(value="data") List<Embedding> data, @JsonProperty(value="model") String model, @JsonProperty(value="error_code") String errorCode, @JsonProperty(value="error_msg") String errorNsg, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embedding(@JsonProperty(value="index") Integer index, @JsonProperty(value="embedding") List<Double> embedding, @JsonProperty(value="object") String object) {
        public Embedding(Integer index, List<Double> embedding) {
            this(index, embedding, "embedding");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Usage(@JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role) {
        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT;

        }
    }
}

