/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.types.CoreApiException;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.type.functional.ExceptionCreator;

public final class ErrorCase<ExceptionType extends CoreApiException> {
    public static final String DEFAULT = "DEFAULT";
    private String reason;
    private ExceptionCreator<ExceptionType> exceptionCreator;

    private ErrorCase(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        this.reason = reason;
        this.exceptionCreator = exceptionCreator;
    }

    public void throwException(Context httpContext) throws ExceptionType {
        throw (CoreApiException)this.exceptionCreator.apply(this.reason, httpContext);
    }

    public static <ExceptionType extends CoreApiException> ErrorCase<ExceptionType> create(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        ErrorCase<ExceptionType> errorCase = new ErrorCase<ExceptionType>(reason, exceptionCreator);
        return errorCase;
    }
}

