/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.configurations.http.client;

import io.apimatic.coreinterfaces.http.proxy.ProxyConfiguration;

public final class CoreProxyConfiguration
implements ProxyConfiguration {
    private final String address;
    private final int port;
    private final String username;
    private final String password;

    private CoreProxyConfiguration(String address, int port, String username, String password) {
        this.address = address;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Builder newBuilder() {
        return new Builder(this.address, this.port).username(this.username).password(this.password);
    }

    public String toString() {
        return "CoreProxyConfiguration [address=" + this.address + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + "]";
    }

    public static class Builder {
        private final String address;
        private final int port;
        private String username;
        private String password;

        public Builder(String address, int port) {
            this.address = address;
            this.port = port;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public CoreProxyConfiguration build() {
            return new CoreProxyConfiguration(this.address, this.port, this.username, this.password);
        }
    }
}

