/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.handler;

import com.dtp.adapter.web.handler.WebServerTpHandler;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.config.DtpProperties;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;

public abstract class AbstractWebServerTpHandler
implements WebServerTpHandler,
InitializingBean {
    protected volatile Executor webServerExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Executor getWebServerTp() {
        if (this.webServerExecutor != null) return this.webServerExecutor;
        Class<AbstractWebServerTpHandler> clazz = AbstractWebServerTpHandler.class;
        synchronized (AbstractWebServerTpHandler.class) {
            if (this.webServerExecutor != null) return this.webServerExecutor;
            ApplicationContext applicationContext = ApplicationContextHolder.getInstance();
            WebServer webServer = ((WebServerApplicationContext)applicationContext).getWebServer();
            this.webServerExecutor = this.doGetTp(webServer);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.webServerExecutor;
        }
    }

    protected abstract Executor doGetTp(WebServer var1);

    public void afterPropertiesSet() {
        DtpProperties dtpProperties = (DtpProperties)ApplicationContextHolder.getBean(DtpProperties.class);
        this.updateWebServerTp(dtpProperties);
    }
}

