/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.handler;

import com.dtp.adapter.web.handler.AbstractWebServerTpHandler;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.web.JettyThreadPool;
import com.dtp.common.dto.ThreadPoolStats;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;

public class JettyTpHandler
extends AbstractWebServerTpHandler {
    private static final Logger log = LoggerFactory.getLogger(JettyTpHandler.class);

    @Override
    public Executor doGetTp(WebServer webServer) {
        JettyWebServer jettyWebServer = (JettyWebServer)webServer;
        return jettyWebServer.getServer().getThreadPool();
    }

    @Override
    public ThreadPoolStats getPoolStats() {
        ThreadPool.SizedThreadPool threadPool = (ThreadPool.SizedThreadPool)this.getWebServerTp();
        ThreadPoolStats poolStats = ThreadPoolStats.builder().corePoolSize(threadPool.getMinThreads()).maximumPoolSize(threadPool.getMaxThreads()).dtpName("jettyWebServerTp").build();
        if (threadPool instanceof QueuedThreadPool) {
            QueuedThreadPool queuedThreadPool = (QueuedThreadPool)threadPool;
            poolStats.setActiveCount(queuedThreadPool.getBusyThreads());
            poolStats.setQueueSize(queuedThreadPool.getQueueSize());
            poolStats.setPoolSize(queuedThreadPool.getThreads());
        }
        return poolStats;
    }

    @Override
    public void updateWebServerTp(DtpProperties dtpProperties) {
        JettyThreadPool jettyTp = dtpProperties.getJettyTp();
        if (Objects.isNull(jettyTp)) {
            return;
        }
        int oldMinThreads = this.convertAndGet().getMinThreads();
        int oldMaxThreads = this.convertAndGet().getMaxThreads();
        this.convertAndGet().setMinThreads(jettyTp.getMin());
        this.convertAndGet().setMaxThreads(jettyTp.getMax());
        log.info("DynamicTp jettyWebServerTp refreshed end, minThreads: [{}], maxThreads: [{}]", (Object)String.format("%s => %s", oldMinThreads, jettyTp.getMin()), (Object)String.format("%s => %s", oldMaxThreads, jettyTp.getMax()));
    }

    private ThreadPool.SizedThreadPool convertAndGet() {
        return (ThreadPool.SizedThreadPool)this.getWebServerTp();
    }
}

