/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.handler;

import com.dtp.adapter.web.handler.AbstractWebServerTpHandler;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.web.TomcatThreadPool;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.em.RejectedTypeEnum;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatTpHandler
extends AbstractWebServerTpHandler {
    private static final Logger log = LoggerFactory.getLogger(TomcatTpHandler.class);

    @Override
    public Executor doGetTp(WebServer webServer) {
        TomcatWebServer tomcatWebServer = (TomcatWebServer)webServer;
        return tomcatWebServer.getTomcat().getConnector().getProtocolHandler().getExecutor();
    }

    @Override
    public ThreadPoolStats getPoolStats() {
        ThreadPoolExecutor executor = this.convertAndGet();
        return ThreadPoolStats.builder().corePoolSize(executor.getCorePoolSize()).maximumPoolSize(executor.getMaximumPoolSize()).queueType(executor.getQueue().getClass().getSimpleName()).queueCapacity(executor.getQueue().size() + executor.getQueue().remainingCapacity()).queueSize(executor.getQueue().size()).queueRemainingCapacity(executor.getQueue().remainingCapacity()).activeCount(executor.getActiveCount()).taskCount(executor.getTaskCount()).completedTaskCount(executor.getCompletedTaskCount()).largestPoolSize(executor.getLargestPoolSize()).poolSize(executor.getPoolSize()).waitTaskCount(executor.getQueue().size()).rejectHandlerName(RejectedTypeEnum.formatRejectName((String)executor.getRejectedExecutionHandler().getClass().getSimpleName())).dtpName("tomcatWebServerTp").build();
    }

    @Override
    public void updateWebServerTp(DtpProperties dtpProperties) {
        TomcatThreadPool tomcatTp = dtpProperties.getTomcatTp();
        if (Objects.isNull(tomcatTp)) {
            return;
        }
        int oldMinSpare = this.convertAndGet().getCorePoolSize();
        int oldMax = this.convertAndGet().getMaximumPoolSize();
        this.convertAndGet().setCorePoolSize(tomcatTp.getMinSpare());
        this.convertAndGet().setMaximumPoolSize(tomcatTp.getMax());
        log.info("DynamicTp tomcatWebServerTp refreshed end, minSpare: [{}], max: [{}]", (Object)String.format("%s => %s", oldMinSpare, tomcatTp.getMinSpare()), (Object)String.format("%s => %s", oldMax, tomcatTp.getMax()));
    }

    private ThreadPoolExecutor convertAndGet() {
        return (ThreadPoolExecutor)this.getWebServerTp();
    }
}

