/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.listener;

import com.dtp.adapter.web.handler.WebServerTpHandler;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.event.RefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;

public class DtpWebRefreshListener
implements ApplicationListener<RefreshEvent> {
    private static final Logger log = LoggerFactory.getLogger(DtpWebRefreshListener.class);

    public void onApplicationEvent(RefreshEvent event) {
        ApplicationContext applicationContext = ApplicationContextHolder.getInstance();
        if (!(applicationContext instanceof WebServerApplicationContext)) {
            return;
        }
        try {
            WebServerTpHandler webServerTpHandler = (WebServerTpHandler)ApplicationContextHolder.getBean(WebServerTpHandler.class);
            webServerTpHandler.updateWebServerTp(event.getDtpProperties());
        }
        catch (Exception e) {
            log.error("DynamicTp refresh, update web server thread pool failed.", (Throwable)e);
        }
    }
}

