/*
 * Decompiled with CFR 0.152.
 */
package com.benjaminwan.ocrlibrary;

import com.benjaminwan.ocrlibrary.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class TextBlock {
    private final ArrayList<Point> boxPoint;
    private final float boxScore;
    private final int angleIndex;
    private final float angleScore;
    private final double angleTime;
    private final String text;
    private final float[] charScores;
    private final double crnnTime;
    private final double blockTime;

    public TextBlock(ArrayList<Point> boxPoint, float boxScore, int angleIndex, float angleScore, double angleTime, String text, float[] charScores, double crnnTime, double blockTime) {
        this.boxPoint = boxPoint;
        this.boxScore = boxScore;
        this.angleIndex = angleIndex;
        this.angleScore = angleScore;
        this.angleTime = angleTime;
        this.text = text;
        this.charScores = charScores;
        this.crnnTime = crnnTime;
        this.blockTime = blockTime;
    }

    public ArrayList<Point> getBoxPoint() {
        return this.boxPoint;
    }

    public float getBoxScore() {
        return this.boxScore;
    }

    public int getAngleIndex() {
        return this.angleIndex;
    }

    public float getAngleScore() {
        return this.angleScore;
    }

    public double getAngleTime() {
        return this.angleTime;
    }

    public String getText() {
        return this.text;
    }

    public float[] getCharScores() {
        return this.charScores;
    }

    public double getCrnnTime() {
        return this.crnnTime;
    }

    public double getBlockTime() {
        return this.blockTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBlock textBlock = (TextBlock)o;
        return Float.compare(textBlock.boxScore, this.boxScore) == 0 && this.angleIndex == textBlock.angleIndex && Float.compare(textBlock.angleScore, this.angleScore) == 0 && Double.compare(textBlock.angleTime, this.angleTime) == 0 && Double.compare(textBlock.crnnTime, this.crnnTime) == 0 && Double.compare(textBlock.blockTime, this.blockTime) == 0 && Objects.equals(this.boxPoint, textBlock.boxPoint) && Objects.equals(this.text, textBlock.text) && Arrays.equals(this.charScores, textBlock.charScores);
    }

    public int hashCode() {
        int result = Objects.hash(this.boxPoint, Float.valueOf(this.boxScore), this.angleIndex, Float.valueOf(this.angleScore), this.angleTime, this.text, this.crnnTime, this.blockTime);
        result = 31 * result + Arrays.hashCode(this.charScores);
        return result;
    }

    public String toString() {
        return "TextBlock{boxPoint=" + this.boxPoint + ", boxScore=" + this.boxScore + ", angleIndex=" + this.angleIndex + ", angleScore=" + this.angleScore + ", angleTime=" + this.angleTime + ", text='" + this.text + "', charScores=" + Arrays.toString(this.charScores) + ", crnnTime=" + this.crnnTime + ", blockTime=" + this.blockTime + "}";
    }
}

