/*
 * Decompiled with CFR 0.152.
 */
package io.github.mymonstercat.ocr;

import com.benjaminwan.ocrlibrary.OcrEngine;
import com.benjaminwan.ocrlibrary.OcrResult;
import io.github.mymonstercat.Model;
import io.github.mymonstercat.exception.LoadException;
import io.github.mymonstercat.loader.LibraryLoader;
import io.github.mymonstercat.loader.ModelsLoader;
import io.github.mymonstercat.ocr.LoadUtil;
import io.github.mymonstercat.ocr.config.HardwareConfig;
import io.github.mymonstercat.ocr.config.ParamConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferenceEngine
extends OcrEngine {
    private static final Logger log = LoggerFactory.getLogger(InferenceEngine.class);
    private Model model = Model.ONNX_PPOCR_V3;
    private HardwareConfig hardwareConfig = HardwareConfig.getOnnxConfig();
    private static InferenceEngine inferenceEngine;
    private static LibraryLoader nativeLoader;
    private static ModelsLoader modelsLoader;
    private static final AtomicBoolean isLibraryLoaded;

    private InferenceEngine() {
    }

    private InferenceEngine(Model model, HardwareConfig hardwareConfig) {
        this.model = model;
        this.hardwareConfig = hardwareConfig;
    }

    public static InferenceEngine getInstance(Model model) {
        return InferenceEngine.getInstance(model, HardwareConfig.getOnnxConfig());
    }

    public static InferenceEngine getInstance(Model model, HardwareConfig hardwareConfig) {
        if (inferenceEngine == null) {
            inferenceEngine = new InferenceEngine(model, hardwareConfig);
        }
        return inferenceEngine;
    }

    public OcrResult runOcr(String imagePath) {
        return this.runOcr(imagePath, ParamConfig.getDefaultConfig());
    }

    public OcrResult runOcr(String imagePath, ParamConfig config) {
        InferenceEngine.loadFileIfNeeded(this.model);
        this.initEngine(this.model, this.hardwareConfig);
        log.info("\u56fe\u7247\u8def\u5f84\uff1a{}\uff0c \u53c2\u6570\u914d\u7f6e\uff1a{}", (Object)imagePath, (Object)config);
        OcrResult result = this.detect(imagePath, config.getPadding(), config.getMaxSideLen(), config.getBoxScoreThresh(), config.getBoxThresh(), config.getUnClipRatio(), config.isDoAngle(), config.isMostAngle());
        log.info("\u8bc6\u522b\u7ed3\u679c\u4e3a\uff1a{}\uff0c\u8017\u65f6{}ms", (Object)result.getStrRes().replace("\n", ""), (Object)result.getDetectTime());
        log.debug("\u6587\u672c\u5757\uff1a{}\uff0cDbNet\u8017\u65f6{}ms", result.getTextBlocks(), (Object)result.getDbNetTime());
        return result;
    }

    private static synchronized void loadFileIfNeeded(Model model) {
        String modelType = model.getModelType();
        if (nativeLoader == null && isLibraryLoaded.compareAndSet(false, true)) {
            nativeLoader = LoadUtil.findLibLoader(modelType);
            if (nativeLoader == null) {
                throw new LoadException("\u627e\u4e0d\u5230\u5408\u9002\u7684\u672c\u673a\u52a0\u8f7d\u7a0b\u5e8f\u5b9e\u73b0\uff0c\u53ef\u80fd\u7684\u539f\u56e0\uff1a1.\u8fd0\u884c\u5e93\u53ef\u80fd\u6682\u65f6\u672a\u9002\u914d\u60a8\u7684\u673a\u578b! 2.\u4f7f\u7528\u7684\u6a21\u578b\u4e0e\u5f15\u5165\u7684jar\u5305\u4e0d\u5339\u914d\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u6a21\u578b\u4e3a\uff1a" + modelType + "\uff0c\u8bf7\u68c0\u67e5\u60a8\u5f15\u5165\u7684jar\u4f9d\u8d56\u662f\u5426\u6b63\u786e! 3.\u6253\u5305\u65f6\u672a\u6b63\u786e\u5f15\u5165\u8fd0\u884c\u5e93\uff0c\u4f8b\u5982\u6253\u5305\u7684\u662fwindow\u4f9d\u8d56\u5374\u5728linux\u4e0b\u8fd0\u884c!");
            }
            log.debug("\u5f53\u524d\u5e93\u52a0\u8f7d\u5668: {}", (Object)nativeLoader.getClass().getSimpleName());
            nativeLoader.loadLibrary();
            isLibraryLoaded.set(true);
        }
        if (modelsLoader == null) {
            modelsLoader = LoadUtil.findModelsLoader(modelType);
            if (modelsLoader == null) {
                throw new LoadException("\u672a\u80fd\u6210\u529f\u52a0\u8f7d\u6a21\u578b!");
            }
            log.debug("\u5f53\u524d\u6a21\u578b\u52a0\u8f7d\u5668: {}", (Object)modelsLoader.getClass().getSimpleName());
            modelsLoader.loadModels(model);
        }
    }

    static {
        isLibraryLoaded = new AtomicBoolean(false);
    }
}

