/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.api.common.GrpcBase;
import io.github.pnoker.api.common.GrpcPage;
import io.github.pnoker.common.constant.common.DefaultConstant;
import io.github.pnoker.common.entity.base.BaseBO;
import io.github.pnoker.common.entity.base.BaseDTO;
import io.github.pnoker.common.entity.common.Pages;
import io.github.pnoker.common.optional.LongOptional;
import io.github.pnoker.common.optional.StringOptional;
import io.github.pnoker.common.utils.LocalDateTimeUtil;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;

public class GrpcBuilderUtil {
    private GrpcBuilderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Pages buildPagesByGrpcPage(GrpcPage page) {
        if (Objects.isNull(page)) {
            GrpcPage.Builder builder = GrpcPage.newBuilder();
            builder.setCurrent(1L);
            builder.setPages(DefaultConstant.PAGE_SIZE.intValue());
            page = builder.build();
        }
        Pages pages = new Pages();
        long current = page.getCurrent() < 1L ? 1L : page.getCurrent();
        long pageSize = page.getSize() < 1L ? (long)DefaultConstant.PAGE_SIZE.intValue() : page.getSize();
        pageSize = pageSize > (long)DefaultConstant.MAX_PAGE_SIZE.intValue() ? (long)DefaultConstant.MAX_PAGE_SIZE.intValue() : pageSize;
        pages.setCurrent(current);
        pages.setSize(pageSize);
        return pages;
    }

    public static <T extends BaseBO> GrpcBase buildGrpcBaseByBO(T entityBO) {
        if (Objects.isNull(entityBO)) {
            return null;
        }
        GrpcBase.Builder builder = GrpcBase.newBuilder();
        Optional.ofNullable(entityBO.getId()).ifPresentOrElse(builder::setId, () -> builder.setId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityBO.getRemark()).ifPresent(builder::setRemark);
        Optional.ofNullable(entityBO.getCreatorId()).ifPresentOrElse(builder::setCreatorId, () -> builder.setCreatorId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityBO.getCreatorName()).ifPresent(builder::setCreatorName);
        Optional.ofNullable(entityBO.getCreateTime()).ifPresent(value -> builder.setCreateTime(LocalDateTimeUtil.milliSeconds((LocalDateTime)value)));
        Optional.ofNullable(entityBO.getOperatorId()).ifPresentOrElse(builder::setOperatorId, () -> builder.setOperatorId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityBO.getOperatorName()).ifPresent(builder::setOperatorName);
        Optional.ofNullable(entityBO.getOperateTime()).ifPresent(value -> builder.setOperateTime(LocalDateTimeUtil.milliSeconds((LocalDateTime)value)));
        return builder.build();
    }

    public static <T extends BaseBO> void buildBaseBOByGrpcBase(GrpcBase entityGrpc, T entityBO) {
        if (Objects.isNull(entityGrpc)) {
            return;
        }
        LongOptional.ofNullable((Long)entityGrpc.getId()).ifPresent(arg_0 -> entityBO.setId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getRemark()).ifPresent(arg_0 -> entityBO.setRemark(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getCreatorId()).ifPresent(arg_0 -> entityBO.setCreatorId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getCreatorName()).ifPresent(arg_0 -> entityBO.setCreatorName(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getCreateTime()).ifPresent(value -> entityBO.setCreateTime(LocalDateTimeUtil.localDateTime((long)value)));
        LongOptional.ofNullable((Long)entityGrpc.getOperatorId()).ifPresent(arg_0 -> entityBO.setOperatorId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getOperatorName()).ifPresent(arg_0 -> entityBO.setOperatorName(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getOperateTime()).ifPresent(value -> entityBO.setOperateTime(LocalDateTimeUtil.localDateTime((long)value)));
    }

    public static <T extends BaseDTO> GrpcBase buildGrpcBaseByDTO(T entityDTO) {
        if (Objects.isNull(entityDTO)) {
            return null;
        }
        GrpcBase.Builder builder = GrpcBase.newBuilder();
        Optional.ofNullable(entityDTO.getId()).ifPresentOrElse(builder::setId, () -> builder.setId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityDTO.getRemark()).ifPresent(builder::setRemark);
        Optional.ofNullable(entityDTO.getCreatorId()).ifPresentOrElse(builder::setCreatorId, () -> builder.setCreatorId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityDTO.getCreatorName()).ifPresent(builder::setCreatorName);
        Optional.ofNullable(entityDTO.getCreateTime()).ifPresent(value -> builder.setCreateTime(LocalDateTimeUtil.milliSeconds((LocalDateTime)value)));
        Optional.ofNullable(entityDTO.getOperatorId()).ifPresentOrElse(builder::setOperatorId, () -> builder.setOperatorId(DefaultConstant.NULL_INT.intValue()));
        Optional.ofNullable(entityDTO.getOperatorName()).ifPresent(builder::setOperatorName);
        Optional.ofNullable(entityDTO.getOperateTime()).ifPresent(time -> builder.setOperateTime(LocalDateTimeUtil.milliSeconds((LocalDateTime)time)));
        return builder.build();
    }

    public static <T extends BaseDTO> void buildBaseDTOByGrpcBase(GrpcBase entityGrpc, T entityDTO) {
        if (Objects.isNull(entityGrpc)) {
            return;
        }
        LongOptional.ofNullable((Long)entityGrpc.getId()).ifPresent(arg_0 -> entityDTO.setId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getRemark()).ifPresent(arg_0 -> entityDTO.setRemark(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getCreatorId()).ifPresent(arg_0 -> entityDTO.setCreatorId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getCreatorName()).ifPresent(arg_0 -> entityDTO.setCreatorName(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getCreateTime()).ifPresent(value -> entityDTO.setCreateTime(LocalDateTimeUtil.localDateTime((long)value)));
        LongOptional.ofNullable((Long)entityGrpc.getOperatorId()).ifPresent(arg_0 -> entityDTO.setOperatorId(arg_0));
        StringOptional.ofNullable((String)entityGrpc.getOperatorName()).ifPresent(arg_0 -> entityDTO.setOperatorName(arg_0));
        LongOptional.ofNullable((Long)entityGrpc.getOperateTime()).ifPresent(value -> entityDTO.setOperateTime(LocalDateTimeUtil.localDateTime((long)value)));
    }
}

