/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.AbstractContractValidator;
import io.github.robwin.swagger.test.SchemaObjectResolver;
import io.github.robwin.swagger.test.SwaggerAssertionConfig;
import io.github.robwin.swagger.test.SwaggerAssertionType;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.ProxyableIterableAssert;
import org.assertj.core.api.ProxyableListAssert;
import org.assertj.core.api.ProxyableMapAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;

class ConsumerDrivenValidator
extends AbstractContractValidator {
    private SoftAssertions softAssertions;
    private SwaggerAssertionConfig assertionConfig;
    private Swagger actual;
    private SchemaObjectResolver schemaObjectResolver;

    ConsumerDrivenValidator(Swagger actual, SwaggerAssertionConfig assertionConfig) {
        this.actual = actual;
        this.assertionConfig = assertionConfig;
        this.softAssertions = new SoftAssertions();
    }

    @Override
    public void validateSwagger(Swagger expected, SchemaObjectResolver schemaObjectResolver) {
        Set<String> filter;
        this.schemaObjectResolver = schemaObjectResolver;
        this.validateInfo(this.actual.getInfo(), expected.getInfo());
        if (this.isAssertionEnabled(SwaggerAssertionType.PATHS)) {
            filter = this.assertionConfig.getPathsToIgnoreInExpected();
            Map<String, Path> expectedPaths = this.findExpectedPaths(expected, this.assertionConfig);
            Map<String, Path> actualPaths = this.getPathsIncludingBasePath(this.actual);
            this.validatePaths(actualPaths, this.removeAllFromMap(expectedPaths, filter));
        }
        if (this.isAssertionEnabled(SwaggerAssertionType.DEFINITIONS)) {
            filter = this.assertionConfig.getDefinitionsToIgnoreInExpected();
            this.validateDefinitions(this.actual.getDefinitions(), this.removeAllFromMap(expected.getDefinitions(), filter));
        }
        this.softAssertions.assertAll();
    }

    private void validateInfo(Info actualInfo, Info expectedInfo) {
        if (this.isAssertionEnabled(SwaggerAssertionType.VERSION)) {
            ((StringAssert)this.softAssertions.assertThat(actualInfo.getVersion()).as("Checking Version", new Object[0])).isEqualTo((Object)expectedInfo.getVersion());
        }
        if (this.isAssertionEnabled(SwaggerAssertionType.INFO)) {
            ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualInfo).as("Checking Info", new Object[0])).isEqualToComparingFieldByField((Object)expectedInfo);
        }
    }

    private void validatePaths(Map<String, Path> actualPaths, Map<String, Path> expectedPaths) {
        if (MapUtils.isNotEmpty(expectedPaths)) {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualPaths)) {
                ((ProxyableIterableAssert)this.softAssertions.assertThat(actualPaths.keySet()).as("Checking Paths", new Object[0])).containsAll(expectedPaths.keySet());
                for (Map.Entry<String, Path> actualPathEntry : actualPaths.entrySet()) {
                    Path expectedPath = expectedPaths.get(actualPathEntry.getKey());
                    Path actualPath = actualPathEntry.getValue();
                    String pathName = actualPathEntry.getKey();
                    this.validatePath(pathName, actualPath, expectedPath);
                }
            }
        } else {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualPaths).as("Checking Paths", new Object[0])).isNullOrEmpty();
        }
    }

    private void validateDefinitions(Map<String, Model> actualDefinitions, Map<String, Model> expectedDefinitions) {
        if (MapUtils.isNotEmpty(expectedDefinitions)) {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualDefinitions).as("Checking Definitions", new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitions)) {
                ((ProxyableIterableAssert)this.softAssertions.assertThat(actualDefinitions.keySet()).as("Checking Definitions", new Object[0])).containsAll(expectedDefinitions.keySet());
                for (Map.Entry<String, Model> expectedDefinitionEntry : expectedDefinitions.entrySet()) {
                    Model expectedDefinition = expectedDefinitionEntry.getValue();
                    Model actualDefinition = actualDefinitions.get(expectedDefinitionEntry.getKey());
                    String definitionName = expectedDefinitionEntry.getKey();
                    this.validateDefinition(definitionName, actualDefinition, expectedDefinition);
                }
            }
        }
    }

    private void validatePath(String pathName, Path actualPath, Path expectedPath) {
        if (expectedPath != null) {
            ((IntegerAssert)this.softAssertions.assertThat(actualPath.getOperations().size()).as("Checking number of operations of path '%s'", new Object[]{pathName})).isGreaterThanOrEqualTo(expectedPath.getOperations().size());
            this.validateOperation(actualPath.getGet(), expectedPath.getGet(), pathName, "GET");
            this.validateOperation(actualPath.getDelete(), expectedPath.getDelete(), pathName, "DELETE");
            this.validateOperation(actualPath.getPost(), expectedPath.getPost(), pathName, "POST");
            this.validateOperation(actualPath.getPut(), expectedPath.getPut(), pathName, "PUT");
            this.validateOperation(actualPath.getPatch(), expectedPath.getPatch(), pathName, "PATCH");
            this.validateOperation(actualPath.getOptions(), expectedPath.getOptions(), pathName, "OPTIONS");
        }
    }

    private void validateDefinition(String definitionName, Model actualDefinition, Model expectedDefinition) {
        if (expectedDefinition != null && actualDefinition != null) {
            this.validateModel(actualDefinition, expectedDefinition, String.format("Checking model of definition '%s", definitionName));
            this.validateDefinitionProperties(this.schemaObjectResolver.resolvePropertiesFromActual(actualDefinition), this.schemaObjectResolver.resolvePropertiesFromExpected(expectedDefinition), definitionName);
            if (expectedDefinition instanceof ModelImpl && actualDefinition instanceof ModelImpl) {
                this.validateDefinitionRequiredProperties(((ModelImpl)actualDefinition).getRequired(), ((ModelImpl)expectedDefinition).getRequired(), definitionName);
            }
        }
    }

    private void validateDefinitionRequiredProperties(List<String> actualRequiredProperties, List<String> expectedRequiredProperties, String definitionName) {
        if (CollectionUtils.isNotEmpty(expectedRequiredProperties)) {
            ((ProxyableListAssert)this.softAssertions.assertThat(actualRequiredProperties).as("Checking required properties of definition '%s'", new Object[]{definitionName})).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualRequiredProperties)) {
                Set<String> filteredExpectedProperties = this.filterWhitelistedPropertyNames(definitionName, new HashSet<String>(expectedRequiredProperties));
                ((ProxyableListAssert)this.softAssertions.assertThat(actualRequiredProperties).as("Checking required properties of definition '%s'", new Object[]{definitionName})).hasSameElementsAs(filteredExpectedProperties);
            }
        } else {
            ((ProxyableListAssert)this.softAssertions.assertThat(actualRequiredProperties).as("Checking required properties of definition '%s'", new Object[]{definitionName})).isNullOrEmpty();
        }
    }

    private void validateModel(Model actualDefinition, Model expectedDefinition, String message) {
        if (this.isAssertionEnabled(SwaggerAssertionType.MODELS)) {
            if (expectedDefinition instanceof ModelImpl) {
                ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ModelImpl.class);
            } else if (expectedDefinition instanceof RefModel) {
                ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(RefModel.class);
            } else if (expectedDefinition instanceof ArrayModel) {
                ArrayModel arrayModel = (ArrayModel)expectedDefinition;
                ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualDefinition).as(message, new Object[0])).isExactlyInstanceOf(ArrayModel.class);
            } else {
                this.softAssertions.assertThat((Object)actualDefinition).isExactlyInstanceOf(expectedDefinition.getClass());
            }
        }
    }

    private void validateDefinitionProperties(Map<String, Property> actualDefinitionProperties, Map<String, Property> expectedDefinitionProperties, String definitionName) {
        if (MapUtils.isNotEmpty(expectedDefinitionProperties)) {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNotEmpty();
            if (MapUtils.isNotEmpty(actualDefinitionProperties)) {
                Set<String> filteredExpectedProperties = this.filterWhitelistedPropertyNames(definitionName, expectedDefinitionProperties.keySet());
                ((ProxyableIterableAssert)this.softAssertions.assertThat(actualDefinitionProperties.keySet()).as("Checking properties of definition '%s'", new Object[]{definitionName})).containsAll(filteredExpectedProperties);
                for (Map.Entry<String, Property> expectedDefinitionPropertyEntry : expectedDefinitionProperties.entrySet()) {
                    Property expectedDefinitionProperty = expectedDefinitionPropertyEntry.getValue();
                    Property actualDefinitionProperty = actualDefinitionProperties.get(expectedDefinitionPropertyEntry.getKey());
                    String propertyName = expectedDefinitionPropertyEntry.getKey();
                    this.validateProperty(actualDefinitionProperty, expectedDefinitionProperty, String.format("Checking property '%s' of definition '%s'", propertyName, definitionName));
                }
            }
        } else {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualDefinitionProperties).as("Checking properties of definition '%s", new Object[]{definitionName})).isNullOrEmpty();
        }
    }

    private void validateProperty(Property actualProperty, Property expectedProperty, String message) {
        if (expectedProperty != null && this.isAssertionEnabled(SwaggerAssertionType.PROPERTIES)) {
            if (expectedProperty instanceof RefProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.REF_PROPERTIES)) {
                    RefProperty refProperty = (RefProperty)expectedProperty;
                    ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(RefProperty.class);
                }
            } else if (expectedProperty instanceof ArrayProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.ARRAY_PROPERTIES)) {
                    ArrayProperty arrayProperty = (ArrayProperty)expectedProperty;
                    ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(ArrayProperty.class);
                }
            } else if (expectedProperty instanceof StringProperty) {
                if (this.isAssertionEnabled(SwaggerAssertionType.STRING_PROPERTIES)) {
                    StringProperty expectedStringProperty = (StringProperty)expectedProperty;
                    ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(StringProperty.class);
                    if (actualProperty instanceof StringProperty) {
                        StringProperty actualStringProperty = (StringProperty)expectedProperty;
                        List expectedEnums = expectedStringProperty.getEnum();
                        if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                            this.softAssertions.assertThat(actualStringProperty.getEnum()).hasSameElementsAs((Iterable)expectedEnums);
                        } else {
                            this.softAssertions.assertThat(actualStringProperty.getEnum()).isNullOrEmpty();
                        }
                    }
                }
            } else {
                ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(expectedProperty.getClass());
            }
        }
    }

    private void validateOperation(Operation actualOperation, Operation expectedOperation, String path, String httpMethod) {
        String message = String.format("Checking '%s' operation of path '%s'", httpMethod, path);
        if (expectedOperation != null && actualOperation != null) {
            ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualOperation).as(message, new Object[0])).isNotNull();
            this.validateList(this.schemaObjectResolver.getActualConsumes(actualOperation), this.schemaObjectResolver.getExpectedConsumes(expectedOperation), String.format("Checking '%s' of '%s' operation of path '%s'", "consumes", httpMethod, path));
            this.validateList(this.schemaObjectResolver.getActualProduces(actualOperation), this.schemaObjectResolver.getExpectedProduces(expectedOperation), String.format("Checking '%s' of '%s' operation of path '%s'", "produces", httpMethod, path));
            this.validateParameters(actualOperation.getParameters(), expectedOperation.getParameters(), httpMethod, path);
            this.validateResponses(actualOperation.getResponses(), expectedOperation.getResponses(), httpMethod, path);
        }
    }

    private void validateParameters(List<Parameter> actualOperationParameters, List<Parameter> expectedOperationParameters, String httpMethod, String path) {
        String message = String.format("Checking parameters of '%s' operation of path '%s'.", httpMethod, path);
        HashMap<String, Parameter> actualParametersMap = new HashMap<String, Parameter>();
        for (Parameter parameter : actualOperationParameters) {
            actualParametersMap.put(this.parameterUniqueKey(parameter), parameter);
        }
        for (Parameter expectedParameter : expectedOperationParameters) {
            String parameterName = expectedParameter.getName();
            Parameter actualParameter = (Parameter)actualParametersMap.remove(this.parameterUniqueKey(expectedParameter));
            String actualParameterNotNullMessage = String.format("%s Expected parameter with name='%s' and in='%s' is missing", message, expectedParameter.getName(), expectedParameter.getIn());
            ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualParameter).as(actualParameterNotNullMessage, new Object[0])).isNotNull();
            this.validateParameter(actualParameter, expectedParameter, parameterName, httpMethod, path);
        }
        for (Parameter extraParameter : actualParametersMap.values()) {
            String extraParameterNotOptionalMessage = String.format("%s Unexpected parameter with name='%s' and in='%s' is missing", message, extraParameter.getName(), extraParameter.getIn());
            ((BooleanAssert)this.softAssertions.assertThat(extraParameter.getRequired()).as(extraParameterNotOptionalMessage, new Object[0])).isFalse();
        }
    }

    private String parameterUniqueKey(Parameter parameter) {
        return parameter.getName() + parameter.getIn();
    }

    private void validateParameter(Parameter actualParameter, Parameter expectedParameter, String parameterName, String httpMethod, String path) {
        if (expectedParameter != null) {
            String message = String.format("Checking parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path);
            ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualParameter).as(message, new Object[0])).isExactlyInstanceOf(expectedParameter.getClass());
            if (expectedParameter instanceof BodyParameter && actualParameter instanceof BodyParameter) {
                BodyParameter actualBodyParameter = (BodyParameter)expectedParameter;
                BodyParameter expectedBodyParameter = (BodyParameter)expectedParameter;
                this.validateModel(actualBodyParameter.getSchema(), expectedBodyParameter.getSchema(), String.format("Checking model of parameter '%s' of '%s' operation of path '%s'", parameterName, httpMethod, path));
            } else if (expectedParameter instanceof PathParameter && actualParameter instanceof PathParameter) {
                PathParameter actualPathParameter = (PathParameter)actualParameter;
                PathParameter expectedPathParameter = (PathParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualPathParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedPathParameter.getType());
                List expectedEnums = expectedPathParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualPathParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof QueryParameter && actualParameter instanceof QueryParameter) {
                QueryParameter actualQueryParameter = (QueryParameter)actualParameter;
                QueryParameter expectedQueryParameter = (QueryParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualQueryParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedQueryParameter.getType());
                List expectedEnums = expectedQueryParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualQueryParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof HeaderParameter && actualParameter instanceof HeaderParameter) {
                HeaderParameter actualHeaderParameter = (HeaderParameter)actualParameter;
                HeaderParameter expectedHeaderParameter = (HeaderParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualHeaderParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedHeaderParameter.getType());
                List expectedEnums = expectedHeaderParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualHeaderParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof FormParameter && actualParameter instanceof FormParameter) {
                FormParameter actualFormParameter = (FormParameter)actualParameter;
                FormParameter expectedFormParameter = (FormParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualFormParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedFormParameter.getType());
                List expectedEnums = expectedFormParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualFormParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof CookieParameter && actualParameter instanceof CookieParameter) {
                CookieParameter actualCookieParameter = (CookieParameter)actualParameter;
                CookieParameter expectedCookieParameter = (CookieParameter)expectedParameter;
                ((StringAssert)this.softAssertions.assertThat(actualCookieParameter.getType()).as(message, new Object[0])).isEqualTo((Object)expectedCookieParameter.getType());
                List expectedEnums = expectedCookieParameter.getEnum();
                if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).hasSameElementsAs((Iterable)expectedEnums);
                } else {
                    ((ProxyableListAssert)this.softAssertions.assertThat(actualCookieParameter.getEnum()).as(message, new Object[0])).isNullOrEmpty();
                }
            } else if (expectedParameter instanceof RefParameter && actualParameter instanceof RefParameter) {
                RefParameter expectedRefParameter = (RefParameter)expectedParameter;
                RefParameter actualRefParameter = (RefParameter)actualParameter;
                ((StringAssert)this.softAssertions.assertThat(actualRefParameter.getSimpleRef()).as(message, new Object[0])).isEqualTo((Object)expectedRefParameter.getSimpleRef());
            }
        }
    }

    private void validateResponses(Map<String, Response> actualOperationResponses, Map<String, Response> expectedOperationResponses, String httpMethod, String path) {
        String message = String.format("Checking responses of '%s' operation of path '%s'", httpMethod, path);
        if (MapUtils.isNotEmpty(expectedOperationResponses)) {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualOperationResponses)) {
                ((ProxyableIterableAssert)this.softAssertions.assertThat(actualOperationResponses.keySet()).as(message, new Object[0])).hasSameElementsAs(expectedOperationResponses.keySet());
                for (Map.Entry<String, Response> actualResponseEntry : actualOperationResponses.entrySet()) {
                    Response expectedResponse = expectedOperationResponses.get(actualResponseEntry.getKey());
                    Response actualResponse = actualResponseEntry.getValue();
                    String responseName = actualResponseEntry.getKey();
                    this.validateResponse(actualResponse, expectedResponse, responseName, httpMethod, path);
                }
            }
        } else {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualOperationResponses).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateResponse(Response actualResponse, Response expectedResponse, String responseName, String httpMethod, String path) {
        if (expectedResponse != null) {
            this.validateProperty(actualResponse.getSchema(), expectedResponse.getSchema(), String.format("Checking response schema of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path));
            this.validateResponseHeaders(actualResponse.getHeaders(), expectedResponse.getHeaders(), responseName, httpMethod, path);
        }
    }

    private void validateResponseHeaders(Map<String, Property> actualResponseHeaders, Map<String, Property> expectedResponseHeaders, String responseName, String httpMethod, String path) {
        String message = String.format("Checking response headers of response '%s' of '%s' operation of path '%s'", responseName, httpMethod, path);
        if (MapUtils.isNotEmpty(expectedResponseHeaders)) {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNotEmpty();
            if (MapUtils.isNotEmpty(actualResponseHeaders)) {
                ((ProxyableIterableAssert)this.softAssertions.assertThat(actualResponseHeaders.keySet()).as(message, new Object[0])).containsAll(expectedResponseHeaders.keySet());
                for (Map.Entry<String, Property> expectedResponseHeaderEntry : expectedResponseHeaders.entrySet()) {
                    Property expectedResponseHeader = expectedResponseHeaderEntry.getValue();
                    Property actualResponseHeader = actualResponseHeaders.get(expectedResponseHeaderEntry.getKey());
                    String responseHeaderName = expectedResponseHeaderEntry.getKey();
                    this.validateProperty(actualResponseHeader, expectedResponseHeader, String.format("Checking response header '%s' of response '%s' of '%s' operation of path '%s'", responseHeaderName, responseName, httpMethod, path));
                }
            }
        } else {
            ((ProxyableMapAssert)this.softAssertions.assertThat(actualResponseHeaders).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private void validateList(List<String> actualList, List<String> expectedList, String message) {
        if (CollectionUtils.isNotEmpty(expectedList)) {
            ((ProxyableListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNotEmpty();
            if (CollectionUtils.isNotEmpty(actualList)) {
                ((ProxyableListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).containsAll(expectedList);
            }
        } else {
            ((ProxyableListAssert)this.softAssertions.assertThat(actualList).as(message, new Object[0])).isNullOrEmpty();
        }
    }

    private boolean isAssertionEnabled(SwaggerAssertionType assertionType) {
        return this.assertionConfig.swaggerAssertionEnabled(assertionType);
    }

    private Set<String> filterWhitelistedPropertyNames(String definitionName, Set<String> expectedPropertyNames) {
        HashSet<String> result = new HashSet<String>(expectedPropertyNames.size());
        Set<String> ignoredPropertyNames = this.assertionConfig.getPropertiesToIgnoreInExpected();
        for (String property : expectedPropertyNames) {
            if (ignoredPropertyNames.contains(definitionName + '.' + property)) continue;
            result.add(property);
        }
        return result;
    }

    private <K, V> Map<K, V> removeAllFromMap(Map<K, V> map, Set<K> keysToExclude) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(map);
        result.keySet().removeAll(keysToExclude);
        return result;
    }
}

